/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.attribute;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FloatAttribute;
import se.ericsson.cello.su.convert.attribute.ConverterAttributeType;
import se.ericsson.cello.su.convert.base.ConverterAttributeBase;
import se.ericsson.cello.su.convert.exception.ConverterAttributeException;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class FloatConverterAttribute
extends ConverterAttributeBase {
    private Float myValue = null;

    public FloatConverterAttribute(String string) {
        super(ConverterAttributeType.FLOAT, string);
    }

    public FloatConverterAttribute(String string, Boolean bl) {
        super(ConverterAttributeType.FLOAT, string, bl);
    }

    public FloatConverterAttribute(String string, Float f, Boolean bl) {
        super(ConverterAttributeType.FLOAT, string, bl);
        this.myValue = f;
    }

    public FloatConverterAttribute(FloatAttribute floatAttribute) {
        super(ConverterAttributeType.FLOAT, floatAttribute.getName(), floatAttribute.isAVCNotifier());
        this.myValue = new Float(floatAttribute.getValue(null));
    }

    public Attribute getPersistentAttribute() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPersistentAttribute()");
        }
        return new FloatAttribute(this.myName, this.myIsAVC_Notifier.booleanValue(), this.myValue.floatValue());
    }

    public String getValueAsString() {
        return this.myValue.toString();
    }

    public void addPreviousValue(String string, Attribute attribute) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setPreviousValue(Attribute theAttribute)", "aMoLdn: " + string + "\n\ttheAttribute: " + attribute);
        }
        this.myPreviousName = attribute.getName();
        this.myPreviousIsAVC_Notifier = attribute.isAVCNotifier();
        this.myPreviousValues.put(string, new Float(((FloatAttribute)attribute).getValue(null)));
    }

    public String getPreviousValueAsString(String string) throws ConverterAttributeException {
        String string2 = null;
        if (string != null) {
            if (!this.myPreviousValues.containsKey(string)) {
                Trace.error(this.getClass(), "getPreviousValueAsString(String aMoLdn)", "Failed to get a previous value for MoLdn: " + string);
                throw new ConverterAttributeException("Failed to get a previous value for MoLdn: " + string);
            }
            string2 = this.myPreviousValues.get(string).toString();
        } else {
            string2 = this.getValueAsString();
        }
        return string2;
    }

    public String toString() {
        return super.toString() + "\n\tValue: " + this.myValue + "\n\tPreviousValues: " + this.myPreviousValues;
    }
}

