/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.attribute;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.su.convert.attribute.ConverterAttributeType;
import se.ericsson.cello.su.convert.base.ConverterAttributeBase;
import se.ericsson.cello.su.convert.exception.ConverterAttributeException;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class StringConverterAttribute
extends ConverterAttributeBase {
    private String myValue = null;

    public StringConverterAttribute(String string) {
        super(ConverterAttributeType.STRING, string);
    }

    public StringConverterAttribute(String string, Boolean bl) {
        super(ConverterAttributeType.STRING, string, bl);
    }

    public StringConverterAttribute(String string, String string2, Boolean bl) {
        super(ConverterAttributeType.STRING, string, bl);
        this.myValue = string2;
    }

    public StringConverterAttribute(StringAttribute stringAttribute) {
        super(ConverterAttributeType.STRING, stringAttribute.getName(), stringAttribute.isAVCNotifier());
        this.myValue = stringAttribute.getValue(null);
    }

    public Attribute getPersistentAttribute() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPersistentAttribute()");
        }
        return new StringAttribute(this.myName, this.myIsAVC_Notifier.booleanValue(), this.myValue);
    }

    public String getValueAsString() {
        return this.myValue;
    }

    public void addPreviousValue(String string, Attribute attribute) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addPreviousValue(String aMoLdn, Attribute theAttribute)", "\n\taMoLdn: " + string + "theAttribute: " + attribute);
        }
        this.myPreviousName = attribute.getName();
        this.myPreviousIsAVC_Notifier = attribute.isAVCNotifier();
        this.myPreviousValues.put(string, ((StringAttribute)attribute).getValue(null));
    }

    public String getPreviousValueAsString(String string) throws ConverterAttributeException {
        String string2 = null;
        if (string != null) {
            if (!this.myPreviousValues.containsKey(string)) {
                Trace.error(this.getClass(), "getPreviousValueAsString(String aMoLdn)", "Failed to get a previous value for MoLdn: " + string);
                throw new ConverterAttributeException("Failed to get a previous value for MoLdn: " + string);
            }
            string2 = this.myPreviousValues.get(string).toString();
        } else {
            string2 = this.getValueAsString();
        }
        return string2;
    }

    public String toString() {
        return super.toString() + "\n\tValue: " + this.myValue + "\n\tPreviousValues: " + this.myPreviousValues;
    }
}

