/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.step;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.su.convert.actions.AddAttributeConverterAction;
import se.ericsson.cello.su.convert.actions.SetAttributeConverterAction;
import se.ericsson.cello.su.convert.attribute.BooleanConverterAttribute;
import se.ericsson.cello.su.convert.attribute.IntegerConverterAttribute;
import se.ericsson.cello.su.convert.attribute.LongConverterAttribute;
import se.ericsson.cello.su.convert.attribute.SequenceConverterAttribute;
import se.ericsson.cello.su.convert.attribute.StringConverterAttribute;
import se.ericsson.cello.su.convert.base.ConverterStepBase;
import se.ericsson.cello.su.convert.exception.SuConvertActionException;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class UpgradePackage_6100_9000_Step
extends ConverterStepBase {
    public UpgradePackage_6100_9000_Step() {
        super("UpgradePackage", new Integer(6100), new Integer(9000));
    }

    public boolean prepareConvert(Collection collection) throws SuConvertActionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "prepareConvert(Collection aMoDatas)");
        }
        if (!this.isCorrectMoDataRevision(collection)) {
            return true;
        }
        this.createAttributesToBeSet(collection);
        this.createAttributesToBeAdded(collection);
        return false;
    }

    private boolean isCorrectMoDataRevision(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isCorrectMoDataRevision(Collection aMoDatas)");
        }
        String string = "Some UpgradePackage MOs has unknown MoData revision, the SU converter will be put last in the MoDataConverter list. UP information: ";
        boolean bl = true;
        MoData moData = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            moData = (MoData)iterator.next();
            if (!moData.getMoTypeName().equals("UpgradePackage") || moData.getRevision() >= 6100) continue;
            bl = false;
            string = string + "\n\tUP ldn " + moData.getLocalDistinguishedName() + " MoData revision: " + moData.getRevision();
        }
        if (!bl) {
            Trace.log1(this.getClass(), "isCorrectMoDataRevision(Collection aMoDatas)", string);
        }
        return bl;
    }

    private void createAttributesToBeAdded(Collection collection) throws SuConvertActionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createAttributesToBeAdded(Collection aMoDatas)");
        }
        AddAttributeConverterAction addAttributeConverterAction = new AddAttributeConverterAction();
        addAttributeConverterAction.addConverterAttribute(new IntegerConverterAttribute("suCompatibilityIndex", new Integer(1), (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new StringConverterAttribute("SU_LogicName", "", (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new StringConverterAttribute("DynamicClassPathDirFilePath", "", (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new IntegerConverterAttribute("OngoingActionID", new Integer(0), (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new BooleanConverterAttribute("IsForcedInstall", false, (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new IntegerConverterAttribute("PreviousState", new Integer(-1), (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new IntegerConverterAttribute("TotalSumOfInstalledLMs", new Integer(0), (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new BooleanConverterAttribute("IsMergeOfUCF_Successfull", true, (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new IntegerConverterAttribute("TotalNumberOfStepsInSequence", new Integer(0), (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new IntegerConverterAttribute("CurrentStepNumberInSequence", new Integer(0), (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new SequenceConverterAttribute("SU_LMs", new LinkedList(), (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new SequenceConverterAttribute("SU_LMsProductDatas", new LinkedList(), (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new IntegerConverterAttribute("preUpgradeState", new Integer(0), (Boolean)true));
        addAttributeConverterAction.addConverterAttribute(new LongConverterAttribute("previousJavaHeapSize", new Long(-1L), (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new SequenceConverterAttribute("removedJavaLMsAtPreUpgrade", new LinkedList(), (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new BooleanConverterAttribute("isDeleteUP_InProgress", false, (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new IntegerConverterAttribute("PreUpgradeExecutedInPhase", new Integer(0), (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new SequenceConverterAttribute("DynamicClassPath", new LinkedList(), (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new IntegerConverterAttribute("upgradeActionExecuting", new Integer(0), (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new SequenceConverterAttribute("tmpActionResultDatas", new LinkedList(), (Boolean)false));
        addAttributeConverterAction.addConverterAttribute(new BooleanConverterAttribute("lmsInstalledInVerifyStep", false, (Boolean)false));
        this.myConverterActions.add(addAttributeConverterAction);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createAttributesToBeAdded(Collection aMoDatas)", "myConverterActions: " + this.myConverterActions);
        }
    }

    public void createAttributesToBeSet(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createAttributesToBeSet(Collection aMoDatas)");
        }
        SetAttributeConverterAction setAttributeConverterAction = null;
        MoData moData = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            moData = (MoData)iterator.next();
            if (!moData.getMoTypeName().equals("UpgradePackage")) continue;
            setAttributeConverterAction = new SetAttributeConverterAction(moData.getLocalDistinguishedName());
            String string = ((StringAttribute)moData.getAttribute("stepLabel")).getValue(null);
            setAttributeConverterAction.addConverterAttribute(new StringConverterAttribute("stepLabel", string, (Boolean)false));
            this.myConverterActions.add(setAttributeConverterAction);
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createAttributesToBeSet(Collection aMoDatas)", "myConverterActions: " + this.myConverterActions);
        }
    }
}

