/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.froproxy.swinstall;

import enea.ose.io.SignalInputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.ChecksumFileResultInterface;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public class OsaSwChecksumFileRsp
extends UnlinkedSignal
implements ChecksumFileResultInterface {
    private static final int SIGNO = 68898;
    private int result;
    private byte[] checksum = new byte[33];
    private byte[] filePath = new byte[256];
    private byte[] errorInfo = new byte[256];

    public OsaSwChecksumFileRsp() {
        super(68898);
    }

    public int getSignalNumber() {
        return 68898;
    }

    public int getResult() {
        return this.result;
    }

    public boolean getChecksumOK() {
        return SuLib.convertIntToBoolean(this.result);
    }

    public String getChecksum() {
        return SuLib.convertByteArrayToString(this.checksum);
    }

    public String getFilePath() {
        return SuLib.convertByteArrayToString(this.filePath);
    }

    public String getErrorInfo() {
        if (this.result == 1) {
            return "";
        }
        return SuLib.convertByteArrayToString(this.errorInfo);
    }

    protected void initReceive() {
        SignalInputStream signalInputStream = this.getSignalInputStream();
        try {
            this.result = signalInputStream.readU16();
            this.checksum = signalInputStream.readS8Array(33);
            this.filePath = signalInputStream.readS8Array(256);
            this.errorInfo = signalInputStream.readS8Array(256);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "initReceive( )", "result: " + this.result + "\n\t ----- these attributes in string format --------------" + "\n\tchecksum: " + SuLib.convertByteArrayToString(this.checksum) + "\n\tfilePath: " + SuLib.convertByteArrayToString(this.filePath) + "\n\terrorInfo: " + SuLib.convertByteArrayToString(this.errorInfo));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void initSend() {
    }

    public String toString() {
        return "\n\tchecksumOK: " + this.getChecksumOK() + "\n\tchecksum: " + this.getChecksum() + "\n\tfilePath: " + this.getFilePath() + "\n\terrorInfo: " + this.getErrorInfo();
    }
}

