/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.uci.verify.jdbc;

import com.polyhedra.sql.Connection;
import com.polyhedra.sql.DriverManager;
import com.polyhedra.sql.SQLException;
import se.ericsson.cello.su.uci.verify.VerificationResult;
import se.ericsson.cello.support.control.Control;
import se.ericsson.cello.upgradepackage.main.util.ActionResultData;
import se.ericsson.cello.upgradepackage.main.util.ActionResultInformationEnum;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class JDBC_ConnectionController {
    private static final String JDBC_DRIVER = "com.polyhedra.jdbc.JdbcDriver";
    private static final String HOST = "127.0.0.1";
    private static final String PORT = "5434";
    private static final String POLYHEDRA_URL = "jdbc:polyhedra://127.0.0.1:5434";

    public VerificationResult execute() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "execute()");
        }
        if (Control.getOs() == 1) {
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "execute()", "DB Connection check will be not performed as Polyhedra is not supported in Linux OS");
            }
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
        try {
            Class.forName(JDBC_DRIVER).newInstance();
        }
        catch (InstantiationException instantiationException) {
            return this.defineVerificationResult("Not possible to connect to the DB by using JDBC due to Polyhedra driver not found.\n\tDetails: " + instantiationException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "execute()", "Do not report problems sine the Polyhedra functionallity not even is part of the node configuration\n\tNoClassDefFoundError: " + noClassDefFoundError);
            }
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "execute()", "Do not report problems sine the Polyhedra functionallity not even is part of the node configuration\n\tClassNotFoundException: " + classNotFoundException);
            }
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
        catch (IllegalAccessException illegalAccessException) {
            return this.defineVerificationResult("Not possible to connect to the DB by using JDBC due to can not access the Polyhedra JDBC driver.\n\tDetails: " + illegalAccessException);
        }
        catch (Throwable throwable) {
            return this.defineVerificationResult("Not possible to connect to the DB by using JDBC due to a connection problem occured.\n\tDetails: " + throwable);
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection((String)POLYHEDRA_URL);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "execute()", "Do not report problems sine the Polyhedra functionallity not even is part of the node configuration\n\tNoClassDefFoundError: " + noClassDefFoundError);
            }
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
        catch (SQLException sQLException) {
            return this.defineVerificationResult("Not possible to connect to the DB by using JDBC due to not possible to connect to the database.\n\tDetails: " + (Object)((Object)sQLException));
        }
        catch (Throwable throwable) {
            return this.defineVerificationResult("Not possible to connect to the DB by using JDBC due to not possible to problems to connect to the database.\n\tDetails: " + throwable);
        }
        try {
            connection.close();
        }
        catch (Throwable throwable) {
            return this.defineVerificationResult("Failed to disconnect from the Polyhedra database.\n\tDetails: " + throwable);
        }
        VerificationResult verificationResult = new VerificationResult(true);
        return verificationResult;
    }

    private VerificationResult defineVerificationResult(String string) {
        ActionResultData actionResultData = new ActionResultData(ActionResultInformationEnum.DB_CONNECTION_FAILED, string);
        return new VerificationResult(false, false, actionResultData);
    }
}

