/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.control.transform;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.control.transform.ProductDataTransformerBase;
import se.ericsson.cello.sudom.parser.control.transform.TransformException;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallLM;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallLM_AttributeName;
import se.ericsson.cello.sudom.parser.dom.loadmodule.LoadModule;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM_AttributeName;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductData;
import se.ericsson.cello.sudom.parser.dom.transform.Value;

public class LoadModuleTransformer
extends ProductDataTransformerBase {
    public static final String ProductDataPath = "UpgradePackage/LoadModule/ProductData";
    public static final String MoDataLM_PATH = "UpgradePackage/LoadModule/MoDataLM";
    public static final String ModataLM_PATH = "UpgradePackage/LoadModule/ModataLM";
    public static final String InstallLM_PATH = "UpgradePackage/LoadModule/InstallLM";

    public void execute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("execute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        if (value.getElementPath().equals(ProductDataPath)) {
            this.transformProductDataAttribute(value, documentObjectUpgradePackage);
        } else if (value.getElementPath().equals(MoDataLM_PATH) || value.getElementPath().equals(ModataLM_PATH)) {
            this.transformMoDataLM_Attribute(value, documentObjectUpgradePackage);
        } else if (value.getElementPath().equals(InstallLM_PATH)) {
            this.transformInstallLM_Attribute(value, documentObjectUpgradePackage);
        } else {
            UpgradeTrace.info(this.getClass(), (String)"execute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected element path has been specified which is ignored\n\tUCF Element path: " + value.getElementPath() + "\n\tUCF Attribute name: " + value.getAttributeName() + "\n\tUCF From value: " + value.getFrom() + "\n\tUCF To value: " + value.getTo()));
        }
    }

    private void transformProductDataAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformProductDataAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getProductDatas(documentObjectUpgradePackage);
        this.transformProductDataAttribute(value, collection);
    }

    private Collection getProductDatas(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getProductDatas(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        HashSet<ProductData> hashSet = new HashSet<ProductData>();
        Vector vector = documentObjectUpgradePackage.getLoadModules();
        Iterator iterator = vector.iterator();
        LoadModule loadModule = null;
        while (iterator.hasNext()) {
            loadModule = (LoadModule)iterator.next();
            hashSet.add(loadModule.getProductData());
        }
        return hashSet;
    }

    private void transformMoDataLM_Attribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformMoDataLM_Attribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getMoDataLMs(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        MoDataLM moDataLM = null;
        while (iterator.hasNext()) {
            moDataLM = (MoDataLM)iterator.next();
            if (value.getAttributeName().equals(MoDataLM_AttributeName.LoaderName.getValue())) {
                if (moDataLM.getLoaderName() == null || !moDataLM.getLoaderName().equals(value.getFrom())) continue;
                moDataLM.setLoaderName(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(MoDataLM_AttributeName.OseProgramLoadClass.getValue())) {
                if (moDataLM.getOseProgramLoadClass() == null || !moDataLM.getOseProgramLoadClass().equals(value.getFrom())) continue;
                moDataLM.setOseProgramLoadClass(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(MoDataLM_AttributeName.Preload.getValue())) {
                if (moDataLM.getPreload() == null || !moDataLM.getPreload().equals(value.getFrom())) continue;
                moDataLM.setPreload(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(MoDataLM_AttributeName.MaxExecInstancesNode.getValue())) {
                if (moDataLM.getMaxExecInstancesNode() == null || !moDataLM.getMaxExecInstancesNode().equals(value.getFrom())) continue;
                moDataLM.setMaxExecInstancesNode(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformMoDataLM_Attribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private void transformInstallLM_Attribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformInstallLM_Attribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getInstallLMs(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        InstallLM installLM = null;
        while (iterator.hasNext()) {
            installLM = (InstallLM)iterator.next();
            if (value.getAttributeName().equals(InstallLM_AttributeName.Directory.getValue())) {
                if (installLM.getDirectory() == null || !installLM.getDirectory().equals(value.getFrom())) continue;
                installLM.setDirectory(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformInstallLM_Attribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private Collection getMoDataLMs(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getMoDataLMs(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        Vector vector = documentObjectUpgradePackage.getLoadModules();
        Iterator iterator = vector.iterator();
        LinkedList<MoDataLM> linkedList = new LinkedList<MoDataLM>();
        LoadModule loadModule = null;
        while (iterator.hasNext()) {
            loadModule = (LoadModule)iterator.next();
            linkedList.add(loadModule.getMoDataLM());
        }
        return linkedList;
    }

    private Collection getInstallLMs(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getInstallLMs(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        Vector vector = documentObjectUpgradePackage.getLoadModules();
        Iterator iterator = vector.iterator();
        LinkedList linkedList = new LinkedList();
        LoadModule loadModule = null;
        while (iterator.hasNext()) {
            loadModule = (LoadModule)iterator.next();
            linkedList.addAll(loadModule.getInstallLM());
        }
        return linkedList;
    }
}

