/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.IllegalAttributeValueException;
import se.ericsson.cello.sudom.parser.InvalidMainElementNameException;
import se.ericsson.cello.sudom.parser.MainElementNames;
import se.ericsson.cello.sudom.parser.ParseException;
import se.ericsson.cello.sudom.parser.RootElementName;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeException;
import se.ericsson.cello.sudom.parser.dom.CommonDocumentObjectInformation;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectInterface;
import se.ericsson.cello.sudom.parser.dom.OptimizeInterface;
import se.ericsson.cello.sudom.parser.dom.ParsedData;
import se.ericsson.cello.sudom.parser.dom.UnexpectedElementReason;
import se.ericsson.cello.sudom.parser.dom.UpgradePackageAttributeName;
import se.ericsson.cello.sudom.parser.dom.basedon.BasedOn;
import se.ericsson.cello.sudom.parser.dom.commonpiutypelist.CommonPiuTypeList;
import se.ericsson.cello.sudom.parser.dom.cpp_up_version.CPP_UP_Version;
import se.ericsson.cello.sudom.parser.dom.deltaaddition.DeltaAddition;
import se.ericsson.cello.sudom.parser.dom.explicitaddition.ExplicitAddition;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.ExplicitReplacement;
import se.ericsson.cello.sudom.parser.dom.installsequence.InstallSequence;
import se.ericsson.cello.sudom.parser.dom.installup.InstallUp;
import se.ericsson.cello.sudom.parser.dom.loadmodule.LoadModule;
import se.ericsson.cello.sudom.parser.dom.managedelement.ManagedElement;
import se.ericsson.cello.sudom.parser.dom.mandatorypiutypelist.MandatoryPiuTypeList;
import se.ericsson.cello.sudom.parser.dom.nodetypespecificpiutypelist.NodeTypeSpecificPiuTypeList;
import se.ericsson.cello.sudom.parser.dom.piutype.PiuType;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductData;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductDataValidator;
import se.ericsson.cello.sudom.parser.dom.repertoire.Repertoire;
import se.ericsson.cello.sudom.parser.dom.subrackprodtype.SubrackProdType;
import se.ericsson.cello.sudom.parser.dom.transform.Transform;
import se.ericsson.cello.sudom.parser.dom.upcompatibilityindex.UP_CompatibilityIndex;
import se.ericsson.cello.sudom.parser.dom.updatesequence.UpdateSequence;
import se.ericsson.cello.sudom.parser.dom.upgradelogic.UpgradeLogic;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.UpgradeSequence;
import se.ericsson.cello.sudom.parser.dom.upgradewindow.UpgradeWindow;
import se.ericsson.cello.sudom.parser.dom.verifysequence.VerifySequence;
import se.ericsson.cello.sudom.parser.dom.verifyupdatesequence.VerifyUpdateSequence;
import se.ericsson.cello.sudom.parser.dom.verifyupgradesequence.VerifyUpgradeSequence;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.piutype.PiuTypeProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradelogic.UpgradeLogicInterface;

public class DocumentObjectUpgradePackage
extends ParsedData
implements DocumentObjectInterface,
OptimizeInterface {
    private String myHW_Sensitive = null;
    private String myTransformUnknownValues = null;
    private String myType = null;
    private String myIgnoreUnknownAttributes = null;
    private String myIgnoreUnknownElements = null;
    private String mySyntaxVersion = null;
    private String myIsSignedSW = null;
    private String myIsObsoleteLmUP = null;
    private static String myXML_VersionAndEncoding = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static String myDocType = "<!DOCTYPE UpgradePackage>";
    private static String myDocTypeAsItShouldBe = "<!--DOCTYPE UpgradePackage SYSTEM \"file:///C:\\SystemUpgrade\\UpgradePackage_PE1.dtd\"-->";
    private static String myDeltaInformation = "<!-- This Upgrade Control File is automatically generated as a result of a Delta Upgrade Package -->";
    private static String mySelectiveInformation = "<!-- This Upgrade Control File is automatically generated as a result of a Selective Upgrade Package -->";
    private boolean myDeltaGenerationMode = false;
    private boolean mySelectiveGenerationMode = false;
    private Vector myGeneralComments = null;
    private Vector myUpgradeSequences = new Vector(1);
    private Vector myInstallSequences = new Vector(1);
    private Vector myVerifySequences = new Vector(1);
    private Vector myVerifyUpgradeSequences = new Vector(1);
    private Vector myVerifyUpdateSequences = new Vector(1);
    private Vector myPiuTypes = new Vector(1);
    private Vector mySubrackProdType = new Vector(1);
    private Vector myLoadModules = new Vector(1);
    private Vector myBasedOn = new Vector(1);
    private Vector myRepertoires = new Vector(1);
    private Vector myExplicitReplacement = new Vector(1);
    private Vector myExplicitAddition = new Vector(1);
    private Vector myDeltaAdditions = new Vector(1);
    private UpdateSequence myUpdateSequence = null;
    private UpgradeWindow myUpgradeWindow = null;
    private ProductData myProductData = null;
    private InstallUp myInstallUp = null;
    private CPP_UP_Version myCPP_UP_Version = null;
    private UP_CompatibilityIndex myUP_CompatibilityIndex = null;
    private ManagedElement myManagedElement = null;
    private MandatoryPiuTypeList myMandatoryPiuTypeList = null;
    private CommonPiuTypeList myCommonPiuTypeList = null;
    private Vector myNodeTypeSpecificPiuTypeList = new Vector(1);
    private UpgradeLogic myUpgradeLogic = null;
    private Transform myTransform = null;
    private boolean myLoadModulesIsOptimized = false;
    private boolean myPiuTypesIsOptimized = false;
    private boolean myRepertoiresIsOptimized = false;

    public DocumentObjectUpgradePackage() {
    }

    public DocumentObjectUpgradePackage(AttributeList attributeList, Locator locator) throws UnexpectedAttributeException {
        super(locator);
        String[] stringArray;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"DocumentObjectUpgradePackage(AttributeList anAttributeList, Locator aLocator)", (String)("anAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if ((stringArray = UpgradePackageAttributeName.verifyNames(attributeList)) == null) {
            super.handleUnexpectedAttribute("DocumentObjectUpgradePackage(AttributeList anAttributeList, Locator aLocator)", RootElementName.UpgradePackage.getValue(), null, locator);
        }
        this.myType = attributeList.getValue(UpgradePackageAttributeName.Type.getValue());
        this.myIgnoreUnknownAttributes = attributeList.getValue(UpgradePackageAttributeName.IgnoreUnknownAttributes.getValue());
        this.myIgnoreUnknownElements = attributeList.getValue(UpgradePackageAttributeName.IgnoreUnknownElements.getValue());
        this.mySyntaxVersion = attributeList.getValue(UpgradePackageAttributeName.SyntaxVersion.getValue());
        this.myHW_Sensitive = attributeList.getValue(UpgradePackageAttributeName.HW_sensitive.getValue());
        this.myTransformUnknownValues = attributeList.getValue(UpgradePackageAttributeName.TransformUnknownValues.getValue());
        this.myIsSignedSW = attributeList.getValue(UpgradePackageAttributeName.IsSignedSW.getValue());
        this.myIsObsoleteLmUP = attributeList.getValue(UpgradePackageAttributeName.IsObsoleteLmUP.getValue());
        if (stringArray != null && stringArray.length > 0) {
            super.handleUnexpectedAttribute("DocumentObjectUpgradePackage(AttributeList anAttributeList, Locator aLocator)", RootElementName.UpgradePackage.getValue(), stringArray, locator);
        }
    }

    public void setCommonDocumentInformation() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setCommonDocumentInformation()");
        }
        this.setCommonDocumentInformationIgnoreUnknownAttributes(this.myIgnoreUnknownAttributes);
        this.setCommonDocumentInformationIgnoreUnknownElements(this.myIgnoreUnknownElements);
        this.setCommonDocumentInformationSyntaxVersion(this.mySyntaxVersion);
        this.resetCommonDocumentInformationIgnoredUnknownAttributes();
        this.resetCommonDocumentInformationIgnoredUnknownSubElements();
    }

    public boolean isTransformUnknownValues() {
        return this.myTransformUnknownValues != null && this.myTransformUnknownValues.equals("yes");
    }

    public DocumentObjectInterface create(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (string.equals("ProductData")) {
            return this.createProductData(string, attributeList, locator);
        }
        if (string.equals("CppUpVersion")) {
            return this.createCPP_UP_Version(string, attributeList, locator);
        }
        if (string.equals("UpCompatibilityIndex")) {
            return this.createUP_CompatibilityIndex(string, attributeList, locator);
        }
        if (string.equals("BasedOn")) {
            return this.createBasedOn(string, attributeList, locator);
        }
        if (string.equals("ManagedElement")) {
            return this.createManagedElement(string, attributeList, locator);
        }
        if (string.equals("InstallUp")) {
            return this.createInstallUp(string, attributeList, locator);
        }
        if (string.equals("UpgradeWindow")) {
            return this.createUpgradeWindow(string, attributeList, locator);
        }
        if (string.equals("UpgradeLogic")) {
            return this.createUpgradeLogic(string, attributeList, locator);
        }
        if (string.equals("PiuType")) {
            return this.createPiuType(string, attributeList, locator);
        }
        if (string.equals("SubrackProdType")) {
            return this.createSubrackProdType(string, attributeList, locator);
        }
        if (string.equals("MandatoryPiuTypeList")) {
            return this.createMandatoryPiuTypeList(string, attributeList, locator);
        }
        if (string.equals("CommonPiuTypeList")) {
            return this.createCommonPiuTypeList(string, attributeList, locator);
        }
        if (string.equals("NodeTypeSpecificPiuTypeList")) {
            return this.createNodeTypeSpecificPiuTypeList(string, attributeList, locator);
        }
        if (string.equals("Repertoire")) {
            return this.createRepertoire(string, attributeList, locator);
        }
        if (string.equals("ExplicitAddition")) {
            return this.createExplicitAddition(string, attributeList, locator);
        }
        if (string.equals("DeltaAddition")) {
            return this.createDeltaAddition(string, attributeList, locator);
        }
        if (string.equals("ExplicitReplacement")) {
            return this.createExplicitReplacement(string, attributeList, locator);
        }
        if (string.equals("InstallSequence")) {
            return this.createInstallSequence(string, attributeList, locator);
        }
        if (string.equals("Transform")) {
            return this.createTransform(string, attributeList, locator);
        }
        if (string.equals("VerifySequence")) {
            return this.createVerifySequence(string, attributeList, locator);
        }
        if (string.equals("VerifyUpgradeSequence")) {
            return this.createVerifyUpgradeSequence(string, attributeList, locator);
        }
        if (string.equals("UpgradeSequence")) {
            return this.createUpgradeSequence(string, attributeList, locator);
        }
        if (string.equals("VerifyUpdateSequence")) {
            return this.createVerifyUpdateSequence(string, attributeList, locator);
        }
        if (string.equals("UpdateSequence")) {
            return this.createUpdateSequence(string, attributeList, locator);
        }
        if (string.equals("LoadModule")) {
            return this.createLoadModule(string, attributeList, locator);
        }
        return super.handleUnexpectedElement("create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", RootElementName.UpgradePackage.getValue(), string, locator);
    }

    public Vector getBasedOn() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getBasedOn( )");
        }
        return this.myBasedOn;
    }

    public CPP_UP_Version getCPP_UP_Version() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getCPP_UP_Version( )");
        }
        return this.myCPP_UP_Version;
    }

    public Vector getExplicitAdditions() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getExplicitAdditions( )");
        }
        return this.myExplicitAddition;
    }

    public Vector getDeltaAdditions() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getDeltaAdditions( )");
        }
        return this.myDeltaAdditions;
    }

    public Vector getExplicitReplacement() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getExplicitReplacement( )");
        }
        return this.myExplicitReplacement;
    }

    public String getIgnoreUnknownAttributes() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getIgnoreUnknownAttributes( )");
        }
        return this.myIgnoreUnknownAttributes;
    }

    public String getIgnoreUnknownElements() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getIgnoreUnknownElements( )");
        }
        return this.myIgnoreUnknownElements;
    }

    public InstallUp getInstallUp() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getInstallUp( )");
        }
        return this.myInstallUp;
    }

    public Vector getLoadModules() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModules()");
        }
        return this.myLoadModules;
    }

    public ManagedElement getManagedElement() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getManagedElement( )");
        }
        return this.myManagedElement;
    }

    public Vector getPiuTypes() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getPiuTypes( )");
        }
        return this.myPiuTypes;
    }

    public Vector getSubrackProdType() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getSubrackProdType( )");
        }
        return this.mySubrackProdType;
    }

    public ProductData getProductData() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductData( )");
        }
        return this.myProductData;
    }

    public Vector getRepertoires() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRepertoires()");
        }
        return this.myRepertoires;
    }

    public String getType() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getType( )");
        }
        return this.myType;
    }

    public UP_CompatibilityIndex getUP_CompatibilityIndex() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getUP_CompatibilityIndex( )");
        }
        return this.myUP_CompatibilityIndex;
    }

    public UpgradeLogic getUpgradeLogic() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getUpgradeLogic()");
        }
        return this.myUpgradeLogic;
    }

    public Vector getInstallSequences() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getInstallSequences( )");
        }
        return this.myInstallSequences;
    }

    public Vector getVerifySequences() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getVerifySequences( )");
        }
        return this.myVerifySequences;
    }

    public Vector getVerifyUpgradeSequences() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getVerifyUpgradeSequences()\n\tmyVerifyUpgradeSequences: " + this.myVerifyUpgradeSequences));
        }
        return this.myVerifyUpgradeSequences;
    }

    public Vector getVerifyUpdateSequences() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getVerifyUpdateSequences()");
        }
        return this.myVerifyUpdateSequences;
    }

    public Vector getUpgradeSequences() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getUpgradeSequences( )");
        }
        return this.myUpgradeSequences;
    }

    public Transform getTransform() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getTransform()");
        }
        return this.myTransform;
    }

    public UpgradeWindow getUpgradeWindow() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getUpgradeWindow( )");
        }
        return this.myUpgradeWindow;
    }

    public String getSyntaxVersion() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getSyntaxVersion( )");
        }
        return this.mySyntaxVersion;
    }

    public boolean isMainElement(String string, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"isMainElement(String aDocumentObjectName, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\taLocator: " + locator));
        }
        if (MainElementNames.verifyName(string)) {
            return true;
        }
        super.handleUnexpectedElement("isMainElement(String aDocumentObjectName, Locator aLocator)", RootElementName.UpgradePackage.getValue(), string, locator);
        return false;
    }

    public void optimize() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"optimize()", (String)("myLoadModulesIsOptimized: " + this.myLoadModulesIsOptimized + "\n\tmyPiuTypesIsOptimized: " + this.myPiuTypesIsOptimized + "\n\tmyRepertoiresIsOptimized: " + this.myRepertoiresIsOptimized));
        }
        if (!this.myLoadModulesIsOptimized) {
            this.myLoadModulesIsOptimized = true;
        }
        if (!this.myPiuTypesIsOptimized) {
            this.myPiuTypesIsOptimized = true;
        }
        if (!this.myRepertoiresIsOptimized) {
            this.myRepertoiresIsOptimized = true;
        }
    }

    public void print(PrintStream printStream, String string) {
        Object object;
        Enumeration enumeration;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"print(PrintStream aPrintStream, String anIndentation)", (String)("aPrintStream: " + printStream + "\n\tanIndentation: " + string));
        }
        printStream.println(myXML_VersionAndEncoding);
        printStream.println(myDocType);
        printStream.println(myDocTypeAsItShouldBe);
        if (this.myGeneralComments != null) {
            enumeration = this.myGeneralComments.elements();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                printStream.println("<!--" + (String)object + "-->");
            }
        }
        if (this.myDeltaGenerationMode) {
            printStream.println(myDeltaInformation);
        }
        if (this.mySelectiveGenerationMode) {
            printStream.println(mySelectiveInformation);
        }
        printStream.println();
        if (this.myType == null && this.myIgnoreUnknownAttributes == null && this.myIgnoreUnknownElements == null && this.mySyntaxVersion == null && this.myIsObsoleteLmUP == null) {
            printStream.println(string + "<" + RootElementName.UpgradePackage.getValue() + ">");
        } else {
            printStream.println(string + "<" + RootElementName.UpgradePackage.getValue());
            if (this.myType != null) {
                printStream.println("  " + string + UpgradePackageAttributeName.Type.getValue() + " = \"" + this.myType + "\"");
            }
            if (this.myIgnoreUnknownAttributes != null) {
                printStream.println("  " + string + UpgradePackageAttributeName.IgnoreUnknownAttributes.getValue() + " = \"" + this.myIgnoreUnknownAttributes + "\"");
            }
            if (this.myIgnoreUnknownElements != null) {
                printStream.println("  " + string + UpgradePackageAttributeName.IgnoreUnknownElements.getValue() + " = \"" + this.myIgnoreUnknownElements + "\"");
            }
            if (this.mySyntaxVersion != null) {
                printStream.println("  " + string + UpgradePackageAttributeName.SyntaxVersion.getValue() + " = \"" + this.mySyntaxVersion + "\"");
            }
            if (this.myHW_Sensitive != null) {
                printStream.println("  " + string + UpgradePackageAttributeName.HW_sensitive.getValue() + " = \"" + this.myHW_Sensitive + "\"");
            }
            if (this.myIsSignedSW != null) {
                printStream.println("  " + string + UpgradePackageAttributeName.IsSignedSW.getValue() + " = \"" + this.myIsSignedSW + "\"");
            }
            if (this.myIsObsoleteLmUP != null) {
                printStream.println("  " + string + UpgradePackageAttributeName.IsObsoleteLmUP.getValue() + " = \"" + this.myIsObsoleteLmUP + "\"");
            }
            printStream.println("  " + string + ">");
        }
        if (this.myProductData != null) {
            printStream.println();
            this.myProductData.print(printStream, "  " + string);
        }
        if (this.myCPP_UP_Version != null) {
            printStream.println();
            this.myCPP_UP_Version.print(printStream, "  " + string);
        }
        if (this.myUP_CompatibilityIndex != null) {
            printStream.println();
            this.myUP_CompatibilityIndex.print(printStream, "  " + string);
        }
        enumeration = this.myBasedOn.elements();
        while (enumeration.hasMoreElements()) {
            printStream.println();
            ((BasedOn)enumeration.nextElement()).print(printStream, "  " + string);
        }
        if (this.myManagedElement != null) {
            printStream.println();
            this.myManagedElement.print(printStream, "  " + string);
        }
        if (this.myInstallUp != null) {
            printStream.println();
            this.myInstallUp.print(printStream, "  " + string);
        }
        if (this.myUpgradeWindow != null) {
            printStream.println();
            this.myUpgradeWindow.print(printStream, "  " + string);
        }
        if (this.myUpgradeLogic != null) {
            printStream.println();
            this.myUpgradeLogic.print(printStream, "  " + string);
        }
        object = this.myPiuTypes.elements();
        while (object.hasMoreElements()) {
            printStream.println();
            ((PiuType)object.nextElement()).print(printStream, "  " + string);
        }
        Enumeration enumeration2 = this.mySubrackProdType.elements();
        while (enumeration2.hasMoreElements()) {
            printStream.println();
            ((SubrackProdType)enumeration2.nextElement()).print(printStream, "  " + string);
        }
        if (this.myMandatoryPiuTypeList != null) {
            printStream.println();
            this.myMandatoryPiuTypeList.print(printStream, "  " + string);
        }
        if (this.myCommonPiuTypeList != null) {
            printStream.println();
            this.myCommonPiuTypeList.print(printStream, "  " + string);
        }
        Enumeration enumeration3 = this.myNodeTypeSpecificPiuTypeList.elements();
        while (enumeration3.hasMoreElements()) {
            printStream.println();
            ((NodeTypeSpecificPiuTypeList)enumeration3.nextElement()).print(printStream, "  " + string);
        }
        Enumeration enumeration4 = this.myRepertoires.elements();
        while (enumeration4.hasMoreElements()) {
            printStream.println();
            ((Repertoire)enumeration4.nextElement()).print(printStream, "  " + string);
        }
        Enumeration enumeration5 = this.myExplicitAddition.elements();
        while (enumeration5.hasMoreElements()) {
            printStream.println();
            ((ExplicitAddition)enumeration5.nextElement()).print(printStream, "  " + string);
        }
        Enumeration enumeration6 = this.myDeltaAdditions.elements();
        while (enumeration6.hasMoreElements()) {
            printStream.println();
            ((DeltaAddition)enumeration6.nextElement()).print(printStream, "  " + string);
        }
        Enumeration enumeration7 = this.myExplicitReplacement.elements();
        while (enumeration7.hasMoreElements()) {
            printStream.println();
            ((ExplicitReplacement)enumeration7.nextElement()).print(printStream, "  " + string);
        }
        Enumeration enumeration8 = this.myInstallSequences.elements();
        while (enumeration8.hasMoreElements()) {
            printStream.println();
            ((InstallSequence)enumeration8.nextElement()).print(printStream, "  " + string);
        }
        Enumeration enumeration9 = this.myVerifySequences.elements();
        while (enumeration9.hasMoreElements()) {
            printStream.println();
            ((VerifySequence)enumeration9.nextElement()).print(printStream, "  " + string);
        }
        Enumeration enumeration10 = this.myVerifyUpgradeSequences.elements();
        while (enumeration10.hasMoreElements()) {
            printStream.println();
            ((VerifyUpgradeSequence)enumeration10.nextElement()).print(printStream, "  " + string);
        }
        Enumeration enumeration11 = this.myVerifyUpdateSequences.elements();
        while (enumeration11.hasMoreElements()) {
            printStream.println();
            ((VerifyUpdateSequence)enumeration11.nextElement()).print(printStream, "  " + string);
        }
        Enumeration enumeration12 = this.myUpgradeSequences.elements();
        while (enumeration12.hasMoreElements()) {
            printStream.println();
            ((UpgradeSequence)enumeration12.nextElement()).print(printStream, "  " + string);
        }
        if (this.myUpdateSequence != null) {
            printStream.println();
            this.myUpdateSequence.print(printStream, "  " + string);
        }
        Enumeration enumeration13 = this.myLoadModules.elements();
        while (enumeration13.hasMoreElements()) {
            printStream.println();
            ((LoadModule)enumeration13.nextElement()).print(printStream, "  " + string);
        }
        printStream.println();
        printStream.println(string + "</" + RootElementName.UpgradePackage.getValue() + ">");
    }

    public void setBasedOn(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setBasedOn(BasedOn aBasedOn)", (String)("aBasedOn: " + vector));
        }
        this.myBasedOn = vector;
    }

    public void setCPP_UP_Version(CPP_UP_Version cPP_UP_Version) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setCPP_UP_Version(CPP_UP_Version aCPP_UP_Version)", (String)("aCPP_UP_Version: " + cPP_UP_Version));
        }
        this.myCPP_UP_Version = cPP_UP_Version;
    }

    public void setDeltaGenerationMode(boolean bl) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setDeltaGenerationMode(boolean aDeltaMode)", (String)("aDeltaMode: " + bl));
        }
        this.myDeltaGenerationMode = bl;
    }

    public void setExplicitAdditions(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setExplicitAdditions(Vector aExplicitAddition)", (String)("aExplicitAddition: " + vector));
        }
        this.myExplicitAddition = vector;
    }

    public void setDeltaAdditions(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setDeltaAdditions(Vector aDeltaAdditions)", (String)("aDeltaAdditions: " + vector));
        }
        this.myDeltaAdditions = vector;
    }

    public void setExplicitReplacement(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setExplicitReplacement(Vector aExplicitReplacement)", (String)("aExplicitReplacement: " + vector));
        }
        this.myExplicitReplacement = vector;
    }

    public void setInstallSequences(Vector vector) {
        this.myInstallSequences = vector;
    }

    public void setVerifySequences(Vector vector) {
        this.myVerifySequences = vector;
    }

    public void setVerifyUpdateSequences(Vector vector) {
        this.myVerifyUpdateSequences = vector;
    }

    public void setVerifyUpgradeSequences(Vector vector) {
        this.myVerifyUpgradeSequences = vector;
    }

    public void setIgnoreUnknownAttributes(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setIgnoreUnknownAttributes(String anIgnoreUnknownAttributes)", (String)("anIgnoreUnknownAttributes: " + string));
        }
        this.myIgnoreUnknownAttributes = string;
        this.setCommonDocumentInformationIgnoreUnknownAttributes(this.myIgnoreUnknownAttributes);
    }

    public void setIgnoreUnknownElements(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setIgnoreUnknownElements(String anIgnoreUnknownElements)", (String)("anIgnoreUnknownElements: " + string));
        }
        this.myIgnoreUnknownElements = string;
        this.setCommonDocumentInformationIgnoreUnknownElements(this.myIgnoreUnknownElements);
    }

    public void setInstallUp(InstallUp installUp) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setInstallUp(InstallUp aInstallUp)", (String)("aInstallUp: " + installUp));
        }
        this.myInstallUp = installUp;
    }

    public void adaptLoadModules(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"adaptLoadModule(Vector aLoadModule)", (String)("aLoadModule: " + collection));
        }
        Iterator iterator = collection.iterator();
        this.myLoadModules.clear();
        while (iterator.hasNext()) {
            LoadModule loadModule = ((LoadModuleProxyInterface)iterator.next()).getLoadModule();
            this.myLoadModules.addElement(loadModule);
        }
    }

    public void adaptPiuTypes(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"adaptPiuTypes(Vector aPiuTypes)", (String)("aPiuTypes: " + collection));
        }
        Iterator iterator = collection.iterator();
        this.myPiuTypes.clear();
        while (iterator.hasNext()) {
            PiuType piuType = ((PiuTypeProxyInterface)iterator.next()).getPiuType();
            this.myPiuTypes.addElement(piuType);
        }
    }

    public void setLoadModule(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setLoadModule(Vector aLoadModule)", (String)("aLoadModule: " + vector));
        }
        this.myLoadModules = vector;
    }

    public void setManagedElement(ManagedElement managedElement) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setManagedElement(ManagedElement aManagedElement)", (String)("aManagedElement: " + managedElement));
        }
        this.myManagedElement = managedElement;
    }

    public void setMandatoryPiuTypeList(MandatoryPiuTypeList mandatoryPiuTypeList) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setMandatoryPiuTypeList (MandatoryPiuTypeList aMandatoryPiuTypeList)", (String)("aMandatoryPiuTypeList: " + mandatoryPiuTypeList));
        }
        this.myMandatoryPiuTypeList = mandatoryPiuTypeList != null && mandatoryPiuTypeList.getPiuTypeRefs().isEmpty() ? null : mandatoryPiuTypeList;
    }

    public void setCommonPiuTypeList(CommonPiuTypeList commonPiuTypeList) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setCommonPiuTypeList (CommonPiuTypeList aCommonPiuTypeList)", (String)("aCommonPiuTypeList: " + commonPiuTypeList));
        }
        this.myCommonPiuTypeList = commonPiuTypeList != null && commonPiuTypeList.getPiuTypeRefs().isEmpty() ? null : commonPiuTypeList;
    }

    public void setNodeTypeSpecificPiuTypeList(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setNodeTypeSpecificPiuTypeList(Vector aNodeTypeSpecificPiuTypeList)", (String)("aNodeTypeSpecificPiuTypeList: " + vector));
        }
        this.myNodeTypeSpecificPiuTypeList = vector;
    }

    public void setPiuType(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setPiuType(Vector aPiuType)", (String)("aPiuType: " + vector));
        }
        this.myPiuTypes = vector;
    }

    public void setSubrackProdType(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setSubrackProdType(Vector aSubrackProdType)", (String)("aSubrackProdType: " + vector));
        }
        this.mySubrackProdType = vector;
    }

    public void setTransform(Transform transform) {
        this.myTransform = transform;
    }

    public void setProductData(ProductData productData) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setProductData(ProductData aProductData)", (String)("aProductData: " + productData));
        }
        this.myProductData = productData;
    }

    public void setRepertoire(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setRepertoire(Vector aRepertoire)", (String)("aRepertoire: " + vector));
        }
        this.myRepertoires = vector;
    }

    public void setSelectiveGenerationMode(boolean bl) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setSelectiveGenerationMode(boolean aSelectiveMode)", (String)("aSelectiveMode: " + bl));
        }
        this.mySelectiveGenerationMode = bl;
    }

    public void setType(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setType(String aType)", (String)("aType: " + string));
        }
        this.myType = string;
    }

    public void setUP_CompatibilityIndex(UP_CompatibilityIndex uP_CompatibilityIndex) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setUP_CompatibilityIndex(UP_CompatibilityIndex anUP_CompatibilityIndex)", (String)("anUP_CompatibilityIndex: " + uP_CompatibilityIndex));
        }
        this.myUP_CompatibilityIndex = uP_CompatibilityIndex;
    }

    public void setUpgradeLogic(UpgradeLogicInterface upgradeLogicInterface) {
        this.myUpgradeLogic = (UpgradeLogic)upgradeLogicInterface;
    }

    public void setUpgradeSequence(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setUpgradeSequence(Vector aUpgradeSequence)", (String)("aUpgradeSequence: " + vector));
        }
        this.myUpgradeSequences = vector;
    }

    public void setUpgradeWindow(UpgradeWindow upgradeWindow) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setUpgradeWindow(UpgradeWindow aUpgradeWindow)", (String)("aUpgradeWindow: " + upgradeWindow));
        }
        this.myUpgradeWindow = upgradeWindow;
    }

    public void setSyntaxVersion(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setSyntaxVersion(String aSyntaxVersion)", (String)("aSyntaxVersion: " + string));
        }
        this.mySyntaxVersion = string;
        this.setCommonDocumentInformationSyntaxVersion(this.mySyntaxVersion);
    }

    public void validate() throws ValidateException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validate( )");
        }
        UpgradePackageAttributeName.Type.validate(this.myType, super.getLocatorData());
        UpgradePackageAttributeName.IgnoreUnknownAttributes.validate(this.myIgnoreUnknownAttributes, super.getLocatorData());
        UpgradePackageAttributeName.IgnoreUnknownElements.validate(this.myIgnoreUnknownElements, super.getLocatorData());
        UpgradePackageAttributeName.SyntaxVersion.validate(this.mySyntaxVersion, super.getLocatorData());
        UpgradePackageAttributeName.HW_sensitive.validate(this.myHW_Sensitive, super.getLocatorData());
        UpgradePackageAttributeName.TransformUnknownValues.validate(this.myTransformUnknownValues, super.getLocatorData());
        UpgradePackageAttributeName.IsSignedSW.validate(this.myIsSignedSW, super.getLocatorData());
        UpgradePackageAttributeName.IsObsoleteLmUP.validate(this.myIsObsoleteLmUP, super.getLocatorData());
        this.validateHwSensitiveAndType(this.myType, this.myHW_Sensitive, super.getLocatorData());
        try {
            MainElementNames.get("ProductData").validate(this.myProductData, super.getLocatorData());
            MainElementNames.get("CppUpVersion").validate(this.myCPP_UP_Version, super.getLocatorData());
            MainElementNames.get("UpCompatibilityIndex").validate(this.myUP_CompatibilityIndex, super.getLocatorData());
            MainElementNames.get("BasedOn").validate(this.myBasedOn, super.getLocatorData());
            MainElementNames.get("ManagedElement").validate(this.myManagedElement, super.getLocatorData());
            MainElementNames.get("InstallUp").validate(this.myInstallUp, super.getLocatorData());
            MainElementNames.get("UpgradeWindow").validate(this.myUpgradeWindow, super.getLocatorData());
            MainElementNames.get("UpgradeLogic").validate(this.myUpgradeLogic, super.getLocatorData());
            MainElementNames.get("PiuType").validate(this.myPiuTypes, super.getLocatorData());
            MainElementNames.get("SubrackProdType").validate(this.mySubrackProdType, super.getLocatorData());
            MainElementNames.get("MandatoryPiuTypeList").validate(this.myMandatoryPiuTypeList, super.getLocatorData());
            MainElementNames.get("CommonPiuTypeList").validate(this.myCommonPiuTypeList, super.getLocatorData());
            MainElementNames.get("NodeTypeSpecificPiuTypeList").validate(this.myNodeTypeSpecificPiuTypeList, super.getLocatorData());
            MainElementNames.get("Repertoire").validate(this.myRepertoires, super.getLocatorData());
            MainElementNames.get("ExplicitReplacement").validate(this.myExplicitReplacement, super.getLocatorData());
            MainElementNames.get("ExplicitAddition").validate(this.myExplicitAddition, super.getLocatorData());
            MainElementNames.get("DeltaAddition").validate(this.myDeltaAdditions, super.getLocatorData());
            MainElementNames.get("InstallSequence").validate(this.myInstallSequences, super.getLocatorData());
            MainElementNames.get("VerifySequence").validate(this.myVerifySequences, super.getLocatorData());
            MainElementNames.get("VerifyUpgradeSequence").validate(this.myVerifyUpgradeSequences, super.getLocatorData());
            MainElementNames.get("VerifyUpdateSequence").validate(this.myVerifyUpdateSequences, super.getLocatorData());
            MainElementNames.get("UpgradeSequence").validate(this.myUpgradeSequences, super.getLocatorData());
            MainElementNames.get("UpdateSequence").validate(this.myUpdateSequence, super.getLocatorData());
            MainElementNames.get("LoadModule").validate(this.myLoadModules, super.getLocatorData());
            MainElementNames.get("Transform").validate(this.myTransform, super.getLocatorData());
        }
        catch (InvalidMainElementNameException invalidMainElementNameException) {
            throw new ValidateException(invalidMainElementNameException.toString());
        }
        if (this.myProductData != null) {
            this.myProductData.validate();
            ProductDataValidator.validate(this.myProductData, 8, 36, 1, 10, true, true, RootElementName.UpgradePackage.getValue(), true);
        }
        if (this.myCPP_UP_Version != null) {
            this.myCPP_UP_Version.validate();
        }
        if (this.myUP_CompatibilityIndex != null) {
            this.myUP_CompatibilityIndex.validate();
        }
        Enumeration enumeration = this.myBasedOn.elements();
        while (enumeration.hasMoreElements()) {
            ((BasedOn)enumeration.nextElement()).validate();
        }
        if (this.myManagedElement != null) {
            this.myManagedElement.validate();
        }
        if (this.myInstallUp != null) {
            this.myInstallUp.validate();
        }
        if (this.myUpgradeWindow != null) {
            this.myUpgradeWindow.validate();
        }
        if (this.myUpgradeLogic != null) {
            this.myUpgradeLogic.validate();
        }
        Enumeration enumeration2 = this.myPiuTypes.elements();
        while (enumeration2.hasMoreElements()) {
            ((PiuType)enumeration2.nextElement()).validate();
        }
        Enumeration enumeration3 = this.mySubrackProdType.elements();
        while (enumeration3.hasMoreElements()) {
            ((SubrackProdType)enumeration3.nextElement()).validate();
        }
        if (this.myMandatoryPiuTypeList != null) {
            this.myMandatoryPiuTypeList.validate();
        }
        if (this.myCommonPiuTypeList != null) {
            this.myCommonPiuTypeList.validate();
        }
        Enumeration enumeration4 = this.myNodeTypeSpecificPiuTypeList.elements();
        while (enumeration4.hasMoreElements()) {
            ((NodeTypeSpecificPiuTypeList)enumeration4.nextElement()).validate();
        }
        Enumeration enumeration5 = this.myRepertoires.elements();
        while (enumeration5.hasMoreElements()) {
            ((Repertoire)enumeration5.nextElement()).validate();
        }
        Enumeration enumeration6 = this.myExplicitAddition.elements();
        while (enumeration6.hasMoreElements()) {
            ((ExplicitAddition)enumeration6.nextElement()).validate();
        }
        Enumeration enumeration7 = this.myDeltaAdditions.elements();
        while (enumeration7.hasMoreElements()) {
            ((DeltaAddition)enumeration7.nextElement()).validate();
        }
        Enumeration enumeration8 = this.myExplicitReplacement.elements();
        while (enumeration8.hasMoreElements()) {
            ((ExplicitReplacement)enumeration8.nextElement()).validate();
        }
        Enumeration enumeration9 = this.myInstallSequences.elements();
        while (enumeration9.hasMoreElements()) {
            ((InstallSequence)enumeration9.nextElement()).validate();
        }
        Enumeration enumeration10 = this.myVerifySequences.elements();
        while (enumeration10.hasMoreElements()) {
            ((VerifySequence)enumeration10.nextElement()).validate();
        }
        Enumeration enumeration11 = this.myVerifyUpgradeSequences.elements();
        while (enumeration11.hasMoreElements()) {
            ((VerifyUpgradeSequence)enumeration11.nextElement()).validate();
        }
        Enumeration enumeration12 = this.myVerifyUpdateSequences.elements();
        while (enumeration12.hasMoreElements()) {
            ((VerifyUpdateSequence)enumeration12.nextElement()).validate();
        }
        Enumeration enumeration13 = this.myUpgradeSequences.elements();
        while (enumeration13.hasMoreElements()) {
            ((UpgradeSequence)enumeration13.nextElement()).validate();
        }
        if (this.myUpdateSequence != null) {
            this.myUpdateSequence.validate();
        }
        Enumeration enumeration14 = this.myLoadModules.elements();
        while (enumeration14.hasMoreElements()) {
            ((LoadModule)enumeration14.nextElement()).validate();
        }
    }

    private void validateHwSensitiveAndType(String string, String string2, Locator locator) throws IllegalAttributeValueException {
        if (string != null) {
            if (string.equalsIgnoreCase("Selective")) {
                if (string2 != null && string2.equalsIgnoreCase("yes")) {
                    this.errorIllegalAttributeValue(this.getClass(), "validateHwSensitiveAndType(String aType, String aHwSensitive)", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.Type.getValue(), string, string, " HwSensitive is not allowed when type is selective.", locator);
                }
            } else if (string.equalsIgnoreCase("Delta") && string2 != null && string2.equalsIgnoreCase("yes")) {
                this.errorIllegalAttributeValue(this.getClass(), "validateHwSensitiveAndType(String aType, String aHwSensitive)", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.Type.getValue(), string, string, " HwSensitive is not allowed when type is delta.", locator);
            }
        }
    }

    private DocumentObjectInterface createBasedOn(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createBasedOn(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myBasedOn.addElement(new BasedOn(attributeList, locator));
        return (BasedOn)this.myBasedOn.lastElement();
    }

    private DocumentObjectInterface createCPP_UP_Version(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createCPP_UP_Version(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (this.myCPP_UP_Version == null) {
            this.myCPP_UP_Version = new CPP_UP_Version(attributeList, locator);
            return this.myCPP_UP_Version;
        }
        return super.errorUnexpectedElement(UnexpectedElementReason.MoreElementsThanExpected, "createCPP_UP_Version(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", RootElementName.UpgradePackage.getValue(), string, locator);
    }

    private DocumentObjectInterface createExplicitAddition(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createExplicitAddition(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myExplicitAddition.addElement(new ExplicitAddition(attributeList, locator));
        return (ExplicitAddition)this.myExplicitAddition.lastElement();
    }

    private DocumentObjectInterface createDeltaAddition(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createDeltaAddition(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myDeltaAdditions.addElement(new DeltaAddition(attributeList, locator));
        return (DeltaAddition)this.myDeltaAdditions.lastElement();
    }

    private DocumentObjectInterface createExplicitReplacement(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createExplicitReplacement(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myExplicitReplacement.addElement(new ExplicitReplacement(attributeList, locator));
        return (ExplicitReplacement)this.myExplicitReplacement.lastElement();
    }

    private DocumentObjectInterface createInstallUp(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createInstallUp(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (this.myInstallUp == null) {
            this.myInstallUp = new InstallUp(attributeList, locator);
            return this.myInstallUp;
        }
        return super.errorUnexpectedElement(UnexpectedElementReason.MoreElementsThanExpected, "createInstallUp(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", RootElementName.UpgradePackage.getValue(), string, locator);
    }

    private DocumentObjectInterface createLoadModule(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createLoadModule(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myLoadModulesIsOptimized = false;
        this.myLoadModules.addElement(new LoadModule(attributeList, locator));
        return (LoadModule)this.myLoadModules.lastElement();
    }

    private DocumentObjectInterface createManagedElement(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createManagedElement(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (this.myManagedElement == null) {
            this.myManagedElement = new ManagedElement(attributeList, locator);
            return this.myManagedElement;
        }
        return super.errorUnexpectedElement(UnexpectedElementReason.MoreElementsThanExpected, "createManagedElement(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", RootElementName.UpgradePackage.getValue(), string, locator);
    }

    private DocumentObjectInterface createPiuType(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createPiuType(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myPiuTypesIsOptimized = false;
        this.myPiuTypes.addElement(new PiuType(attributeList, locator));
        return (PiuType)this.myPiuTypes.lastElement();
    }

    private DocumentObjectInterface createSubrackProdType(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createSubrackProdType(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.mySubrackProdType.addElement(new SubrackProdType(attributeList, locator));
        return (SubrackProdType)this.mySubrackProdType.lastElement();
    }

    private DocumentObjectInterface createMandatoryPiuTypeList(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createMandatoryPiuTypeList(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (this.myMandatoryPiuTypeList == null) {
            this.myMandatoryPiuTypeList = new MandatoryPiuTypeList(locator, attributeList);
            return this.myMandatoryPiuTypeList;
        }
        return super.errorUnexpectedElement(UnexpectedElementReason.MoreElementsThanExpected, "createMandatoryPiuTypeList(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", RootElementName.UpgradePackage.getValue(), string, locator);
    }

    private DocumentObjectInterface createCommonPiuTypeList(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createCommonPiuTypeList(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (this.myCommonPiuTypeList == null) {
            this.myCommonPiuTypeList = new CommonPiuTypeList(locator, attributeList);
            return this.myCommonPiuTypeList;
        }
        return super.errorUnexpectedElement(UnexpectedElementReason.MoreElementsThanExpected, "createCommonPiuTypeList(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", RootElementName.UpgradePackage.getValue(), string, locator);
    }

    private DocumentObjectInterface createNodeTypeSpecificPiuTypeList(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createNodeTypeSpecificPiuTypeList(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myNodeTypeSpecificPiuTypeList.addElement(new NodeTypeSpecificPiuTypeList(attributeList, locator));
        return (NodeTypeSpecificPiuTypeList)this.myNodeTypeSpecificPiuTypeList.lastElement();
    }

    private DocumentObjectInterface createUpgradeLogic(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createUpgradeLogic(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (this.myUpgradeLogic == null) {
            this.myUpgradeLogic = new UpgradeLogic(attributeList, locator);
            return this.myUpgradeLogic;
        }
        return super.errorUnexpectedElement(UnexpectedElementReason.MoreElementsThanExpected, "createUpgradeLogic(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", RootElementName.UpgradePackage.getValue(), string, locator);
    }

    private DocumentObjectInterface createProductData(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createProductData(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (this.myProductData == null) {
            this.myProductData = new ProductData(attributeList, locator);
            return this.myProductData;
        }
        return super.errorUnexpectedElement(UnexpectedElementReason.MoreElementsThanExpected, "createProductData(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", RootElementName.UpgradePackage.getValue(), string, locator);
    }

    private DocumentObjectInterface createRepertoire(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createRepertoire(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myRepertoiresIsOptimized = false;
        this.myRepertoires.addElement(new Repertoire(attributeList, locator));
        return (Repertoire)this.myRepertoires.lastElement();
    }

    private DocumentObjectInterface createUP_CompatibilityIndex(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createUP_CompatibilityIndex(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (this.myUP_CompatibilityIndex == null) {
            this.myUP_CompatibilityIndex = new UP_CompatibilityIndex(attributeList, locator);
            return this.myUP_CompatibilityIndex;
        }
        return super.errorUnexpectedElement(UnexpectedElementReason.MoreElementsThanExpected, "createUP_CompatibilityIndex(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", RootElementName.UpgradePackage.getValue(), string, locator);
    }

    private DocumentObjectInterface createInstallSequence(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createInstallSequence(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myInstallSequences.addElement(new InstallSequence(attributeList, locator));
        return (InstallSequence)this.myInstallSequences.lastElement();
    }

    private DocumentObjectInterface createVerifySequence(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createVerifySequence(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myVerifySequences.addElement(new VerifySequence(attributeList, locator));
        return (VerifySequence)this.myVerifySequences.lastElement();
    }

    private DocumentObjectInterface createVerifyUpgradeSequence(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createVerifyUpgradeSequence(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myVerifyUpgradeSequences.addElement(new VerifyUpgradeSequence(attributeList, locator));
        return (VerifyUpgradeSequence)this.myVerifyUpgradeSequences.lastElement();
    }

    private DocumentObjectInterface createVerifyUpdateSequence(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createVerifyUpdateSequence(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myVerifyUpdateSequences.addElement(new VerifyUpdateSequence(attributeList, locator));
        return (VerifyUpdateSequence)this.myVerifyUpdateSequences.lastElement();
    }

    private DocumentObjectInterface createUpgradeSequence(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createUpgradeSequence(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myUpgradeSequences.addElement(new UpgradeSequence(attributeList, locator));
        return (UpgradeSequence)this.myUpgradeSequences.lastElement();
    }

    private DocumentObjectInterface createUpgradeWindow(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createUpgradeWindow(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (this.myUpgradeWindow == null) {
            this.myUpgradeWindow = new UpgradeWindow(attributeList, locator);
            return this.myUpgradeWindow;
        }
        return super.errorUnexpectedElement(UnexpectedElementReason.MoreElementsThanExpected, "createUpgradeWindow(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", RootElementName.UpgradePackage.getValue(), string, locator);
    }

    private DocumentObjectInterface createTransform(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createTransform(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName:" + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator:" + locator));
        }
        if (this.myTransform == null) {
            this.myTransform = new Transform(attributeList, locator);
            return this.myTransform;
        }
        return super.errorUnexpectedElement(UnexpectedElementReason.SubElementNotAllowed, "createTransform(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", RootElementName.UpgradePackage.getValue(), string, locator);
    }

    private void resetCommonDocumentInformationIgnoredUnknownAttributes() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"resetCommonDocumentInformationIgnoredUnknownAttributes( )");
        }
        CommonDocumentObjectInformation.getInstance().resetIgnoredUnknownAttributes();
    }

    private void resetCommonDocumentInformationIgnoredUnknownSubElements() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"resetCommonDocumentInformationIgnoredUnknownSubElements( )");
        }
        CommonDocumentObjectInformation.getInstance().resetIgnoredUnknownSubElements();
    }

    private void setCommonDocumentInformationIgnoreUnknownAttributes(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setCommonDocumentInformationIgnoreUnknownAttributes(String anIgnoreUnknownAttributes)", (String)("anIgnoreUnknownAttributes: " + string));
        }
        if (string == null || string.equals("")) {
            CommonDocumentObjectInformation.getInstance().setIgnoreUnknownAttributes(false);
        } else if (string.equals("yes")) {
            CommonDocumentObjectInformation.getInstance().setIgnoreUnknownAttributes(true);
        } else {
            CommonDocumentObjectInformation.getInstance().setIgnoreUnknownAttributes(false);
        }
    }

    private void setCommonDocumentInformationIgnoreUnknownElements(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setCommonDocumentInformationIgnoreUnknownElements(String anIgnoreUnknownElements)", (String)("anIgnoreUnknownElements: " + string));
        }
        if (string == null || string.equals("")) {
            CommonDocumentObjectInformation.getInstance().setIgnoreUnknownElements(false);
        } else if (string.equals("yes")) {
            CommonDocumentObjectInformation.getInstance().setIgnoreUnknownElements(true);
        } else {
            CommonDocumentObjectInformation.getInstance().setIgnoreUnknownElements(false);
        }
    }

    private void setCommonDocumentInformationSyntaxVersion(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setCommonDocumentInformationSyntaxVersion(String aSyntaxVersion)", (String)("aSyntaxVersion: " + string));
        }
        if (string == null || string.equals("")) {
            CommonDocumentObjectInformation.getInstance().setSyntaxVersion("L");
        } else {
            CommonDocumentObjectInformation.getInstance().setSyntaxVersion(string);
        }
    }

    public void setGeneralComments(Vector vector) {
        this.myGeneralComments = vector;
    }

    private DocumentObjectInterface createUpdateSequence(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createUpdateSequence(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (this.myUpdateSequence == null) {
            this.myUpdateSequence = new UpdateSequence(attributeList, locator);
            return this.myUpdateSequence;
        }
        return super.errorUnexpectedElement(UnexpectedElementReason.MoreElementsThanExpected, "createUpdateSequence(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", RootElementName.UpgradePackage.getValue(), string, locator);
    }

    public UpdateSequence getUpdateSequence() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getUpdateSequence( )");
        }
        return this.myUpdateSequence;
    }

    public void setUpdateSequence(UpdateSequence updateSequence) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setUpdateSequence(Vector anUpdateSequence)", (String)("anUpdateSequence: " + updateSequence));
        }
        this.myUpdateSequence = updateSequence;
    }

    public String getHW_Sensitive() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getHW_Sensitive( )");
        }
        return this.myHW_Sensitive;
    }

    public void setHW_Sensitive(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setHW_Sensitive( )", (String)("aString: " + string));
        }
        this.myHW_Sensitive = string;
    }

    public String getIsSignedSW() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getIsSignedSW( )");
        }
        return this.myIsSignedSW;
    }

    public void setIsSignedSW(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setIsSignedSW( )", (String)("aString: " + string));
        }
        this.myIsSignedSW = string;
    }

    public String getIsObsoleteLmUP() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getIsObsoleteLmUP( )");
        }
        return this.myIsObsoleteLmUP;
    }

    public void setIsObsoleteLmUP(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setIsObsoleteLmUP( )", (String)("aString: " + string));
        }
        this.myIsObsoleteLmUP = string;
    }

    public MandatoryPiuTypeList getMandatoryPiuTypeList() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getMandatoryPiuTypeList");
        }
        return this.myMandatoryPiuTypeList;
    }

    public CommonPiuTypeList getCommonPiuTypeList() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getCommonPiuTypeList");
        }
        return this.myCommonPiuTypeList;
    }

    public Vector getNodeTypeSpecificPiuTypeList() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getNodeTypeSpecificPiuTypeList()");
        }
        return this.myNodeTypeSpecificPiuTypeList;
    }

    public boolean isOptimized() {
        boolean bl = false;
        if (this.isLoadModulesOptimized() && this.isPiuTypesOptimized() && this.isRepertoiresOptimized()) {
            bl = true;
        }
        return bl;
    }

    public boolean isLoadModulesOptimized() {
        return this.myLoadModulesIsOptimized;
    }

    public boolean isPiuTypesOptimized() {
        return this.myPiuTypesIsOptimized;
    }

    public boolean isRepertoiresOptimized() {
        return this.myRepertoiresIsOptimized;
    }
}

