/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.explicitreplacement;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.IllegalAttributeValueException;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeException;
import se.ericsson.cello.sudom.parser.dom.UnexpectedElementReason;
import se.ericsson.cello.sudom.parser.dom.exceptions.UnexpectedElementException;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.ExplicitReplacementSubElementName;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.NewRpu;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.NewRpuAttributeName;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.OldRpu;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.OldRpu2;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.OldRpu2_AttributeName;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.OldRpuAttributeName;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.RpuAddition;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.RpuAdditionAttributeName;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.RpuAdditionSubElementName;
import se.ericsson.cello.sudom.parser.dom.validators.Validator;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class RpuAdditionValidator
extends Validator {
    private static final String MODIFY_EXISTING = "modifyExisting";
    private static final String CREATE_USING_TWO = "createUsingTwo";
    private static final String CREATE_USING_ONE = "createUsingOne";

    public static void validate(RpuAddition rpuAddition) throws ValidateException {
        String string;
        if (UpgradeTrace.valid((Class)RpuAdditionValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)RpuAdditionValidator.class, (int)25, (String)"validate(RpuAddition anRpuAddition)", (String)("anRpuAddition: " + rpuAddition));
        }
        if ((string = RpuAdditionValidator.getTypeOfElement(rpuAddition)).equals(MODIFY_EXISTING)) {
            RpuAdditionValidator.validateA_ModifyExistingElement(rpuAddition);
        } else if (string.equals(CREATE_USING_TWO)) {
            RpuAdditionValidator.validateA_CreateUsingTwoOldElement(rpuAddition);
        }
    }

    public static void validate(Vector vector) throws ValidateException {
        Vector vector2;
        if (UpgradeTrace.valid((Class)RpuAdditionValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)RpuAdditionValidator.class, (int)25, (String)"validate(Vector anRpuAdditions)", (String)("anRpuAdditions: " + vector));
        }
        if (!vector.isEmpty() && (vector2 = RpuAdditionValidator.extractRequestedTypeOfElements(vector, MODIFY_EXISTING)).size() > 1) {
            RpuAdditionValidator.validateThatOldRpusAreUniqueInRpuAdditions(vector2);
        }
    }

    private static String getTypeOfElement(RpuAddition rpuAddition) {
        if (UpgradeTrace.valid((Class)RpuAdditionValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)RpuAdditionValidator.class, (int)25, (String)"getTypeOfElement(RpuAddition anRpuAddition)", (String)("anRpuAddition: " + rpuAddition));
        }
        if (rpuAddition.getModifyExisting() != null) {
            return MODIFY_EXISTING;
        }
        if (rpuAddition.getOldRpu2() != null) {
            return CREATE_USING_TWO;
        }
        return CREATE_USING_ONE;
    }

    private static Vector extractRequestedTypeOfElements(Vector vector, String string) {
        if (UpgradeTrace.valid((Class)RpuAdditionValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)RpuAdditionValidator.class, (int)25, (String)"extractRequestedTypeOfElements(Vector anRpuAdditions, String aRequestedTypeOfElement)", (String)("anRpuAdditions: " + vector + "\n\taRequestedTypeOfElement: " + string));
        }
        Vector<RpuAddition> vector2 = new Vector<RpuAddition>(1);
        Iterator iterator = vector.iterator();
        RpuAddition rpuAddition = null;
        while (iterator.hasNext()) {
            rpuAddition = (RpuAddition)iterator.next();
            if (!RpuAdditionValidator.getTypeOfElement(rpuAddition).equals(string)) continue;
            vector2.addElement(rpuAddition);
        }
        return vector2;
    }

    private static void validateA_CreateUsingTwoOldElement(RpuAddition rpuAddition) throws IllegalAttributeValueException, UnexpectedAttributeException {
        if (UpgradeTrace.valid((Class)RpuAdditionValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)RpuAdditionValidator.class, (int)25, (String)"validateA_CreateUsingTwoOldElement(RpuAddition anRpuAddition)", (String)("anRpuAddition: " + rpuAddition));
        }
        String string = null;
        OldRpu2 oldRpu2 = rpuAddition.getOldRpu2();
        if (oldRpu2.getRpLabel().equals(rpuAddition.getOldRpu().getRpLabel())) {
            string = "\n\tThe value of attribute " + OldRpu2_AttributeName.RpLabel.getValue() + " in the " + RpuAdditionSubElementName.OldRpu2.getValue() + "\n\telement is not allowed to be equal to the value in the " + RpuAdditionSubElementName.OldRpu.getValue() + " element (within an " + ExplicitReplacementSubElementName.RpuAddition.getValue() + " element).";
            RpuAdditionValidator.errorIllegalAttributeValueWithLocatorString(RpuAdditionValidator.class, "validateA_CreateUsingTwoOldElement(RpuAddition anRpuAddition)", RpuAdditionSubElementName.OldRpu2.getValue(), OldRpu2_AttributeName.RpLabel.getValue(), oldRpu2.getRpLabel(), string, oldRpu2.getLocatorString());
        }
        NewRpu newRpu = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        Iterator iterator = rpuAddition.getNewRpus().iterator();
        while (iterator.hasNext()) {
            newRpu = (NewRpu)iterator.next();
            if (newRpu.getReverseRelations() != null) {
                string2 = NewRpuAttributeName.ReverseRelations.getValue();
                string3 = newRpu.getLocatorString();
                bl = true;
                break;
            }
            if (newRpu.getOneLegged() == null) continue;
            string2 = NewRpuAttributeName.OneLegged.getValue();
            string3 = newRpu.getLocatorString();
            bl = true;
            break;
        }
        if (bl) {
            string = "\n\tAttribute " + string2 + " is not allowed in any of the " + RpuAdditionSubElementName.NewRpu.getValue() + " elements when the" + "\n\t" + ExplicitReplacementSubElementName.RpuAddition.getValue() + " element contains an " + RpuAdditionSubElementName.OldRpu2.getValue() + " element.";
            RpuAdditionValidator.errorUnexpectedAttributeWithLocatorString(RpuAdditionValidator.class, "validateA_CreateUsingTwoOldElement(RpuAddition anRpuAddition)", ExplicitReplacementSubElementName.RpuAddition.getValue(), RpuAdditionSubElementName.NewRpu.getValue(), string2, string, string3);
        }
    }

    private static void validateA_ModifyExistingElement(RpuAddition rpuAddition) throws IllegalAttributeValueException, UnexpectedElementException, UnexpectedAttributeException {
        NewRpu newRpu;
        Vector vector;
        if (UpgradeTrace.valid((Class)RpuAdditionValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)RpuAdditionValidator.class, (int)25, (String)"validateA_ModifyExistingElement(RpuAddition anRpuAddition, Locator aLocator)", (String)("anRpuAddition: " + rpuAddition));
        }
        String string = null;
        OldRpu2 oldRpu2 = rpuAddition.getOldRpu2();
        if (oldRpu2 != null && oldRpu2.getRpLabel().equals(rpuAddition.getOldRpu().getRpLabel())) {
            string = "\n\tThe value of attribute " + OldRpu2_AttributeName.RpLabel.getValue() + " in the " + RpuAdditionSubElementName.OldRpu2.getValue() + "\n\telement is not allowed to be equal to the value in the " + RpuAdditionSubElementName.OldRpu.getValue() + " element (within an " + ExplicitReplacementSubElementName.RpuAddition.getValue() + " element).";
            RpuAdditionValidator.errorIllegalAttributeValueWithLocatorString(RpuAdditionValidator.class, "validateA_CreateUsingTwoOldElement(RpuAddition anRpuAddition)", RpuAdditionSubElementName.OldRpu2.getValue(), OldRpu2_AttributeName.RpLabel.getValue(), oldRpu2.getRpLabel(), string, oldRpu2.getLocatorString());
        }
        if ((vector = rpuAddition.getNewRpus()).size() > 1) {
            string = "\n\tOnly one " + RpuAdditionSubElementName.NewRpu.getValue() + " element is allowed when the " + ExplicitReplacementSubElementName.RpuAddition.getValue() + " element contains attribute " + RpuAdditionAttributeName.ModifyExisting.getValue() + ".";
            RpuAdditionValidator.errorUnexpectedElementWithLocatorString(UnexpectedElementReason.MoreElementsThanExpected, RpuAdditionValidator.class, "validateA_ModifyExistingElement(RpuAddition anRpuAddition)", ExplicitReplacementSubElementName.RpuAddition.getValue(), RpuAdditionSubElementName.NewRpu.getValue(), string, ((NewRpu)vector.elementAt(1)).getLocatorString());
        }
        if ((newRpu = (NewRpu)vector.elementAt(0)).getReverseRelations() != null) {
            string = "\n\tAttribute " + NewRpuAttributeName.ReverseRelations.getValue() + " is not allowed in the " + RpuAdditionSubElementName.NewRpu.getValue() + " element when the" + "\n\t" + ExplicitReplacementSubElementName.RpuAddition.getValue() + " element contains attribute " + RpuAdditionAttributeName.ModifyExisting.getValue() + ".";
            RpuAdditionValidator.errorUnexpectedAttributeWithLocatorString(RpuAdditionValidator.class, "validateA_ModifyExistingElement(RpuAddition anRpuAddition)", ExplicitReplacementSubElementName.RpuAddition.getValue(), RpuAdditionSubElementName.NewRpu.getValue(), NewRpuAttributeName.ReverseRelations.getValue(), string, newRpu.getLocatorString());
        }
        if (newRpu.getCreateOnlyIfNotExisting() != null) {
            string = "\n\tAttribute " + NewRpuAttributeName.CreateOnlyIfNotExisting.getValue() + " is not allowed in the " + RpuAdditionSubElementName.NewRpu.getValue() + " element when the" + "\n\t" + ExplicitReplacementSubElementName.RpuAddition.getValue() + " element contains attribute " + RpuAdditionAttributeName.ModifyExisting.getValue() + ".";
            RpuAdditionValidator.errorUnexpectedAttributeWithLocatorString(RpuAdditionValidator.class, "validateA_ModifyExistingElement(RpuAddition anRpuAddition)", ExplicitReplacementSubElementName.RpuAddition.getValue(), RpuAdditionSubElementName.NewRpu.getValue(), NewRpuAttributeName.CreateOnlyIfNotExisting.getValue(), string, newRpu.getLocatorString());
        }
        if (oldRpu2 != null && newRpu.getOneLegged() != null) {
            string = "\n\tAttribute " + NewRpuAttributeName.OneLegged.getValue() + " is not allowed in the " + RpuAdditionSubElementName.NewRpu.getValue() + " element when the" + "\n\t" + ExplicitReplacementSubElementName.RpuAddition.getValue() + " element contains an " + RpuAdditionSubElementName.OldRpu2.getValue() + " element.";
            RpuAdditionValidator.errorUnexpectedAttributeWithLocatorString(RpuAdditionValidator.class, "validateA_ModifyExistingElement(RpuAddition anRpuAddition)", ExplicitReplacementSubElementName.RpuAddition.getValue(), RpuAdditionSubElementName.NewRpu.getValue(), NewRpuAttributeName.OneLegged.getValue(), string, newRpu.getLocatorString());
        }
    }

    private static void validateThatOldRpusAreUniqueInRpuAdditions(Vector vector) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid((Class)RpuAdditionValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)RpuAdditionValidator.class, (int)25, (String)"validateThatOldRpusAreUniqueInRpuAdditions(Vector anRpuAdditions)", (String)("anRpuAdditions: " + vector));
        }
        HashSet<String> hashSet = new HashSet<String>();
        OldRpu oldRpu = null;
        String string = null;
        boolean bl = false;
        Object object = vector.iterator();
        while (object.hasNext()) {
            oldRpu = ((RpuAddition)object.next()).getOldRpu();
            if (hashSet.add(oldRpu.getRpLabel())) continue;
            string = oldRpu.getLocatorString();
            bl = true;
            break;
        }
        if (bl) {
            object = "\n\tThe " + RpuAdditionSubElementName.OldRpu.getValue() + " element must be unique among the " + ExplicitReplacementSubElementName.RpuAddition.getValue() + " elements that contains attribute " + RpuAdditionAttributeName.ModifyExisting.getValue() + ".";
            String string2 = "TheOldRpu 'null'";
            if (oldRpu != null) {
                string2 = oldRpu.getRpLabel();
            }
            RpuAdditionValidator.errorIllegalAttributeValueWithLocatorString(RpuAdditionValidator.class, "validateThatOldRpusAreUniqueInRpuAdditions(Vector anRpuAdditions)", RpuAdditionSubElementName.OldRpu.getValue(), OldRpuAttributeName.RpLabel.getValue(), string2, (String)object, string);
        }
    }
}

