/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.repertoire;

import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.dom.repertoire.PiuTypeLoadList;
import se.ericsson.cello.sudom.parser.dom.repertoire.PiuTypeLoadListSubElementName;
import se.ericsson.cello.sudom.parser.dom.repertoire.Repertoire;
import se.ericsson.cello.sudom.parser.dom.repertoire.RepertoireSubElementName;
import se.ericsson.cello.sudom.parser.dom.validators.Validator;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class RepertoireValidator
extends Validator {
    public static void validate(Repertoire repertoire, Locator locator) throws ValidateException {
        if (UpgradeTrace.valid((Class)RepertoireValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)RepertoireValidator.class, (int)25, (String)"validate(Repertoire aRepertoire, Locator aLocator)", (String)("aRepertoire: " + repertoire + "\n\taLocator: " + locator));
        }
        RepertoireValidator.validateCardinalityLoadModuleRef(repertoire, locator);
    }

    private static void validateCardinalityLoadModuleRef(Repertoire repertoire, Locator locator) throws ValidateException {
        if (UpgradeTrace.valid((Class)RepertoireValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)RepertoireValidator.class, (int)25, (String)"validateCardinalityLoadModuleRef(Repertoire aRepertoire, Locator aLocator)", (String)("aRepertoire: " + repertoire + "\n\taLocator: " + locator));
        }
        Vector vector = repertoire.getPiuTypeLoadLists();
        Iterator iterator = vector.iterator();
        PiuTypeLoadList piuTypeLoadList = null;
        Vector vector2 = null;
        Vector vector3 = null;
        while (iterator.hasNext()) {
            piuTypeLoadList = (PiuTypeLoadList)iterator.next();
            vector2 = piuTypeLoadList.getLoadModuleRefs();
            vector3 = piuTypeLoadList.getPiuTypeRefs();
            if (!vector2.isEmpty() || !vector3.isEmpty()) continue;
            String string = "\n\tAt least one " + PiuTypeLoadListSubElementName.LoadModuleRef.getValue() + " element or one " + PiuTypeLoadListSubElementName.PiuTypeRef.getValue() + " element must be defined within a " + RepertoireSubElementName.PiuTypeLoadList.getValue() + " in a " + "Repertoire" + ".";
            RepertoireValidator.errorElementIsMissing(class$se$ericsson$cello$sudom$parser$dom$repertoire$RepertoireValidator == null ? RepertoireValidator.class$("se.ericsson.cello.sudom.parser.dom.repertoire.RepertoireValidator") : class$se$ericsson$cello$sudom$parser$dom$repertoire$RepertoireValidator, "validateCardinalityLoadModuleRef(Repertoire aRepertoire, Locator aLocator)", "Repertoire", RepertoireSubElementName.PiuTypeLoadList.getValue(), PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), string, locator);
        }
    }
}

