/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.upgradesequence;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.IllegalAttributeValueException;
import se.ericsson.cello.sudom.parser.RootElementName;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeException;
import se.ericsson.cello.sudom.parser.dom.CommonDocumentObjectInformation;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.Step;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.StepAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.StepSubElementName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.Trigger;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.TriggerAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.TriggerSubSpecValue;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.UpgradeSequence;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.UpgradeSequenceAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.UpgradeSequenceSubElementName;
import se.ericsson.cello.sudom.parser.dom.validators.Validator;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class UpgradeSequenceValidator
extends Validator {
    public static void validate(UpgradeSequence upgradeSequence, Locator locator) throws ValidateException {
        if (UpgradeTrace.valid((Class)UpgradeSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)UpgradeSequenceValidator.class, (int)25, (String)"validate(UpgradeSequence anUpgradeSequence, Locator aLocator)", (String)("anUpgradeSequence: " + upgradeSequence + "\n\taLocator: " + locator));
        }
        if (!CommonDocumentObjectInformation.getInstance().getIgnoreUnknownAttributes()) {
            UpgradeSequenceValidator.validateNotExpectedAttributes(upgradeSequence, locator);
        }
        Vector vector = upgradeSequence.getSteps();
        Iterator iterator = vector.iterator();
        Step step = null;
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            step = (Step)iterator.next();
            UpgradeSequenceValidator.validateThatLabelInAllStepsIsUnique(step, hashSet);
            UpgradeSequenceValidator.valdateThatTriggerInStepContainsAllowedSubSpecValue(step);
        }
    }

    private static void validateNotExpectedAttributes(UpgradeSequence upgradeSequence, Locator locator) throws UnexpectedAttributeException {
        if (UpgradeTrace.valid((Class)UpgradeSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)UpgradeSequenceValidator.class, (int)25, (String)"validateNotExpectedAttributes(UpgradeSequence anUpgradeSequence, Locator aLocator)", (String)("anUpgradeSequence: " + upgradeSequence + "\n\taLocator: " + locator));
        }
        if (upgradeSequence.getErrorEscalation() != null) {
            String[] stringArray = new String[]{UpgradeSequenceAttributeName.ErrorEscalation.getValue()};
            String string = "\n\tThe label attribute of the upgrade sequence is: \n\tLabel : " + upgradeSequence.getLabel();
            UpgradeSequenceValidator.errorUnexpectedAttribute(UpgradeSequenceValidator.class, "validateNotExpectedAttributes(UpgradeSequence anUpgradeSequence, Locator aLocator)", RootElementName.UpgradePackage.getValue(), "UpgradeSequence", stringArray, string, locator);
        }
    }

    private static void validateThatLabelInAllStepsIsUnique(Step step, HashSet hashSet) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid((Class)UpgradeSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)UpgradeSequenceValidator.class, (int)25, (String)"validateThatLabelInAllStepsIsUnique(Step aStep, HashSet aLabels)", (String)("aStep: " + step + "\n\taLabels: " + hashSet));
        }
        if (!hashSet.add(step.getLabel().toUpperCase())) {
            String string = "\n\tThe value of this attribute must be unique among all " + UpgradeSequenceSubElementName.Step.getValue() + " elements in this " + "UpgradeSequence" + ".";
            UpgradeSequenceValidator.errorIllegalAttributeValueWithLocatorString(UpgradeSequenceValidator.class, "validateThatLabelInAllStepsIsUnique(Step aStep, HashSet aLabels)", UpgradeSequenceSubElementName.Step.getValue(), StepAttributeName.Label.getValue(), step.getLabel(), string, step.getLocatorString());
        }
    }

    private static void valdateThatTriggerInStepContainsAllowedSubSpecValue(Step step) throws ValidateException {
        if (UpgradeTrace.valid((Class)UpgradeSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)UpgradeSequenceValidator.class, (int)25, (String)"valdateThatTriggerInStepContainsAllowedSubSpecValue(Step aStep)", (String)("aStep: " + step));
        }
        Vector vector = step.getTrigger();
        Iterator iterator = vector.iterator();
        Trigger trigger = null;
        String string = null;
        while (iterator.hasNext()) {
            trigger = (Trigger)iterator.next();
            string = trigger.getSubSpec();
            if (TriggerSubSpecValue.isValuePreDefinedForUpgradeSequence(string) || !TriggerSubSpecValue.isValuePreDefinedForPreCheckSequence(string)) continue;
            String string2 = "\n\tThe requested value is one of the values that is predefined for a VerifyUpgradeSequence,";
            if (TriggerSubSpecValue.isValuePreDefinedForInstallSequence(string)) {
                string2 = "\n\tThe requested value is the value that is predefined for an InstallSequence,";
            } else if (TriggerSubSpecValue.isValuePreDefinedForVerifySequence(string)) {
                string2 = "\n\tThe requested value is the value that is predefined for a VerifySequence,";
            } else if (TriggerSubSpecValue.isValuePreDefinedForVerifyUpdateSequence(string)) {
                string2 = "\n\tThe requested value is the value that is predefined for a VerifyUpdateSequence,";
            }
            String string3 = "\n\tthis value is not allowed in an UpgradeSequence.";
            UpgradeSequenceValidator.errorIllegalAttributeValueWithLocatorString(class$se$ericsson$cello$sudom$parser$dom$upgradesequence$UpgradeSequenceValidator == null ? UpgradeSequenceValidator.class$("se.ericsson.cello.sudom.parser.dom.upgradesequence.UpgradeSequenceValidator") : class$se$ericsson$cello$sudom$parser$dom$upgradesequence$UpgradeSequenceValidator, "valdateThatTriggerInStepContainsAllowedSubSpecValue(Step aStep)", UpgradeSequenceSubElementName.Step.getValue(), StepSubElementName.Trigger.getValue(), TriggerAttributeName.SubSpec.getValue(), string, string2 + string3, trigger.getLocatorString());
        }
    }
}

