/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.proxy.validators;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.LoaderName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.TypeOfUCF;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.TypeOfUpgrade;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionInterface;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionRawInterface;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevisionRaw;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.DuplicadedUpgradeSequencesInformation;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.MultipleUpgradeSequencesInformation;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.SupportedSequenceInformation;
import se.ericsson.cello.sudom.parser.IllegalAttributeValueException;
import se.ericsson.cello.sudom.parser.InvalidMainElementNameException;
import se.ericsson.cello.sudom.parser.MainElementNames;
import se.ericsson.cello.sudom.parser.MandatoryElementIsMissingException;
import se.ericsson.cello.sudom.parser.NotAllowedCombinationException;
import se.ericsson.cello.sudom.parser.RootElementName;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeException;
import se.ericsson.cello.sudom.parser.dom.CommonDocumentObjectInformation;
import se.ericsson.cello.sudom.parser.dom.FromStateInformation;
import se.ericsson.cello.sudom.parser.dom.UpgradePackageAttributeName;
import se.ericsson.cello.sudom.parser.dom.UpgradePackageSyntaxVersionValue;
import se.ericsson.cello.sudom.parser.dom.deltaaddition.PiuTypeNodeTypeAdditionSubElementName;
import se.ericsson.cello.sudom.parser.dom.exceptions.UnexpectedElementException;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.ExplicitReplacementSubElementName;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.LoadModuleReplacementSubElementName;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.NewRepAttributeName;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.NewRpuAttributeName;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.PiuTypeReplacementSubElementName;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.RepertoireReplacementSubElementName;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.RpuAdditionSubElementName;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.SubrackProdTypeReplacementSubElementName;
import se.ericsson.cello.sudom.parser.dom.installsequence.InstallSequenceAttributeName;
import se.ericsson.cello.sudom.parser.dom.installsequence.InstallSequenceSubElementName;
import se.ericsson.cello.sudom.parser.dom.installsequence.InstallStepSubElementName;
import se.ericsson.cello.sudom.parser.dom.installsequence.LoadJavaLM_AttributeName;
import se.ericsson.cello.sudom.parser.dom.installsequence.PreUpgradeSuAttributeName;
import se.ericsson.cello.sudom.parser.dom.installsequence.PreUpgradeSuSubElementName;
import se.ericsson.cello.sudom.parser.dom.installsequence.SoftJvmUpgradeSubElementName;
import se.ericsson.cello.sudom.parser.dom.loadmodule.LoadModuleSubElementName;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM_AttributeName;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM_LoaderNameValue;
import se.ericsson.cello.sudom.parser.dom.nodetypespecificpiutypelist.NodeTypeSpecificPiuTypeListAttributeName;
import se.ericsson.cello.sudom.parser.dom.piutype.PiuTypeSubElementName;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductData;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductDataAttributeName;
import se.ericsson.cello.sudom.parser.dom.repertoire.LoadModuleRef;
import se.ericsson.cello.sudom.parser.dom.repertoire.LoadModuleRefAttributeName;
import se.ericsson.cello.sudom.parser.dom.repertoire.PiuTypeLoadListSubElementName;
import se.ericsson.cello.sudom.parser.dom.repertoire.RepertoireAttributeName;
import se.ericsson.cello.sudom.parser.dom.repertoire.RepertoireSubElementName;
import se.ericsson.cello.sudom.parser.dom.subrackprodtype.SubrackProdTypeSubElementName;
import se.ericsson.cello.sudom.parser.dom.upcompatibilityindex.UP_CompatibilityIndex;
import se.ericsson.cello.sudom.parser.dom.updatesequence.UpdateSequenceSubElementName;
import se.ericsson.cello.sudom.parser.dom.upgradelogic.SuLmRefAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradelogic.UpgradeLogicAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradelogic.UpgradeLogicSubElementName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.AddJavaLM_AttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.FindPiuAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.FindPiuToTolerateAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RebootNodeUpgradeSubElementName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RebootPiuUpgradeSubElementName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RebootProgramUpgradeSubElementName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RemoveJavaLM_AttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RemoveProgramsAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RunProgramsAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.StepSubElementName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.UpgradeCaseRefAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.UpgradeSequence;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.UpgradeSequenceAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.UpgradeSequenceSubElementName;
import se.ericsson.cello.sudom.parser.dom.upgradewindow.OldUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.upgradewindow.OldUpgradePackageSubElementName;
import se.ericsson.cello.sudom.parser.dom.upgradewindow.OtherUpgradePackages;
import se.ericsson.cello.sudom.parser.dom.upgradewindow.PreUpgradeCaseAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradewindow.UpgradeCaseAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradewindow.UpgradeWindowSubElementName;
import se.ericsson.cello.sudom.parser.dom.validators.LoadModuleFilePathLengthOutOfRangeException;
import se.ericsson.cello.sudom.parser.dom.validators.ReferencedElementMissingException;
import se.ericsson.cello.sudom.parser.dom.validators.Validator;
import se.ericsson.cello.sudom.parser.dom.verifysequence.VerifySequenceAttributeName;
import se.ericsson.cello.sudom.parser.dom.verifysequence.VerifySequenceSubElementName;
import se.ericsson.cello.sudom.parser.dom.verifysequence.VerifyStepSubElementName;
import se.ericsson.cello.sudom.parser.dom.verifyupdatesequence.VerifyUpdateSequenceSubElementName;
import se.ericsson.cello.sudom.parser.dom.verifyupdatesequence.VerifyUpdateStepSubElementName;
import se.ericsson.cello.sudom.parser.dom.verifyupgradesequence.VerifyUpgradeSequenceSubElementName;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.commonpiutypelist.CommonPiuTypeListProxyInterface;
import se.ericsson.cello.sudom.proxy.deltaaddition.DeltaAdditionsProxyInterface;
import se.ericsson.cello.sudom.proxy.deltaaddition.PiuTypeNodeTypeAdditionsProxyInterface;
import se.ericsson.cello.sudom.proxy.exceptions.UCF_ValidationException;
import se.ericsson.cello.sudom.proxy.explicitaddition.ExplicitAdditionsProxyInterface;
import se.ericsson.cello.sudom.proxy.explicitreplacement.ExplicitReplacementsProxyInterface;
import se.ericsson.cello.sudom.proxy.explicitreplacement.LoadModuleReplacementsProxyInterface;
import se.ericsson.cello.sudom.proxy.explicitreplacement.PiuTypeReplacementsProxyInterface;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RepertoireReplacementsProxyInterface;
import se.ericsson.cello.sudom.proxy.explicitreplacement.SubrackProdTypeReplacementsProxyInterface;
import se.ericsson.cello.sudom.proxy.installsequence.InstallSequenceInterface;
import se.ericsson.cello.sudom.proxy.installsequence.InstallSequencesProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesWithLoaderNamesInformation;
import se.ericsson.cello.sudom.proxy.mandatorypiutypelist.MandatoryPiuTypeListProxyInterface;
import se.ericsson.cello.sudom.proxy.nodetypespecificpiutypelist.NodeTypeSpecificPiuTypeListContainer;
import se.ericsson.cello.sudom.proxy.nodetypespecificpiutypelist.NodeTypeSpecificPiuTypeListsProxyInterface;
import se.ericsson.cello.sudom.proxy.piutype.PiuTypesProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.LoadModuleRefsWithLoaderNamesInformation;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.sudom.proxy.subrackprodtype.SubrackProdTypesProxyInterface;
import se.ericsson.cello.sudom.proxy.updatesequence.UpdateSequenceProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradelogic.UpgradeLogicProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradesequence.UpgradeSequenceProxy;
import se.ericsson.cello.sudom.proxy.upgradesequence.UpgradeSequencesProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradewindow.UpgradeWindowProxyInterface;
import se.ericsson.cello.sudom.proxy.verifysequence.VerifySequenceInterface;
import se.ericsson.cello.sudom.proxy.verifysequence.VerifySequencesProxyInterface;
import se.ericsson.cello.sudom.proxy.verifyupdatesequence.VerifyUpdateSequenceInterface;
import se.ericsson.cello.sudom.proxy.verifyupdatesequence.VerifyUpdateSequencesProxyInterface;
import se.ericsson.cello.sudom.proxy.verifyupgradesequence.VerifyUpgradeSequenceInterface;
import se.ericsson.cello.sudom.proxy.verifyupgradesequence.VerifyUpgradeSequencesProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.InstallLM_Container;

public class DocumentObjectValidator
extends Validator {
    private int maximumLoadModuleSourceFilePathLength = 256;
    private int maximumLoadModuleDestinationFilePathLength = 256;

    public void validate(DocumentObjectProxyInterface documentObjectProxyInterface, String string) throws UCF_ValidationException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validate(DocumentObjectUpgradePackage aDocumentObjectUpgradePackage, String anUpgradeControlFileSourceAbsolutePath)", (String)("aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "anUpgradeControlFileSourceAbsolutePath: " + string));
        }
        try {
            this.validateThatProductNumbersWithWildCardRevisionAreUnique(documentObjectProxyInterface, "PiuType");
            this.validateThatUpgradeSequenceReferedFromOldUpgradePackageIsUnique(documentObjectProxyInterface);
            this.validateThatProductNumbersWithWildCardRevisionAreUnique(documentObjectProxyInterface, "SubrackProdType");
            this.validateThatProductNumbersWithSpecificRevisionAreUnique(documentObjectProxyInterface, "SubrackProdType");
            this.validateThatTheNameInRepertoireIsUnique(documentObjectProxyInterface);
            this.validateThatAttributeCaseInUpgradeCaseRefsInExplicitReplacementsIsUnique(documentObjectProxyInterface);
            this.validateThatUpgradeWindowReferencedFromExplicitReplacementIsPresent(documentObjectProxyInterface);
            this.validateThatLabelInAllInstallSequencesIsUnique(documentObjectProxyInterface);
            this.validateThatAttributeCaseInUpgradeCaseRefsInInstallSequencesIsUnique(documentObjectProxyInterface);
            this.validateThatUpgradeWindowReferencedFromInstallSequenceIsPresent(documentObjectProxyInterface);
            this.validateThatLabelInAllVerifySequencesIsUnique(documentObjectProxyInterface);
            this.validateThatAttributeCaseInUpgradeCaseRefsInVerifySequencesIsUnique(documentObjectProxyInterface);
            this.validateThatUpgradeWindowReferencedFromVerifySequenceIsPresent(documentObjectProxyInterface);
            this.validateThatLabelInAllVerifyUpgradeSequencesIsUnique(documentObjectProxyInterface);
            this.validateThatAttributeCaseInUpgradeCaseRefsInVerifyUpgradeSequencesIsUnique(documentObjectProxyInterface);
            this.validateThatUpgradeCaseRefsInVerifyUpgradeSequencesExistsInAnUpgradeSequence(documentObjectProxyInterface);
            this.validateThatLabelInAllVerifyUpdateSequencesIsUnique(documentObjectProxyInterface);
            this.validateThatAttributeCaseInUpgradeCaseRefsInVerifyUpdateSequencesIsUnique(documentObjectProxyInterface);
            this.validateThatUpgradeCaseRefsInVerifyUpdateSequencesExistsInTheUpdateSequence(documentObjectProxyInterface);
            this.validateThatUpgradePackageContainsUpgradeSequenceOrUpdateSequence(documentObjectProxyInterface);
            this.validateThatUpgradeWindowReferencedFromUpdateSequenceIsPresent(documentObjectProxyInterface);
            this.validateThatLabelInAllUpgradeSequencesIsUnique(documentObjectProxyInterface);
            this.validateThatAttributeCaseInUpgradeCaseRefsInUpgradeSequencesIsUnique(documentObjectProxyInterface);
            this.validateThatUpgradeWindowReferencedFromUpgradeSequenceIsPresent(documentObjectProxyInterface);
            this.validateLoadModuleFilePathLengths(documentObjectProxyInterface, string);
            if (documentObjectProxyInterface.getUpgradePackageType().equals("Delta")) {
                this.validateDeltaUpgradePackage(documentObjectProxyInterface);
            } else {
                this.validateNonDeltaUpgradePackage(documentObjectProxyInterface);
            }
        }
        catch (InvalidMainElementNameException invalidMainElementNameException) {
            throw new UCF_ValidationException(invalidMainElementNameException.toString());
        }
        catch (ValidateException validateException) {
            throw new UCF_ValidationException(validateException.toString());
        }
    }

    private void errorLoadModuleFilePathLengthOutOfRange(String string, String string2, String string3, String string4, String string5, int n, String string6) throws LoadModuleFilePathLengthOutOfRangeException {
        String string7 = "Upgrade control file error,\n\tthe length of the compiled " + string4 + " is out of range." + "\n\tProductData of indicated LoadModule element: number = " + string2 + ", revision = " + string3 + "\n\t" + string4 + "=" + "\n\t" + string5 + "\n\tlenght of filepath: " + string5.length() + ", maximum allowed length: " + n;
        UpgradeTrace.info(this.getClass(), (String)string, (String)(string7 + "\n\tLocation: " + string6));
        throw new LoadModuleFilePathLengthOutOfRangeException(string7, string6);
    }

    private void errorNotAllowedCombination(String string, String string2) throws NotAllowedCombinationException {
        String string3 = "Upgrade control file error,\n\tcombination of elements not allowed.";
        UpgradeTrace.info(this.getClass(), (String)string, (String)(string3 + string2));
        throw new NotAllowedCombinationException(string3, string2);
    }

    private void errorMoreElementsThanExpected(String string, String string2, String string3, String string4) throws UnexpectedElementException {
        String string5 = "Upgrade control file error,\n\telement of type " + string2 + " contains more sub elements of type " + string3 + " than allowed.";
        UpgradeTrace.info(this.getClass(), (String)string, (String)(string5 + string4));
        throw new UnexpectedElementException(string5, string4);
    }

    private void errorReferencedElementMissing(String string, ProductNumberAndRevisionRaw productNumberAndRevisionRaw, String string2, String string3) throws ReferencedElementMissingException {
        String string4 = "Upgrade control file error,\n\treferenced " + string3 + " element does not exist." + "\n\tAn element of type " + string2 + " contains the reference data:" + "\n\t'productNumber = " + productNumberAndRevisionRaw.getProductNumberRaw() + ", revision = " + productNumberAndRevisionRaw.getRevisionRaw() + "'." + "\n\tThis reference data does not indicate any existing element of type " + string3;
        UpgradeTrace.info(this.getClass(), (String)string, (String)(string4 + "\n\tLocation: " + productNumberAndRevisionRaw.getLocatorString()));
        throw new ReferencedElementMissingException(string4, productNumberAndRevisionRaw.getLocatorString());
    }

    private void errorReferencedElementMissing(String string, ProductNumberAndRevision productNumberAndRevision, String string2, String string3) throws ReferencedElementMissingException {
        String string4 = "Upgrade control file error,\n\treferenced " + string3 + " element does not exist." + "\n\tAn element of type " + string2 + " contains the reference data:" + "\n\t'productNumber = " + productNumberAndRevision.getProductNumber() + ", revision = " + productNumberAndRevision.getRevision() + "'." + "\n\tThis reference data does not indicate any existing element of type " + string3;
        UpgradeTrace.info(this.getClass(), (String)string, (String)(string4 + "\n\tLocation: " + productNumberAndRevision.getLocatorString()));
        throw new ReferencedElementMissingException(string4, productNumberAndRevision.getLocatorString());
    }

    private void errorUnexpectedElement(String string, String string2, String string3, String string4) throws UnexpectedElementException {
        String string5 = "Upgrade control file error,\n\telement of type " + string2 + " contains sub element of not allowed type " + string3 + ".";
        UpgradeTrace.info(this.getClass(), (String)string, (String)(string5 + string4));
        throw new UnexpectedElementException(string5, string4);
    }

    private void validateDeltaUpgradePackage(DocumentObjectProxyInterface documentObjectProxyInterface) throws ValidateException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateDeltaUpgradePackage(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        this.validateThatUpgradePackageContainsMaxOneExplicitReplacement(documentObjectProxyInterface);
        this.validateLoadModuleReplacements(documentObjectProxyInterface);
        this.validatePiuTypeReplacements(documentObjectProxyInterface);
        this.validateSubrackProdTypeReplacements(documentObjectProxyInterface);
        this.validateThatOldPiuTypeInPiuTypeReplacementIsNotIncludedInDeltaAddition(documentObjectProxyInterface);
    }

    private void validateLoadModuleFilePathLengths(DocumentObjectProxyInterface documentObjectProxyInterface, String string) throws LoadModuleFilePathLengthOutOfRangeException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateLoadModuleFilePathLengths(DocumentObjectProxyInterface aDocumentObjectProxy, ProductNumbersAndRevisions aLoadModuleIdentifiers, String anUpgradeControlFileSourceAbsolutePath)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface + "anUpgradeControlFileSourceAbsolutePath: " + string));
        }
        LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
        ProductNumbersAndRevisions productNumbersAndRevisions = loadModulesProxyInterface.getProductNumberAndRevisionOfLoadModules();
        Enumeration enumeration = productNumbersAndRevisions.getElements().elements();
        ProductNumberAndRevision productNumberAndRevision = null;
        LoadModuleProxyInterface loadModuleProxyInterface = null;
        String string2 = null;
        String string3 = null;
        Vector vector = null;
        Enumeration enumeration2 = null;
        InstallLM_Container installLM_Container = null;
        String string4 = null;
        while (enumeration.hasMoreElements()) {
            productNumberAndRevision = (ProductNumberAndRevision)enumeration.nextElement();
            loadModuleProxyInterface = loadModulesProxyInterface.getLoadModuleProxyInterface(productNumberAndRevision);
            string2 = loadModuleProxyInterface.getProductNumberRaw();
            string3 = loadModuleProxyInterface.getProductRevisionRaw();
            vector = loadModuleProxyInterface.getInstallDatas();
            if (vector == null) continue;
            enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                installLM_Container = (InstallLM_Container)enumeration2.nextElement();
                string4 = documentObjectProxyInterface.selectLoadModuleSourceAbsolutePath(installLM_Container.getSrcFilePathName(), string, string2, string3);
                if (string4.length() > this.maximumLoadModuleSourceFilePathLength) {
                    this.errorLoadModuleFilePathLengthOutOfRange("validateLoadModuleFilePathLengths(DocumentObjectProxyInterface aDocumentObjectProxy, String anUpgradeControlFileSourceAbsolutePath)", string2, string3, "AbsoluteLoadModuleSourceFilePath", string4, this.maximumLoadModuleSourceFilePathLength, installLM_Container.getLocatorString());
                }
                if ((string4 = documentObjectProxyInterface.selectLoadModuleDestinationAbsolutePath(installLM_Container.getDestFilePathName(), string2, string3)).length() <= this.maximumLoadModuleDestinationFilePathLength) continue;
                this.errorLoadModuleFilePathLengthOutOfRange("validateLoadModuleFilePathLengths(DocumentObjectProxyInterface aDocumentObjectProxy, String anUpgradeControlFileSourceAbsolutePath)", string2, string3, "AbsoluteLoadModuleDestinationFilePath", string4, this.maximumLoadModuleDestinationFilePathLength, installLM_Container.getLocatorString());
            }
        }
    }

    private void validateRestartCounterAndRestartTimerC_AUEs(DocumentObjectProxyInterface documentObjectProxyInterface) throws UnexpectedAttributeException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateRestartCounterAndRestartTimerC_AUEs(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        UpgradeSequencesProxyInterface upgradeSequencesProxyInterface = documentObjectProxyInterface.getUpgradeSequencesProxyInterface();
        Collection collection = upgradeSequencesProxyInterface.getC_AUE_Repertoires();
        RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
        Iterator iterator = collection.iterator();
        String string = null;
        Collection collection2 = null;
        Iterator iterator2 = null;
        LoadModuleRef loadModuleRef = null;
        while (iterator.hasNext()) {
            String string2;
            string = (String)iterator.next();
            collection2 = repertoiresProxyInterface.getLoadModuleRefInformations(string);
            iterator2 = collection2.iterator();
            if (!iterator2.hasNext()) continue;
            loadModuleRef = (LoadModuleRef)iterator2.next();
            if (loadModuleRef.getRestartCounterLimit() != null) {
                string2 = "It is not allowed to use this attribute in Repertoires where C-AUEs are specified.\n\tThe repertoire name: " + string + "\n\tThe Load Module Ref product number: " + loadModuleRef.getProductNumber() + "\n\tThe Load Module Ref revision: " + loadModuleRef.getRevision() + "\n\tThe value specified for this attribute: " + loadModuleRef.getRestartCounterLimit();
                DocumentObjectValidator.errorUnexpectedAttributeWithLocatorString(this.getClass(), "validateRestartCounterAndRestartTimerC_AUEs(DocumentObjectProxyInterface aDocumentObjectProxy)", RepertoireSubElementName.PiuTypeLoadList.getValue(), PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), LoadModuleRefAttributeName.RestartCounterLimit.getValue(), string2, loadModuleRef.getLocatorString());
                continue;
            }
            if (loadModuleRef.getRestartTimer() == null) continue;
            string2 = "It is not allowed to use this attribute in Repertoires where C-AUEs are specified.\n\tThe repertoire name: " + string + "\n\tThe Load Module Ref product number: " + loadModuleRef.getProductNumber() + "\n\tThe Load Module Ref revision: " + loadModuleRef.getRevision() + "\n\tThe value specified for this attribute: " + loadModuleRef.getRestartTimer();
            DocumentObjectValidator.errorUnexpectedAttributeWithLocatorString(this.getClass(), "validateRestartCounterAndRestartTimerC_AUEs(DocumentObjectProxyInterface aDocumentObjectProxy)", RepertoireSubElementName.PiuTypeLoadList.getValue(), PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), LoadModuleRefAttributeName.RestartTimer.getValue(), string2, loadModuleRef.getLocatorString());
        }
    }

    private void validateLoadModuleRefs(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException, UnexpectedAttributeException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateLoadModuleRefs(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        this.validateThatLoadModulesReferencedFromRepertoiresArePresent(documentObjectProxyInterface);
        this.validateThatLoadModuleRefsContainingLoaderNamesAreAllowed(documentObjectProxyInterface);
    }

    private void validateLoadModuleReplacements(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateLoadModuleReplacements(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
        ProductNumbersAndRevisions productNumbersAndRevisions = loadModulesProxyInterface.getProductNumberAndRevisionOfLoadModules();
        LoadModuleReplacementsProxyInterface loadModuleReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface().getLoadModuleReplacementsProxyInterface();
        Vector vector = loadModuleReplacementsProxyInterface.getProductNumberAndRevisionOfNewLMs().getElements();
        Iterator iterator = vector.iterator();
        ProductNumberAndRevisionRaw productNumberAndRevisionRaw = null;
        while (iterator.hasNext()) {
            productNumberAndRevisionRaw = (ProductNumberAndRevisionRaw)iterator.next();
            if (productNumbersAndRevisions.contains(productNumberAndRevisionRaw)) continue;
            this.errorReferencedElementMissing("validateLoadModuleReplacements(DocumentObjectProxyInterface aDocumentObjectProxy)", productNumberAndRevisionRaw, LoadModuleReplacementSubElementName.NewLM.getValue(), "LoadModule");
        }
    }

    private void validateCommonPiuTypeListAndSelective(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        CommonPiuTypeListProxyInterface commonPiuTypeListProxyInterface;
        Collection collection;
        TypeOfUCF typeOfUCF;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateNodeTypeSpecificPiuTypeListAndSelective(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if (((typeOfUCF = documentObjectProxyInterface.getTypeOfUCF()).equals(TypeOfUCF.Selective) || typeOfUCF.equals(TypeOfUCF.DeltaSelective)) && !(collection = (commonPiuTypeListProxyInterface = documentObjectProxyInterface.getCommonPiuTypeListProxyInterface()).getProductNumberAndRevisionsForPiuTypes()).isEmpty()) {
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateCommonPiuTypeListAndSelective(DocumentObjectProxyInterface aDocumentObjectProxy )", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.Type.getValue(), typeOfUCF.getDescription(), "This value is not allowed when element CommonPiuTypeList is included in the UCF.Type of UCF = " + typeOfUCF);
        }
    }

    private void validateNodeTypeSpecificPiuTypeListAndSelective(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        NodeTypeSpecificPiuTypeListsProxyInterface nodeTypeSpecificPiuTypeListsProxyInterface;
        Collection collection;
        TypeOfUCF typeOfUCF;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateNodeTypeSpecificPiuTypeListAndSelective(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if (((typeOfUCF = documentObjectProxyInterface.getTypeOfUCF()).equals(TypeOfUCF.Selective) || typeOfUCF.equals(TypeOfUCF.DeltaSelective)) && !(collection = (nodeTypeSpecificPiuTypeListsProxyInterface = documentObjectProxyInterface.getNodeTypeSpecificPiuTypeListsProxyInterface()).getProductNumberAndRevisionsForPiuTypes()).isEmpty()) {
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateNodeTypeSpecificPiuTypeListAndSelective(DocumentObjectProxyInterface aDocumentObjectProxy )", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.Type.getValue(), typeOfUCF.getDescription(), "This value is not allowed when element NodeTypeSpecificPiuTypeList is included in the UCF.Type of UCF = " + typeOfUCF);
        }
    }

    private void validateNameUniqueInNodeTypeSpecificPiuTypeLists(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateNameUniqueInNodeTypeSpecificPiuTypeLists(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        NodeTypeSpecificPiuTypeListsProxyInterface nodeTypeSpecificPiuTypeListsProxyInterface = documentObjectProxyInterface.getNodeTypeSpecificPiuTypeListsProxyInterface();
        Vector<String> vector = new Vector<String>(1);
        NodeTypeSpecificPiuTypeListContainer nodeTypeSpecificPiuTypeListContainer = null;
        Iterator iterator = nodeTypeSpecificPiuTypeListsProxyInterface.getNodeTypeSpecificPiuTypeListContainers().iterator();
        while (iterator.hasNext()) {
            nodeTypeSpecificPiuTypeListContainer = (NodeTypeSpecificPiuTypeListContainer)iterator.next();
            if (!vector.contains(nodeTypeSpecificPiuTypeListContainer.getName())) {
                vector.add(nodeTypeSpecificPiuTypeListContainer.getName());
                continue;
            }
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateNameUniqueInNodeTypeSpecificPiuTypeLists(DocumentObjectProxyInterface aDocumentObjectProxy )", "NodeTypeSpecificPiuTypeList", NodeTypeSpecificPiuTypeListAttributeName.Name.getValue(), nodeTypeSpecificPiuTypeListContainer.getName(), "The attribute 'name' must be unique between all NodeTypeSpecificPiuTypeList elements.");
        }
    }

    private void validateAtLeastOneInstallSMAndSignedSW(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateMandatoryInstallSMAndSignedSW(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        boolean bl = documentObjectProxyInterface.isSignedSW();
        LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
        Iterator iterator = loadModulesProxyInterface.getLoadModuleProxyInterfaces().iterator();
        LoadModuleProxyInterface loadModuleProxyInterface = null;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            loadModuleProxyInterface = (LoadModuleProxyInterface)iterator.next();
            if (loadModuleProxyInterface.getInstallSMs().isEmpty()) continue;
            bl2 = true;
        }
        if (bl) {
            UpgradeTrace.log1(this.getClass(), (String)"validateMandatoryInstallSMAndSignedSW(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("hasInstallSMs: " + bl2));
            if (!bl2) {
                DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateMandatoryInstallSMAndSignedSW(DocumentObjectProxyInterface aDocumentObjectProxy )", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.IsSignedSW.getValue(), "...", "When attribute IsSignedSW is set to value yes, UCF has contained  at least one InstallSM ");
            }
        } else if (bl2) {
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateMandatoryInstallSMAndSignedSW(DocumentObjectProxyInterface aDocumentObjectProxy )", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.IsSignedSW.getValue(), "...", "InstallSM is allowed only when attribute IsSignedSW is set to value yes  ");
        }
    }

    private void validateMandatoryPiuTypeListAndHwSensitive(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateMandatoryPiuTypeListAndHwSensitive(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        boolean bl = documentObjectProxyInterface.isHW_Sensitive();
        TypeOfUCF typeOfUCF = documentObjectProxyInterface.getTypeOfUCF();
        MandatoryPiuTypeListProxyInterface mandatoryPiuTypeListProxyInterface = documentObjectProxyInterface.getMandatoryPiuTypeListProxyInterface();
        Collection collection = mandatoryPiuTypeListProxyInterface.getProductNumberAndRevisionsForPiuTypes();
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateMandatoryPiuTypeListAndHwSensitive(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("\n\tHwSensitive: " + bl + "\n\ttheTypeOfUCF: " + typeOfUCF + "\n\tthePiuTypeRefIdentifiers: " + collection));
        }
        if (!(collection.isEmpty() || bl || typeOfUCF.isDelta())) {
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateMandatoryPiuTypeListAndHwSensitive(DocumentObjectProxyInterface aDocumentObjectProxy )", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.HW_sensitive.getValue(), "...", "MandatoryPiuTypeList is allowed only when attribute hwSensitive is set to value yes or when attribute type is set to delta.Type of UCF = " + typeOfUCF);
        }
    }

    private void validateNonDeltaUpgradePackage(DocumentObjectProxyInterface documentObjectProxyInterface) throws ValidateException, InvalidMainElementNameException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateNonDeltaUpgradePackage(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        this.validateThatOtherUpgradePackagesNotIsPresentInOldUpgradePackage(documentObjectProxyInterface);
        this.validateThatLoadModulesReferencedFromUpgradeLogicArePresent(documentObjectProxyInterface);
        this.validateSubrackProdTypeInUpgradePackage(documentObjectProxyInterface);
        this.validateMandatoryPiuTypeListAndHwSensitive(documentObjectProxyInterface);
        this.validatePiuTypeRefsInMandatoryPiuTypeList(documentObjectProxyInterface);
        this.validatePiuTypeRefsInCommonPiuTypeList(documentObjectProxyInterface);
        this.validateCommonPiuTypeListAndSelective(documentObjectProxyInterface);
        this.validateMandatoryPiuTypeListVsCommonPiuTypeList(documentObjectProxyInterface);
        this.validateNameUniqueInNodeTypeSpecificPiuTypeLists(documentObjectProxyInterface);
        this.validateNodeTypeSpecificPiuTypeListAndSelective(documentObjectProxyInterface);
        this.validatePiuTypeRefsInNodeTypeSpecificPiuTypeList(documentObjectProxyInterface);
        this.validateAtLeastOneInstallSMAndSignedSW(documentObjectProxyInterface);
        this.validateThatRepertoireReferencedFromNewRepIsPresent(documentObjectProxyInterface);
        this.validateThatLoadModuleReferencedFromNewRpuIsPresent(documentObjectProxyInterface);
        this.validateRepertoires(documentObjectProxyInterface);
        this.validateThatUpgradePackageDoesNotContainExplicitAddition(documentObjectProxyInterface);
        this.validateThatUpgradePackageDoesNotContainDeltaAddition(documentObjectProxyInterface);
        this.validateThatExplicitReplacementDoesNotContainLoadModuleReplacement(documentObjectProxyInterface);
        this.validateThatExplicitReplacementDoesNotContainPiuTypeReplacement(documentObjectProxyInterface);
        this.validateThatExplicitReplacementDoesNotContainSubrackProdTypeReplacement(documentObjectProxyInterface);
        this.validateThatUpgradeLogicReferencedFromInstallSequencesIsPresent(documentObjectProxyInterface);
        this.validateThatLoadModulesReferencedFromInstallSequencesArePresent(documentObjectProxyInterface);
        this.validateThatUpgradeLogicReferencedFromVerifySequencesIsPresent(documentObjectProxyInterface);
        this.validateThatLoadModulesReferencedFromVerifySequencesArePresent(documentObjectProxyInterface);
        this.validateThatUpgradeLogicReferencedFromVerifyUpgradeSequencesIsPresent(documentObjectProxyInterface);
        this.validateThatLoadModulesReferencedFromVerifyUpgradeSequencesArePresent(documentObjectProxyInterface);
        this.validateThatLoadModulesReferencedFromVerifyUpdateSequencesArePresent(documentObjectProxyInterface);
        this.validateThatReferencedRepertoireNamesFromUpgradeSequenceArePresent(documentObjectProxyInterface);
        this.validateThatLoadModulesReferencedFromUpgradeSequencesArePresent(documentObjectProxyInterface);
        this.validateRestartCounterAndRestartTimerC_AUEs(documentObjectProxyInterface);
    }

    private void validatePiuTypeRefs(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validatePiuTypeRefs(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
        Vector vector = repertoiresProxyInterface.getProductNumbersAndRevisionsOfPiuTypeRefs().getElements();
        PiuTypesProxyInterface piuTypesProxyInterface = documentObjectProxyInterface.getPiuTypesProxyInterface();
        ProductNumbersAndRevisions productNumbersAndRevisions = piuTypesProxyInterface.getProductNumberAndRevisionOfPiuTypes();
        if (!vector.isEmpty()) {
            Enumeration enumeration = vector.elements();
            ProductNumberAndRevisionRaw productNumberAndRevisionRaw = null;
            while (enumeration.hasMoreElements()) {
                productNumberAndRevisionRaw = (ProductNumberAndRevisionRaw)enumeration.nextElement();
                if (productNumbersAndRevisions.contains(productNumberAndRevisionRaw)) continue;
                this.errorReferencedElementMissing("validatePiuTypeRefs(DocumentObjectProxyInterface aDocumentObjectProxy)", productNumberAndRevisionRaw, PiuTypeLoadListSubElementName.PiuTypeRef.getValue(), "PiuType");
            }
        }
    }

    private void validateMandatoryPiuTypeListVsCommonPiuTypeList(DocumentObjectProxyInterface documentObjectProxyInterface) throws NotAllowedCombinationException {
        CommonPiuTypeListProxyInterface commonPiuTypeListProxyInterface;
        Collection collection;
        MandatoryPiuTypeListProxyInterface mandatoryPiuTypeListProxyInterface;
        Collection collection2;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateMandatoryPiuTypeListVsCommonPiuTypeList(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if (!(collection2 = (mandatoryPiuTypeListProxyInterface = documentObjectProxyInterface.getMandatoryPiuTypeListProxyInterface()).getProductNumberAndRevisionsForPiuTypes()).isEmpty() && !(collection = (commonPiuTypeListProxyInterface = documentObjectProxyInterface.getCommonPiuTypeListProxyInterface()).getProductNumberAndRevisionsForPiuTypes()).isEmpty()) {
            String string = "\n\tElement CommonPiuTypeList and element MandatoryPiuTypeList cannot exist in the same UCF.";
            this.errorNotAllowedCombination("validateMandatoryPiuTypeListVsCommonPiuTypeList(DocumentObjectProxy aDocumentObjectProxy)", string);
        }
    }

    private void validatePiuTypeRefsInCommonPiuTypeList(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validatePiuTypeRefsInCommonPiuTypeList(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        Collection collection = documentObjectProxyInterface.getCommonPiuTypeListProxyInterface().getProductNumberAndRevisionsForPiuTypes();
        ProductNumbersAndRevisions productNumbersAndRevisions = documentObjectProxyInterface.getPiuTypesProxyInterface().getProductNumberAndRevisionOfPiuTypes();
        this.checkThatPiuTypeRefExists(collection, productNumbersAndRevisions);
    }

    private void validatePiuTypeRefsInNodeTypeSpecificPiuTypeList(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validatePiuTypeRefsInNodeTypeSpecificPiuTypeList(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        ProductNumbersAndRevisions productNumbersAndRevisions = documentObjectProxyInterface.getPiuTypesProxyInterface().getProductNumberAndRevisionOfPiuTypes();
        NodeTypeSpecificPiuTypeListsProxyInterface nodeTypeSpecificPiuTypeListsProxyInterface = documentObjectProxyInterface.getNodeTypeSpecificPiuTypeListsProxyInterface();
        Collection collection = nodeTypeSpecificPiuTypeListsProxyInterface.getProductNumberAndRevisionsForPiuTypes();
        this.checkThatPiuTypeRefExists(collection, productNumbersAndRevisions);
    }

    private void validatePiuTypeRefsInMandatoryPiuTypeList(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validatePiuTypeRefsInMandatoryPiuTypeList(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        MandatoryPiuTypeListProxyInterface mandatoryPiuTypeListProxyInterface = documentObjectProxyInterface.getMandatoryPiuTypeListProxyInterface();
        Collection collection = mandatoryPiuTypeListProxyInterface.getProductNumberAndRevisionsForPiuTypes();
        ProductNumbersAndRevisions productNumbersAndRevisions = documentObjectProxyInterface.getPiuTypesProxyInterface().getProductNumberAndRevisionOfPiuTypes();
        this.checkThatPiuTypeRefExists(collection, productNumbersAndRevisions);
    }

    private void checkThatPiuTypeRefExists(Collection collection, ProductNumbersAndRevisions productNumbersAndRevisions) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"checkThatPiuTypeRefExists(Collection aPiuTypeRefIdentifiers, ProductNumbersAndRevisions aPiuTypes)", (String)("\n\taPiuTypeRefIdentifiers: " + collection + "\n\taPiuTypes:" + productNumbersAndRevisions));
        }
        if (!collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            ProductNumberAndRevision productNumberAndRevision = null;
            while (iterator.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                if (productNumbersAndRevisions.contains(productNumberAndRevision)) continue;
                this.errorReferencedElementMissing("checkThatPiuTypeRefExists(Collection aPiuTypeRefIdentifiers, ProductNumbersAndRevisions aPiuTypes)", productNumberAndRevision, PiuTypeLoadListSubElementName.PiuTypeRef.getValue(), "PiuType");
            }
        }
    }

    private void validatePiuTypeReplacements(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validatePiuTypeReplacements(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        PiuTypesProxyInterface piuTypesProxyInterface = documentObjectProxyInterface.getPiuTypesProxyInterface();
        ProductNumbersAndRevisions productNumbersAndRevisions = piuTypesProxyInterface.getProductNumberAndRevisionOfPiuTypes();
        PiuTypeReplacementsProxyInterface piuTypeReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface().getPiuTypeReplacementsProxyInterface();
        Vector vector = piuTypeReplacementsProxyInterface.getProductNumberAndRevisionOfNewPiuTypes().getElements();
        Iterator iterator = vector.iterator();
        ProductNumberAndRevisionRaw productNumberAndRevisionRaw = null;
        while (iterator.hasNext()) {
            productNumberAndRevisionRaw = (ProductNumberAndRevisionRaw)iterator.next();
            if (productNumbersAndRevisions.contains(productNumberAndRevisionRaw)) continue;
            this.errorReferencedElementMissing("validatePiuTypeReplacements(DocumentObjectProxyInterface aDocumentObjectProxy)", productNumberAndRevisionRaw, PiuTypeReplacementSubElementName.NewPiuType.getValue(), "PiuType");
        }
    }

    private void validateRepertoires(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException, UnexpectedAttributeException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateRepertoires(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        this.validatePiuTypeRefs(documentObjectProxyInterface);
        this.validateLoadModuleRefs(documentObjectProxyInterface);
    }

    private void validateSubrackProdTypeInUpgradePackage(DocumentObjectProxyInterface documentObjectProxyInterface) throws MandatoryElementIsMissingException, InvalidMainElementNameException {
        SubrackProdTypesProxyInterface subrackProdTypesProxyInterface;
        Collection collection;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateSubrackProdTypeInUpgradePackage(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if (UpgradePackageSyntaxVersionValue.isAllowed(CommonDocumentObjectInformation.getInstance().getSyntaxVersion(), MainElementNames.get("SubrackProdType").getUpgradePackageSyntaxVersionConstraints()) && (collection = (subrackProdTypesProxyInterface = documentObjectProxyInterface.getSubrackProdTypesProxyInterface()).getSubrackProdTypeProxyInterfaces()).isEmpty()) {
            String string = "\n\t Sub element SubrackProdType is missing.";
            DocumentObjectValidator.errorElementIsMissing(this.getClass(), "validateSubrackProdTypeInUpgradePackage(DocumentObjectProxyInterface aDocumentObjectProxy)", RootElementName.UpgradePackage.getValue(), string);
        }
    }

    private void validateSubrackProdTypeReplacements(DocumentObjectProxyInterface documentObjectProxyInterface) throws UnexpectedElementException, IllegalAttributeValueException, ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateSubrackProdTypeReplacements(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        SubrackProdTypesProxyInterface subrackProdTypesProxyInterface = documentObjectProxyInterface.getSubrackProdTypesProxyInterface();
        ProductNumbersAndRevisions productNumbersAndRevisions = subrackProdTypesProxyInterface.getProductNumberAndRevisionOfSubrackProdTypes();
        SubrackProdTypeReplacementsProxyInterface subrackProdTypeReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface().getSubrackProdTypeReplacementsProxyInterface();
        Vector vector = subrackProdTypeReplacementsProxyInterface.getProductNumberAndRevisionOfNewSubrackProdTypes().getElements();
        Iterator iterator = vector.iterator();
        ProductNumberAndRevisionRaw productNumberAndRevisionRaw = null;
        while (iterator.hasNext()) {
            productNumberAndRevisionRaw = (ProductNumberAndRevisionRaw)iterator.next();
            if (productNumbersAndRevisions.contains(productNumberAndRevisionRaw)) continue;
            this.errorReferencedElementMissing("validateSubrackProdTypeReplacements(DocumentObjectProxyInterface aDocumentObjectProxy)", productNumberAndRevisionRaw, SubrackProdTypeReplacementSubElementName.NewSubrackProdType.getValue(), "SubrackProdType");
        }
    }

    private void validateThatOldPiuTypeInPiuTypeReplacementIsNotIncludedInDeltaAddition(DocumentObjectProxyInterface documentObjectProxyInterface) throws NotAllowedCombinationException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatOldPiuTypeInPiuTypeReplacementIsNotIncludedInDeltaAddition(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        DeltaAdditionsProxyInterface deltaAdditionsProxyInterface = documentObjectProxyInterface.getDeltaAdditionsProxyInterface();
        PiuTypeNodeTypeAdditionsProxyInterface piuTypeNodeTypeAdditionsProxyInterface = deltaAdditionsProxyInterface.getPiuTypeNodeTypeAdditionsProxyInterface();
        Collection collection = piuTypeNodeTypeAdditionsProxyInterface.getNodeTypeSpecificPiuTypeListContainers();
        ExplicitReplacementsProxyInterface explicitReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface();
        ProductNumbersAndRevisions productNumbersAndRevisions = explicitReplacementsProxyInterface.getPiuTypeReplacementsProxyInterface().getProductNumberAndRevisionOfOldPiuTypes();
        NodeTypeSpecificPiuTypeListContainer nodeTypeSpecificPiuTypeListContainer = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            nodeTypeSpecificPiuTypeListContainer = (NodeTypeSpecificPiuTypeListContainer)iterator.next();
            ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
            Iterator iterator2 = nodeTypeSpecificPiuTypeListContainer.getProductNumbersAndRevisions().getElements().iterator();
            while (iterator2.hasNext()) {
                productNumberAndRevisionInterface = (ProductNumberAndRevisionInterface)iterator2.next();
                if (!productNumbersAndRevisions.contains(productNumberAndRevisionInterface)) continue;
                String string = "\n\tProductData of indicated PiuTypeRef element: number = " + productNumberAndRevisionInterface.getProductNumber() + ", revision = " + productNumberAndRevisionInterface.getRevision() + " has been specified in a contradictive way." + "\n\tThe subelement " + PiuTypeNodeTypeAdditionSubElementName.NodeTypeSpecificPiuTypeList.getValue() + " with attribute name=" + nodeTypeSpecificPiuTypeListContainer.getName() + " under element " + "DeltaAddition" + " contains a PiuTypeRef with same product number and revision as in subelement " + PiuTypeReplacementSubElementName.OldPiuType + " in " + ExplicitReplacementSubElementName.PiuTypeReplacement;
                this.errorNotAllowedCombination("validateThatOldPiuTypeInPiuTypeReplacementIsNotIncludedInDeltaAddition(DocumentObjectProxy aDocumentObjectProxy)", string);
            }
        }
    }

    private void validateThatAttributeCaseInUpgradeCaseRefsInExplicitReplacementsIsUnique(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatAttributeCaseInUpgradeCaseRefsInExplicitReplacementsIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        ExplicitReplacementsProxyInterface explicitReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface();
        Vector vector = explicitReplacementsProxyInterface.getAllCaseValues();
        if (UpgradeTrace.valid(this.getClass(), (int)27)) {
            UpgradeTrace.debug(this.getClass(), (int)27, (String)"validateThatAttributeCaseInUpgradeCaseRefsInExplicitReplacementsIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("theAllCaseValues: " + vector));
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = vector.iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (hashSet.add(string)) continue;
            String string2 = "\n\tThe value of this attribute must be unique among all " + ExplicitReplacementSubElementName.UpgradeCaseRef.getValue() + " elements in the " + "ExplicitReplacement" + " elements.";
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatAttributeCaseInUpgradeCaseRefsInExplicitReplacementsIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy )", ExplicitReplacementSubElementName.UpgradeCaseRef.getValue(), UpgradeCaseRefAttributeName.Case.getValue(), string, string2);
        }
    }

    private void validateThatAttributeCaseInUpgradeCaseRefsInInstallSequencesIsUnique(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatAttributeCaseInUpgradeCaseRefsInInstallSequencesIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        InstallSequencesProxyInterface installSequencesProxyInterface = documentObjectProxyInterface.getInstallSequencesProxyInterface();
        Collection collection = installSequencesProxyInterface.getAllCaseValues();
        if (UpgradeTrace.valid(this.getClass(), (int)27)) {
            UpgradeTrace.debug(this.getClass(), (int)27, (String)"validateThatAttributeCaseInUpgradeCaseRefsInInstallSequencesIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("theAllCaseValues: " + collection));
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = collection.iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (hashSet.add(string)) continue;
            String string2 = "\n\tThe value of this attribute must be unique among all " + InstallSequenceSubElementName.UpgradeCaseRef.getValue() + " elements in the " + "InstallSequence" + " elements.";
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatAttributeCaseInUpgradeCaseRefsInInstallSequencesIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy )", InstallSequenceSubElementName.UpgradeCaseRef.getValue(), UpgradeCaseRefAttributeName.Case.getValue(), string, string2);
        }
    }

    private void validateThatAttributeCaseInUpgradeCaseRefsInUpgradeSequencesIsUnique(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatAttributeCaseInUpgradeCaseRefsInUpgradeSequencesIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        UpgradeSequencesProxyInterface upgradeSequencesProxyInterface = documentObjectProxyInterface.getUpgradeSequencesProxyInterface();
        Vector vector = upgradeSequencesProxyInterface.getAllCaseValues();
        if (UpgradeTrace.valid(this.getClass(), (int)27)) {
            UpgradeTrace.debug(this.getClass(), (int)27, (String)"validateThatAttributeCaseInUpgradeCaseRefsInUpgradeSequencesIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("theAllCaseValues: " + vector));
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = vector.iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (hashSet.add(string)) continue;
            String string2 = "\n\tThe value of this attribute must be unique among all " + UpgradeSequenceSubElementName.UpgradeCaseRef.getValue() + " elements in the " + "UpgradeSequence" + " elements.";
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatAttributeCaseInUpgradeCaseRefsInUpgradeSequencesIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy )", UpgradeSequenceSubElementName.UpgradeCaseRef.getValue(), UpgradeCaseRefAttributeName.Case.getValue(), string, string2);
        }
    }

    private void validateThatAttributeCaseInUpgradeCaseRefsInVerifySequencesIsUnique(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatAttributeCaseInUpgradeCaseRefsInVerifySequencesIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        VerifySequencesProxyInterface verifySequencesProxyInterface = documentObjectProxyInterface.getVerifySequencesProxyInterface();
        Collection collection = verifySequencesProxyInterface.getAllCaseValues();
        if (UpgradeTrace.valid(this.getClass(), (int)27)) {
            UpgradeTrace.debug(this.getClass(), (int)27, (String)"validateThatAttributeCaseInUpgradeCaseRefsInVerifySequencesIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("theAllCaseValues: " + collection));
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = collection.iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (hashSet.add(string)) continue;
            String string2 = "\n\tThe value of this attribute must be unique among all " + VerifySequenceSubElementName.UpgradeCaseRef.getValue() + " elements in the " + "VerifySequence" + " elements.";
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatAttributeCaseInUpgradeCaseRefsInVerifySequencesIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy )", VerifySequenceSubElementName.UpgradeCaseRef.getValue(), UpgradeCaseRefAttributeName.Case.getValue(), string, string2);
        }
    }

    private void validateThatAttributeCaseInUpgradeCaseRefsInVerifyUpdateSequencesIsUnique(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatAttributeCaseInUpgradeCaseRefsInVerifyUpdateSequencesIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        VerifyUpdateSequencesProxyInterface verifyUpdateSequencesProxyInterface = documentObjectProxyInterface.getVerifyUpdateSequencesProxyInterface();
        Collection collection = verifyUpdateSequencesProxyInterface.getAllCaseValues();
        if (UpgradeTrace.valid(this.getClass(), (int)27)) {
            UpgradeTrace.debug(this.getClass(), (int)27, (String)"validateThatAttributeCaseInUpgradeCaseRefsInVerifyUpdateSequencesIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("theAllCaseValues: " + collection));
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = collection.iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (hashSet.add(string)) continue;
            String string2 = "\n\tThe value of this attribute must be unique among all " + VerifyUpdateSequenceSubElementName.UpgradeCaseRef.getValue() + " elements in the " + "VerifyUpdateSequence" + " elements.";
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatAttributeCaseInUpgradeCaseRefsInVerifyUpdateSequencesIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy )", VerifyUpdateSequenceSubElementName.UpgradeCaseRef.getValue(), UpgradeCaseRefAttributeName.Case.getValue(), string, string2);
        }
    }

    private void validateThatAttributeCaseInUpgradeCaseRefsInVerifyUpgradeSequencesIsUnique(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatAttributeCaseInUpgradeCaseRefsInVerifyUpgradeSequencesIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        VerifyUpgradeSequencesProxyInterface verifyUpgradeSequencesProxyInterface = documentObjectProxyInterface.getVerifyUpgradeSequencesProxyInterface();
        Collection collection = verifyUpgradeSequencesProxyInterface.getAllCaseValues();
        if (UpgradeTrace.valid(this.getClass(), (int)27)) {
            UpgradeTrace.debug(this.getClass(), (int)27, (String)"validateThatAttributeCaseInUpgradeCaseRefsInVerifyUpgradeSequencesIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("theAllCaseValues: " + collection));
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = collection.iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (hashSet.add(string)) continue;
            String string2 = "\n\tThe value of this attribute must be unique among all " + VerifyUpgradeSequenceSubElementName.UpgradeCaseRef.getValue() + " elements in the " + "VerifyUpgradeSequence" + " elements.";
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatAttributeCaseInUpgradeCaseRefsInVerifyUpgradeSequencesIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy )", VerifyUpgradeSequenceSubElementName.UpgradeCaseRef.getValue(), UpgradeCaseRefAttributeName.Case.getValue(), string, string2);
        }
    }

    private void validateThatExplicitReplacementDoesNotContainLoadModuleReplacement(DocumentObjectProxyInterface documentObjectProxyInterface) throws UnexpectedElementException {
        ExplicitReplacementsProxyInterface explicitReplacementsProxyInterface;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatExplicitReplacementDoesNotContainLoadModuleReplacement(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if ((explicitReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface()).loadModuleReplacementExists()) {
            this.errorUnexpectedElement("validateThatExplicitReplacementDoesNotContainLoadModuleReplacement(DocumentObjectProxyInterface aDocumentObjectProxy)", "ExplicitReplacement", ExplicitReplacementSubElementName.LoadModuleReplacement.getValue(), "\n\tThe element " + ExplicitReplacementSubElementName.LoadModuleReplacement.getValue() + " is only valid if the upgrade package is of type 'delta'.");
        }
    }

    private void validateThatExplicitReplacementDoesNotContainPiuTypeReplacement(DocumentObjectProxyInterface documentObjectProxyInterface) throws UnexpectedElementException {
        ExplicitReplacementsProxyInterface explicitReplacementsProxyInterface;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatExplicitReplacementDoesNotContainPiuTypeReplacement(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if ((explicitReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface()).piuTypeReplacementExists()) {
            this.errorUnexpectedElement("validateThatExplicitReplacementDoesNotContainPiuTypeReplacement(DocumentObjectProxyInterface aDocumentObjectProxy)", "ExplicitReplacement", ExplicitReplacementSubElementName.PiuTypeReplacement.getValue(), "\n\tThe element " + ExplicitReplacementSubElementName.PiuTypeReplacement.getValue() + " is only valid if the upgrade package is of type 'delta'.");
        }
    }

    private void validateThatExplicitReplacementDoesNotContainSubrackProdTypeReplacement(DocumentObjectProxyInterface documentObjectProxyInterface) throws UnexpectedElementException {
        ExplicitReplacementsProxyInterface explicitReplacementsProxyInterface;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatExplicitReplacementDoesNotContainSubrackProdTypeReplacement(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if ((explicitReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface()).subrackProdTypeReplacementExists()) {
            this.errorUnexpectedElement("validateThatExplicitReplacementDoesNotContainSubrackProdTypeReplacement(DocumentObjectProxyInterface aDocumentObjectProxy)", "ExplicitReplacement", ExplicitReplacementSubElementName.SubrackProdTypeReplacement.getValue(), "\n\tThe element " + ExplicitReplacementSubElementName.SubrackProdTypeReplacement.getValue() + " is only valid if the upgrade package is of type 'delta'.");
        }
    }

    private void validateThatLabelInAllInstallSequencesIsUnique(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLabelInAllInstallSequencesIsUnique(DocumentObjectProxy aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        InstallSequencesProxyInterface installSequencesProxyInterface = documentObjectProxyInterface.getInstallSequencesProxyInterface();
        Collection collection = installSequencesProxyInterface.getInstallSequenceInterfaces();
        Iterator iterator = collection.iterator();
        InstallSequenceInterface installSequenceInterface = null;
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        while (iterator.hasNext()) {
            installSequenceInterface = (InstallSequenceInterface)iterator.next();
            string = installSequenceInterface.getLabel();
            if (hashSet.add(string)) continue;
            String string2 = "\n\tThe value of this attribute must be unique among all InstallSequence elements.";
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatLabelInAllInstallSequencesIsUnique(DocumentObjectProxy aDocumentObjectProxy)", "InstallSequence", InstallSequenceAttributeName.Label.getValue(), string, string2);
        }
    }

    private void validateThatLabelInAllUpgradeSequencesIsUnique(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLabelInAllUpgradeSequencesIsUnique(DocumentObjectProxy aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        UpgradeSequencesProxyInterface upgradeSequencesProxyInterface = documentObjectProxyInterface.getUpgradeSequencesProxyInterface();
        Vector vector = upgradeSequencesProxyInterface.getUpgradeSequences();
        Iterator iterator = vector.iterator();
        UpgradeSequence upgradeSequence = null;
        UpgradeSequenceProxy upgradeSequenceProxy = null;
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        while (iterator.hasNext()) {
            upgradeSequence = (UpgradeSequence)iterator.next();
            upgradeSequenceProxy = new UpgradeSequenceProxy(upgradeSequence);
            string = upgradeSequenceProxy.getLabel();
            if (hashSet.add(string)) continue;
            String string2 = "\n\tThe value of this attribute must be unique among all UpgradeSequence elements.";
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatLabelInAllUpgradeSequencesIsUnique(DocumentObjectProxy aDocumentObjectProxy)", "UpgradeSequence", UpgradeSequenceAttributeName.Label.getValue(), string, string2);
        }
    }

    private void validateThatLabelInAllVerifySequencesIsUnique(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLabelInAllVerifySequencesIsUnique(DocumentObjectProxy aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        VerifySequencesProxyInterface verifySequencesProxyInterface = documentObjectProxyInterface.getVerifySequencesProxyInterface();
        Collection collection = verifySequencesProxyInterface.getVerifySequenceInterfaces();
        Iterator iterator = collection.iterator();
        VerifySequenceInterface verifySequenceInterface = null;
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        while (iterator.hasNext()) {
            verifySequenceInterface = (VerifySequenceInterface)iterator.next();
            string = verifySequenceInterface.getLabel();
            if (hashSet.add(string)) continue;
            String string2 = "\n\tThe value of this attribute must be unique among all VerifySequence elements.";
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatLabelInAllInstallSequencesIsUnique(DocumentObjectProxy aDocumentObjectProxy)", "VerifySequence", VerifySequenceAttributeName.Label.getValue(), string, string2);
        }
    }

    private void validateThatLabelInAllVerifyUpdateSequencesIsUnique(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLabelInAllVerifyUpdateSequencesIsUnique(DocumentObjectProxy aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        VerifyUpdateSequencesProxyInterface verifyUpdateSequencesProxyInterface = documentObjectProxyInterface.getVerifyUpdateSequencesProxyInterface();
        Collection collection = verifyUpdateSequencesProxyInterface.getVerifyUpdateSequenceInterfaces();
        Iterator iterator = collection.iterator();
        VerifyUpdateSequenceInterface verifyUpdateSequenceInterface = null;
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        while (iterator.hasNext()) {
            verifyUpdateSequenceInterface = (VerifyUpdateSequenceInterface)iterator.next();
            string = verifyUpdateSequenceInterface.getLabel();
            if (hashSet.add(string)) continue;
            String string2 = "\n\tThe value of this attribute must be unique among all VerifyUpdateSequence elements.";
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatLabelInAllVerifyUpdateSequencesIsUnique(DocumentObjectProxy aDocumentObjectProxy)", "VerifyUpdateSequence", VerifySequenceAttributeName.Label.getValue(), string, string2);
        }
    }

    private void validateThatLabelInAllVerifyUpgradeSequencesIsUnique(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLabelInAllVerifyUpgradeSequencesIsUnique(DocumentObjectProxy aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        VerifyUpgradeSequencesProxyInterface verifyUpgradeSequencesProxyInterface = documentObjectProxyInterface.getVerifyUpgradeSequencesProxyInterface();
        Collection collection = verifyUpgradeSequencesProxyInterface.getVerifyUpgradeSequenceInterfaces();
        Iterator iterator = collection.iterator();
        VerifyUpgradeSequenceInterface verifyUpgradeSequenceInterface = null;
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        while (iterator.hasNext()) {
            verifyUpgradeSequenceInterface = (VerifyUpgradeSequenceInterface)iterator.next();
            string = verifyUpgradeSequenceInterface.getLabel();
            if (hashSet.add(string)) continue;
            String string2 = "\n\tThe value of this attribute must be unique among all VerifyUpgradeSequence elements.";
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatLabelInAllInstallSequencesIsUnique(DocumentObjectProxy aDocumentObjectProxy)", "VerifyUpgradeSequence", VerifySequenceAttributeName.Label.getValue(), string, string2);
        }
    }

    private void validateThatLoadModuleReferencedFromNewRpuIsPresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        ExplicitReplacementsProxyInterface explicitReplacementsProxyInterface;
        Vector vector;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLoadModuleReferencedFromNewRpuIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if (!(vector = (explicitReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface()).getAllNewRpuRpLabelValues()).isEmpty()) {
            LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
            Vector vector2 = loadModulesProxyInterface.getAllReliableProgramLabelValues();
            Iterator iterator = vector.iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (vector2.contains(string)) continue;
                String string2 = "Upgrade control file error,\n\treferenced LoadModule element does not exist.\n\tAn element of type " + RpuAdditionSubElementName.NewRpu.getValue() + "\n\tcontains the reference data:" + NewRpuAttributeName.RpLabel.getValue() + " = " + string + "." + "\n\tThis reference data does not indicate any existing element of type " + "LoadModule";
                UpgradeTrace.warning(this.getClass(), (String)"validateThatLoadModuleReferencedFromNewRpuIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)string2);
            }
        }
    }

    private void validateThatLoadModulesReferencedFromInstallSequencesArePresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        ProductNumbersAndRevisions productNumbersAndRevisions;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLoadModulesReferencedFromInstallSequencesArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        InstallSequencesProxyInterface installSequencesProxyInterface = documentObjectProxyInterface.getInstallSequencesProxyInterface();
        ProductNumbersAndRevisions productNumbersAndRevisions2 = installSequencesProxyInterface.getAddJavaLMsProductNumbersAndRevisions();
        LoadModulesProxyInterface loadModulesProxyInterface = null;
        ProductNumbersAndRevisions productNumbersAndRevisions3 = null;
        ProductNumberAndRevisionRawInterface productNumberAndRevisionRawInterface = null;
        if (!productNumbersAndRevisions2.isEmpty() && (productNumberAndRevisionRawInterface = (productNumbersAndRevisions3 = (loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface()).getProductNumberAndRevisionOfLoadModules()).getFirstNotIncludedRawElement(productNumbersAndRevisions2.getElements())) != null) {
            this.errorReferencedElementMissing("validateThatLoadModulesReferencedFromInstallSequencesArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", "\n\t\tproductNumber: " + productNumberAndRevisionRawInterface.getProductNumberRaw() + "\n\t\trevision: " + productNumberAndRevisionRawInterface.getRevisionRaw(), InstallStepSubElementName.PreUpgradeSu.getValue(), PreUpgradeSuSubElementName.AddJavaLM.getValue(), AddJavaLM_AttributeName.ProductNumber.getValue() + " and " + AddJavaLM_AttributeName.Revision.getValue(), "LoadModule");
        }
        if (!(productNumbersAndRevisions = installSequencesProxyInterface.getLoadJavaLMsProductNumbersAndRevisions()).isEmpty()) {
            if (productNumbersAndRevisions3 == null) {
                loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
                productNumbersAndRevisions3 = loadModulesProxyInterface.getProductNumberAndRevisionOfLoadModules();
            }
            if ((productNumberAndRevisionRawInterface = productNumbersAndRevisions3.getFirstNotIncludedRawElement(productNumbersAndRevisions.getElements())) != null) {
                this.errorReferencedElementMissing("validateThatLoadModulesReferencedFromInstallSequencesArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", "\n\t\tproductNumber: " + productNumberAndRevisionRawInterface.getProductNumberRaw() + "\n\t\trevision: " + productNumberAndRevisionRawInterface.getRevisionRaw(), InstallStepSubElementName.SoftJvmUpgrade.getValue(), SoftJvmUpgradeSubElementName.LoadJavaLM.getValue(), LoadJavaLM_AttributeName.ProductNumber.getValue() + " and " + LoadJavaLM_AttributeName.Revision.getValue(), "LoadModule");
            }
        }
    }

    private void validateThatLoadModulesReferencedFromRepertoiresArePresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        RepertoiresProxyInterface repertoiresProxyInterface;
        Vector vector;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLoadModulesReferencedFromRepertoiresArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if (!(vector = (repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface()).getProductNumbersAndRevisionsOfLoadModuleRefs().getElements()).isEmpty()) {
            LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
            ProductNumbersAndRevisions productNumbersAndRevisions = loadModulesProxyInterface.getProductNumberAndRevisionOfLoadModules();
            Enumeration enumeration = vector.elements();
            ProductNumberAndRevisionRaw productNumberAndRevisionRaw = null;
            while (enumeration.hasMoreElements()) {
                productNumberAndRevisionRaw = (ProductNumberAndRevisionRaw)enumeration.nextElement();
                if (productNumbersAndRevisions.contains(productNumberAndRevisionRaw)) continue;
                this.errorReferencedElementMissing("validateThatLoadModulesReferencedFromRepertoiresArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", productNumberAndRevisionRaw, PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), "LoadModule");
            }
        }
    }

    public void validateThatLoadModulesReferencedFromUpgradeLogicArePresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLoadModulesReferencedFromUpgradeLogicArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        this.validateThatLoadModulesReferencedFromUpgradeLogicArePresent(documentObjectProxyInterface.getUpgradeLogicProxyInterface());
    }

    public void validateThatLoadModulesReferencedFromUpgradeLogicArePresent(UpgradeLogicProxyInterface upgradeLogicProxyInterface) throws ReferencedElementMissingException {
        LoadModulesProxyInterface loadModulesProxyInterface;
        ProductNumbersAndRevisions productNumbersAndRevisions;
        ProductNumberAndRevisionRawInterface productNumberAndRevisionRawInterface;
        Collection collection;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLoadModulesReferencedFromUpgradeLogicArePresent(UpgradeLogicProxyInterface anUpgradeLogicProxy)", (String)("anUpgradeLogicProxyInterface: " + upgradeLogicProxyInterface));
        }
        if (!(collection = upgradeLogicProxyInterface.getLoadModules()).isEmpty() && (productNumberAndRevisionRawInterface = (productNumbersAndRevisions = (loadModulesProxyInterface = upgradeLogicProxyInterface.getLoadModulesProxyInterface()).getProductNumberAndRevisionOfLoadModules()).getFirstNotIncludedRawElement(collection)) != null) {
            this.errorReferencedElementMissing("validateThatLoadModulesReferencedFromUpgradeLogicArePresent(UpgradeLogicProxyInterface anUpgradeLogicProxy)", "\n\t\tproductNumber: " + productNumberAndRevisionRawInterface.getProductNumberRaw() + "\n\t\trevision: " + productNumberAndRevisionRawInterface.getRevisionRaw(), "UpgradeLogic", UpgradeLogicSubElementName.SuLmRef.getValue(), SuLmRefAttributeName.ProductNumber.getValue() + " and " + SuLmRefAttributeName.Revision.getValue(), "LoadModule");
        }
    }

    private void validateThatLoadModulesReferencedFromUpgradeSequencesArePresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        Object object;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLoadModulesReferencedFromUpgradeSequencesArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
        ProductNumbersAndRevisions productNumbersAndRevisions = loadModulesProxyInterface.getProductNumberAndRevisionOfLoadModules();
        UpgradeSequencesProxyInterface upgradeSequencesProxyInterface = documentObjectProxyInterface.getUpgradeSequencesProxyInterface();
        Vector vector = upgradeSequencesProxyInterface.getAddJavaLMs();
        Iterator iterator = vector.iterator();
        ProductNumberAndRevisionRawInterface productNumberAndRevisionRawInterface = null;
        while (iterator.hasNext()) {
            productNumberAndRevisionRawInterface = (ProductNumberAndRevisionRawInterface)iterator.next();
            if (productNumbersAndRevisions.contains(productNumberAndRevisionRawInterface.getProductNumber(), productNumberAndRevisionRawInterface.getRevision())) continue;
            this.errorReferencedElementMissing("validateThatLoadModulesReferencedFromUpgradeSequencesArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", productNumberAndRevisionRawInterface.getProductNumberRaw() + productNumberAndRevisionRawInterface.getRevisionRaw(), RebootNodeUpgradeSubElementName.AddJavaLM.getValue(), AddJavaLM_AttributeName.ProductNumber.getValue() + " and " + AddJavaLM_AttributeName.Revision.getValue(), "LoadModule");
        }
        Vector vector2 = upgradeSequencesProxyInterface.getRemoveJavaLMs();
        Iterator iterator2 = vector2.iterator();
        ProductNumberAndRevisionRawInterface productNumberAndRevisionRawInterface2 = null;
        while (iterator2.hasNext()) {
            productNumberAndRevisionRawInterface2 = (ProductNumberAndRevisionRawInterface)iterator2.next();
            if (productNumbersAndRevisions.contains(productNumberAndRevisionRawInterface2.getProductNumber(), productNumberAndRevisionRawInterface2.getRevision())) continue;
            object = "Upgrade control file error,\n\treferenced LoadModule element does not exist.\n\tAn element of type " + RebootNodeUpgradeSubElementName.RemoveJavaLM.getValue() + "\n\tcontains the reference data:" + RemoveJavaLM_AttributeName.ProductNumber.getValue() + " = " + productNumberAndRevisionRawInterface2.getProductNumberRaw() + productNumberAndRevisionRawInterface2.getRevisionRaw() + "." + "\n\tThis reference data does not indicate any existing element of type " + "LoadModule";
            UpgradeTrace.warning(this.getClass(), (String)"validateThatLoadModulesReferencedFromUpgradeSequencesArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)object);
        }
        object = upgradeSequencesProxyInterface.getLoadJavaLMs();
        Iterator iterator3 = ((Vector)object).iterator();
        ProductNumberAndRevisionRawInterface productNumberAndRevisionRawInterface3 = null;
        while (iterator3.hasNext()) {
            productNumberAndRevisionRawInterface3 = (ProductNumberAndRevisionRawInterface)iterator3.next();
            if (productNumbersAndRevisions.contains(productNumberAndRevisionRawInterface3.getProductNumber(), productNumberAndRevisionRawInterface3.getRevision())) continue;
            this.errorReferencedElementMissing("validateThatLoadModulesReferencedFromUpgradeSequencesArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", "\n\t\tproductNumber: " + productNumberAndRevisionRawInterface3.getProductNumberRaw() + "\n\t\trevision: " + productNumberAndRevisionRawInterface3.getRevisionRaw(), StepSubElementName.SoftJvmUpgrade.getValue(), SoftJvmUpgradeSubElementName.LoadJavaLM.getValue(), LoadJavaLM_AttributeName.ProductNumber.getValue() + " and " + LoadJavaLM_AttributeName.Revision.getValue(), "LoadModule");
        }
    }

    private void validateThatLoadModulesReferencedFromVerifySequencesArePresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        ProductNumbersAndRevisions productNumbersAndRevisions;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLoadModulesReferencedFromVerifySequencesArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        VerifySequencesProxyInterface verifySequencesProxyInterface = documentObjectProxyInterface.getVerifySequencesProxyInterface();
        ProductNumbersAndRevisions productNumbersAndRevisions2 = verifySequencesProxyInterface.getAddJavaLMsProductNumbersAndRevisions();
        LoadModulesProxyInterface loadModulesProxyInterface = null;
        ProductNumbersAndRevisions productNumbersAndRevisions3 = null;
        ProductNumberAndRevisionRawInterface productNumberAndRevisionRawInterface = null;
        if (!productNumbersAndRevisions2.isEmpty() && (productNumberAndRevisionRawInterface = (productNumbersAndRevisions3 = (loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface()).getProductNumberAndRevisionOfLoadModules()).getFirstNotIncludedRawElement(productNumbersAndRevisions2.getElements())) != null) {
            this.errorReferencedElementMissing("validateThatLoadModulesReferencedFromVerifySequencesArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", "\n\t\tproductNumber: " + productNumberAndRevisionRawInterface.getProductNumberRaw() + "\n\t\trevision: " + productNumberAndRevisionRawInterface.getRevisionRaw(), VerifyStepSubElementName.PreUpgradeSu.getValue(), PreUpgradeSuSubElementName.AddJavaLM.getValue(), AddJavaLM_AttributeName.ProductNumber.getValue() + " and " + AddJavaLM_AttributeName.Revision.getValue(), "LoadModule");
        }
        if (!(productNumbersAndRevisions = verifySequencesProxyInterface.getLoadJavaLMsProductNumbersAndRevisions()).isEmpty()) {
            if (productNumbersAndRevisions3 == null) {
                loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
                productNumbersAndRevisions3 = loadModulesProxyInterface.getProductNumberAndRevisionOfLoadModules();
            }
            if ((productNumberAndRevisionRawInterface = productNumbersAndRevisions3.getFirstNotIncludedRawElement(productNumbersAndRevisions.getElements())) != null) {
                this.errorReferencedElementMissing("validateThatLoadModulesReferencedFromVerifySequencesArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", "\n\t\tproductNumber: " + productNumberAndRevisionRawInterface.getProductNumberRaw() + "\n\t\trevision: " + productNumberAndRevisionRawInterface.getRevisionRaw(), VerifyStepSubElementName.SoftJvmUpgrade.getValue(), SoftJvmUpgradeSubElementName.LoadJavaLM.getValue(), LoadJavaLM_AttributeName.ProductNumber.getValue() + " and " + LoadJavaLM_AttributeName.Revision.getValue(), "LoadModule");
            }
        }
    }

    private void validateThatLoadModulesReferencedFromVerifyUpdateSequencesArePresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        LoadModulesProxyInterface loadModulesProxyInterface;
        ProductNumbersAndRevisions productNumbersAndRevisions;
        ProductNumberAndRevisionRawInterface productNumberAndRevisionRawInterface;
        VerifyUpdateSequencesProxyInterface verifyUpdateSequencesProxyInterface;
        ProductNumbersAndRevisions productNumbersAndRevisions2;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLoadModulesReferencedFromVerifyUpdateSequencesArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if (!(productNumbersAndRevisions2 = (verifyUpdateSequencesProxyInterface = documentObjectProxyInterface.getVerifyUpdateSequencesProxyInterface()).getLoadJavaLMsProductNumbersAndRevisions()).isEmpty() && (productNumberAndRevisionRawInterface = (productNumbersAndRevisions = (loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface()).getProductNumberAndRevisionOfLoadModules()).getFirstNotIncludedRawElement(productNumbersAndRevisions2.getElements())) != null) {
            this.errorReferencedElementMissing("validateThatLoadModulesReferencedFromVerifyUpdateSequencesArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", "\n\t\tproductNumber: " + productNumberAndRevisionRawInterface.getProductNumberRaw() + "\n\t\trevision: " + productNumberAndRevisionRawInterface.getRevisionRaw(), VerifyUpdateStepSubElementName.SoftJvmUpgrade.getValue(), SoftJvmUpgradeSubElementName.LoadJavaLM.getValue(), LoadJavaLM_AttributeName.ProductNumber.getValue() + " and " + LoadJavaLM_AttributeName.Revision.getValue(), "LoadModule");
        }
    }

    private void validateThatLoadModulesReferencedFromVerifyUpgradeSequencesArePresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        ProductNumbersAndRevisions productNumbersAndRevisions;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLoadModulesReferencedFromVerifyUpgradeSequencesArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        VerifyUpgradeSequencesProxyInterface verifyUpgradeSequencesProxyInterface = documentObjectProxyInterface.getVerifyUpgradeSequencesProxyInterface();
        ProductNumbersAndRevisions productNumbersAndRevisions2 = verifyUpgradeSequencesProxyInterface.getAddJavaLMsProductNumbersAndRevisions();
        LoadModulesProxyInterface loadModulesProxyInterface = null;
        ProductNumbersAndRevisions productNumbersAndRevisions3 = null;
        ProductNumberAndRevisionRawInterface productNumberAndRevisionRawInterface = null;
        if (!productNumbersAndRevisions2.isEmpty() && (productNumberAndRevisionRawInterface = (productNumbersAndRevisions3 = (loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface()).getProductNumberAndRevisionOfLoadModules()).getFirstNotIncludedRawElement(productNumbersAndRevisions2.getElements())) != null) {
            this.errorReferencedElementMissing("validateThatLoadModulesReferencedFromVerifyUpgradeSequencesArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", "\n\t\tproductNumber: " + productNumberAndRevisionRawInterface.getProductNumberRaw() + "\n\t\trevision: " + productNumberAndRevisionRawInterface.getRevisionRaw(), VerifyStepSubElementName.PreUpgradeSu.getValue(), PreUpgradeSuSubElementName.AddJavaLM.getValue(), AddJavaLM_AttributeName.ProductNumber.getValue() + " and " + AddJavaLM_AttributeName.Revision.getValue(), "LoadModule");
        }
        if (!(productNumbersAndRevisions = verifyUpgradeSequencesProxyInterface.getLoadJavaLMsProductNumbersAndRevisions()).isEmpty()) {
            if (productNumbersAndRevisions3 == null) {
                loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
                productNumbersAndRevisions3 = loadModulesProxyInterface.getProductNumberAndRevisionOfLoadModules();
            }
            if ((productNumberAndRevisionRawInterface = productNumbersAndRevisions3.getFirstNotIncludedRawElement(productNumbersAndRevisions.getElements())) != null) {
                this.errorReferencedElementMissing("validateThatLoadModulesReferencedFromVerifyUpgradeSequencesArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", "\n\t\tproductNumber: " + productNumberAndRevisionRawInterface.getProductNumberRaw() + "\n\t\trevision: " + productNumberAndRevisionRawInterface.getRevisionRaw(), VerifyStepSubElementName.SoftJvmUpgrade.getValue(), SoftJvmUpgradeSubElementName.LoadJavaLM.getValue(), LoadJavaLM_AttributeName.ProductNumber.getValue() + " and " + LoadJavaLM_AttributeName.Revision.getValue(), "LoadModule");
            }
        }
    }

    private void validateThatLoadModuleRefsContainingLoaderNamesAreAllowed(DocumentObjectProxyInterface documentObjectProxyInterface) throws UnexpectedAttributeException {
        RepertoiresProxyInterface repertoiresProxyInterface;
        LoadModuleRefsWithLoaderNamesInformation loadModuleRefsWithLoaderNamesInformation;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLoadModuleRefsContainingLoaderNamesAreAllowed(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if (!(loadModuleRefsWithLoaderNamesInformation = (repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface()).getLoadModuleRefsWithLoaderNamesInformation()).isEmpty()) {
            HashSet<LoaderName> hashSet = new HashSet<LoaderName>();
            hashSet.add(LoaderName.SPM_Loader);
            hashSet.add(LoaderName.OSE_Loader);
            hashSet.add(LoaderName.DeviceLoader);
            LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
            LoadModulesWithLoaderNamesInformation loadModulesWithLoaderNamesInformation = loadModulesProxyInterface.getLoadModulesWithLoaderNamesInformation(hashSet, false);
            ProductNumbersAndRevisions productNumbersAndRevisions = null;
            LoaderName loaderName = LoaderName.OSE_Loader;
            ProductNumbersAndRevisions productNumbersAndRevisions2 = loadModuleRefsWithLoaderNamesInformation.getLoadModuleRefs(loaderName);
            if (!productNumbersAndRevisions2.isEmpty()) {
                hashSet.remove(LoaderName.SPM_Loader);
                productNumbersAndRevisions = loadModulesWithLoaderNamesInformation.getLoadModules(hashSet);
                this.validateThatLoadModuleRefsContainingLoaderNamesAreAllowed(loaderName, productNumbersAndRevisions2.getElements(), productNumbersAndRevisions);
            }
            if (!(productNumbersAndRevisions2 = loadModuleRefsWithLoaderNamesInformation.getLoadModuleRefs(loaderName = LoaderName.DeviceLoader)).isEmpty()) {
                productNumbersAndRevisions = loadModulesWithLoaderNamesInformation.getLoadModules();
                this.validateThatLoadModuleRefsContainingLoaderNamesAreAllowed(loaderName, productNumbersAndRevisions2.getElements(), productNumbersAndRevisions);
            }
        }
    }

    private void validateThatLoadModuleRefsContainingLoaderNamesAreAllowed(LoaderName loaderName, Collection collection, ProductNumbersAndRevisions productNumbersAndRevisions) throws UnexpectedAttributeException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatLoadModuleRefsContainingLoaderNamesAreAllowed(LoaderName aLoadModuleRefLoaderName, Collection aLoadModuleRefIdentifiers, ProductNumbersAndRevisions aLoadModuleIdentifiers)", (String)("aLoadModuleRefLoaderName: " + loaderName + "\n\taLoadModuleRefIdentifiers: " + collection + "\n\taLoadModuleIdentifiers: " + productNumbersAndRevisions));
        }
        Iterator iterator = collection.iterator();
        ProductNumberAndRevision productNumberAndRevision = null;
        while (iterator.hasNext()) {
            productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
            if (productNumbersAndRevisions.contains(productNumberAndRevision)) continue;
            String string = "\n\tAttribute " + LoadModuleRefAttributeName.LoaderName.getValue() + " with value " + loaderName.getValue() + " is only allowed in a " + PiuTypeLoadListSubElementName.LoadModuleRef.getValue() + " element if the referenced " + "LoadModule" + " element" + "\n\tcontains an " + LoadModuleSubElementName.MoDataLM.getValue() + " element where the value for attribute " + MoDataLM_AttributeName.LoaderName.getValue() + " is ";
            String string2 = MoDataLM_LoaderNameValue.OSE_Loader + " or " + MoDataLM_LoaderNameValue.DeviceLoader + ".";
            if (loaderName.equals(LoaderName.DeviceLoader)) {
                string2 = MoDataLM_LoaderNameValue.SPM_Loader + ", " + MoDataLM_LoaderNameValue.OSE_Loader + " or " + MoDataLM_LoaderNameValue.DeviceLoader + ".";
            }
            DocumentObjectValidator.errorUnexpectedAttributeWithLocatorString(this.getClass(), "validateThatLoadModuleRefsContainingLoaderNamesAreAllowed(LoaderName aLoadModuleRefLoaderName, Collection aLoadModuleRefIdentifiers, ProductNumbersAndRevisions aLoadModuleIdentifiers)", RepertoireSubElementName.PiuTypeLoadList.getValue(), PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), LoadModuleRefAttributeName.LoaderName.getValue(), string + string2, productNumberAndRevision.getLocatorString());
        }
    }

    private void validateThatOtherUpgradePackagesNotIsPresentInOldUpgradePackage(DocumentObjectProxyInterface documentObjectProxyInterface) throws UnexpectedElementException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatOtherUpgradePackagesNotIsPresentInOldUpgradePackage(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        UpgradeWindowProxyInterface upgradeWindowProxyInterface = documentObjectProxyInterface.getUpgradeWindowProxyInterface();
        Vector vector = upgradeWindowProxyInterface.getOldUpgradePackages();
        Iterator iterator = vector.iterator();
        OldUpgradePackage oldUpgradePackage = null;
        OtherUpgradePackages otherUpgradePackages = null;
        while (iterator.hasNext()) {
            oldUpgradePackage = (OldUpgradePackage)iterator.next();
            otherUpgradePackages = oldUpgradePackage.getOtherUpgradePackages();
            if (otherUpgradePackages == null) continue;
            DocumentObjectValidator.errorUnexpectedElement(this.getClass(), "validateThatOtherUpgradePackagesNotIsPresentInOldUpgradePackage(DocumentObjectProxyInterface aDocumentObjectProxy)", "UpgradeWindow", UpgradeWindowSubElementName.OldUpgradePackage.getValue(), OldUpgradePackageSubElementName.OtherUpgradePackages.getValue(), "\n\tThe element " + OldUpgradePackageSubElementName.OtherUpgradePackages.getValue() + " is only valid if and only if the upgrade package is of type 'delta'.");
        }
    }

    private void validateThatUpgradeSequenceReferedFromOldUpgradePackageIsUnique(DocumentObjectProxyInterface documentObjectProxyInterface) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradeSequenceReferedFromOldUpgradePackageIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        HashSet<String> hashSet = new HashSet<String>();
        ProductData productData = null;
        UP_CompatibilityIndex uP_CompatibilityIndex = null;
        OldUpgradePackage oldUpgradePackage = null;
        Vector vector = documentObjectProxyInterface.getUpgradeWindowProxyInterface().getOldUpgradePackages();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            oldUpgradePackage = (OldUpgradePackage)iterator.next();
            productData = oldUpgradePackage.getProductData();
            uP_CompatibilityIndex = oldUpgradePackage.getUP_CompatibilityIndex();
            if (productData != null) {
                hashSet.add(productData.getNumberRaw() + "\u00a3\u00a3\u00a3" + productData.getRevisionRaw());
                continue;
            }
            if (uP_CompatibilityIndex == null) continue;
            hashSet.add(uP_CompatibilityIndex.getIndex());
        }
        SupportedSequenceInformation supportedSequenceInformation = null;
        Iterator iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            FromStateInformation fromStateInformation = new FromStateInformation((String)iterator2.next());
            if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradeSequenceReferedFromOldUpgradePackageIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("Fetching SupportedSequenceInformation for " + TypeOfUpgrade.RebootNodeUpgrade));
            }
            supportedSequenceInformation = documentObjectProxyInterface.getValidSequences(TypeOfUpgrade.RebootNodeUpgrade, fromStateInformation.getProductNumber(), fromStateInformation.getProductRevision(), fromStateInformation.getUpCompabilityIndex());
            this.validateThatUpgradeSequenceReferedFromOldUpgradePackageIsUnique(TypeOfUpgrade.RebootNodeUpgrade, fromStateInformation, supportedSequenceInformation);
            if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradeSequenceReferedFromOldUpgradePackageIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("Fetching SupportedSequenceInformation for " + TypeOfUpgrade.Upgrade));
            }
            supportedSequenceInformation = documentObjectProxyInterface.getValidSequences(TypeOfUpgrade.Upgrade, fromStateInformation.getProductNumber(), fromStateInformation.getProductRevision(), fromStateInformation.getUpCompabilityIndex());
            this.validateThatUpgradeSequenceReferedFromOldUpgradePackageIsUnique(TypeOfUpgrade.Upgrade, fromStateInformation, supportedSequenceInformation);
            if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradeSequenceReferedFromOldUpgradePackageIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("Fetching SupportedSequenceInformation for " + TypeOfUpgrade.Update));
            }
            supportedSequenceInformation = documentObjectProxyInterface.getValidSequences(TypeOfUpgrade.Update, fromStateInformation.getProductNumber(), fromStateInformation.getProductRevision(), fromStateInformation.getUpCompabilityIndex());
            this.validateThatUpgradeSequenceReferedFromOldUpgradePackageIsUnique(TypeOfUpgrade.Update, fromStateInformation, supportedSequenceInformation);
        }
    }

    private void validateThatUpgradeSequenceReferedFromOldUpgradePackageIsUnique(TypeOfUpgrade typeOfUpgrade, FromStateInformation fromStateInformation, SupportedSequenceInformation supportedSequenceInformation) {
        MultipleUpgradeSequencesInformation multipleUpgradeSequencesInformation;
        DuplicadedUpgradeSequencesInformation duplicadedUpgradeSequencesInformation;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradeSequenceReferedFromOldUpgradePackageIsUnique(TypeOfUpgrade aTypeOfUpgrade, FromStateInformation aFromStateInformation, SupportedSequenceInformation theSupportedSequenceInformation)", (String)("aTypeOfUpgrade: " + typeOfUpgrade + "\n\taFromStateInformation: " + fromStateInformation + "\n\taSupportedSequenceInformation: " + supportedSequenceInformation));
        }
        if ((duplicadedUpgradeSequencesInformation = supportedSequenceInformation.getDuplicatedUpgradeSequences()).hasDuplicatedUpgradeSequences()) {
            UpgradeTrace.info(this.getClass(), (String)"validateThatUpgradeSequenceReferedFromOldUpgradePackageIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("Upgrade control file inconsistency: \n\tSeveral upgrades of type " + typeOfUpgrade + " refers to the same UpgradeSequence (ignored)." + "\n\tThe UpgradeSequence label: " + duplicadedUpgradeSequencesInformation.getLabelForDuplicatedUpgradeSequence() + "\n\tFrom state information: " + fromStateInformation.getFromStateInformation()));
        }
        if ((multipleUpgradeSequencesInformation = supportedSequenceInformation.getMultipleUpgradeSequences()).hasMultipleUpgradeSequences()) {
            UpgradeTrace.warning(this.getClass(), (String)"validateThatUpgradeSequenceReferedFromOldUpgradePackageIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("Upgrade control file inconsistency: \n\tTwo upgrades of type " + typeOfUpgrade + " refers to the different UpgradeSequences: " + "\n\tFirst UpgradeSequence label: " + multipleUpgradeSequencesInformation.getFirstLabelForMultipleUpgradeSequences() + "\n\tSecond UpgradeSequence label: " + multipleUpgradeSequencesInformation.getSecondLabelForMultipleUpgradeSequences() + "\n\tFrom state information: " + fromStateInformation.getFromStateInformation() + "\n\tLabel for sequence that will be used for " + typeOfUpgrade + ": " + supportedSequenceInformation.getFirstSequenceInformation().label));
        }
    }

    private void validateThatProductNumbersWithWildCardRevisionAreUnique(DocumentObjectProxyInterface documentObjectProxyInterface, String string) throws IllegalAttributeValueException, UnexpectedElementException {
        HashSet<String> hashSet;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatProductNumbersWithWildCardRevisionAreUnique(DocumentObjectProxyInterface aDocumentObjectProxy, String anElementName)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface + "\n\tanElementName" + string));
        }
        ProductNumbersAndRevisions productNumbersAndRevisions = null;
        if (string.equalsIgnoreCase("PiuType")) {
            hashSet = documentObjectProxyInterface.getPiuTypesProxyInterface();
            productNumbersAndRevisions = hashSet.getProductNumberAndRevisionOfAllPiuTypes();
        } else if (string.equalsIgnoreCase("SubrackProdType")) {
            hashSet = documentObjectProxyInterface.getSubrackProdTypesProxyInterface();
            productNumbersAndRevisions = hashSet.getProductNumberAndRevisionOfAllSubrackProdTypes();
        } else {
            UpgradeTrace.info(this.getClass(), (String)"validateThatProductNumbersWithWildCardRevisionAreUnique(DocumentObjectProxyInterface aDocumentObjectProxy, String anElementName)", (String)("Handling of received element name is not implemented, received elementname: " + string));
            return;
        }
        hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        ProductNumberAndRevision productNumberAndRevision = null;
        boolean bl = true;
        String string2 = null;
        Iterator iterator = productNumbersAndRevisions.getElements().iterator();
        while (iterator.hasNext()) {
            productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
            if (!productNumberAndRevision.revision.equals("*")) {
                if (!hashSet.contains(productNumberAndRevision.productNumber)) {
                    hashSet2.add(productNumberAndRevision.productNumber);
                } else {
                    bl = false;
                }
            } else if (!hashSet2.contains(productNumberAndRevision.productNumber)) {
                if (!hashSet.add(productNumberAndRevision.productNumber)) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl) continue;
            string2 = "\n\tThe value of this attribute must be unique among all " + string + " elements (when the attribute '" + ProductDataAttributeName.Revision.getValue() + "' has value '" + "*" + "')";
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatProductNumbersWithWildCardRevisionAreUnique(DocumentObjectProxyInterface aDocumentObjectProxy, String anElementName)", PiuTypeSubElementName.ProductData.getValue(), ProductDataAttributeName.Number.getValue(), productNumberAndRevision.productNumber, string2);
        }
    }

    private void validateThatProductNumbersWithSpecificRevisionAreUnique(DocumentObjectProxyInterface documentObjectProxyInterface, String string) throws IllegalAttributeValueException, UnexpectedElementException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatProductNumbersWithSpecificRevisionAreUnique(DocumentObjectProxyInterface aDocumentObjectProxy, String anElementName)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface + "\n\tanElementName" + string));
        }
        ProductNumbersAndRevisions productNumbersAndRevisions = null;
        if (!string.equalsIgnoreCase("SubrackProdType")) {
            UpgradeTrace.info(this.getClass(), (String)"validateThatProductNumbersWithSpecificRevisionAreUnique(DocumentObjectProxyInterface aDocumentObjectProxy, String anElementName)", (String)("Handling of received element name is not implemented, received elementname: " + string));
            return;
        }
        Object object = documentObjectProxyInterface.getSubrackProdTypesProxyInterface();
        productNumbersAndRevisions = object.getProductNumberAndRevisionOfAllSubrackProdTypes();
        object = new HashMap();
        HashSet<String> hashSet = null;
        ProductNumberAndRevision productNumberAndRevision = null;
        String string2 = null;
        Iterator iterator = productNumbersAndRevisions.getElements().iterator();
        while (iterator.hasNext()) {
            productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
            hashSet = (HashSet<String>)((HashMap)object).get(productNumberAndRevision.productNumber);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashSet.add(productNumberAndRevision.revision);
                ((HashMap)object).put(productNumberAndRevision.productNumber, hashSet);
                continue;
            }
            if (!hashSet.contains(productNumberAndRevision.revision)) {
                hashSet.add(productNumberAndRevision.revision);
                ((HashMap)object).put(productNumberAndRevision.productNumber, hashSet);
                continue;
            }
            string2 = "\n\tThe productNumber and revision must be unique for all " + string + " elements.";
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatProductNumbersWithSpecificRevisionAreUnique(DocumentObjectProxyInterface aDocumentObjectProxy, String anElementName)", SubrackProdTypeSubElementName.ProductData.getValue(), ProductDataAttributeName.Number.getValue(), productNumberAndRevision.productNumber, string2);
        }
    }

    private void validateThatReferencedRepertoireNamesFromUpgradeSequenceArePresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatReferencedRepertoireNamesFromUpgradeSequenceArePresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        UpgradeSequencesProxyInterface upgradeSequencesProxyInterface = documentObjectProxyInterface.getUpgradeSequencesProxyInterface();
        Vector vector = upgradeSequencesProxyInterface.getRepertoireNamesInFindPiuToTolerates();
        this.validateThatRepertoireNamesExists(documentObjectProxyInterface, vector, UpgradeSequenceSubElementName.FindPiuToTolerate.getValue(), FindPiuToTolerateAttributeName.MatchRepertoireName.getValue());
        vector = upgradeSequencesProxyInterface.getRepertoireNamesInFindPius();
        this.validateThatRepertoireNamesExists(documentObjectProxyInterface, vector, RebootPiuUpgradeSubElementName.FindPiu.getValue(), FindPiuAttributeName.MatchRepertoireName.getValue());
        Collection collection = upgradeSequencesProxyInterface.getRepertoireNamesInRemovePrograms();
        this.validateThatRepertoireNamesExists(documentObjectProxyInterface, collection, RebootProgramUpgradeSubElementName.RemovePrograms.getValue(), RemoveProgramsAttributeName.RepertoireName.getValue());
        collection = upgradeSequencesProxyInterface.getRepertoireNamesInRunPrograms();
        this.validateThatRepertoireNamesExists(documentObjectProxyInterface, collection, RebootProgramUpgradeSubElementName.RunPrograms.getValue(), RunProgramsAttributeName.RepertoireName.getValue());
    }

    private void validateThatRepertoireNamesExists(DocumentObjectProxyInterface documentObjectProxyInterface, Collection collection, String string, String string2) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatRepertoireNamesExists ( DocumentObjectProxyInterface aDocumentObjectProxy, Vector anMatchRepertoireNames )", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface + "\n\tanRepertoireNames: " + collection + "\n\taReferenceFromElementName: " + string + "\n\taReferenceFromAttributeName: " + string2));
        }
        RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
        Vector vector = repertoiresProxyInterface.getRepertoireNames();
        Iterator iterator = collection.iterator();
        String string3 = null;
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            if (vector.contains(string3)) continue;
            this.errorReferencedElementMissing("validateThatRepertoireNamesExists (DocumentObjectProxyInterface aDocumentObjectProxy, Vector anRepertoireNames, String aReferenceFromElementName, String aReferencedElementName )", string3, string, string2, "Repertoire");
        }
    }

    private void validateThatRepertoireReferencedFromNewRepIsPresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatRepertoireReferencedFromNewRepIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        RepertoireReplacementsProxyInterface repertoireReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface().getRepertoireReplacementsProxyInterface();
        Vector vector = repertoireReplacementsProxyInterface.getRepertoireNamesInNewReps();
        this.validateThatRepertoireNamesExists(documentObjectProxyInterface, vector, RepertoireReplacementSubElementName.NewRep.getValue(), NewRepAttributeName.Name.getValue());
    }

    private void validateThatTheNameInRepertoireIsUnique(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatTheNameInRepertoireIsUnique ( DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
        Vector vector = repertoiresProxyInterface.getRepertoireNames();
        Iterator iterator = vector.iterator();
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (hashSet.add(string)) continue;
            String string2 = "\n\tThe value of this attribute must be unique among all Repertoire elements in this " + RootElementName.UpgradePackage.getValue() + ".";
            DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatTheNameInRepertoireIsUnique(DocumentObjectProxyInterface aDocumentObjectProxy)", "Repertoire", RepertoireAttributeName.Name.getValue(), string, string2);
        }
    }

    private void validateThatUpgradeCaseRefsInVerifyUpdateSequencesExistsInTheUpdateSequence(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        VerifyUpdateSequencesProxyInterface verifyUpdateSequencesProxyInterface;
        Collection collection;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradeCaseRefsInVerifyUpdateSequencesExistsInTheUpdateSequence(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if (!(collection = (verifyUpdateSequencesProxyInterface = documentObjectProxyInterface.getVerifyUpdateSequencesProxyInterface()).getAllCaseValues()).isEmpty()) {
            UpdateSequenceProxyInterface updateSequenceProxyInterface = documentObjectProxyInterface.getUpdateSequenceProxyInterface();
            Collection collection2 = updateSequenceProxyInterface.getAllCaseValues();
            Iterator iterator = collection.iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (collection2.contains(string)) continue;
                String string2 = "\n\tAn " + VerifyUpdateSequenceSubElementName.UpgradeCaseRef.getValue() + " element in a " + "VerifyUpdateSequence" + " element must contain the same value for attribute " + UpgradeCaseRefAttributeName.Case.getValue() + " as one of the " + UpdateSequenceSubElementName.UpgradeCaseRef.getValue() + " elements in the " + "UpdateSequence" + " element.";
                DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatUpgradeCaseRefsInVerifyUpdateSequencesExistsInTheUpdateSequence(DocumentObjectProxyInterface aDocumentObjectProxy)", "VerifyUpdateSequence", VerifyUpdateSequenceSubElementName.UpgradeCaseRef.getValue(), UpgradeCaseRefAttributeName.Case.getValue(), string, string2);
            }
        }
    }

    private void validateThatUpgradeCaseRefsInVerifyUpgradeSequencesExistsInAnUpgradeSequence(DocumentObjectProxyInterface documentObjectProxyInterface) throws IllegalAttributeValueException {
        VerifyUpgradeSequencesProxyInterface verifyUpgradeSequencesProxyInterface;
        Collection collection;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradeCaseRefsInVerifyUpgradeSequencesExistsInAnUpgradeSequence(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if (!(collection = (verifyUpgradeSequencesProxyInterface = documentObjectProxyInterface.getVerifyUpgradeSequencesProxyInterface()).getAllCaseValues()).isEmpty()) {
            UpgradeSequencesProxyInterface upgradeSequencesProxyInterface = documentObjectProxyInterface.getUpgradeSequencesProxyInterface();
            Vector vector = upgradeSequencesProxyInterface.getAllCaseValues();
            Iterator iterator = collection.iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (vector.contains(string)) continue;
                String string2 = "\n\tAn " + VerifyUpgradeSequenceSubElementName.UpgradeCaseRef.getValue() + " element in a " + "VerifyUpgradeSequence" + " element must contain the same value for attribute " + UpgradeCaseRefAttributeName.Case.getValue() + " as one of the " + UpgradeSequenceSubElementName.UpgradeCaseRef.getValue() + " elements in an " + "UpgradeSequence" + " element.";
                DocumentObjectValidator.errorIllegalAttributeValue(this.getClass(), "validateThatUpgradeCaseRefsInVerifyUpgradeSequencesExistsInAnUpgradeSequence(DocumentObjectProxyInterface aDocumentObjectProxy)", "VerifyUpgradeSequence", VerifyUpgradeSequenceSubElementName.UpgradeCaseRef.getValue(), UpgradeCaseRefAttributeName.Case.getValue(), string, string2);
            }
        }
    }

    private void validateThatUpgradeLogicReferencedFromInstallSequencesIsPresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws MandatoryElementIsMissingException, ReferencedElementMissingException {
        InstallSequencesProxyInterface installSequencesProxyInterface;
        Collection collection;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradeLogicReferencedFromInstallSequencesIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if (!(collection = (installSequencesProxyInterface = documentObjectProxyInterface.getInstallSequencesProxyInterface()).getUpgradeLogicNameValues()).isEmpty()) {
            UpgradeLogicProxyInterface upgradeLogicProxyInterface = documentObjectProxyInterface.getUpgradeLogicProxyInterface();
            String string = upgradeLogicProxyInterface.getName();
            if (string != null) {
                Iterator iterator = collection.iterator();
                String string2 = null;
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    if (string2.equals(string)) continue;
                    String string3 = "\n\tThis reference data does not indicate the existing element of type UpgradeLogic (since that element does not contain a matching value for attribute " + UpgradeLogicAttributeName.Name.getValue() + ").";
                    this.errorReferencedElementMissing("validateThatUpgradeLogicReferencedFromInstallSequencesIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", string2, "InstallSequence", InstallSequenceSubElementName.InstallStep.getValue(), InstallStepSubElementName.PreUpgradeSu.getValue(), PreUpgradeSuAttributeName.UpgradeLogicName.getValue(), "UpgradeLogic", string3);
                }
            } else {
                String string4 = "\n\tAn UpgradeLogic element must be present since there is at least one InstallSequence element\n\t(with an " + InstallSequenceSubElementName.InstallStep.getValue() + " element with a " + InstallStepSubElementName.PreUpgradeSu + " element)" + "\n\twhich contains a reference to an element of type " + "UpgradeLogic" + ".";
                DocumentObjectValidator.errorElementIsMissing(this.getClass(), "validateThatUpgradeLogicReferencedFromInstallSequencesIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", RootElementName.UpgradePackage.getValue(), string4);
            }
        }
    }

    private void validateThatUpgradeLogicReferencedFromVerifySequencesIsPresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws MandatoryElementIsMissingException, ReferencedElementMissingException {
        VerifySequencesProxyInterface verifySequencesProxyInterface;
        Collection collection;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradeLogicReferencedFromVerifySequencesIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if (!(collection = (verifySequencesProxyInterface = documentObjectProxyInterface.getVerifySequencesProxyInterface()).getUpgradeLogicNameValues()).isEmpty()) {
            UpgradeLogicProxyInterface upgradeLogicProxyInterface = documentObjectProxyInterface.getUpgradeLogicProxyInterface();
            String string = upgradeLogicProxyInterface.getName();
            if (string != null) {
                Iterator iterator = collection.iterator();
                String string2 = null;
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    if (string2.equals(string)) continue;
                    String string3 = "\n\tThis reference data does not indicate the existing element of type UpgradeLogic (since that element does not contain a matching value for attribute " + UpgradeLogicAttributeName.Name.getValue() + ".";
                    this.errorReferencedElementMissing("validateThatUpgradeLogicReferencedFromVerifySequencesIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", string2, "VerifySequence", VerifySequenceSubElementName.VerifyStep.getValue(), VerifyStepSubElementName.PreUpgradeSu.getValue(), PreUpgradeSuAttributeName.UpgradeLogicName.getValue(), "UpgradeLogic", string3);
                }
            } else {
                String string4 = "\n\tAn UpgradeLogic element must be present since there is at least one VerifySequence element\n\t(with an " + VerifySequenceSubElementName.VerifyStep.getValue() + " element with a " + VerifyStepSubElementName.PreUpgradeSu + " element)" + "\n\twhich contains a reference to an element of type " + "UpgradeLogic";
                DocumentObjectValidator.errorElementIsMissing(this.getClass(), "validateThatUpgradeLogicReferencedFromVerifySequencesIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", RootElementName.UpgradePackage.getValue(), string4);
            }
        }
    }

    private void validateThatUpgradeLogicReferencedFromVerifyUpgradeSequencesIsPresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws MandatoryElementIsMissingException, ReferencedElementMissingException {
        VerifyUpgradeSequencesProxyInterface verifyUpgradeSequencesProxyInterface;
        Collection collection;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradeLogicReferencedFromVerifyUpgradeSequencesIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if (!(collection = (verifyUpgradeSequencesProxyInterface = documentObjectProxyInterface.getVerifyUpgradeSequencesProxyInterface()).getUpgradeLogicNameValues()).isEmpty()) {
            UpgradeLogicProxyInterface upgradeLogicProxyInterface = documentObjectProxyInterface.getUpgradeLogicProxyInterface();
            String string = upgradeLogicProxyInterface.getName();
            if (string != null) {
                Iterator iterator = collection.iterator();
                String string2 = null;
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    if (string2.equals(string)) continue;
                    String string3 = "\n\tThis reference data does not indicate the existing element of type UpgradeLogic (since that element does not contain a matching value for attribute " + UpgradeLogicAttributeName.Name.getValue() + ".";
                    this.errorReferencedElementMissing("validateThatUpgradeLogicReferencedFromVerifyUpgradeSequencesIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", string2, "VerifyUpgradeSequence", VerifyUpgradeSequenceSubElementName.VerifyStep.getValue(), VerifyStepSubElementName.PreUpgradeSu.getValue(), PreUpgradeSuAttributeName.UpgradeLogicName.getValue(), "UpgradeLogic", string3);
                }
            } else {
                String string4 = "\n\tAn UpgradeLogic element must be present since there is at least one VerifyUpgradeSequence element\n\t(with an " + VerifyUpgradeSequenceSubElementName.VerifyStep.getValue() + " element with a " + VerifyStepSubElementName.PreUpgradeSu + " element)" + "\n\twhich contains a reference to an element of type " + "UpgradeLogic";
                DocumentObjectValidator.errorElementIsMissing(this.getClass(), "validateThatUpgradeLogicReferencedFromVerifyUpgradeSequencesIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", RootElementName.UpgradePackage.getValue(), string4);
            }
        }
    }

    private void validateThatUpgradePackageContainsMaxOneExplicitReplacement(DocumentObjectProxyInterface documentObjectProxyInterface) throws UnexpectedElementException {
        ExplicitReplacementsProxyInterface explicitReplacementsProxyInterface;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradePackageContainsMaxOneExplicitReplacement(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if ((explicitReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface()).getNumberOfExplicitReplacements() > 1) {
            this.errorMoreElementsThanExpected("validateThatUpgradePackageContainsMaxOneExplicitReplacement(DocumentObjectProxyInterface aDocumentObjectProxy)", RootElementName.UpgradePackage.getValue(), "ExplicitReplacement", "\n\tMax. 1 ExplicitReplacement is allowed if the upgrade package is of type 'delta'.");
        }
    }

    private void validateThatUpgradePackageContainsUpgradeSequenceOrUpdateSequence(DocumentObjectProxyInterface documentObjectProxyInterface) throws MandatoryElementIsMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradePackageContainsUpgradeSequenceOrUpdateSequence(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        UpgradeSequencesProxyInterface upgradeSequencesProxyInterface = documentObjectProxyInterface.getUpgradeSequencesProxyInterface();
        UpdateSequenceProxyInterface updateSequenceProxyInterface = documentObjectProxyInterface.getUpdateSequenceProxyInterface();
        if (!upgradeSequencesProxyInterface.upgradeSequenceExists() && !updateSequenceProxyInterface.updateSequenceExists()) {
            String string = "\n\tAt least one UpgradeSequence element or one UpdateSequence element must be defined in the " + RootElementName.UpgradePackage.getValue() + " element.";
            DocumentObjectValidator.errorElementIsMissing(DocumentObjectValidator.class, "validateThatUpgradePackageContainsUpgradeSequenceOrUpdateSequence(DocumentObjectProxyInterface aDocumentObjectProxy)", RootElementName.UpgradePackage.getValue(), string);
        }
    }

    private void validateThatUpgradePackageDoesNotContainExplicitAddition(DocumentObjectProxyInterface documentObjectProxyInterface) throws UnexpectedElementException {
        ExplicitAdditionsProxyInterface explicitAdditionsProxyInterface;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradePackageDoesNotContainExplicitAddition(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if (!(explicitAdditionsProxyInterface = documentObjectProxyInterface.getExplicitAdditionsProxyInterface()).getExplicitAdditions().isEmpty()) {
            this.errorUnexpectedElement("validateThatUpgradePackageDoesNotContainExplicitAddition(DocumentObjectProxyInterface aDocumentObjectProxy)", RootElementName.UpgradePackage.getValue(), "ExplicitAddition", "\n\tThe element ExplicitAddition is only valid if the upgrade package is of type 'delta'.");
        }
    }

    private void validateThatUpgradePackageDoesNotContainDeltaAddition(DocumentObjectProxyInterface documentObjectProxyInterface) throws UnexpectedElementException {
        DeltaAdditionsProxyInterface deltaAdditionsProxyInterface;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradePackageDoesNotContainDeltaAddition(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        if (!(deltaAdditionsProxyInterface = documentObjectProxyInterface.getDeltaAdditionsProxyInterface()).getDeltaAdditions().isEmpty()) {
            this.errorUnexpectedElement("validateThatUpgradePackageDoesNotContainDeltaAddition(DocumentObjectProxyInterface aDocumentObjectProxy)", RootElementName.UpgradePackage.getValue(), "DeltaAddition", "\n\tThe element DeltaAddition is only valid if the upgrade package is of type 'delta'.");
        }
    }

    private void validateThatUpgradeWindowReferencedFromExplicitReplacementIsPresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradeWindowReferencedFromExplicitReplacementIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        UpgradeWindowProxyInterface upgradeWindowProxyInterface = documentObjectProxyInterface.getUpgradeWindowProxyInterface();
        Vector<TypeOfUpgrade> vector = new Vector<TypeOfUpgrade>();
        vector.add(TypeOfUpgrade.RebootNodeUpgrade);
        vector.add(TypeOfUpgrade.Upgrade);
        vector.add(TypeOfUpgrade.Update);
        Collection collection = upgradeWindowProxyInterface.getCaseValuesOfUpgradeCasesMatchingIndicatedTypes(vector);
        ExplicitReplacementsProxyInterface explicitReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface();
        Iterator iterator = explicitReplacementsProxyInterface.getAllCaseValues().iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (collection.contains(string)) continue;
            String string2 = "\n\tThis reference data does not indicate any existing element of type " + OldUpgradePackageSubElementName.UpgradeCase.getValue() + " in a parent element of type " + UpgradeWindowSubElementName.OldUpgradePackage.getValue() + ".";
            this.errorReferencedElementMissing("validateThatUpgradeWindowReferencedFromExplicitReplacementIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", string, "ExplicitReplacement", UpdateSequenceSubElementName.UpgradeCaseRef.getValue(), UpgradeCaseRefAttributeName.Case.getValue(), "UpgradeWindow", string2);
        }
    }

    private void validateThatUpgradeWindowReferencedFromInstallSequenceIsPresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradeWindowReferencedFromInstallSequenceIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        UpgradeWindowProxyInterface upgradeWindowProxyInterface = documentObjectProxyInterface.getUpgradeWindowProxyInterface();
        Collection collection = upgradeWindowProxyInterface.getCaseValuesOfUpgradeCasesMatchingIndicatedType(TypeOfUpgrade.Install);
        InstallSequencesProxyInterface installSequencesProxyInterface = documentObjectProxyInterface.getInstallSequencesProxyInterface();
        Iterator iterator = installSequencesProxyInterface.getAllCaseValues().iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (collection.contains(string)) continue;
            String string2 = "\n\tThis reference data does not indicate any existing element of type " + OldUpgradePackageSubElementName.PreUpgradeCase.getValue() + " (containing a matching value for attribute " + PreUpgradeCaseAttributeName.Type.getValue() + ") in a parent element of type " + UpgradeWindowSubElementName.OldUpgradePackage.getValue() + ".";
            this.errorReferencedElementMissing("validateThatUpgradeWindowReferencedFromInstallSequenceIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", string, "InstallSequence", InstallSequenceSubElementName.UpgradeCaseRef.getValue(), UpgradeCaseRefAttributeName.Case.getValue(), "UpgradeWindow", string2);
        }
    }

    private void validateThatUpgradeWindowReferencedFromUpdateSequenceIsPresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradeWindowReferencedFromUpdateSequenceIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        UpgradeWindowProxyInterface upgradeWindowProxyInterface = documentObjectProxyInterface.getUpgradeWindowProxyInterface();
        Collection collection = upgradeWindowProxyInterface.getCaseValuesOfUpgradeCasesMatchingIndicatedType(TypeOfUpgrade.Update);
        UpdateSequenceProxyInterface updateSequenceProxyInterface = documentObjectProxyInterface.getUpdateSequenceProxyInterface();
        Iterator iterator = updateSequenceProxyInterface.getAllCaseValues().iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (collection.contains(string)) continue;
            String string2 = "\n\tThis reference data does not indicate any existing element of type " + OldUpgradePackageSubElementName.UpgradeCase.getValue() + " (containing a matching value for attribute " + UpgradeCaseAttributeName.Type.getValue() + ") in a parent element of type " + UpgradeWindowSubElementName.OldUpgradePackage.getValue() + ".";
            this.errorReferencedElementMissing("validateThatUpgradeWindowReferencedFromUpdateSequenceIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", string, "UpdateSequence", UpdateSequenceSubElementName.UpgradeCaseRef.getValue(), UpgradeCaseRefAttributeName.Case.getValue(), "UpgradeWindow", string2);
        }
    }

    private void validateThatUpgradeWindowReferencedFromUpgradeSequenceIsPresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradeWindowReferencedFromUpgradeSequenceIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        UpgradeWindowProxyInterface upgradeWindowProxyInterface = documentObjectProxyInterface.getUpgradeWindowProxyInterface();
        Vector<TypeOfUpgrade> vector = new Vector<TypeOfUpgrade>(2);
        vector.add(TypeOfUpgrade.Upgrade);
        vector.add(TypeOfUpgrade.RebootNodeUpgrade);
        Collection collection = upgradeWindowProxyInterface.getCaseValuesOfUpgradeCasesMatchingIndicatedTypes(vector);
        UpgradeSequencesProxyInterface upgradeSequencesProxyInterface = documentObjectProxyInterface.getUpgradeSequencesProxyInterface();
        Iterator iterator = upgradeSequencesProxyInterface.getAllCaseValues().iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (collection.contains(string)) continue;
            String string2 = "\n\tThis reference data does not indicate any existing element of type " + OldUpgradePackageSubElementName.UpgradeCase.getValue() + " (containing a matching value for attribute " + UpgradeCaseAttributeName.Type.getValue() + ") in a parent element of type " + UpgradeWindowSubElementName.OldUpgradePackage.getValue() + ".";
            this.errorReferencedElementMissing("validateThatUpgradeWindowReferencedFromUpgradeSequenceIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", string, "UpgradeSequence", UpgradeSequenceSubElementName.UpgradeCaseRef.getValue(), UpgradeCaseRefAttributeName.Case.getValue(), "UpgradeWindow", string2);
        }
    }

    private void validateThatUpgradeWindowReferencedFromVerifySequenceIsPresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws ReferencedElementMissingException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validateThatUpgradeWindowReferencedFromVerifySequenceIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", (String)("aDocumentObjectProxy: " + documentObjectProxyInterface));
        }
        UpgradeWindowProxyInterface upgradeWindowProxyInterface = documentObjectProxyInterface.getUpgradeWindowProxyInterface();
        Collection collection = upgradeWindowProxyInterface.getCaseValuesOfUpgradeCasesMatchingIndicatedType(TypeOfUpgrade.Verify);
        VerifySequencesProxyInterface verifySequencesProxyInterface = documentObjectProxyInterface.getVerifySequencesProxyInterface();
        Iterator iterator = verifySequencesProxyInterface.getAllCaseValues().iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (collection.contains(string)) continue;
            String string2 = "\n\tThis reference data does not indicate any existing element of type " + OldUpgradePackageSubElementName.PreUpgradeCase.getValue() + " (containing a matching value for attribute " + PreUpgradeCaseAttributeName.Type.getValue() + ") in a parent element of type " + UpgradeWindowSubElementName.OldUpgradePackage.getValue() + ".";
            this.errorReferencedElementMissing("validateThatUpgradeWindowReferencedFromVerifySequenceIsPresent(DocumentObjectProxyInterface aDocumentObjectProxy)", string, "VerifySequence", VerifySequenceSubElementName.UpgradeCaseRef.getValue(), UpgradeCaseRefAttributeName.Case.getValue(), "UpgradeWindow", string2);
        }
    }
}

