/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.install.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.upgradepackage.install.UP_AndLM_Information;
import se.ericsson.cello.upgradepackage.install.UP_LoadModulesRelationInformation;
import se.ericsson.cello.upgradepackage.install.event.UP_InstallRequestEvent;
import se.ericsson.cello.upgradepackage.install.util.LoadModulesToBeInstalledAnalyserException;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.enumer.LoadModuleState;
import se.ericsson.cello.upgradepackage.util.hwsensitive.HW_SensitiveAdapter;
import se.ericsson.cello.upgradepackage.util.hwsensitive.HW_SensitiveAdapterException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class LoadModulesToBeInstalledAnalyser {
    public LoadModulesToBeInstalledAnalyser() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "LoadModulesToBeInstalledAnalyser( )");
        }
    }

    public Collection getLoadModulesToBeInstalled(UP_AndLM_Information uP_AndLM_Information, UP_InstallRequestEvent uP_InstallRequestEvent, boolean bl, Collection collection, boolean bl2) throws HW_SensitiveAdapterException, LoadModulesToBeInstalledAnalyserException {
        String string = "getLoadModulesToBeInstalled(UP_AndLM_Information anUP_AndLM_Information, UP_InstallRequestEvent anUP_InstallRequestEvent, boolean anIsForcedInstall, Collection aFaultyLoadModuleIdentifiers, boolean anIsOnlyVerification)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "anUP_AndLM_Information: " + uP_AndLM_Information + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\tanIsForcedInstall: " + bl + "\n\taFaultyLoadModuleIdentifiers: " + collection + "\n\tanIsOnlyVerification: " + bl2);
        }
        Collection collection2 = new Vector();
        try {
            UP_LoadModulesRelationInformation uP_LoadModulesRelationInformation = uP_AndLM_Information.transformedUP;
            String string2 = "will";
            if (bl2) {
                string2 = "needs to";
            }
            String string3 = "HW Sensitive";
            if (bl) {
                if (uP_InstallRequestEvent.getRequestedTypeOfUP().isHW_Sensitive()) {
                    if (uP_InstallRequestEvent.getHSI_Variant().isNSI()) {
                        string3 = "Node Type Specific";
                    }
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, string, "All load modules in the transformed UCF that are required, from a " + string3 + " point of view, " + string2 + " be installed (forced install)." + "\n\tUP Type: " + uP_InstallRequestEvent.getRequestedTypeOfUP().getDescription());
                    }
                    HW_SensitiveAdapter hW_SensitiveAdapter = new HW_SensitiveAdapter();
                    collection2 = hW_SensitiveAdapter.getRequiredLoadModules(uP_LoadModulesRelationInformation.ucfPath, uP_LoadModulesRelationInformation.productDataOfUP.getNumber(), uP_LoadModulesRelationInformation.productDataOfUP.getRevision(), false);
                } else {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, string, "All load modules in the transformed UCF " + string2 + " be installed (forced install)." + "\n\tUP Type: " + uP_InstallRequestEvent.getRequestedTypeOfUP().getDescription());
                    }
                    collection2 = (Collection)uP_LoadModulesRelationInformation.productNumberAndRevisionForLoadModules.clone();
                }
            } else if (uP_InstallRequestEvent.getRequestedTypeOfUP().isHW_Sensitive()) {
                if (uP_InstallRequestEvent.getHSI_Variant().isNSI()) {
                    string3 = "Node Type Specific";
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "Only load modules in the transformed/complete UCF that are required and missing on the node, from a " + string3 + " point of view, " + string2 + " be installed (soft install)." + "\n\tUP Type: " + uP_InstallRequestEvent.getRequestedTypeOfUP().getDescription());
                }
                HW_SensitiveAdapter hW_SensitiveAdapter = new HW_SensitiveAdapter();
                collection2 = hW_SensitiveAdapter.getRequiredLoadModules(uP_LoadModulesRelationInformation.ucfPath, uP_LoadModulesRelationInformation.productDataOfUP.getNumber(), uP_LoadModulesRelationInformation.productDataOfUP.getRevision(), false);
                collection2 = this.determineTheLoadModulesToBeInstalled(new Vector(collection2), collection, uP_AndLM_Information);
            } else {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "Only load modules that are missing on the node, in the transformed/complete UCF, " + string2 + " be installed (soft install)." + "\n\tUP Type: " + uP_InstallRequestEvent.getRequestedTypeOfUP().getDescription());
                }
                collection2 = this.determineTheLoadModulesToBeInstalled(uP_LoadModulesRelationInformation.productNumberAndRevisionForLoadModules, collection, uP_AndLM_Information);
            }
            return collection2;
        }
        catch (LoadModulesToBeInstalledAnalyserException loadModulesToBeInstalledAnalyserException) {
            throw loadModulesToBeInstalledAnalyserException;
        }
        catch (HW_SensitiveAdapterException hW_SensitiveAdapterException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string, "The search for load modules that needs to be installed has failed due to an HW_SensitiveAdapterException was caught.\n\tHW_SensitiveAdapterException: " + (Object)((Object)hW_SensitiveAdapterException));
            }
            throw hW_SensitiveAdapterException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "The search for load modules that needs to be installed has failed due to a Throwable was caught.\n\tanUP_AndLM_Information: " + uP_AndLM_Information + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\tanIsForcedInstall: " + bl + "\n\taFaultyLoadModuleIdentifiers: " + collection + "\n\tanIsOnlyVerification: " + bl2 + "\n\tThrowable message: " + throwable, throwable);
            throw new LoadModulesToBeInstalledAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + string + "\n\tThrowable caught." + "\n\tOrigin Throwable data: " + throwable);
        }
    }

    public Collection getLoadModulesToBeInstalledForDeltaUP(UP_AndLM_Information uP_AndLM_Information, UP_InstallRequestEvent uP_InstallRequestEvent, boolean bl, Collection collection, boolean bl2) throws HW_SensitiveAdapterException, LoadModulesToBeInstalledAnalyserException {
        String string = "getLoadModulesToBeInstalledForDeltaUP(UP_AndLM_Information anUP_AndLM_Information, UP_InstallRequestEvent anUP_InstallRequestEvent, boolean anIsForcedInstall, Collection aFaultyLoadModuleIdentifiers, boolean anIsOnlyVerification)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "anUP_AndLM_Information: " + uP_AndLM_Information + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\tanIsForcedInstall: " + bl + "\n\taFaultyLoadModuleIdentifiers: " + collection + "\n\tanIsOnlyVerification: " + bl2);
        }
        Collection collection2 = new Vector();
        try {
            String string2 = "will";
            if (bl2) {
                string2 = "needs to";
            }
            String string3 = "HW Sensitive";
            if (bl) {
                if (uP_InstallRequestEvent.getRequestedTypeOfUP().isHW_Sensitive()) {
                    if (uP_InstallRequestEvent.getHSI_Variant().isNSI()) {
                        string3 = "Node Type Specific";
                    }
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, string, "All load modules needed from a " + string3 + " point of view, in the transformed/complete UCF (origin delta UCF), " + string2 + " be installed (forced install)." + "\n\tUP Type: " + uP_InstallRequestEvent.getRequestedTypeOfUP().getDescription());
                    }
                    HW_SensitiveAdapter hW_SensitiveAdapter = new HW_SensitiveAdapter();
                    collection2 = hW_SensitiveAdapter.getRequiredLoadModules(uP_AndLM_Information.transformedUP.ucfPath, uP_AndLM_Information.transformedUP.productDataOfUP.getNumber(), uP_AndLM_Information.transformedUP.productDataOfUP.getRevision(), true);
                } else {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, string, "All load modules in the transformed/complete UCF (origin delta UCF), " + string2 + " be installed (forced install)." + "\n\tUP Type: " + uP_InstallRequestEvent.getRequestedTypeOfUP().getDescription());
                    }
                    collection2 = uP_AndLM_Information.transformedUP.productNumberAndRevisionForLoadModules;
                }
            } else if (uP_InstallRequestEvent.getRequestedTypeOfUP().isHW_Sensitive()) {
                if (uP_InstallRequestEvent.getHSI_Variant().isNSI()) {
                    string3 = "Node Type Specific";
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "Only load modules in the transformed/complete UCF (origin delta UCF) that are required and missing on the node, from a " + string3 + " point of view, " + string2 + " be installed (soft install)" + "\n\tUP Type: " + uP_InstallRequestEvent.getRequestedTypeOfUP().getDescription());
                }
                HW_SensitiveAdapter hW_SensitiveAdapter = new HW_SensitiveAdapter();
                collection2 = hW_SensitiveAdapter.getRequiredLoadModules(uP_AndLM_Information.transformedUP.ucfPath, uP_AndLM_Information.transformedUP.productDataOfUP.getNumber(), uP_AndLM_Information.transformedUP.productDataOfUP.getRevision(), true);
                collection2 = this.determineTheLoadModulesToBeInstalled(new Vector(collection2), collection, uP_AndLM_Information);
            } else {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "Only load modules that are missing on the node, in the transformed/complete UCF (origin delta UCF), " + string2 + " be installed (soft install)." + "\n\tUP Type: " + uP_InstallRequestEvent.getRequestedTypeOfUP().getDescription());
                }
                collection2 = this.determineTheLoadModulesToBeInstalled(uP_AndLM_Information.transformedUP.productNumberAndRevisionForLoadModules, collection, uP_AndLM_Information);
            }
            return collection2;
        }
        catch (LoadModulesToBeInstalledAnalyserException loadModulesToBeInstalledAnalyserException) {
            throw loadModulesToBeInstalledAnalyserException;
        }
        catch (HW_SensitiveAdapterException hW_SensitiveAdapterException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string, "The search for load modules that needs to be installed has failed due to an HW_SensitiveAdapterException was caught.\n\tHW_SensitiveAdapterException: " + (Object)((Object)hW_SensitiveAdapterException));
            }
            throw hW_SensitiveAdapterException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "The search for load modules that needs to be installed has failed due to a Throwable was caught.\n\tanUP_AndLM_Information: " + uP_AndLM_Information + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\tanIsForcedInstall: " + bl + "\n\taFaultyLoadModuleIdentifiers: " + collection + "\n\tanIsOnlyVerification: " + bl2 + "\n\tThrowable message: " + throwable, throwable);
            throw new LoadModulesToBeInstalledAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + string + "\n\tThrowable caught." + "\n\tOrigin Throwable data: " + throwable);
        }
    }

    private Collection determineTheLoadModulesToBeInstalled(Vector vector, Collection collection, UP_AndLM_Information uP_AndLM_Information) throws LoadModulesToBeInstalledAnalyserException {
        String string = "determineTheLoadModulesToBeInstalled(Vector aCompleteListOfNeededLoadModules, Collection aFaultyLoadModuleIdentifiers, UP_AndLM_Information anAllUP_AndLM_Information)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aCompleteListOfNeededLoadModules: " + vector + "\n\taFaultyLoadModuleIdentifiers: " + collection + "\n\tanAllUP_AndLM_Information: " + uP_AndLM_Information);
        }
        try {
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            Vector vector2 = loadModuleMO_HandlerInterface.extractIdentifiersOfNonExistingLoadModules(vector);
            Collection collection2 = loadModuleMO_HandlerInterface.extractIdentifiersOfLoadModulesWithState(vector, LoadModuleState.NotInstalled);
            vector2.addAll(collection2);
            Collection collection3 = this.getLMsWhereFileStateShouldBeNotInstalled(vector, uP_AndLM_Information, loadModuleMO_HandlerInterface);
            vector2.addAll(collection3);
            Collection collection4 = this.selectLMsWithNotMatchingFilePathToBeInstalled(vector, collection, uP_AndLM_Information, vector2);
            vector2.addAll(collection4);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theLoadModulesToBeInstalled: " + vector2);
            }
            return vector2;
        }
        catch (LoadModulesToBeInstalledAnalyserException loadModulesToBeInstalledAnalyserException) {
            throw loadModulesToBeInstalledAnalyserException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\taCompleteListOfNeededLoadModules: " + vector + "\n\taFaultyLoadModuleIdentifiers: " + collection + "\n\tanAllUP_AndLM_Information: " + uP_AndLM_Information, throwable);
            throw new LoadModulesToBeInstalledAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + string + "\n\tThrowable caught." + "\n\tOrigin Throwable: " + throwable);
        }
    }

    private Collection getLMsWhereFileStateShouldBeNotInstalled(Collection collection, UP_AndLM_Information uP_AndLM_Information, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface) throws LoadModulesToBeInstalledAnalyserException {
        String string = "getLMsWhereFileStateShouldBeNotInstalled(Collection aCompleteListOfNeededLoadModules, UP_AndLM_Information anAllUP_AndLM_Information, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aCompleteListOfNeededLoadModules: " + collection + "\n\tanAllUP_AndLM_Information: " + uP_AndLM_Information + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface);
        }
        try {
            HashSet<ProductNumberAndRevision> hashSet = new HashSet<ProductNumberAndRevision>();
            Collection collection2 = loadModuleMO_HandlerInterface.extractIdentifiersOfLoadModulesWithState(collection, LoadModuleState.Installed);
            LoadModulesProxyInterface loadModulesProxyInterface = null;
            UP_LoadModulesRelationInformation uP_LoadModulesRelationInformation = uP_AndLM_Information.transformedUP;
            DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(uP_LoadModulesRelationInformation.productDataOfUP.getNumber(), uP_LoadModulesRelationInformation.productDataOfUP.getRevision(), uP_LoadModulesRelationInformation.ucfPath.getAbsolutePath(), "LoadModule");
            loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
            Iterator iterator = collection2.iterator();
            ProductNumberAndRevision productNumberAndRevision = null;
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            while (iterator.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                loadModuleMoSU_Access = loadModuleMO_HandlerInterface.getLoadModule(productNumberAndRevision);
                if (loadModuleMoSU_Access.isFileStateCorrect(LoadModuleState.Installed.getValue(), null)) {
                    if (!this.isLM_UnsignedInMO_ButSignedInUCF(loadModuleMoSU_Access, loadModuleMO_HandlerInterface, loadModulesProxyInterface.getLoadModuleProxyInterface(productNumberAndRevision))) continue;
                    hashSet.add(productNumberAndRevision);
                    continue;
                }
                hashSet.add(productNumberAndRevision);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theLMsWhereFileStateShouldBeNotInstalled: " + hashSet);
            }
            return hashSet;
        }
        catch (LoadModulesToBeInstalledAnalyserException loadModulesToBeInstalledAnalyserException) {
            throw loadModulesToBeInstalledAnalyserException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\taCompleteListOfNeededLoadModules: " + collection + "\n\tanAllUP_AndLM_Information: " + uP_AndLM_Information + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface, throwable);
            throw new LoadModulesToBeInstalledAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + string + "\n\tThrowable caught." + "\n\tOrigin Throwable: " + throwable);
        }
    }

    private boolean isLM_UnsignedInMO_ButSignedInUCF(LoadModuleMoSU_Access loadModuleMoSU_Access, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface, LoadModuleProxyInterface loadModuleProxyInterface) throws LoadModulesToBeInstalledAnalyserException {
        String string = "isLM_UnsignedInMO_ButSignedInUCF(LoadModuleMoSU_Access anLM_MO, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, LoadModuleProxyInterface aLoadModuleProxyInterface)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "anLM_MO: " + loadModuleMoSU_Access + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface);
        }
        try {
            boolean bl = false;
            boolean bl2 = false;
            if (loadModuleMO_HandlerInterface.isSU_VersionSupported("SU_3", loadModuleMoSU_Access)) {
                bl = loadModuleMoSU_Access.getIsSignedSw(null);
            }
            if (!bl && loadModuleProxyInterface.isSigned()) {
                bl2 = true;
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theIsLM_UnsignedInMO_ButSignedInUCF: " + bl2);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught,\n\tanLM_MO: " + loadModuleMoSU_Access + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface, throwable);
            throw new LoadModulesToBeInstalledAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + string + "\n\tThrowable caught," + "\n\tOrigin Throwable: " + throwable);
        }
    }

    private Collection selectLMsWithNotMatchingFilePathToBeInstalled(Vector vector, Collection collection, UP_AndLM_Information uP_AndLM_Information, Vector vector2) throws LoadModulesToBeInstalledAnalyserException {
        String string = "selectLMsWithNotMatchingFilePathToBeInstalled(Vector aCompleteListOfNeededLoadModules, Collection aFaultyLoadModuleIdentifiers, UP_AndLM_Information anAllUP_AndLM_Information, Vector aLoadModulesToBeInstalled)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aCompleteListOfNeededLoadModules: " + vector + "\n\taFaultyLoadModuleIdentifiers: " + collection + "\n\tanAllUP_AndLM_Information: " + uP_AndLM_Information + "\n\taLoadModulesToBeInstalled: " + vector2);
        }
        if (collection.isEmpty()) {
            return collection;
        }
        try {
            Iterator iterator = collection.iterator();
            ProductNumberAndRevision productNumberAndRevision = null;
            ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions(vector);
            ProductNumbersAndRevisions productNumbersAndRevisions2 = new ProductNumbersAndRevisions(vector2);
            LinkedList<ProductNumberAndRevision> linkedList = new LinkedList<ProductNumberAndRevision>();
            ProductNumbersAndRevisions productNumbersAndRevisions3 = new ProductNumbersAndRevisions(uP_AndLM_Information.transformedUP.productNumberAndRevisionForLoadModules);
            while (iterator.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                if (productNumbersAndRevisions3.contains(productNumberAndRevision)) {
                    if (!productNumbersAndRevisions.contains(productNumberAndRevision) || productNumbersAndRevisions2.contains(productNumberAndRevision)) continue;
                    linkedList.add(productNumberAndRevision);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, string, "The LM with not matching file path is excluded from install due to it is not found in the transformed UCF.\n\ttheLM_WithNotMatchingFilePath: " + productNumberAndRevision + "\n\ttheAllUP_AndLM_ProductNumbersAndRevisions: " + productNumbersAndRevisions3);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theSelectedLMs: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\taFaultyLoadModuleIdentifiers: " + collection + "\n\taCompleteListOfNeededLoadModules: " + vector + "\n\taLoadModulesToBeInstalled: " + vector2, throwable);
            throw new LoadModulesToBeInstalledAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + string + "\n\tThrowable caught." + "\n\tOrigin Throwable: " + throwable);
        }
    }
}

