/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.install.verify;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.parser.UpgradeControlFileParserFactory;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.loadmodule.InstallSMInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.InstallLM_Container;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.upgradepackage.install.event.UP_InstallRequestEvent;
import se.ericsson.cello.upgradepackage.install.verify.DiskspaceInformation;
import se.ericsson.cello.upgradepackage.install.verify.InstallVerifyException;
import se.ericsson.cello.upgradepackage.install.verify.SignedLM_ExtensionMissmatch;
import se.ericsson.cello.upgradepackage.install.verify.SignedLM_SW_Information;
import se.ericsson.cello.upgradepackage.install.verify.SignedSW_MissmatchInformation;
import se.ericsson.cello.upgradepackage.install.verify.event.ConfigurationMissmatchForLM;
import se.ericsson.cello.upgradepackage.install.verify.event.VerifyConfirmedEvent;
import se.ericsson.cello.upgradepackage.install.verify.event.VerifyRejectedEvent;
import se.ericsson.cello.upgradepackage.install.verify.event.VerifyResponseEvent;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelementdata.ManagedElementDataMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class InstallVerifier {
    private static final String EMPTY_STRING = "";

    public InstallVerifier() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "InstallVerifier()");
        }
    }

    public VerifyResponseEvent verify(UP_InstallRequestEvent uP_InstallRequestEvent) throws InstallVerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verify ( UP_InstallRequestEvent anInstallRequestEvent )", "anInstallRequestEvent: " + uP_InstallRequestEvent);
        }
        try {
            DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(uP_InstallRequestEvent.upgradePackageDocumentNumber, uP_InstallRequestEvent.upgradePackageDocumentRevision, uP_InstallRequestEvent.upgradePackageUCF_Path + "Original", "LoadModule");
            Collection collection = this.verifyLMsDestinationFilePath(documentObjectProxyInterface);
            DiskspaceInformation diskspaceInformation = this.checkDiskspace(uP_InstallRequestEvent);
            if (collection.isEmpty() && diskspaceInformation.isDiskspaceAvailable) {
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "verify ( UP_InstallRequestEvent anInstallRequestEvent )", "RETURNS - VerifyConfirmedEvent");
                }
                VerifyConfirmedEvent verifyConfirmedEvent = new VerifyConfirmedEvent(this);
                return verifyConfirmedEvent;
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "verify ( UP_InstallRequestEvent anInstallRequestEvent )", "RETURNS - VerifyRejectedEvent");
            }
            VerifyRejectedEvent verifyRejectedEvent = new VerifyRejectedEvent(this, collection, diskspaceInformation);
            return verifyRejectedEvent;
        }
        catch (InstallVerifyException installVerifyException) {
            throw installVerifyException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verify ( InstallRequestEvent anInstallRequestEvent )", "anInstallRequestEvent: " + uP_InstallRequestEvent + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
            throw new InstallVerifyException("Class name: " + this.getClass() + "\n\tverify ( InstallRequestEvent anInstallRequestEvent )" + "anInstallRequestEvent: " + uP_InstallRequestEvent + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
        finally {
            UpgradeControlFileParserFactory.instance().removeDocumentObjectForUpgradePackage(uP_InstallRequestEvent.upgradePackageDocumentNumber, uP_InstallRequestEvent.upgradePackageDocumentRevision);
        }
    }

    public SignedSW_MissmatchInformation verifySignedLMsInUCF_VersusConfiguredLM_MOs(DocumentObjectProxyInterface documentObjectProxyInterface, UpgradePackageMoExtended upgradePackageMoExtended) throws InstallVerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifySignedLMsInUCF_VersusConfiguredLM_MOs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_Mo)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\tanUP_Mo: " + upgradePackageMoExtended);
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface;
            ProductNumberAndRevision productNumberAndRevision = null;
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
            ProductNumbersAndRevisions productNumbersAndRevisions = loadModulesProxyInterface.getProductNumberAndRevisionOfLoadModules();
            Iterator iterator = productNumbersAndRevisions.getElements().iterator();
            LoadModuleProxyInterface loadModuleProxyInterface = null;
            SignedSW_MissmatchInformation signedSW_MissmatchInformation = new SignedSW_MissmatchInformation();
            Collection collection = loadModuleMO_HandlerInterface.getAllLoadModuleMOs();
            if (!loadModuleMO_HandlerInterface.isSU_VersionSupported("SU_3", collection)) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "verifySignedLMsInUCF_VersusConfiguredLM_MOs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_Mo)", "The LM SU Access version 3 not supported i.e. not valid to validate the signed sw information consistency in any configured LM Mo compared to the definitions in the UCF.");
                }
                return signedSW_MissmatchInformation;
            }
            if (loadModuleMO_HandlerInterface.isUpgradeEnabler(collection)) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "verifySignedLMsInUCF_VersusConfiguredLM_MOs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_Mo)", "The LM SU Access version 3 is supported but since it is an upgrade enabler version of the LM MOs no consistency check shall take place");
                }
                return signedSW_MissmatchInformation;
            }
            Collection collection2 = null;
            InstallSMInterface installSMInterface = null;
            while (iterator.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                configurationVersionMO_HandlerInterface = loadModuleMO_HandlerInterface.getLoadModule(productNumberAndRevision);
                loadModuleProxyInterface = loadModulesProxyInterface.getLoadModuleProxyInterface(productNumberAndRevision);
                if (configurationVersionMO_HandlerInterface == null) continue;
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "verifySignedLMsInUCF_VersusConfiguredLM_MOs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_Mo)", "The LM prod no and rev: " + productNumberAndRevision + "theLM_MO.getIsSignedSW(null): " + configurationVersionMO_HandlerInterface.getIsSignedSw(null) + "\n\ttheLoadModuleProxyInterface: " + loadModuleProxyInterface);
                }
                if (configurationVersionMO_HandlerInterface.getIsSignedSw(null) != loadModuleProxyInterface.isSigned()) {
                    signedSW_MissmatchInformation.add(new SignedLM_SW_Information(productNumberAndRevision, configurationVersionMO_HandlerInterface.getIsSignedSw(null), loadModuleProxyInterface.isSigned()));
                }
                if ((collection2 = loadModuleProxyInterface.getInstallSMs()).isEmpty()) continue;
                installSMInterface = (InstallSMInterface)collection2.iterator().next();
                if (configurationVersionMO_HandlerInterface.getSignatureFileNameExtension(null).equals(EMPTY_STRING) || configurationVersionMO_HandlerInterface.getSignatureFileNameExtension(null).equals(installSMInterface.getExtension())) continue;
                signedSW_MissmatchInformation.add(new SignedLM_ExtensionMissmatch(productNumberAndRevision, configurationVersionMO_HandlerInterface.getSignatureFileNameExtension(null), installSMInterface.getExtension()));
            }
            if (!signedSW_MissmatchInformation.getSignedSW_Missmatch().isEmpty()) {
                configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
                UpgradePackageMoExtended upgradePackageMoExtended2 = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null);
                if (upgradePackageMoExtended2 != upgradePackageMoExtended) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "verifySignedLMsInUCF_VersusConfiguredLM_MOs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_Mo)", "Configuration missmatch regarding signed software between LoadModule MOs and specification in UCF, aborting installation...\n\ttheSignedSW_Missmatch: " + signedSW_MissmatchInformation.getSignedSW_Missmatch());
                    }
                    return signedSW_MissmatchInformation;
                }
                signedSW_MissmatchInformation.clearSignedSW_Missmatch();
            }
            if (!signedSW_MissmatchInformation.getSignedSW_ExtensionMissmatch().isEmpty()) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "verifySignedLMsInUCF_VersusConfiguredLM_MOs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_Mo)", "Configuration missmatch regarding signed software between LoadModule MOs and specification in UCF i.e. the extension for signed module(s) have changed, aborting installation...\n\ttheSignedSW_ExtensionMissmatch: " + signedSW_MissmatchInformation.getSignedSW_ExtensionMissmatch());
                }
                return signedSW_MissmatchInformation;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "verifySignedLMsInUCF_VersusConfiguredLM_MOs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_Mo)", "RETURNS - theSignIgnedSW_MissmatchInformation: " + signedSW_MissmatchInformation);
            }
            return signedSW_MissmatchInformation;
        }
        catch (InstallVerifyException installVerifyException) {
            throw installVerifyException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifySignedLMsInUCF_VersusConfiguredLM_MOs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_Mo)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\tanUP_Mo: " + upgradePackageMoExtended, throwable);
            throw new InstallVerifyException(throwable.toString());
        }
    }

    public DiskspaceInformation checkDiskspace(UP_InstallRequestEvent uP_InstallRequestEvent) throws InstallVerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkDiskspace (UP_InstallRequestEvent anInstallRequestEvent)", "anInstallRequestEvent: " + uP_InstallRequestEvent);
        }
        try {
            ManagedElementDataMO_HandlerInterface managedElementDataMO_HandlerInterface = ServiceFinder.getManagedElementDataMO_HandlerInterface();
            long l = managedElementDataMO_HandlerInterface.getHdVolumeCFreespace(null);
            File file = null;
            long l2 = 0L;
            File file2 = null;
            long l3 = 0L;
            long l4 = 0L;
            file = new File(uP_InstallRequestEvent.upgradePackageOriginalUCF_Path);
            l2 = file.length();
            if (l2 != 0L) {
                l2 = l2 / 1024L / 1024L;
            }
            if (uP_InstallRequestEvent.getRequestedTypeOfUP().isDelta() && (l3 = (file2 = new File(uP_InstallRequestEvent.baseUP_UCF_Path)).length()) != 0L) {
                l3 = l3 / 1024L / 1024L;
            }
            if (!uP_InstallRequestEvent.getRequestedTypeOfUP().isSelective()) {
                l4 = 0L;
            }
            long l5 = l2 + l3 + l4;
            DiskspaceInformation diskspaceInformation = null;
            if (l == -1L) {
                return new DiskspaceInformation(true, l, l2, l3, l4, uP_InstallRequestEvent.getRequestedTypeOfUP());
            }
            diskspaceInformation = l < l5 ? new DiskspaceInformation(false, l, l2, l3, l4, uP_InstallRequestEvent.getRequestedTypeOfUP()) : new DiskspaceInformation(true, l, l2, l3, l4, uP_InstallRequestEvent.getRequestedTypeOfUP());
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "checkDiskspace (UP_InstallRequestEvent anInstallRequestEvent)", "RETURNS: " + diskspaceInformation);
            }
            return diskspaceInformation;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "checkDiskspace (UP_InstallRequestEvent anInstallRequestEvent)", "anInstallRequestEvent: " + uP_InstallRequestEvent + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
            throw new InstallVerifyException("Class name: " + this.getClass() + "\n\tcheckDiskspace (UP_InstallRequestEvent anInstallRequestEvent)" + "\n\tanInstallRequestEvent: " + uP_InstallRequestEvent + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private Collection verifyLMsDestinationFilePath(DocumentObjectProxyInterface documentObjectProxyInterface) throws InstallVerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyLMsDestinationFilePath ( DocumentObjectProxyInterface aDocumentObjectProxyInterface )", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface);
        }
        ProductNumberAndRevision productNumberAndRevision = null;
        try {
            LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
            ProductNumbersAndRevisions productNumbersAndRevisions = loadModulesProxyInterface.getProductNumberAndRevisionOfLoadModules();
            Iterator iterator = productNumbersAndRevisions.getElements().iterator();
            Collection collection = new HashSet();
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            Map map = this.buildSetOfLM_MOsMap();
            while (iterator.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                collection = this.verifyLM_DestinationFilePath(collection, productNumberAndRevision, loadModulesProxyInterface.getLoadModuleProxyInterface(productNumberAndRevision), documentObjectProxyInterface, loadModuleMO_HandlerInterface, map);
            }
            return collection;
        }
        catch (InstallVerifyException installVerifyException) {
            throw installVerifyException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyLMsDestinationFilePath ( DocumentObjectUpgradePackage aDocumentObjectUpgradePackage ", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\ttheProductNumberAndRevisionForLM: " + productNumberAndRevision + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
            throw new InstallVerifyException("Class name: " + this.getClass() + "\n\tverifyLMsDestinationFilePath ( DocumentObjectUpgradePackage aDocumentObjectUpgradePackage " + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\ttheProductNumberAndRevisionForLM: " + productNumberAndRevision + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private Collection verifyLM_DestinationFilePath(Collection collection, ProductNumberAndRevision productNumberAndRevision, LoadModuleProxyInterface loadModuleProxyInterface, DocumentObjectProxyInterface documentObjectProxyInterface, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface, Map map) throws InstallVerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyLM_DestinationFilePath ( Collection aConfigurationMissmatchForLMs, ProductNumberAndRevision aProductNumberAndRevision, LoadModuleProxyInterface aLoadModuleProxyInterface, DocumentObjectProxyInterface aDocumentObjectProxyInterface, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface)", "aConfigurationMissmatchForLMs: " + collection + "\n\taProductNumberAndRevisionForLM: " + productNumberAndRevision + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taLM_MOsMap: " + map);
        }
        try {
            String string;
            InstallLM_Container installLM_Container = (InstallLM_Container)loadModuleProxyInterface.getInstallDatas().firstElement();
            String string2 = documentObjectProxyInterface.selectLoadModuleDestinationAbsolutePath(installLM_Container.getDestFilePathName(), loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw());
            LoadModuleMoSU_Access loadModuleMoSU_Access = (LoadModuleMoSU_Access)map.get(loadModuleProxyInterface.getProductNumber() + "_" + loadModuleProxyInterface.getProductRevision());
            if (loadModuleMoSU_Access != null && !string2.equals(string = loadModuleMoSU_Access.getRealLoadModuleFilePath(null))) {
                collection.add(new ConfigurationMissmatchForLM(productNumberAndRevision, string, string2));
            }
            return collection;
        }
        catch (InstallVerifyException installVerifyException) {
            throw installVerifyException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyLM_DestinationFilePath ( Collection aConfigurationMissmatchForLMs, ProductNumberAndRevision aProductNumberAndRevisionForLM, LoadModuleProxyInterface aLoadModuleProxyInterface, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface ) ", "aConfigurationMissmatchForLMs: " + collection + "\n\taProductNumberAndRevisionForLM: " + productNumberAndRevision + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
            throw new InstallVerifyException("Class name: " + this.getClass() + "\n\tverifyLM_DestinationFilePath ( Collection aConfigurationMissmatchForLMs, ProductNumberAndRevision aProductNumberAndRevisionForLM, LoadModuleProxyInterface aLoadModuleProxyInterface )" + "\n\taConfigurationMissmatchForLMs: " + collection + "\n\taProductNumberAndRevisionForLM: " + productNumberAndRevision + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private Map buildSetOfLM_MOsMap() throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "buildSetOfLM_MOsMap()");
        }
        try {
            HashMap<String, LoadModuleMoSU_Access> hashMap = new HashMap<String, LoadModuleMoSU_Access>();
            MoIterator moIterator = MoRepository.instance().lookupType("LoadModule");
            if (moIterator == null) {
                return hashMap;
            }
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            String string = null;
            while (moIterator.hasMoreElements()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                string = ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5") ? loadModuleMoSU_Access.getProductNumberOpt(null) + "_" + loadModuleMoSU_Access.getProductRevisionOpt(null) : StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)) + "_" + StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null));
                if (hashMap.get(string) == null) {
                    hashMap.put(string, loadModuleMoSU_Access);
                    continue;
                }
                Trace.error(this.getClass(), "buildSetOfLM_MOsMap()", "More than one LM MO has been configured with the same product number and revision. This may result in an inconsistent configuration of the node\n\ttheProdNoRevKey: " + string + "\n\tWill use the LM MO instance: " + hashMap.get(string) + "\n\tIgnoring the LM MO instance: " + loadModuleMoSU_Access);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "buildSetOfLM_MOsMap()", "Throwable caught", throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }
}

