/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.main;

import java.io.File;
import se.ericsson.cello.commandlog.logcontentcontrol.InspectorMgr;
import se.ericsson.cello.commandlog.logcontentcontrol.LogContentInspector;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.UpgradePackageMoImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.enumer.ActivatedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class UpgradePackageMoFactory
implements MoFactory,
LogContentInspector {
    private static UpgradePackageMoFactory instance = null;

    public static synchronized UpgradePackageMoFactory instance() {
        if (Trace.valid(UpgradePackageMoFactory.class, 20)) {
            Trace.debug(UpgradePackageMoFactory.class, 20, "instance()");
        }
        if (instance == null) {
            instance = new UpgradePackageMoFactory();
        }
        return instance;
    }

    public ManagedObject createMo(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createMo( ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context )", "parent: " + managedObject + "\n\tattributes: " + attrList + "\n\tidentity: " + string + "\n\tsource: " + managedObject2 + "\n\tcontext: " + coordinator);
        }
        return UpgradePackageMoImpl.create(managedObject, attrList, string, managedObject2, coordinator);
    }

    public ManagedObject recoverMo(MoData moData) throws MoNameAlreadyTakenException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "recoverMo( MoData moData )", "moData: " + moData);
        }
        StringAttribute stringAttribute = (StringAttribute)moData.getAttribute("upgradeControlFilePath");
        String string = stringAttribute.getValue(null);
        String string2 = string + "Original";
        File file = new File(string);
        File file2 = new File(string2);
        if (file.exists() && file2.exists()) {
            return new UpgradePackageMoImpl(moData);
        }
        return this.recoverMoWhenUCF_IsMissing(file2, file, moData);
    }

    public String getMoTypeName() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getMoTypeName()");
        }
        return "UpgradePackage";
    }

    public void registerFactory() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "registerFactory()");
        }
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
    }

    public Object[] hideHazardousAttributeValues(AttrList attrList) {
        if (attrList.indexOf("password") != -1) {
            Object[] objectArray = new Object[attrList.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    if (attrList.getName(i).equalsIgnoreCase("password")) {
                        objectArray[i] = "*****";
                        continue;
                    }
                    objectArray[i] = attrList.getValue(i);
                    continue;
                }
                catch (NotHandledAttributeTypeException notHandledAttributeTypeException) {
                    objectArray[i] = "Unknown type";
                    continue;
                }
                catch (MoNotFoundException moNotFoundException) {
                    objectArray[i] = null;
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    MessageLog.info(this.getClass(), (String)("In hideHazardousAttributeValues, not able to hide hazardous parameters due to " + runtimeException));
                    return null;
                }
            }
            return objectArray;
        }
        return null;
    }

    public Object[] hideHazardousActionParameters(String string, Object[] objectArray) {
        try {
            if (!string.equalsIgnoreCase("updateFTPServerData")) {
                return null;
            }
            int n = 3;
            try {
                objectArray[n] = "*****";
            }
            catch (Exception exception) {
                MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + exception));
                return null;
            }
            return objectArray;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + runtimeException));
            return null;
        }
    }

    private UpgradePackageMoFactory() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpgradePackageMoFactory()");
        }
        InspectorMgr.getInspectorRepository().register((LogContentInspector)this, "UpgradePackage");
    }

    private ManagedObject recoverMoWhenUCF_IsMissing(File file, File file2, MoData moData) throws MoNameAlreadyTakenException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "recoverMoWhenOneOftheUCFsIsMissing(File anOriginalControlFile, File aControlFile, MoData anMoData)", "anOriginalControlFile. " + file + "\n\taControlFile: " + file2 + "\n\tanMoData: " + moData);
        }
        UpgradePackageMoImpl upgradePackageMoImpl = null;
        if ((file.exists() || file2.exists()) && this.isUCFsExpectedToBeIdentical(moData)) {
            this.copyUCF(file, file2);
        }
        upgradePackageMoImpl = new UpgradePackageMoImpl(moData);
        return upgradePackageMoImpl;
    }

    private void removeMoAtRecovery(File file, File file2, MoData moData) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeMoAtRecovery(File anOriginalControlFile, File aControlFile, MoData anMoData)", "anOriginalControlFile. " + file + "\n\taControlFile: " + file2 + "\n\tanMoData: " + moData);
        }
        Control control = null;
        try {
            control = Transaction.create(2000);
            Coordinator coordinator = control.getCoordinator();
            moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            moData.delete(coordinator);
            Transaction.commit(control);
            Trace.warning(this.getClass(), "removeMoAtRecovery(File anOriginalControlFile, File aControlFile, MoData anMoData)", "Ignoring UpgradePackageMo,\n\tfile " + file + " found: " + file.exists() + "\n\tfile " + file2 + " found: " + file2.exists());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "removeMoAtRecovery(File anOriginalControlFile, File aControlFile, MoData anMoData)", "Deletion of MoData failed", throwable);
            Transaction.rollback(control);
        }
    }

    private boolean isUCFsExpectedToBeIdentical(MoData moData) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isUCFsExpectedToBeIdentical(MoData anMoData)", "anMoData: " + moData);
        }
        try {
            boolean bl = false;
            StringAttribute stringAttribute = (StringAttribute)moData.getAttribute("origUcfChecksum");
            String string = stringAttribute.getValue(null);
            if (!string.equals("")) {
                StringAttribute stringAttribute2 = (StringAttribute)moData.getAttribute("ucfChecksum");
                String string2 = stringAttribute2.getValue(null);
                if (string2.equals(string)) {
                    bl = true;
                }
            } else {
                IntegerAttribute integerAttribute = (IntegerAttribute)moData.getAttribute("activatedTypeOfUP");
                int n = integerAttribute.getValue(null);
                ActivatedTypeOfUP activatedTypeOfUP = ActivatedTypeOfUP.getInstance(n);
                if (!activatedTypeOfUP.isUndefined() && !activatedTypeOfUP.isDelta()) {
                    bl = true;
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "isUCFsExpectedToBeIdentical(MoData anMoData)", "RETURNS - theIsUCFsExpectedToBeIdentical: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isUCFsExpectedToBeIdentical(MoData anMoData)", "Throwable caught, returning false", throwable);
            return false;
        }
    }

    private boolean copyUCF(File file, File file2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "copyUCF(File anOriginalControlFile, File aControlFile)", "anOriginalControlFile. " + file + "\n\taControlFile: " + file2);
        }
        try {
            if (file.exists()) {
                SuLib.copyUCF(file, file2);
            } else {
                SuLib.copyUCF(file2, file);
            }
            return true;
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "copyUCF(File anOriginalControlFile, File aControlFile)", "Copy UCF failed, Throwable caught,\n\tThrowable: " + throwable.toString());
            return false;
        }
    }
}

