/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.main.interfaces;

import java.util.HashSet;
import java.util.Iterator;
import se.ericsson.cello.configurationversion.service.ServiceController;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceStatusInformationEvent;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceType;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.upgradepackage.main.interfaces.SU_ServiceStatusListener;
import se.ericsson.cello.upgradepackage.main.interfaces.SU_ServiceStatusSupport;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class SU_ServiceStatusSupportHandler
implements SU_ServiceStatusSupport,
PropertyChangeListener {
    HashSet myListeners = new HashSet();

    public SU_ServiceStatusSupportHandler() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ServiceStatusSupportHandler()");
        }
        ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.ServiceStatus, this);
    }

    public boolean isServiceInExecution() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isServiceInExecution()");
        }
        if (this.isServiceExecuting(0)) {
            return true;
        }
        return this.isServiceExecuting(1);
    }

    public synchronized void addAsListener(SU_ServiceStatusListener sU_ServiceStatusListener) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListener(ServiceStatusListener aServiceStatusListener)", "aServiceStatusListener: " + sU_ServiceStatusListener + "\n\tmyListeners: " + this.myListeners, false);
        }
        this.myListeners.add(sU_ServiceStatusListener);
    }

    public synchronized boolean isServiceExecuting(int n) throws IllegalArgumentException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isServiceExecuting(int aServiceName)", "aServiceName: " + n + "\n\tmyListeners: " + this.myListeners, false);
        }
        ServiceType serviceType = null;
        if (n == 0) {
            serviceType = ServiceType.SystemUpgrade;
        } else if (n == 1) {
            serviceType = ServiceType.ConfigurationVersion;
        } else {
            throw new IllegalArgumentException("Illegal argument value " + n + " received. Valid values are: 0 and 1.");
        }
        ServiceType serviceType2 = ServiceController.instance().getExecutingServiceType();
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "isServiceExecuting(int aServiceName)", "theInputServiceType: " + serviceType + "\n\ttheOngoingServiceType: " + serviceType2, false);
        }
        return serviceType.equals(serviceType2);
    }

    public synchronized void removeAsListener(SU_ServiceStatusListener sU_ServiceStatusListener) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListener(ServiceStatusListener aServiceStatusListener)", "aServiceStatusListener: " + sU_ServiceStatusListener + "\n\tmyListeners: " + this.myListeners, false);
        }
        this.myListeners.remove(sU_ServiceStatusListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", false);
        }
        try {
            if (propertyChangeEvent.getNewValue() instanceof ServiceStatusInformationEvent) {
                this.invokeHandlePropertyChange((ServiceStatusInformationEvent)propertyChangeEvent.getNewValue());
            } else {
                Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Unknown type of property change value received (ignored).aPropertyChangeEvent: " + propertyChangeEvent, false);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Throwable caught, message: " + throwable.toString(), throwable);
        }
    }

    private void invokeHandlePropertyChange(ServiceStatusInformationEvent serviceStatusInformationEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "invokeHandlePropertyChange ( ServiceStatusInformationEvent aServiceStatusInformationEvent )", "aServiceStatusInformationEvent: " + serviceStatusInformationEvent + "\n\tmyListeners: " + this.myListeners, false);
        }
        int n = -1;
        if (serviceStatusInformationEvent.serviceType.equals(ServiceType.SystemUpgrade)) {
            n = 0;
        } else if (serviceStatusInformationEvent.serviceType.equals(ServiceType.ConfigurationVersion)) {
            n = 1;
        } else {
            Trace.info(this.getClass(), "invokeHandlePropertyChange ( ServiceStatusInformationEvent aServiceStatusInformationEvent )", "Unknown type of service received (ignored).aServiceStatusInformationEvent: " + serviceStatusInformationEvent, false);
            return;
        }
        int n2 = 0;
        if (serviceStatusInformationEvent.isExecuting) {
            n2 = 1;
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "invokeHandlePropertyChange ( ServiceStatusInformationEvent aServiceStatusInformationEvent )", "Service status information changed:\n\ttheServiceName: " + n + "\n\ttheServiceStatus: " + n2);
        }
        Iterator iterator = this.myListeners.iterator();
        SU_ServiceStatusListener sU_ServiceStatusListener = null;
        while (iterator.hasNext()) {
            sU_ServiceStatusListener = (SU_ServiceStatusListener)iterator.next();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "invokeHandlePropertyChange ( ServiceStatusInformationEvent aServiceStatusInformationEvent )", "Service status information changed (inokes a ServiceStatusListener interface):\n\ttheServiceName: " + n + "\n\ttheServiceStatus: " + n2, false);
            }
            sU_ServiceStatusListener.serviceStatusChanged(n, n2);
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "invokeHandlePropertyChange ( ServiceStatusInformationEvent aServiceStatusInformationEvent )", "No more notifications will be sent  to any listeners.", false);
        }
    }
}

