/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.trace;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.upgradepackage.trace.TraceProperties;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceInfoDataContainer;
import se.ericsson.cello.upgradepackage.trace.exception.TracePropertyFileHandlerException;
import se.ericsson.cello.upgradepackage.trace.validate.TraceAttributeValidator;
import se.ericsson.cello.upgradepackage.trace.validate.TraceAttributeValidatorException;
import se.ericsson.cello.upgradepackage.trace.writers.TracePropFileTemplateWriter;
import se.ericsson.cello.upgradepackage.trace.writers.TraceTE_LogWriter;
import se.ericsson.cello.upgradepackage.util.enumer.NotifyingTracePropertyName;

public class TracePropertyFileHandler
implements PropertyChangeListener {
    private static String myPropertyFileDirPath = TraceProperties.getPropertyFilePathToUse();
    private static TracePropertyFileHandler myInstance = new TracePropertyFileHandler();
    private static final String myTraceFileNameKey = "trace.file.name";
    private static final String myTraceFlushIntervalKey = "trace.flush.interval";
    private static final String myTraceOutputModeKey = "trace.output.mode";
    private static final String myTraceFileSizeKey = "trace.file.size";
    private static final String myTraceActiveClassesKey = "trace.active.classes";
    private static final String myTraceActiveFunctionsKey = "trace.active.functions";
    private static final String myTraceLevelKey = "trace.level";
    private static final String myTraceSendLogsAsNotificationsKey = "trace.send.log.as.notifications";
    private static final String myLogServiceEnabledKey = "trace.log.service.enabled";
    private static final String myTraceLevelKeySU = "trace.levels.su";
    private static final String myTraceDisableInfoAndLogKeySU = "trace.disable.infoandlog.su";
    private static final String myTraceActiveMethodsKeySU = "trace.active.methods.su";
    private static final String myBufferSizeKeySU = "trace.buffer.size.su";
    private static final String myInactivityTimeoutKeySU = "trace.inactivity.timeout.su";
    private static final String myOneClickUpgrade = "One.click.upgrade";

    private TracePropertyFileHandler() {
        this.createTraceProperiesDir();
        TracePropFileTemplateWriter tracePropFileTemplateWriter = new TracePropFileTemplateWriter();
        tracePropFileTemplateWriter.createTheTempFileIfNeeded(myPropertyFileDirPath);
    }

    public static synchronized TracePropertyFileHandler instance() {
        return myInstance;
    }

    /*
     * Loose catch block
     */
    public void storeTracePropValues(TraceInfoDataContainer traceInfoDataContainer) throws TracePropertyFileHandlerException {
        block19: {
            Object object;
            Properties properties = new Properties();
            String string = "";
            Iterator iterator = traceInfoDataContainer.getActiveClasses().iterator();
            while (iterator.hasNext()) {
                if (!string.equals("")) {
                    string = string + ";";
                }
                string = string + (String)iterator.next();
            }
            properties.setProperty(myTraceActiveClassesKey, string);
            String string2 = "";
            Iterator iterator2 = traceInfoDataContainer.getActiveFunctions().iterator();
            while (iterator2.hasNext()) {
                if (!string2.equals("")) {
                    string2 = string2 + ";";
                }
                string2 = string2 + ((Integer)iterator2.next()).toString();
            }
            properties.setProperty(myTraceActiveFunctionsKey, string2);
            String string3 = null;
            String string4 = Boolean.FALSE.toString();
            try {
                if (traceInfoDataContainer.getOutputMode() == 3) {
                    string3 = TraceAttributeValidator.convertOutputModeInt(0);
                    string4 = Boolean.TRUE.toString();
                } else {
                    string3 = TraceAttributeValidator.convertOutputModeInt(traceInfoDataContainer.getOutputMode());
                }
            }
            catch (TraceAttributeValidatorException traceAttributeValidatorException) {
                TraceTE_LogWriter.teLogError(this.getClass(), "storeTracePropInfo()", "Trying to store an unknown value of outputMode in trace property file.\n\tDefault value: File and logServiceEnabled set to true will be stored (default).");
                string3 = "File";
                string4 = Boolean.TRUE.toString();
            }
            properties.setProperty(myTraceOutputModeKey, string3);
            properties.setProperty(myLogServiceEnabledKey, string4);
            properties.setProperty(myTraceFileNameKey, traceInfoDataContainer.getFileName(false));
            properties.setProperty(myTraceFileSizeKey, new Integer(traceInfoDataContainer.getFileSize()).toString());
            properties.setProperty(myTraceFlushIntervalKey, new Integer(traceInfoDataContainer.getFlushInterval()).toString());
            properties.setProperty(myTraceLevelKey, new Integer(traceInfoDataContainer.getLevel()).toString());
            properties.setProperty(myTraceSendLogsAsNotificationsKey, new Integer(traceInfoDataContainer.getSendLogsAsNotifications()).toString());
            if (!traceInfoDataContainer.getLevelsSU().isEmpty()) {
                object = TraceAttributeValidator.convertLevelsSU_Collection(traceInfoDataContainer.getLevelsSU());
                properties.setProperty(myTraceLevelKeySU, (String)object);
            }
            if (!traceInfoDataContainer.getActiveMethodsSU().isEmpty()) {
                object = TraceAttributeValidator.convertActiveMethodsSU_Map(traceInfoDataContainer.getActiveMethodsSU());
                properties.setProperty(myTraceActiveMethodsKeySU, (String)object);
            }
            properties.setProperty(myBufferSizeKeySU, new Integer(traceInfoDataContainer.getBufferSize()).toString());
            properties.setProperty(myInactivityTimeoutKeySU, new Integer(traceInfoDataContainer.getInactivityTimeout()).toString());
            properties.setProperty(myOneClickUpgrade, Boolean.valueOf(traceInfoDataContainer.isOneClickUpgrade()).toString());
            object = null;
            object = new FileOutputStream(myPropertyFileDirPath + "Trace_02.prop");
            properties.store((OutputStream)object, "Auto Store Of SU Trace Properties");
            ((FileOutputStream)object).close();
            Object var12_11 = null;
            try {
                if (object != null) {
                    ((FileOutputStream)object).close();
                }
                break block19;
            }
            catch (Throwable throwable) {
                TraceTE_LogWriter.teLogError(this.getClass(), "storeCurrentTracePropInfo()", "Failed to close the handle to the Trace_02.prop file, throwable caught.", throwable);
            }
            break block19;
            {
                catch (Throwable throwable) {
                    TraceTE_LogWriter.teLogError(this.getClass(), "storeCurrentTracePropInfo()", "Could not store the values to the property file due to throwable caught.", throwable);
                    throw new TracePropertyFileHandlerException("Could not store the values to the Trace_02.prop file, throwable caught. Throwable: " + throwable);
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    if (object != null) {
                        ((FileOutputStream)object).close();
                    }
                }
                catch (Throwable throwable2) {
                    TraceTE_LogWriter.teLogError(this.getClass(), "storeCurrentTracePropInfo()", "Failed to close the handle to the Trace_02.prop file, throwable caught.", throwable2);
                }
                throw throwable;
            }
        }
    }

    public TraceInfoDataContainer getTraceInfoDataFromPropFile(boolean bl) {
        TraceInfoDataContainer traceInfoDataContainer = new TraceInfoDataContainer();
        Properties properties = this.getPropertiesFromFile();
        if (properties != null) {
            traceInfoDataContainer.setTypeOfStorage(2);
            traceInfoDataContainer.setActiveClasses(this.getActiveClassesFromProperty(properties));
            traceInfoDataContainer.setActiveFunctions(this.checkAndGetActiveFunctionsFromProperties(properties));
            traceInfoDataContainer.setOutputMode(this.checkAndGetOutputModeFromProperties(properties));
            traceInfoDataContainer.setFileName(this.checkAndGetFileNameFromProperties(properties));
            traceInfoDataContainer.setLevel(this.checkAndGetLevelFromProperties(properties));
            traceInfoDataContainer.setSendLogsAsNotifications(this.checkAndGetSendLogsAsNotificationsFromProperties(properties));
            traceInfoDataContainer.setFileSize(this.checkAndGetFileSizeFromProperties(properties));
            traceInfoDataContainer.setFlushInterval(this.checkAndGetFlushIntervalFromProperties(properties));
            traceInfoDataContainer.setLevelsSU(this.checkAndGetLevelsSU_FromProperties(properties));
            traceInfoDataContainer.setDisableInfoAndLogSU(this.getDisableInfoAndLogSU_FromProperties(properties));
            traceInfoDataContainer.setActiveMethodsSU(this.getActiveMethodsFromProperties(properties));
            traceInfoDataContainer.setBufferSize(this.getBufferSizeFromProperties(properties));
            traceInfoDataContainer.setInactivityTimeout(this.getInactivityTimeoutFromProperties(properties));
            traceInfoDataContainer.setOneClickUpgrade(this.getOneClickUpgrade_FromProperties(properties));
        }
        if (bl) {
            this.subscribeForTraceNotifications(traceInfoDataContainer);
        }
        return traceInfoDataContainer;
    }

    private void subscribeForTraceNotifications(TraceInfoDataContainer traceInfoDataContainer) {
        traceInfoDataContainer.addPropertyChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties getPropertiesFromFile() {
        Properties properties = null;
        if (!this.propFileExist()) return properties;
        FileInputStream fileInputStream = null;
        String string = myPropertyFileDirPath + "Trace_02.prop";
        fileInputStream = new FileInputStream(string);
        properties = new Properties();
        properties.load(fileInputStream);
        Object var6_4 = null;
        if (fileInputStream == null) return properties;
        try {
            fileInputStream.close();
            return properties;
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(this.getClass(), "getPropertiesFromFile()", "Failed to close the InputStream, throwable caught.", throwable);
        }
        return properties;
        {
            catch (Throwable throwable) {
                TraceTE_LogWriter.teLogError(this.getClass(), "getPropertiesFromFile()", "Failed to load the properties from the " + string + " file, throwable caught.", throwable);
                properties = null;
                Object var6_5 = null;
                if (fileInputStream == null) return properties;
                try {
                    fileInputStream.close();
                    return properties;
                }
                catch (Throwable throwable2) {
                    TraceTE_LogWriter.teLogError(this.getClass(), "getPropertiesFromFile()", "Failed to close the InputStream, throwable caught.", throwable2);
                }
                return properties;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Throwable throwable3) {
                TraceTE_LogWriter.teLogError(this.getClass(), "getPropertiesFromFile()", "Failed to close the InputStream, throwable caught.", throwable3);
            }
            throw throwable;
        }
    }

    private boolean propFileExist() {
        File file = new File(myPropertyFileDirPath + "Trace_02.prop");
        return file.exists();
    }

    public void deletePropertyFile() {
        File file = new File(myPropertyFileDirPath + "Trace_02.prop");
        if (file.exists() && !file.delete()) {
            TraceTE_LogWriter.teLogError(this.getClass(), "deleteTrace02_prop()", "Failed to delete the trace property file: " + myPropertyFileDirPath + "Trace_02.prop");
        }
    }

    private void createTraceProperiesDir() {
        try {
            File file = new File(myPropertyFileDirPath);
            if (!file.exists() && !file.mkdirs()) {
                TraceTE_LogWriter.teLogError(this.getClass(), "createTraceProperiesDir()", "Failed to create the directory " + myPropertyFileDirPath + " for the SU trace property file.");
            }
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(this.getClass(), "createTraceProperiesDir()", "Failed to create the directory for SU trace property file, throwable caught.", throwable);
        }
    }

    /*
     * Loose catch block
     */
    private void storeTracePropValue(String string, String string2) throws TracePropertyFileHandlerException {
        block14: {
            Throwable throwable2222;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            block13: {
                fileInputStream = null;
                fileOutputStream = null;
                String string3 = myPropertyFileDirPath + "Trace_02.prop";
                fileInputStream = new FileInputStream(string3);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                properties.setProperty(string, string2);
                fileInputStream.close();
                fileOutputStream = new FileOutputStream(string3);
                properties.store(fileOutputStream, "Auto Store Of SU Trace Properties");
                fileOutputStream.close();
                Object var8_8 = null;
                if (fileInputStream == null) break block13;
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2222) {
                    TraceTE_LogWriter.teLogError(this.getClass(), "storeTracePropValue(String aPropKey, String aPropValue)", "Failed to close the inputstream to Trace_02.prop, throwable caught.", throwable2222);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable2222) {
                    TraceTE_LogWriter.teLogError(this.getClass(), "updateValueInPropertyFile(String aPropKey, String aPropValue)", "Failed to close the outputstream to Trace_02.prop, throwable caught.", throwable2222);
                }
            }
            break block14;
            {
                catch (Throwable throwable3) {
                    TraceTE_LogWriter.teLogError(this.getClass(), "storeTracePropValue(String aPropKey, String aPropValue)", "Failed to updated the Trace_02.propwith new value, throwable caught.", throwable3);
                    throw new TracePropertyFileHandlerException("Failed to updated the Trace_02.propwith new value, throwable caught. Throwable: " + throwable3);
                }
            }
            catch (Throwable throwable4) {
                Throwable throwable52222;
                Object var8_9 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable52222) {
                        TraceTE_LogWriter.teLogError(this.getClass(), "storeTracePropValue(String aPropKey, String aPropValue)", "Failed to close the inputstream to Trace_02.prop, throwable caught.", throwable52222);
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable52222) {
                        TraceTE_LogWriter.teLogError(this.getClass(), "updateValueInPropertyFile(String aPropKey, String aPropValue)", "Failed to close the outputstream to Trace_02.prop, throwable caught.", throwable52222);
                    }
                }
                throw throwable4;
            }
        }
    }

    private String checkAndGetFileNameFromProperties(Properties properties) {
        String string = properties.getProperty(myTraceFileNameKey, "Trace.log");
        try {
            TraceAttributeValidator.checkFileName(string);
        }
        catch (TraceAttributeValidatorException traceAttributeValidatorException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "checkAndGetFileNameFromProperties(Properties aTraceProperties)", "Failed to read value of property: trace.file.name from properties.\n\tReason: " + traceAttributeValidatorException.getReasonTag() + "\n\tString in trace property file: " + string + "\n\tDefault value " + "Trace.log" + " will be used.");
            string = "Trace.log";
        }
        return string;
    }

    private int checkAndGetFlushIntervalFromProperties(Properties properties) {
        int n = 3;
        String string = properties.getProperty(myTraceFlushIntervalKey, Integer.toString(3));
        try {
            n = new Integer(string);
            TraceAttributeValidator.checkFlushInterval(n);
        }
        catch (NumberFormatException numberFormatException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "checkAndGetFlushIntervalFromProperties(Properties aTraceProperties)", "String value does not contain a parsable integer in key trace.flush.interval in trace property file.\n\tString: " + string + "Default value " + 3 + " will be used.");
            n = 3;
        }
        catch (TraceAttributeValidatorException traceAttributeValidatorException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "checkAndGetFlushIntervalFromProperties(Properties aTraceProperties)", "Failed to read value of property: trace.flush.interval from properties.\n\tReason: " + traceAttributeValidatorException.getReasonTag() + "\n\tString in trace property file: " + string + "\n\tDefault value " + 3 + " will be used.");
            n = 3;
        }
        return n;
    }

    private HashSet checkAndGetLevelsSU_FromProperties(Properties properties) {
        HashSet hashSet = new HashSet();
        String string = properties.getProperty(myTraceLevelKeySU);
        if (string == null || string.length() == 0) {
            return hashSet;
        }
        Integer n = null;
        try {
            hashSet = TraceAttributeValidator.convertLevelsSU_String(string);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                TraceAttributeValidator.checkLevel(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "checkAndGetLevelsSU_FromProperties(Properties aTraceProperties)", "String value does not contain a parsable integer in key trace.levels.su in trace property file.\n\tThe property will be ignored.\n\tString: " + string);
            hashSet.clear();
        }
        catch (TraceAttributeValidatorException traceAttributeValidatorException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "checkAndGetLevelsSU_FromProperties(Properties aTraceProperties)", "Failed to read value of property: trace.levels.su from properties.\n\tReason: " + traceAttributeValidatorException.getReasonTag() + "\n\tString in trace property file: " + string + "\n\tThe property will be ignored.");
            hashSet.clear();
        }
        return hashSet;
    }

    private boolean getDisableInfoAndLogSU_FromProperties(Properties properties) {
        boolean bl = false;
        String string = properties.getProperty(myTraceDisableInfoAndLogKeySU, Boolean.FALSE.toString());
        try {
            bl = Boolean.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "getDisableInfoAndLogSU_FromProperties(Properties aTraceProperties)", "String value does not contain a parsable boolean in key trace.disable.infoandlog.su in trace property file.\n\tString: " + string + "\n\tThe property will be ignored.");
        }
        return bl;
    }

    private boolean getOneClickUpgrade_FromProperties(Properties properties) {
        boolean bl = false;
        String string = properties.getProperty(myOneClickUpgrade, Boolean.FALSE.toString());
        try {
            bl = Boolean.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "getOneClickUpgrade_FromProperties(Properties aTraceProperties)", "String value does not contain a parsable boolean in key One.click.upgrade in trace property file.\n\tString: " + string + "\n\tThe property will be ignored.");
        }
        return bl;
    }

    private TreeMap getActiveMethodsFromProperties(Properties properties) {
        TreeMap treeMap = new TreeMap();
        String string = properties.getProperty(myTraceActiveMethodsKeySU);
        if (string == null || string.length() == 0) {
            return treeMap;
        }
        try {
            treeMap = TraceAttributeValidator.convertActiveMethodsSU_String(string);
        }
        catch (TraceAttributeValidatorException traceAttributeValidatorException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "getActiveMethodsFromProperties(Properties aTraceProperties)", "Exception caught when reading value of property: trace.active.methods.su\n\tReason: " + traceAttributeValidatorException.getReasonTag() + "\n\tString in trace property file: " + string + "\n\tThe property will be ignored.");
            treeMap.clear();
        }
        return treeMap;
    }

    private int getBufferSizeFromProperties(Properties properties) {
        int n = 40000;
        String string = properties.getProperty(myBufferSizeKeySU, Integer.toString(40000));
        try {
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "getBufferSizeFromProperties(Properties aTraceProperties)", "String value does not contain a parsable integer in key trace.buffer.size.su in trace property file.\n\tString: " + string + "\n\tDefault value " + n + " will be used.");
        }
        return n;
    }

    private int getInactivityTimeoutFromProperties(Properties properties) {
        int n = 2000;
        String string = properties.getProperty(myInactivityTimeoutKeySU, Integer.toString(2000));
        try {
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "getInactivityTimeoutFromProperties(Properties aTraceProperties)", "String value does not contain a parsable integer in key trace.inactivity.timeout.su in trace property file.\n\tString: " + string + "\n\tDefault value " + n + " will be used.");
        }
        return n;
    }

    private int checkAndGetOutputModeFromProperties(Properties properties) {
        int n = 0;
        String string = properties.getProperty(myLogServiceEnabledKey);
        if (string != null && string.equals(Boolean.TRUE.toString())) {
            n = 3;
        } else {
            String string2 = properties.getProperty(myTraceOutputModeKey, "File");
            try {
                n = TraceAttributeValidator.convertOutputModeString(string2);
            }
            catch (TraceAttributeValidatorException traceAttributeValidatorException) {
                n = 0;
                TraceTE_LogWriter.teLogInfo(this.getClass(), "checkAndGetOutputModeFromProperties(Properties aTraceProperties)", "Exception caught when reading value of property: trace.output.mode\n\tReason: " + traceAttributeValidatorException.getReasonTag() + "\n\tString in trace property file: " + string2 + "\n\tValue " + n + " will be used. Trace propertyfile will not be updated.");
            }
        }
        return n;
    }

    private int checkAndGetFileSizeFromProperties(Properties properties) {
        int n = 2000;
        String string = properties.getProperty(myTraceFileSizeKey, Integer.toString(2000));
        try {
            n = new Integer(string);
            TraceAttributeValidator.checkFileSize(n);
        }
        catch (NumberFormatException numberFormatException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "checkAndGetFileSizeFromProperties(Properties aTraceProperties)", "String value does not contain a parsable integer in key trace.file.size in trace property file.\n\tString: " + string + "\n\tDefault value " + 2000 + " will be used.");
            n = 2000;
        }
        catch (TraceAttributeValidatorException traceAttributeValidatorException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "checkAndGetFileSizeFromProperties(Properties aTraceProperties)", "Exception caught when reading value of property: trace.file.size\n\tReason: " + traceAttributeValidatorException.getReasonTag() + "\n\tString in trace property file: " + string + "\n\tDefault value " + 2000 + " will be used.");
            n = 2000;
        }
        return n;
    }

    private int checkAndGetLevelFromProperties(Properties properties) {
        int n = 2;
        String string = properties.getProperty(myTraceLevelKey, Integer.toString(2));
        try {
            n = new Integer(string);
            TraceAttributeValidator.checkLevel(n);
        }
        catch (NumberFormatException numberFormatException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "checkAndGetLevelFromProperties(Properties aTraceProperties)", "String value does not contain a parsable integer in key trace.output.mode in trace property file.\n\tString: " + string + "Default value " + 2 + " will be used.");
            n = 2;
        }
        catch (TraceAttributeValidatorException traceAttributeValidatorException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "checkAndGetLevelFromProperties(Properties aTraceProperties)", "Exception caught when reading value of property: trace.level\n\tReason: " + traceAttributeValidatorException.getReasonTag() + "\n\tString in trace property file: " + string + "Default value " + 2 + " will be used.");
            n = 2;
        }
        return n;
    }

    private int checkAndGetSendLogsAsNotificationsFromProperties(Properties properties) {
        int n = 0;
        String string = null;
        string = properties.getProperty(myTraceSendLogsAsNotificationsKey, Integer.toString(0));
        try {
            n = new Integer(string);
            TraceAttributeValidator.checkSendLogsAsNotification(n);
        }
        catch (NumberFormatException numberFormatException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "checkAndGetSendLogsAsNotificationsFromProperties(Properties aTraceProperties)", "String value does not contain a parsable integer in key trace.send.log.as.notifications in trace property file.\n\tString: " + string + "\n\tDefault value " + 0 + " will be used.");
            n = 0;
        }
        catch (TraceAttributeValidatorException traceAttributeValidatorException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "checkAndGetSendLogsAsNotificationsFromProperties(Properties aTraceProperties)", "Exception caught when reading value of property: trace.send.log.as.notifications\n\tReason: " + traceAttributeValidatorException.getReasonTag() + "\n\tString in trace property file: " + string + "\n\tDefault value " + 0 + " will be used.");
            n = 0;
        }
        return n;
    }

    private HashSet getActiveClassesFromProperty(Properties properties) {
        HashSet<String> hashSet = new HashSet<String>();
        String string = properties.getProperty(myTraceActiveClassesKey, "");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken().trim());
        }
        return hashSet;
    }

    private HashSet checkAndGetActiveFunctionsFromProperties(Properties properties) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        String string = properties.getProperty(myTraceActiveFunctionsKey, "");
        try {
            String string2 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                hashSet.add(new Integer(string2));
            }
            TraceAttributeValidator.checkActiveFunctions(hashSet);
        }
        catch (NumberFormatException numberFormatException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "checkAndGetActiveFunctionsFromProperties(Properties aTraceProperties)", "String value does not contain a parsable integer in key trace.active.functions in trace property file.\n\tString in trace property file: " + string + "\n\tDefault value for activeFunctions will be used.");
            hashSet.clear();
        }
        catch (TraceAttributeValidatorException traceAttributeValidatorException) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "checkAndGetActiveFunctionsFromProperties(Properties aTraceProperties)", "Exception caught when reading value of property: trace.active.functions\n\tReason: " + traceAttributeValidatorException.getReasonTag() + "\n\tString in trace property file: " + string + "\n\tThe property will be ignored.");
            hashSet.clear();
        }
        return hashSet;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block27: {
            if (this.propFileExist()) {
                try {
                    if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.ActiveClasses.getValue())) {
                        String string = "";
                        Iterator iterator = ((Collection)propertyChangeEvent.getNewValue()).iterator();
                        while (iterator.hasNext()) {
                            if (!string.equals("")) {
                                string = string + ";";
                            }
                            string = string + (String)iterator.next();
                        }
                        this.storeTracePropValue(myTraceActiveClassesKey, string);
                        break block27;
                    }
                    if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.ActiveFunctions.getValue())) {
                        String string = "";
                        Integer[] integerArray = TraceAttributeValidator.getSortedIntegerArray((Collection)propertyChangeEvent.getNewValue());
                        for (int i = 0; i < integerArray.length; ++i) {
                            if (!string.equals("")) {
                                string = string + ";";
                            }
                            string = string + integerArray[i].toString();
                        }
                        this.storeTracePropValue(myTraceActiveFunctionsKey, string);
                        break block27;
                    }
                    if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.Level.getValue())) {
                        String string = ((Integer)propertyChangeEvent.getNewValue()).toString();
                        this.storeTracePropValue(myTraceLevelKey, string);
                        break block27;
                    }
                    if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.SendLogsAsNotifications.getValue())) {
                        String string = ((Integer)propertyChangeEvent.getNewValue()).toString();
                        this.storeTracePropValue(myTraceSendLogsAsNotificationsKey, string);
                        break block27;
                    }
                    if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.OutputMode.getValue())) {
                        int n = (Integer)propertyChangeEvent.getNewValue();
                        String string = null;
                        String string2 = Boolean.FALSE.toString();
                        try {
                            if (n == 3) {
                                string = TraceAttributeValidator.convertOutputModeInt(0);
                                string2 = Boolean.TRUE.toString();
                            } else {
                                string = TraceAttributeValidator.convertOutputModeInt(n);
                            }
                        }
                        catch (TraceAttributeValidatorException traceAttributeValidatorException) {
                            TraceTE_LogWriter.teLogError(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Trying to store an unknown value of outputMode in trace property file.\n\tDefault value: File and logServiceEnabled set to true will be stored (default).");
                            string = "File";
                            string2 = Boolean.TRUE.toString();
                        }
                        this.storeTracePropValue(myTraceOutputModeKey, string);
                        this.storeTracePropValue(myLogServiceEnabledKey, string2);
                        break block27;
                    }
                    if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.FileName.getValue())) {
                        String string = (String)propertyChangeEvent.getNewValue();
                        this.storeTracePropValue(myTraceFileNameKey, string);
                    } else if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.FileSize.getValue())) {
                        String string = ((Integer)propertyChangeEvent.getNewValue()).toString();
                        this.storeTracePropValue(myTraceFileSizeKey, string);
                    } else if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.FlushInterval.getValue())) {
                        String string = ((Integer)propertyChangeEvent.getNewValue()).toString();
                        this.storeTracePropValue(myTraceFlushIntervalKey, string);
                    } else if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.OneClickUpgrade.getValue())) {
                        String string = ((Boolean)propertyChangeEvent.getNewValue()).toString();
                        this.storeTracePropValue(myOneClickUpgrade, string);
                    } else if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.LevelsSU.getValue())) {
                        String string = TraceAttributeValidator.convertLevelsSU_Collection((Collection)propertyChangeEvent.getNewValue());
                        this.storeTracePropValue(myTraceLevelKeySU, string);
                    } else if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.ActiveMethodsSU.getValue())) {
                        String string = TraceAttributeValidator.convertActiveMethodsSU_Map((TreeMap)propertyChangeEvent.getNewValue());
                        this.storeTracePropValue(myTraceActiveMethodsKeySU, string);
                    }
                }
                catch (TracePropertyFileHandlerException tracePropertyFileHandlerException) {
                    // empty catch block
                }
            }
        }
    }
}

