/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.RepertoireMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.ActiveOtherLMsHelperException;
import se.ericsson.cello.upgradepackage.upgrade.UpgradeClientInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RepertoireMoData;
import se.ericsson.cello.upgradepackage.util.mohandler.swallocation.SwAllocationMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class ActiveOtherLMsHelper {
    public boolean isConnected() throws ActiveOtherLMsHelperException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isConnected()");
        }
        boolean bl = false;
        if (!this.getConnectedRepertoirNames().isEmpty()) {
            bl = true;
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "boolean isConnected()", "RETURNS -" + bl);
        }
        return bl;
    }

    public Vector getConnectedRepertoirNames() throws ActiveOtherLMsHelperException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConnectedRepertoirNames()");
        }
        try {
            HashSet<String> hashSet = new HashSet<String>();
            SwAllocationMoSU_Access swAllocationMoSU_Access = ServiceFinder.getActiveOtherLMsMO_HandlerInterface().getReferencedSwAllocationMo();
            if (swAllocationMoSU_Access != null) {
                RepertoireMoData repertoireMoData = null;
                SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface();
                Iterator iterator = swAllocationMO_HandlerInterface.getRepertoiresReferencedBySwAllocation(swAllocationMoSU_Access).iterator();
                while (iterator.hasNext()) {
                    repertoireMoData = (RepertoireMoData)iterator.next();
                    hashSet.add(repertoireMoData.repertoireName);
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getConnectedRepertoirNames()", "RETURNS -" + hashSet);
            }
            return new Vector(hashSet);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getConnectedRepertoirNames()", "Throwable caught.", throwable);
            throw new ActiveOtherLMsHelperException("Class name: " + this.getClass().getName() + "\n\tMethod: getConnectedRepertoirNames()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public Collection getOtherLMs(UpgradeClientInterface upgradeClientInterface, File file) throws ActiveOtherLMsHelperException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getOtherLMs(UpgradeClientInterface anUpgradePackageMo, File anUpgradeControlFile)", "anUpgradePackageMo: " + upgradeClientInterface + "\n\tanUpgradeControlFile: " + file);
        }
        DocumentObjectProxyInterface documentObjectProxyInterface = null;
        try {
            Object object;
            Collection<Object> collection = new LinkedList<ManagedObject>();
            if (this.isConnected()) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getOtherLMs(UpgradeClientInterface anUpgradePackageMo, File anUpgradeControlFile)", "The ActiveOtherLMs Mo is connected i.e. only connected load modules are of interest.");
                }
                if ((object = ServiceFinder.getActiveOtherLMsMO_HandlerInterface().getReferencedSwAllocationMo()) != null) {
                    SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface();
                    Collection collection2 = swAllocationMO_HandlerInterface.getRepertoiresReferencedBySwAllocation((SwAllocationMoSU_Access)object);
                    RepertoireMoSU_Access repertoireMoSU_Access = null;
                    LinkedList<String> linkedList = new LinkedList<String>();
                    RepertoireMoData repertoireMoData = null;
                    Iterator iterator = collection2.iterator();
                    while (iterator.hasNext()) {
                        repertoireMoData = (RepertoireMoData)iterator.next();
                        repertoireMoSU_Access = repertoireMoData.repertoireMo;
                        linkedList.add(repertoireMoSU_Access.getName(null));
                    }
                    documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(upgradeClientInterface.getUpgradePackageProductNumber(), upgradeClientInterface.getUpgradePackageProductRevision(), file.getAbsolutePath(), "Repertoire");
                    RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
                    Collection collection3 = repertoiresProxyInterface.getProductNumberAndRevisionsOfAllLoadModulesConnectedToRepertoires(linkedList);
                    LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
                    collection = loadModuleMO_HandlerInterface.getLoadModules(collection3);
                }
            } else {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "getOtherLMs(UpgradeClientInterface anUpgradePackageMo, File anUpgradeControlFile)", "The ActiveOtherLMs Mo is not connected i.e. all load modules of type Other are of interest.");
                }
                object = upgradeClientInterface.getLoadModuleList(null);
                String string = null;
                for (int i = 0; i < ((ManagedObject[])object).length; ++i) {
                    string = ((LoadModuleMoSU_Access)object[i]).getOtherLoaderName(null);
                    if (string == null || string.equals("")) continue;
                    collection.add(object[i]);
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getOtherLMs(UpgradeClientInterface anUpgradePackageMo, File anUpgradeControlFile)", "RETURNS - " + collection);
            }
            object = collection;
            return object;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getOtherLMs(UpgradeClientInterface anUpgradePackageMo, File anUpgradeControlFile)", "Throwable caught.", throwable);
            throw new ActiveOtherLMsHelperException("Class name: " + this.getClass().getName() + "\n\tMethod: getOtherLMs(UpgradeClientInterface anUpgradePackageMo, File anUpgradeControlFile)" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
        finally {
            UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
        }
    }
}

