/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.managedelementdata;

import se.ericsson.cello.configurationversion.file.autoconfiguration.proxy.AutoConfigurationProxy;
import se.ericsson.cello.managedelement.suaccess.ManagedElementDataMoSU_Access;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelementdata.ManagedElementDataMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelementdata.ManagedElementDataMO_HandlerInterface;

public class ManagedElementDataMO_Handler
implements ManagedElementDataMO_HandlerInterface {
    public ManagedElementDataMO_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ManagedElementDataMO_Handler (MO_HandlerFactoryInterface aMO_HandlerFactoryInterface)");
        }
    }

    public boolean disablePlugAndPlay() throws ManagedElementDataMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "disablePlugAndPlay ()");
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            ManagedElementDataMoSU_Access managedElementDataMoSU_Access = (ManagedElementDataMoSU_Access)ServiceLocatorFacade.getRepository().getService(ManagedElementDataMoSU_Access.class);
            boolean bl = managedElementDataMoSU_Access.getAutoConfigurationAllowedForSU(null);
            if (bl) {
                control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                coordinator = control.getCoordinator();
                managedElementDataMoSU_Access.setAutoConfigurationAllowedWithoutCreatingCV(false, coordinator);
                control.getTerminator().commit();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "disablePlugAndPlay ()", "The Plug & Play functionallity has been disabled.");
                }
            }
            return bl;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "disablePlugAndPlay ()", "MoAccessException caught.\n\tMoAccessException data:" + moAccessException.toString(), moAccessException);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ManagedElementDataMO_HandlerException("disablePlugAndPlay ()\n\tMoAccessException caught.\n\tMoAccessException data: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "disablePlugAndPlay ()", "Exception caught.\n\tException data: " + exception.toString(), exception);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new ManagedElementDataMO_HandlerException("disablePlugAndPlay ()\n\tException caught.\n\tException data: " + exception.toString());
        }
    }

    private ManagedElementDataMoSU_Access getManagedElementData() {
        return (ManagedElementDataMoSU_Access)ServiceLocatorFacade.getRepository().getService(ManagedElementDataMoSU_Access.class);
    }

    public long getHdVolumeCFreespace(Coordinator coordinator) throws ManagedElementDataMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getHdVolumeCFreespace(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator));
        }
        ManagedElementDataMoSU_Access managedElementDataMoSU_Access = null;
        managedElementDataMoSU_Access = this.getManagedElementData();
        try {
            long l = managedElementDataMoSU_Access.getHdVolumeCFreespaceExt(coordinator);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getHdVolumeCFreespace(Coordinator aCoordinator)", "RETURNS : " + l);
            }
            return l;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getHdVolumeCFreespace(Coordinator aCoordinator)", "Throwable caught.\n\tRETURNS : -1.\n\tThrowable data: " + throwable);
            return -1L;
        }
    }

    public boolean isPlugAndPlayOn() throws ManagedElementDataMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isPlugAndPlayOn ()");
        }
        try {
            return this.getManagedElementData().getAutoConfigurationAllowedForSU(null);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isPlugAndPlayOn ()", "Throwable caught.\n\tThrowable data:" + throwable.toString(), throwable);
            throw new ManagedElementDataMO_HandlerException("Class: " + this + "\n\tClass Name: " + this.getClass().getName() + "isPlugAndPlayOn ()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public void setPlugAndPlayConfigurationAllowed(boolean bl) throws ManagedElementDataMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setPlugAndPlayConfigurationAllowed (boolean aPlugAndPlayIsAllowed)", "aPlugAndPlayIsAllowed: " + bl);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
            coordinator = control.getCoordinator();
            this.getManagedElementData().setAutoConfigurationAllowedWithoutCreatingCV(bl, coordinator);
            control.getTerminator().commit();
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "setPlugAndPlayConfigurationAllowed (boolean aPlugAndPlayIsAllowed)", "aPlugAndPlayIsAllowed: " + bl + "\n\tMoAccessException caught." + "\n\tMoAccessException data: " + moAccessException.toString(), moAccessException);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ManagedElementDataMO_HandlerException("setPlugAndPlayConfigurationAllowed (boolean aPlugAndPlayIsAllowed)\n\taPlugAndPlayIsAllowed: " + bl + "MoAccessException caught." + "\n\tMoAccessException data: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setPlugAndPlayConfigurationAllowed (boolean aPlugAndPlayIsAllowed)", "aPlugAndPlayIsAllowed: " + bl + "\n\tException caught." + "\n\tException data: " + exception.toString(), exception);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new ManagedElementDataMO_HandlerException("setPlugAndPlayConfigurationAllowed (boolean aPlugAndPlayIsAllowed)\n\taPlugAndPlayIsAllowed: " + bl + "Exception caught." + "\n\tException data: " + exception.toString());
        }
    }

    public boolean isPlugAndPlayRunning() throws ManagedElementDataMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isPlugAndPlayRunning()");
        }
        if (SU_AccessVersionHandler.getInstance().isSupported("SU_2", (Object)this.getManagedElementData())) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isPlugAndPlayRunning(), ManagedElementDataMoSU_Access supports version2");
            }
            try {
                boolean bl = false;
                bl = this.getManagedElementData().getAutoConfigurationStatus(null) != 0;
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "isPlugAndPlayRunning() returns: " + bl);
                }
                return bl;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "isPlugAndPlayRunning()", "Throwable caught.\n\tThrowable data:" + throwable.toString(), throwable);
                throw new ManagedElementDataMO_HandlerException("Class: " + this + "\n\tClass Name: " + this.getClass().getName() + "isPlugAndPlayRunning()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable.toString());
            }
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isPlugAndPlayRunning(), ManagedElementDataMoSU_Access do not support version2");
        }
        return false;
    }

    public void setAutoconfigurationData(String string) throws ManagedElementDataMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setAutoconfigurationData(String aPathToAutoconfigFile)", "aPathToAutoconfigFile: " + string);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
            coordinator = control.getCoordinator();
            AutoConfigurationProxy autoConfigurationProxy = new AutoConfigurationProxy(string);
            String string2 = autoConfigurationProxy.getMode();
            autoConfigurationProxy.deleteFile(string);
            ManagedElementDataMoSU_Access managedElementDataMoSU_Access = this.getManagedElementData();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "setAutoconfigurationData(String aPathToAutoconfigFile)", "Setting autoConfigurationAllowed to: " + string2);
            }
            if (string2.equals("on")) {
                managedElementDataMoSU_Access.setAutoConfigurationAllowedWithoutCreatingCV(true, coordinator);
            } else if (string2.equals("off")) {
                managedElementDataMoSU_Access.setAutoConfigurationAllowedWithoutCreatingCV(false, coordinator);
            }
            control.getTerminator().commit();
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "setAutoconfigurationData(String aPathToAutoconfigFile)", "aPathToAutoconfigFile: " + string + "\n\tMoAccessException caught." + "\n\tMoAccessException data: " + moAccessException.toString(), moAccessException);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ManagedElementDataMO_HandlerException("setAutoconfigurationData(String aPathToAutoconfigFile)\n\taPathToAutoconfigFile: " + string + "MoAccessException caught." + "\n\tMoAccessException data: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setAutoconfigurationData(String aPathToAutoconfigFile)", "aPathToAutoconfigFile: " + string + "\n\tException caught." + "\n\tException data: " + exception.toString(), exception);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new ManagedElementDataMO_HandlerException("setAutoconfigurationData(String aPathToAutoconfigFile)\n\taPathToAutoconfigFile: " + string + "Exception caught." + "\n\tException data: " + exception.toString());
        }
    }
}

