/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.repertoire;

import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoaderTypeConverter;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RestartCounterLimitInformation;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RestartTimerInformation;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.UnexpectedLoaderTypeValueException;

public class LoadModuleInformation {
    private String myLDN = "";
    private String myTag = "";
    private String myHeapSize = "";
    private String myPoolSize = "";
    private String myProgramInstances = "";
    private String myLoaderType = "";
    private String myDeviceLoaderName = "";
    private String myDeviceLoaderInformation = "";
    private String myRestartCounterLimit = "";
    private String myRestartTimer = "";
    private boolean myIsLmRefAlsoDefinedWithoutRestartTimer = false;
    private boolean myIsLmRefAlsoDefinedWithoutRestartCounterLimit = false;

    public LoadModuleInformation(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug("LoadModuleInformation(String aLDN, String aTag, String aHeapSize, String aPoolSize, String aProgramInstances, String aLoaderType, String aDeviceLoaderName, String aDeviceLoaderInformation)", "aLDN: " + string + "\n\taTag: " + string2 + "\n\taHeapSize: " + string3 + "\n\taPoolSize: " + string4 + "\n\taProgramInstances: " + string5 + "\n\taLoaderType: " + string6 + "\n\taDeviceLoaderName: " + string7 + "\n\taDeviceLoaderInformation: " + string8);
        }
        this.myLDN = string;
        this.myTag = string2;
        this.myHeapSize = string3;
        this.myPoolSize = string4;
        this.myProgramInstances = string5;
        this.myLoaderType = string6;
        this.myDeviceLoaderName = string7;
        this.myDeviceLoaderInformation = string8;
    }

    public LoadModuleInformation(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug("LoadModuleInformation(String aLDN, String aTag, String aHeapSize, String aPoolSize, String aProgramInstances, String aLoaderType, String aDeviceLoaderName, String aDeviceLoaderInformation, String aRestartCounterLimit, String aRestartTimer)", "aLDN: " + string + "\n\taTag: " + string2 + "\n\taHeapSize: " + string3 + "\n\taPoolSize: " + string4 + "\n\taProgramInstances: " + string5 + "\n\taLoaderType: " + string6 + "\n\taDeviceLoaderName: " + string7 + "\n\taDeviceLoaderInformation: " + string8 + "\n\taRestartCounterLimit: " + string9 + "\n\taRestartTimer: " + string10);
        }
        this.myLDN = string;
        this.myTag = string2;
        this.myHeapSize = string3;
        this.myPoolSize = string4;
        this.myProgramInstances = string5;
        this.myLoaderType = string6;
        this.myDeviceLoaderName = string7;
        this.myDeviceLoaderInformation = string8;
        this.myRestartCounterLimit = string9;
        this.myRestartTimer = string10;
    }

    public String getTag() {
        return this.myTag;
    }

    public String getHeapSize() {
        return this.myHeapSize;
    }

    public int getHeapSizeAsInt() {
        return new Integer(this.myHeapSize);
    }

    public String getPoolSize() {
        return this.myPoolSize;
    }

    public int getPoolSizeAsInt() {
        return new Integer(this.myPoolSize);
    }

    public String getProgramInstances() {
        return this.myProgramInstances;
    }

    public String getLoaderType() {
        return this.myLoaderType;
    }

    public int getLoaderTypeAsInt() throws UnexpectedLoaderTypeValueException {
        return LoaderTypeConverter.convertToInt(this.myLoaderType);
    }

    public String getDeviceLoaderName() {
        return this.myDeviceLoaderName;
    }

    public String getDeviceLoaderInformation() {
        return this.myDeviceLoaderInformation;
    }

    public String getLDN() {
        return this.myLDN;
    }

    public String getRestartCounterLimit() {
        return this.myRestartCounterLimit;
    }

    public boolean isLmRefAlsoDefinedWithoutRestartCounterLimit() {
        return this.myIsLmRefAlsoDefinedWithoutRestartCounterLimit;
    }

    public boolean isLmRefAlsoDefinedWithoutRestartTimer() {
        return this.myIsLmRefAlsoDefinedWithoutRestartTimer;
    }

    public int getRestartCounterLimitAsInt() {
        return new Integer(this.myRestartCounterLimit);
    }

    public String getRestartTimer() {
        return this.myRestartTimer;
    }

    public int getRestartTimerAsInt() {
        return new Integer(this.myRestartTimer);
    }

    public String toNiceString() {
        return "\n\t\t\t\tmyLDN: " + this.myLDN + "\n\t\t\t\tmyTag: " + this.myTag + "\n\t\t\t\tmyHeapSize: " + this.myHeapSize + "\n\t\t\t\tmyPoolSize: " + this.myPoolSize + "\n\t\t\t\tmyProgramInstances: " + this.myProgramInstances + "\n\t\t\t\tmyLoaderType: " + this.myLoaderType + "\n\t\t\t\tmyDeviceLoaderName: " + this.myDeviceLoaderName + "\n\t\t\t\tmyDeviceLoaderInformation: " + this.myDeviceLoaderInformation + "\n\t\t\t\tmyRestartCounterLimit: " + this.myRestartCounterLimit + "\n\t\t\t\tmyRestartTimer: " + this.myRestartTimer + "\n\t\t\t\tmyIsLmRefAlsoDefinedWithoutRestartCounterLimit: " + this.myIsLmRefAlsoDefinedWithoutRestartCounterLimit + "\n\t\t\t\tmyIsLmRefAlsoDefinedWithoutRestartTimer: " + this.myIsLmRefAlsoDefinedWithoutRestartTimer;
    }

    public String toString() {
        return "\n\tmyLDN: " + this.myLDN + "\n\tmyTag: " + this.myTag + "\n\tmyHeapSize: " + this.myHeapSize + "\n\tmyPoolSize: " + this.myPoolSize + "\n\tmyProgramInstances: " + this.myProgramInstances + "\n\tmyLoaderType: " + this.myLoaderType + "\n\tmyDeviceLoaderName: " + this.myDeviceLoaderName + "\n\tmyDeviceLoaderInformation: " + this.myDeviceLoaderInformation + "\n\tmyRestartCounterLimit: " + this.myRestartCounterLimit + "\n\tmyRestartTimer: " + this.myRestartTimer + "\n\tmyIsLmRefAlsoDefinedWithoutRestartCounterLimit: " + this.myIsLmRefAlsoDefinedWithoutRestartCounterLimit + "\n\tmyIsLmRefAlsoDefinedWithoutRestartTimer: " + this.myIsLmRefAlsoDefinedWithoutRestartTimer;
    }

    public void setHeapSize(String string) {
        this.myHeapSize = string;
    }

    public void setPoolSize(String string) {
        this.myPoolSize = string;
    }

    public void setProgramInstances(String string) {
        this.myProgramInstances = string;
    }

    public void setLoaderType(String string) {
        this.myLoaderType = string;
    }

    public void setDeviceLoaderName(String string) {
        this.myDeviceLoaderName = string;
    }

    public void setDeviceLoaderInformation(String string) {
        this.myDeviceLoaderInformation = string;
    }

    public void setRestartCounterLimit(RestartCounterLimitInformation restartCounterLimitInformation) {
        if (restartCounterLimitInformation.isLmRefGivenWithoutRestartCounterLimit()) {
            this.myIsLmRefAlsoDefinedWithoutRestartCounterLimit = true;
        }
        this.myRestartCounterLimit = restartCounterLimitInformation.getRestartCounterLimit();
    }

    public void setRestartTimer(RestartTimerInformation restartTimerInformation) {
        if (restartTimerInformation.isLmRefGivenWithoutRestartTimer()) {
            this.myIsLmRefAlsoDefinedWithoutRestartTimer = true;
        }
        this.myRestartTimer = restartTimerInformation.getRestartTimer();
    }
}

