/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.imrutility.imr.RepositoryAdminHelper;
import org.jacorb.imrutility.imr.RepositoryHelper;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.AbstractRebindRetryStrategy;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ClientInterceptorHandler;
import org.jacorb.orb.DefaultClientInterceptorHandler;
import org.jacorb.orb.DelegateConfiguration;
import org.jacorb.orb.ImRRebindRetryStrategy;
import org.jacorb.orb.LocateReplyReceiver;
import org.jacorb.orb.NullClientInterceptorHandler;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.ParsedIOROperations;
import org.jacorb.orb.RebindRetryStrategy;
import org.jacorb.orb.Reference;
import org.jacorb.orb.ReplyReceiver;
import org.jacorb.orb.ServantObjectImpl;
import org.jacorb.orb.SpecificProfileSelector;
import org.jacorb.orb.StackRebindRetryStrategy;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.ft.FaultTolerantProfileSelector;
import org.jacorb.orb.ft.FaultTolerantRebindRetryStrategy;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyInputStream;
import org.jacorb.orb.giop.LocateRequestOutputStream;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ReplyPlaceholder;
import org.jacorb.orb.giop.RequestOutputStream;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.miop.MIOPProfile;
import org.jacorb.orb.policies.ClientProtocolPolicy;
import org.jacorb.orb.policies.PolicyManager;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.poa.POA;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.ObjectUtil;
import org.jacorb.util.Time;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyHelper;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;
import org.omg.FT.FTRequestServiceContext;
import org.omg.FT.FTRequestServiceContextHelper;
import org.omg.FT.RequestDurationPolicy;
import org.omg.FT.RequestDurationPolicyHelper;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;
import org.omg.Messaging.RelativeRequestTimeoutPolicy;
import org.omg.Messaging.RelativeRoundtripTimeoutPolicy;
import org.omg.Messaging.ReplyEndTimePolicy;
import org.omg.Messaging.ReplyHandler;
import org.omg.Messaging.ReplyStartTimePolicy;
import org.omg.Messaging.RequestEndTimePolicy;
import org.omg.Messaging.RequestStartTimePolicy;
import org.omg.Messaging.SyncScopePolicy;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.RTCORBA.Protocol;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;
import org.omg.TimeBase.UtcT;

public final class Delegate
extends org.omg.CORBA_2_3.portable.Delegate {
    private ParsedIOR parsedIOR = null;
    private IOR ior = null;
    private ClientConnection[] connections = new ClientConnection[2];
    private static final int IIOP = 0;
    private static final int MIOP = 1;
    private int currentConnection = 0;
    private boolean bound = false;
    private POA poa;
    private final ORB orb;
    private final Logger logger;
    private boolean resolved_locality = false;
    private final Set pending_replies;
    private final Barrier pending_replies_sync = new Barrier();
    private final java.lang.Object bind_sync = new java.lang.Object();
    private boolean locate_on_bind_performed = false;
    private final ClientConnectionManager conn_mg;
    private final Map policy_overrides;
    private CookieHolder cookie = null;
    private boolean clearCurrentContext = true;
    private String invokedOperation = null;
    private byte[] svcObjectID;
    private boolean ctxNegotiated;
    private int socketHash = -1;
    private boolean disableClientOrbPolicies;
    private static final ThreadLocal localInterceptors = new ThreadLocal();
    private final Configuration configuration;
    private boolean locateOnBind;
    private boolean disableSvcNegotiation;
    private static final String REQUEST_END_TIME = "request_end_time";
    private static final String REPLY_END_TIME = "reply_end_time";
    public static final String INTERCEPTOR_CALL = "interceptor_call";
    private static final String SERVANT_PREINVOKE = "servant_preinvoke";
    private static final String IMR_LOCATE_CALL = "imr_locate_call";
    private int defaultGiopMinor;
    private static final ThreadLocal ignoreNextCallToIsLocal = new ThreadLocal(){

        protected java.lang.Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private RebindRetryStrategy rebindRetryStrategy;
    private final RebindRetryStrategy.RebindCallback rebindCallback = new RebindRetryStrategy.RebindCallback(){

        public void setIMRQuerying() {
            Delegate.this.queryingIMR = true;
        }

        public boolean rebind(ParsedIOROperations ior) {
            return Delegate.this.rebindLocked((ParsedIOR)ior, false, false, null);
        }

        public boolean rebind(ParsedIOROperations ior, boolean forceRebind) {
            return Delegate.this.rebindLocked((ParsedIOR)ior, false, forceRebind, null);
        }
    };
    private boolean locForwardRebind;
    private boolean queryingIMR;
    private boolean disconnectAfterNonRecoverableSystemException;
    private static final ThreadLocal invocationContext = new ThreadLocal(){

        protected java.lang.Object initialValue() {
            return new Stack();
        }
    };

    public static final Stack getInvocationContext() {
        return (Stack)invocationContext.get();
    }

    private static void clearInvocationContext() {
        if (!Delegate.getInvocationContext().empty()) {
            Delegate.getInvocationContext().pop();
        } else {
            System.out.println("WARNING: clearing invocation context and stack is empty");
        }
    }

    private Delegate(ORB orb, Configuration config, boolean parseIORLazy) {
        DelegateConfiguration delegateConfig;
        this.orb = orb;
        this.configuration = config;
        this.conn_mg = orb.getClientConnectionManager();
        try {
            delegateConfig = (DelegateConfiguration)config.getAttributeAsObject("jacorb.orb.delegate.config", DelegateConfiguration.DEFAULT);
        }
        catch (ConfigurationException e2) {
            throw new RuntimeException(e2);
        }
        this.logger = delegateConfig.logger;
        this.locateOnBind = delegateConfig.locateOnBind;
        this.disableSvcNegotiation = delegateConfig.disableSvcNegotiation;
        this.disableClientOrbPolicies = delegateConfig.disableClientOrbPolicies;
        this.disconnectAfterNonRecoverableSystemException = delegateConfig.disconnectAfterNonRecoverableSystemException;
        this.defaultGiopMinor = this.configuration.getAttributeAsInteger("jacorb.giop_minor_version", 2);
        if (parseIORLazy) {
            this.pending_replies = new HashSet(0);
            this.policy_overrides = this.disableClientOrbPolicies ? Collections.EMPTY_MAP : new HashMap(0);
        } else {
            this.pending_replies = new HashSet();
            this.policy_overrides = this.disableClientOrbPolicies ? Collections.EMPTY_MAP : new HashMap();
        }
    }

    private void updateRebindRetryStrategy(ParsedIOR ior) {
        this.rebindRetryStrategy = this.newRebindRetryStrategy(this.orb, ior, ior.isIOGR(), ior.getTypeId());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using RebindStrategy: " + this.rebindRetryStrategy);
        }
    }

    private static boolean checkIfImR(String typeId) {
        return "IDL:org/jacorb/imr/ImplementationRepository:1.0".equals(typeId) || RepositoryHelper.id().equals(typeId) || RepositoryAdminHelper.id().equals(typeId);
    }

    private RebindRetryStrategy newRebindRetryStrategy(ORB orb, ParsedIOR ior, boolean isIOGR, String typeId) {
        AbstractRebindRetryStrategy result;
        if (isIOGR) {
            result = new FaultTolerantRebindRetryStrategy(orb.getConfiguration());
        } else {
            StackRebindRetryStrategy strategy = new StackRebindRetryStrategy(orb.getConfiguration());
            result = orb.useIMR() && !Delegate.checkIfImR(typeId) ? new ImRRebindRetryStrategy(strategy, orb, this.logger) : strategy;
        }
        if (this.rebindRetryStrategy == null) {
            result.setOriginalIOR(ior);
        } else {
            result.setOriginalIOR(this.rebindRetryStrategy.getOriginalIOR());
        }
        return result;
    }

    private Delegate(ORB orb, boolean parseIORLazy) {
        this(orb, orb.getConfiguration(), parseIORLazy);
    }

    public Delegate(ORB orb, ParsedIOR pior) {
        this(orb, false);
        this.parsedIOR = pior;
    }

    public Delegate(ORB orb, IOR ior, boolean parseIORLazy) {
        this(orb, parseIORLazy);
        this.ior = ior;
        if (!parseIORLazy) {
            this.getParsedIOR();
        }
    }

    public Delegate(ORB orb, IOR ior) {
        this(orb, ior, false);
    }

    public int _get_TCKind() {
        return 14;
    }

    private void bind() {
        this.bind(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(boolean applyProfileSelection) {
        if (this.bound) {
            return;
        }
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            Profile profile;
            ParsedIOR ior = this.getParsedIOR();
            this.updateRebindRetryStrategy(ior);
            if (applyProfileSelection) {
                Protocol[] protocols = this.getClientProtocols();
                if (protocols != null) {
                    ior.setProfileSelector(new SpecificProfileSelector(protocols));
                }
                if (ior.isIOGR()) {
                    ior.setProfileSelector(new FaultTolerantProfileSelector());
                }
            }
            if ((profile = ior.getEffectiveProfile()) == null) {
                throw new COMM_FAILURE("no effective profile");
            }
            this.patchSSL(profile, ior);
            if (profile instanceof MIOPProfile) {
                this.connections[1] = this.conn_mg.getConnection(profile);
                profile = ((MIOPProfile)profile).getGroupIIOPProfile();
            }
            if (profile != null) {
                this.connections[0] = this.conn_mg.getConnection(profile);
            }
            this.bound = true;
            this.locateOnBind();
        }
    }

    private void patchSSL(Profile profile, ParsedIOR ior) {
        if (!(profile instanceof IIOPProfile)) {
            return;
        }
        IIOPProfile iiopProfile = (IIOPProfile)profile;
        if (iiopProfile.version().minor != 0) {
            return;
        }
        TaggedComponentList multipleComponents = ior.getMultipleComponents();
        SSL ssl = (SSL)multipleComponents.getComponent(20, SSLHelper.class);
        if (ssl != null) {
            this.logger.debug("patching GIOP 1.0 profile to contain SSL information from the multiple components profile");
            iiopProfile.addComponent(20, ssl, SSLHelper.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locateOnBind() {
        List<ServiceContext> serviceContexts;
        if (!this.locateOnBind) {
            return;
        }
        if (this.locate_on_bind_performed) {
            return;
        }
        this.logger.info("locate_on_bind");
        this.locate_on_bind_performed = true;
        if (this.getParsedIOR().isIOGR()) {
            RequestDurationPolicy requestDurationPolicy = RequestDurationPolicyHelper.narrow(this.get_client_policy(47));
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.context_id = 13;
            FTRequestServiceContext contextData = new FTRequestServiceContext();
            contextData.client_id = "";
            contextData.retention_id = -1;
            contextData.expiration_time = Time.corbaFuture((long)requestDurationPolicy.request_duration_value()).time;
            CDROutputStream out = new CDROutputStream(this.orb);
            try {
                out.beginEncapsulatedArray();
                FTRequestServiceContextHelper.write(out, contextData);
                serviceContext.context_data = out.getBufferCopy();
            }
            finally {
                out.close();
            }
            serviceContexts = Collections.singletonList(serviceContext);
        } else {
            serviceContexts = Collections.EMPTY_LIST;
        }
        while (true) {
            ParsedIOR ior = this.getParsedIOR();
            try {
                LocateRequestOutputStream out = new LocateRequestOutputStream(this.orb, ior.get_object_key(), this.connections[this.currentConnection].getId(), ior.getEffectiveProfile().version().minor);
                try {
                    try {
                        LocateReplyReceiver receiver = new LocateReplyReceiver();
                        receiver.configure(this.configuration);
                        this.connections[this.currentConnection].sendRequest(out, receiver, out.getRequestId(), true);
                        LocateReplyInputStream reply = receiver.getReply();
                        try {
                            switch (reply.rep_hdr.locate_status.value()) {
                                case 0: {
                                    throw new UNKNOWN("Could not bind to object, server does not know it!");
                                }
                                case 1: {
                                    return;
                                }
                                case 2: {
                                    this.rebind(reply.read_Object(), false);
                                    return;
                                }
                                case 3: {
                                    this.rebind(reply.read_Object(), true);
                                    return;
                                }
                                case 4: {
                                    throw SystemExceptionHelper.read(reply);
                                }
                                case 5: {
                                    throw new NO_IMPLEMENT("Server responded to LocateRequest with a status of LOC_NEEDS_ADDRESSING_MODE, but this isn't yet implemented by JacORB");
                                }
                            }
                            throw new IllegalArgumentException("Unknown reply status for LOCATE_REQUEST: " + reply.rep_hdr.locate_status.value());
                        }
                        finally {
                            reply.close();
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                catch (SystemException e2) {
                    if (this.rebindRetryStrategy.try_rebind(this.rebindCallback, ior, e2, serviceContexts)) {
                        throw new RemarshalException();
                    }
                    this.logger.error("locate_on_bind failed", e2);
                    throw new COMM_FAILURE(e2.toString());
                }
            }
            catch (RemarshalException e3) {
                if (ior.isIOGR()) continue;
                this.logger.warn("Ignoring RemarshalException during locate_on_bind.");
                return;
            }
            break;
        }
    }

    void rebind(Object obj, boolean isPermanent) {
        this.locForwardRebind = true;
        this.rebindToObject(obj, isPermanent, false);
    }

    void rebind(Object obj) {
        this.rebindToObject(obj, false, false);
    }

    private void rebindToObject(Object object, boolean isPermanent, boolean forceRebind) {
        Delegate delegate;
        String object_reference = this.orb.object_to_string(object);
        if (object_reference.indexOf("IOR:") == 0) {
            delegate = null;
            if (object != null) {
                delegate = (Delegate)((ObjectImpl)object)._get_delegate();
            }
        } else {
            throw new INV_OBJREF("Not an IOR: " + object_reference);
        }
        this.rebindLocked(new ParsedIOR(this.orb, object_reference), isPermanent, forceRebind, delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rebindLocked(ParsedIOR ior, boolean isPermanent, boolean forceRebind, Delegate delegate) {
        this.lockBarrier();
        try {
            Set set = this.pending_replies;
            synchronized (set) {
                Iterator i2 = this.pending_replies.iterator();
                while (i2.hasNext()) {
                    ReplyPlaceholder reply = (ReplyPlaceholder)i2.next();
                    reply.retry();
                }
            }
            boolean bl = this.rebindInternal(ior, isPermanent, forceRebind, delegate);
            return bl;
        }
        finally {
            this.openBarrier();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rebindInternal(ParsedIOR newIOR, boolean isPermanent, boolean forceRebind, Delegate delegateForNewIOR) {
        boolean showRebind;
        String prefix = "Delegate [" + this.hashCode() + "]: ";
        String srVal = System.getProperty("ShowRebind");
        boolean bl = showRebind = srVal != null && srVal.equals("1");
        if (showRebind) {
            System.out.println(prefix + "rebindInternal: delegateForNewIOR = " + (delegateForNewIOR == null ? "null" : Integer.toHexString(delegateForNewIOR.hashCode())));
            System.out.println(prefix + "rebindInternal: forceRebind = " + forceRebind + ", delegateForNewIOR = " + (delegateForNewIOR == null ? "not present" : "present"));
        }
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            ParsedIOR oldIOR = this.getParsedIOR();
            if (!forceRebind) {
                boolean originalMatch = oldIOR.equals(newIOR);
                if (showRebind) {
                    System.out.println(prefix + "rebindInternal: oldIOR = " + oldIOR.toString());
                    System.out.println(prefix + "rebindInternal: originalMatch = " + originalMatch);
                }
                if (delegateForNewIOR != null) {
                    Protocol[] protocolsForNewIOR = delegateForNewIOR.getClientProtocols();
                    if (showRebind) {
                        System.out.println(prefix + "(1) protocols = " + (protocolsForNewIOR == null ? "not present" : "present"));
                    }
                    if (protocolsForNewIOR != null) {
                        if (showRebind) {
                            System.out.println(prefix + "(1) setting profile selector");
                            System.out.println(prefix + "(1) newIOR before = " + newIOR.toString());
                        }
                        newIOR.setProfileSelector(new SpecificProfileSelector(protocolsForNewIOR));
                        if (showRebind) {
                            System.out.println(prefix + "(1) newIOR after = " + newIOR.toString());
                        }
                    }
                } else {
                    Protocol[] thisProtocols = this.getClientProtocols();
                    if (showRebind) {
                        System.out.println(prefix + "(2) protocols = " + (thisProtocols == null ? "not present" : "present"));
                    }
                    if (thisProtocols != null) {
                        if (showRebind) {
                            System.out.println(prefix + "(2) setting profile selector");
                            System.out.println(prefix + "(2) newIOR before = " + newIOR.toString());
                        }
                        newIOR.setProfileSelector(new SpecificProfileSelector(thisProtocols));
                        if (showRebind) {
                            System.out.println(prefix + "(2) newIOR after = " + newIOR.toString());
                        }
                    }
                }
                if (showRebind) {
                    System.out.println(prefix + "code paths merged");
                    System.out.println(prefix + "originalMatch = " + originalMatch);
                }
                if (originalMatch && newIOR.equals(oldIOR)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Ignore rebind request. Already bound to that target");
                    }
                    if (showRebind) {
                        System.out.println(prefix + "new IOR still matches old IOR, dropping out");
                    }
                    return false;
                }
            }
            if (!(newIOR.isIOGR() && isPermanent || this.rebindRetryStrategy == null)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("keep original IOR (" + oldIOR.getIORString() + ") for fallback");
                }
                this.rebindRetryStrategy.pushIOR(oldIOR);
            } else {
                this.logger.debug("doing permanent rebind");
            }
            this.parsedIOR = newIOR;
            this.disconnect();
            this.bind(this.parsedIOR.isIOGR());
            return true;
        }
    }

    public org.omg.CORBA.Request create_request(Object self, Context ctx, String operation, NVList args, NamedValue result) {
        this.checkORB();
        this.bind();
        return new Request(self, this.orb, this.connections[this.currentConnection], this.getParsedIOR().get_object_key(), operation, args, ctx, result);
    }

    public org.omg.CORBA.Request create_request(Object self, Context ctx, String operation, NVList args, NamedValue result, ExceptionList exceptions, ContextList contexts) {
        this.checkORB();
        this.bind();
        return new Request(self, this.orb, this.connections[this.currentConnection], this.getParsedIOR().get_object_key(), operation, args, ctx, result, exceptions, contexts);
    }

    public Object duplicate(Object self) {
        return this.orb._getDelegate(new ParsedIOR(this.orb, this.toString()));
    }

    public boolean equals(java.lang.Object obj) {
        return obj instanceof Object && this.toString().equals(obj.toString());
    }

    public boolean equals(Object self, java.lang.Object obj) {
        return this.equals(obj);
    }

    public DomainManager[] get_domain_managers(Object self) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Policy get_policy(Object self, int policy_type) {
        Policy policy;
        Policy result = this.get_client_policy(policy_type);
        if (result != null) {
            return result;
        }
        OutputStream request = this.request(self, "_get_policy", true);
        try {
            policy = this.get_policy(self, policy_type, request);
            java.lang.Object var7_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var7_7 = null;
            try {
                request.close();
            }
            catch (IOException e2) {
                this.logger.warn("error closing stream", e2);
            }
            throw throwable;
        }
        try {
            request.close();
        }
        catch (IOException e2) {
            this.logger.warn("error closing stream", e2);
        }
        return policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Policy get_client_policy(int policy_type) {
        Policy[] orbPolicies;
        PolicyManager policyManager;
        Policy result = null;
        if (this.disableClientOrbPolicies) {
            return null;
        }
        Map map = this.policy_overrides;
        synchronized (map) {
            Integer key = ObjectUtil.newInteger(policy_type);
            result = (Policy)this.policy_overrides.get(key);
        }
        if (result == null && (policyManager = this.orb.getPolicyManager()) != null && (orbPolicies = policyManager.get_policy_overrides(new int[]{policy_type})) != null && orbPolicies.length == 1) {
            result = orbPolicies[0];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Policy get_policy(Object self, int policy_type, OutputStream os) {
        while (true) {
            try {
                Policy policy;
                os.write_Object(self);
                os.write_long(policy_type);
                InputStream is = this.invoke(self, os);
                try {
                    policy = PolicyHelper.narrow(is.read_Object());
                    java.lang.Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    java.lang.Object var7_9 = null;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        this.logger.warn("error closing stream", e2);
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (IOException e2) {
                    this.logger.warn("error closing stream", e2);
                }
                return policy;
            }
            catch (RemarshalException e3) {
                continue;
            }
            break;
        }
        catch (ApplicationException e4) {
            throw new INTERNAL("Unexpected exception " + e4.getId());
        }
    }

    public UtcT getRequestEndTime() {
        Policy policy = this.get_client_policy(28);
        if (policy != null) {
            return ((RequestEndTimePolicy)policy).end_time();
        }
        return null;
    }

    public UtcT getReplyEndTime() {
        Policy policy = this.get_client_policy(30);
        if (policy != null) {
            return ((ReplyEndTimePolicy)policy).end_time();
        }
        return null;
    }

    public UtcT getRequestStartTime() {
        Policy policy = this.get_client_policy(27);
        if (policy != null) {
            return ((RequestStartTimePolicy)policy).start_time();
        }
        return null;
    }

    public UtcT getReplyStartTime() {
        Policy policy = this.get_client_policy(29);
        if (policy != null) {
            return ((ReplyStartTimePolicy)policy).start_time();
        }
        return null;
    }

    public long getRelativeRoundtripTimeout() {
        Policy policy = this.get_client_policy(32);
        if (policy != null) {
            return ((RelativeRoundtripTimeoutPolicy)policy).relative_expiry();
        }
        return -1L;
    }

    public long getRelativeRequestTimeout() {
        Policy policy = this.get_client_policy(31);
        if (policy != null) {
            return ((RelativeRequestTimeoutPolicy)policy).relative_expiry();
        }
        return -1L;
    }

    public short getSyncScope(boolean responseExcepted) {
        if (responseExcepted) {
            return 1;
        }
        Policy policy = this.get_client_policy(24);
        if (policy != null) {
            return ((SyncScopePolicy)policy).synchronization();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Defaulting to sync with transport");
        }
        return 1;
    }

    public Protocol[] getClientProtocols() {
        Policy policy = this.get_client_policy(43);
        if (policy != null) {
            return ((org.omg.RTCORBA.ClientProtocolPolicy)policy).protocols();
        }
        return null;
    }

    public InterfaceDef get_interface(Object self) {
        return InterfaceDefHelper.narrow(this.get_interface_def(self));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object get_interface_def(Object self) {
        this.checkORB();
        if (this.is_really_local(self)) {
            ServantObject so = this.servant_preinvoke(self, "_interface", java.lang.Object.class);
            if (so == null) {
                throw new OBJ_ADAPTER("Servant from pre_invoke was null");
            }
            try {
                Servant servant = (Servant)so.servant;
                this.orb.set_delegate(servant);
                Object object = servant._get_interface_def();
                return object;
            }
            finally {
                this.servant_postinvoke(self, so);
            }
        }
        while (true) {
            try {
                OutputStream os = this.request(self, "_interface", true);
                InputStream is = this.invoke(self, os);
                return is.read_Object();
            }
            catch (RemarshalException re) {
                continue;
            }
            break;
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientConnection getConnection() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            return this.connections[this.currentConnection];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOR getIOR() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (this.getPiorOriginal() != null) {
                return this.getPiorOriginal().getIOR();
            }
            return this.getParsedIOR().getIOR();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getObjectId() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            return POAUtil.extractOID(this.getParsedIOR().get_object_key());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getObjectKey() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            return this.getParsedIOR().get_object_key();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedIOR getParsedIOR() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (this.parsedIOR == null) {
                if (this.ior == null) {
                    throw new INTERNAL("Internal error - unable to initialise ParsedIOR as IOR is null");
                }
                this.parsedIOR = new ParsedIOR(this.orb, this.ior);
                this.ior = null;
            }
            return this.parsedIOR;
        }
    }

    public void resolvePOA(Object self) {
        if (!this.resolved_locality) {
            this.resolved_locality = true;
            POA local_poa = this.orb.findPOA(this, self);
            if (local_poa != null) {
                this.poa = local_poa;
            }
        }
    }

    public POA getPOA() {
        return this.poa;
    }

    public ObjectImpl getReference(POA _poa) {
        if (_poa != null) {
            this.poa = _poa;
        }
        Reference reference = new Reference(this.ior == null ? this.parsedIOR.getIOR().type_id : this.ior.type_id);
        reference._set_delegate(this);
        return reference;
    }

    public int hash(Object self, int x) {
        this.checkORB();
        return this.hashCode();
    }

    public int hashCode() {
        return this.getIDString().hashCode();
    }

    public int hashCode(Object self) {
        return this.hashCode();
    }

    public void invoke(Object self, OutputStream os, ReplyHandler replyHandler) throws ApplicationException, RemarshalException {
        this.invoke_internal(self, os, replyHandler, true);
    }

    public InputStream invoke(Object self, OutputStream os) throws ApplicationException, RemarshalException {
        return this.invoke_internal(self, os, null, false);
    }

    private InputStream invoke_internal(Object self, OutputStream os, ReplyHandler replyHandler, boolean async) throws ApplicationException, RemarshalException {
        try {
            InputStream in = this._invoke_internal(self, os, replyHandler, async);
            if (this.clearCurrentContext) {
                Delegate.clearInvocationContext();
            }
            return in;
        }
        catch (ApplicationException e2) {
            if (this.clearCurrentContext) {
                Delegate.clearInvocationContext();
            }
            throw e2;
        }
        catch (SystemException t2) {
            if (this.clearCurrentContext) {
                Delegate.clearInvocationContext();
            }
            throw t2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private InputStream _invoke_internal(Object self, OutputStream os, ReplyHandler replyHandler, boolean async) throws ApplicationException, RemarshalException {
        this.checkORB();
        RequestOutputStream ros = (RequestOutputStream)os;
        Stack invocationStack = (Stack)invocationContext.get();
        Map currentCtxt = null;
        if (!invocationStack.empty()) {
            currentCtxt = (Map)invocationStack.peek();
        }
        UtcT reqET = null;
        UtcT repET = null;
        if (currentCtxt != null) {
            reqET = (UtcT)currentCtxt.get(REQUEST_END_TIME);
            repET = (UtcT)currentCtxt.get(REPLY_END_TIME);
            this.checkTimeout(reqET, repET);
        }
        ReplyReceiver receiver = null;
        ClientInterceptorHandler interceptors = this.orb.hasClientRequestInterceptors() ? new DefaultClientInterceptorHandler((DefaultClientInterceptorHandler)localInterceptors.get(), this.orb, ros, self, this, this.getPiorOriginal(), this.connections[this.currentConnection]) : NullClientInterceptorHandler.getInstance();
        if (this.connections[this.currentConnection] != null) {
            this.orb.notifyTransportListeners(this.connections[this.currentConnection].getGIOPConnection());
        }
        if (this.orb.hasRequestInterceptors()) {
            localInterceptors.set(interceptors);
            try {
                interceptors.handle_send_request();
            }
            catch (ForwardRequest fwd) {
            }
            catch (RemarshalException re) {
                throw re;
            }
            catch (RuntimeException e2) {
                localInterceptors.set(null);
                throw e2;
            }
        }
        ClientConnection connectionToUse = null;
        Profile profile = this.getParsedIOR().getEffectiveProfile();
        try {
            block38: {
                try {
                    java.lang.Object object = this.bind_sync;
                    // MONITORENTER : object
                    if (!this.bound) {
                        throw new COMM_FAILURE("Connection closed");
                    }
                    if (ros.getConnection() != this.connections[this.currentConnection]) {
                        this.logger.debug("invoke: RemarshalException due to stale connection");
                        throw new RemarshalException();
                    }
                    connectionToUse = this.connections[this.currentConnection];
                    // MONITOREXIT : object
                    if (!ros.response_expected()) {
                        this.invoke_oneway(ros, connectionToUse, interceptors);
                        break block38;
                    }
                    receiver = new ReplyReceiver(this, ros.operation(), ros.getReplyEndTime(), interceptors, replyHandler);
                    receiver.configure(this.configuration);
                    object = this.pending_replies;
                    // MONITORENTER : object
                    this.pending_replies.add(receiver);
                    // MONITOREXIT : object
                    connectionToUse.sendRequest(ros, receiver, ros.requestId(), true);
                }
                catch (SystemException e3) {
                    boolean check;
                    this.logger.debug("invoke[-->]: SystemException", e3);
                    if (!async) {
                        Set set = this.pending_replies;
                        // MONITORENTER : set
                        this.pending_replies.remove(receiver);
                        // MONITOREXIT : set
                    }
                    try {
                        interceptors.handle_receive_exception(e3);
                    }
                    catch (ForwardRequest fwd) {
                        // empty catch block
                    }
                    boolean bl = this.getParsedIOR().isIOGR() ? true : (check = !this.locForwardRebind);
                    if (check && this.try_rebind(this.getParsedIOR(), e3, ros.getServiceContextList(), profile)) {
                        throw new RemarshalException();
                    }
                    this.disconnect(connectionToUse);
                    throw e3;
                }
            }
            java.lang.Object var19_20 = null;
            if (this.orb.hasRequestInterceptors()) {
                localInterceptors.set(null);
            }
            if (ros.syncScope() != 0) {
                ros.close();
            }
            this.locForwardRebind = false;
        }
        catch (Throwable throwable) {
            java.lang.Object var19_21 = null;
            if (this.orb.hasRequestInterceptors()) {
                localInterceptors.set(null);
            }
            if (ros.syncScope() != 0) {
                ros.close();
            }
            this.locForwardRebind = false;
            throw throwable;
        }
        try {
            if (async) return null;
            if (receiver == null) return null;
            ReplyInputStream is = receiver.getReply();
            ((CDRInputStream)is).updateMutatorConnection(connectionToUse.getGIOPConnection());
            ReplyInputStream check = is;
            return check;
        }
        catch (SystemException e4) {
            this.logger.debug("invoke[<--]: SystemException", e4);
            boolean check = true;
            if (this.queryingIMR) {
                check = false;
            }
            if (check && this.try_rebind(this.getParsedIOR(), e4, ros.getServiceContextList(), profile)) {
                throw new RemarshalException();
            }
            Set set = this.pending_replies;
            // MONITORENTER : set
            this.pending_replies.remove(receiver);
            // MONITOREXIT : set
            this.disconnect(connectionToUse);
            throw e4;
        }
        finally {
            this.queryingIMR = false;
        }
    }

    private void checkTimeout(UtcT reqET, UtcT repET) {
        if (reqET != null && Time.hasPassed(reqET)) {
            throw new TIMEOUT("Request End Time exceeded", 2, CompletionStatus.COMPLETED_NO);
        }
        if (repET != null && Time.hasPassed(repET)) {
            throw new TIMEOUT("Reply End Time exceeded", 3, CompletionStatus.COMPLETED_NO);
        }
    }

    private void invoke_oneway(RequestOutputStream ros, ClientConnection connectionToUse, ClientInterceptorHandler interceptors) throws RemarshalException, ApplicationException {
        switch (ros.syncScope()) {
            case 0: {
                RequestOutputStream copy = new RequestOutputStream(ros);
                this.passToTransport(connectionToUse, copy);
                try {
                    interceptors.handle_receive_other((short)0);
                }
                catch (ForwardRequest fwd) {}
                break;
            }
            case 1: {
                connectionToUse.sendRequest(ros, false);
                try {
                    interceptors.handle_receive_other((short)0);
                }
                catch (ForwardRequest fwd) {}
                break;
            }
            case 2: 
            case 3: {
                ReplyReceiver rcv = new ReplyReceiver(this, ros.operation(), ros.getReplyEndTime(), interceptors, null);
                rcv.configure(this.configuration);
                if (this.connections[1] != null) {
                    this.connections[1].sendRequest(ros, false);
                } else {
                    this.connections[0].sendRequest(ros, rcv, ros.requestId(), true);
                }
                ReplyInputStream in = rcv.getReply();
                try {
                    interceptors.handle_receive_reply(in);
                }
                catch (ForwardRequest fwd) {}
                break;
            }
            default: {
                throw new MARSHAL("Illegal SYNC_SCOPE: " + ros.syncScope(), 0, CompletionStatus.COMPLETED_MAYBE);
            }
        }
    }

    private void passToTransport(final ClientConnection connectionToUse, final RequestOutputStream ros) {
        new Thread(new Runnable(){

            public void run() {
                block2: {
                    try {
                        connectionToUse.sendRequest(ros, false);
                        ros.close();
                    }
                    catch (SystemException e2) {
                        if (!Delegate.this.logger.isWarnEnabled()) break block2;
                        Delegate.this.logger.warn("Caught CORBA SystemException ", e2);
                    }
                }
            }
        }, "PassToTransport").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean try_rebind(ParsedIOR failingIOR, SystemException cause, List serviceContexts, Profile currentProfile) {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (!currentProfile.equals(failingIOR.getEffectiveProfile())) {
                return true;
            }
            return this.rebindRetryStrategy.try_rebind(this.rebindCallback, failingIOR, cause, serviceContexts);
        }
    }

    public void invokeInterceptors(ClientRequestInfoImpl info, short op) throws RemarshalException {
        block3: {
            ClientInterceptorIterator intercept_iter = this.orb.getInterceptorManager().getClientIterator();
            try {
                intercept_iter.iterate(info, op);
            }
            catch (ForwardRequest fwd) {
                this.rebind(fwd.forward);
                throw new RemarshalException();
            }
            catch (UserException ue) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error(ue.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean is_a(Object self, String logical_type_id) {
        if (this.ior != null && this.ior.type_id.equals(logical_type_id)) {
            return true;
        }
        ParsedIOR pior = this.getParsedIOR();
        if (pior.getTypeId().equals(logical_type_id)) {
            return true;
        }
        String[] ids = ((ObjectImpl)self)._ids();
        for (int i2 = 0; i2 < ids.length - 1; ++i2) {
            if (!ids[i2].equals(logical_type_id)) continue;
            return true;
        }
        if (this.is_really_local(self)) {
            ServantObject so;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Located " + self + " on local POA; assuming local.");
            }
            if ((so = this.servant_preinvoke(self, "_is_a", java.lang.Object.class)) == null) {
                throw new OBJ_ADAPTER("Servant from pre_invoke was null");
            }
            try {
                Servant servant = (Servant)so.servant;
                this.orb.set_delegate(servant);
                boolean bl = servant._is_a(logical_type_id);
                return bl;
            }
            finally {
                this.servant_postinvoke(self, so);
            }
        }
        if (!ids[0].equals("IDL:omg.org/CORBA/Object:1.0")) {
            try {
                String classname = RepositoryID.className(ids[0], "Stub", null);
                int lastDot = classname.lastIndexOf(46);
                StringBuffer buffer = new StringBuffer(classname.substring(0, lastDot + 1));
                buffer.append('_');
                buffer.append(classname.substring(lastDot + 1));
                Class stub = null;
                try {
                    stub = ObjectUtil.classForName(buffer.toString());
                }
                catch (ClassNotFoundException e2) {
                    stub = ObjectUtil.classForName("org.omg.stub." + buffer.toString());
                }
                Method idm = stub.getMethod("_ids", null);
                String[] newids = (String[])idm.invoke(stub.newInstance(), (java.lang.Object[])null);
                for (int i3 = 0; i3 < newids.length; ++i3) {
                    if (!newids[i3].equals(logical_type_id)) continue;
                    return true;
                }
            }
            catch (ClassNotFoundException e3) {
            }
            catch (IllegalArgumentException e4) {
            }
            catch (SecurityException e5) {
            }
            catch (NoSuchMethodException e6) {
            }
            catch (IllegalAccessException e7) {
            }
            catch (InvocationTargetException e8) {
            }
            catch (InstantiationException e9) {
            }
            catch (SystemException e10) {
                // empty catch block
            }
            this.logger.debug("trying is_a remotely");
        }
        while (true) {
            try {
                OutputStream os = this.request(self, "_is_a", true);
                os.write_string(logical_type_id);
                InputStream is = this.invoke(self, os);
                return is.read_boolean();
            }
            catch (RemarshalException re) {
                continue;
            }
            break;
        }
        catch (ApplicationException ax) {
            throw new INTERNAL("Unexpected exception " + ax.getId());
        }
    }

    public boolean is_equivalent(Object self, Object obj) {
        this.checkORB();
        boolean result = true;
        if (self != obj) {
            ParsedIOR pior1 = new ParsedIOR(this.orb, obj.toString());
            ParsedIOR pior2 = new ParsedIOR(this.orb, self.toString());
            result = pior2.getIDString().equals(pior1.getIDString());
        }
        return result;
    }

    public String getIDString() {
        return this.getParsedIOR().getIDString();
    }

    public boolean is_local(Object self) {
        if (ignoreNextCallToIsLocal.get() == Boolean.TRUE) {
            ignoreNextCallToIsLocal.set(Boolean.FALSE);
            return false;
        }
        return this.is_really_local(self);
    }

    private boolean is_really_local(Object self) {
        if (this.poa == null) {
            this.resolvePOA(self);
        }
        return this.poa != null;
    }

    public boolean is_nil() {
        ParsedIOR pior = this.getParsedIOR();
        return pior.is_nil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean non_existent(Object self) {
        if (this.is_really_local(self)) {
            ServantObject so = this.servant_preinvoke(self, "_non_existent", java.lang.Object.class);
            try {
                Servant servant = (Servant)so.servant;
                this.orb.set_delegate(servant);
                boolean bl = servant._non_existent();
                return bl;
            }
            finally {
                this.servant_postinvoke(self, so);
            }
        }
        while (true) {
            try {
                OutputStream os = this.request(self, "_non_existent", true);
                InputStream is = this.invoke(self, os);
                return is.read_boolean();
            }
            catch (RemarshalException re) {
                continue;
            }
            break;
        }
        catch (ApplicationException e2) {
            throw new INTERNAL("Unexpected exception " + e2.getId());
        }
    }

    public org.omg.CORBA.ORB orb(Object self) {
        return this.orb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Object self) {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (!this.bound) {
                return;
            }
            this.disconnect();
            this.orb._release(this.getParsedIOR().getIORString());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Delegate released!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(ClientConnection connectionInUse) {
        if (connectionInUse == null) {
            return;
        }
        if (!this.disconnectAfterNonRecoverableSystemException) {
            return;
        }
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (this.connections[this.currentConnection] == null) {
                return;
            }
            if (this.connections[this.currentConnection] != connectionInUse) {
                return;
            }
            this.logger.debug("release the connection");
            this.conn_mg.releaseConnection(this.connections[this.currentConnection]);
            this.connections[this.currentConnection] = null;
            this.bound = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("release connections for " + this.parsedIOR);
            }
            if (this.connections[0] != null) {
                this.conn_mg.releaseConnection(this.connections[0]);
                this.connections[0] = null;
            }
            if (this.connections[1] != null) {
                this.conn_mg.releaseConnection(this.connections[1]);
                this.connections[1] = null;
            }
            this.bound = false;
        }
    }

    public void releaseReply(Object self, InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Time.waitFor(this.getReplyStartTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.CORBA.Request request(Object self, String operation) {
        this.orb.perform_work();
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            return new Request(self, this.orb, this.connections[this.currentConnection], this.getParsedIOR().get_object_key(), operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream request(Object self, String operation, boolean responseExpected) {
        this.orb.perform_work();
        Stack invocationStack = (Stack)invocationContext.get();
        HashMap<String, UtcT> currentCtxt = null;
        if (!invocationStack.empty() && ((currentCtxt = (HashMap<String, UtcT>)invocationStack.peek()).containsKey(INTERCEPTOR_CALL) || currentCtxt.containsKey(SERVANT_PREINVOKE) || currentCtxt.containsKey(IMR_LOCATE_CALL))) {
            this.clearCurrentContext = false;
        }
        if (currentCtxt == null) {
            currentCtxt = new HashMap<String, UtcT>();
            invocationStack.push(currentCtxt);
        }
        UtcT requestEndTime = (UtcT)currentCtxt.get(REQUEST_END_TIME);
        UtcT replyEndTime = (UtcT)currentCtxt.get(REPLY_END_TIME);
        if (!this.disableClientOrbPolicies) {
            if (requestEndTime == null) {
                requestEndTime = this.getRequestEndTime();
                long requestTimeout = this.getRelativeRequestTimeout();
                if ((requestTimeout > 0L || requestEndTime != null) && Time.hasPassed(requestEndTime = Time.earliest(Time.corbaFuture(requestTimeout), requestEndTime))) {
                    if (this.clearCurrentContext) {
                        Delegate.clearInvocationContext();
                    }
                    throw new TIMEOUT("Request End Time exceeded prior to invocation", 2, CompletionStatus.COMPLETED_NO);
                }
                currentCtxt.put(REQUEST_END_TIME, requestEndTime);
            } else if (Time.hasPassed(requestEndTime)) {
                if (this.clearCurrentContext) {
                    Delegate.clearInvocationContext();
                }
                throw new TIMEOUT("Request End Time exceeded", 2, CompletionStatus.COMPLETED_NO);
            }
            if (replyEndTime == null) {
                replyEndTime = this.getReplyEndTime();
                long roundtripTimeout = this.getRelativeRoundtripTimeout();
                if ((roundtripTimeout > 0L || replyEndTime != null) && Time.hasPassed(replyEndTime = Time.earliest(Time.corbaFuture(roundtripTimeout), replyEndTime))) {
                    if (this.clearCurrentContext) {
                        Delegate.clearInvocationContext();
                    }
                    throw new TIMEOUT("Reply End Time exceeded prior to invocation", 3, CompletionStatus.COMPLETED_NO);
                }
                currentCtxt.put(REPLY_END_TIME, replyEndTime);
            } else if (Time.hasPassed(replyEndTime)) {
                if (this.clearCurrentContext) {
                    Delegate.clearInvocationContext();
                }
                throw new TIMEOUT("Reply End Time exceeded", 3, CompletionStatus.COMPLETED_NO);
            }
        }
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            ParsedIOR ior = this.getParsedIOR();
            Profile profile = ior.getEffectiveProfile();
            byte[] objectKey = profile.get_object_key();
            int giopMinor = profile.version().minor;
            if (profile instanceof MIOPProfile) {
                if (responseExpected) {
                    IIOPProfile ip = ((MIOPProfile)profile).getGroupIIOPProfile();
                    if (ip == null) {
                        throw new INV_OBJREF("No Group IIOP Profile so unable to send a two-way request.");
                    }
                    objectKey = ip.get_object_key();
                    this.currentConnection = 0;
                } else {
                    this.currentConnection = 1;
                }
                giopMinor = this.defaultGiopMinor;
            } else {
                objectKey = this.svcObjectID == null ? ior.get_object_key() : this.svcObjectID;
                this.currentConnection = 0;
            }
            GIOPConnection giopConnection = this.connections[this.currentConnection].getGIOPConnection();
            Connection transport = giopConnection.getTransport();
            if (this.isCtxNegotiated() && !transport.is_connected()) {
                this.setSvcObjectID(null);
                this.setCtxNegotiated(false);
            } else if (this.socketHash != -1 && this.isCtxNegotiated() && transport.hashCode() != this.socketHash) {
                this.setSvcObjectID(null);
                this.setCtxNegotiated(false);
            }
            if (!(profile instanceof MIOPProfile)) {
                objectKey = this.svcObjectID == null ? ior.get_object_key() : this.svcObjectID;
                this.currentConnection = 0;
            }
            RequestOutputStream out = new RequestOutputStream(this.orb, this.connections[this.currentConnection], this.connections[this.currentConnection].getId(), operation, responseExpected, this.getSyncScope(responseExpected), this.getRequestStartTime(), requestEndTime, replyEndTime, objectKey, giopMinor);
            if (!this.connections[this.currentConnection].isTCSNegotiated()) {
                this.connections[this.currentConnection].setCodeSet(ior);
            }
            if (!this.isCtxNegotiated() && !this.disableSvcNegotiation) {
                out.addServiceContext(new ServiceContext(1245904912, new byte[]{1}));
            }
            out.setCodeSet(this.connections[this.currentConnection].getTCS(), this.connections[this.currentConnection].getTCSW());
            out.updateMutatorConnection(giopConnection);
            return out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void servant_postinvoke(Object self, ServantObject servant) {
        try {
            block23: {
                if (this.orb.hasRequestInterceptors()) {
                    ServerRequestInfoImpl sinfo = ((ServantObjectImpl)servant).getServerRequestInfo();
                    DefaultClientInterceptorHandler interceptors = ((ServantObjectImpl)servant).getClientInterceptorHandler();
                    if (sinfo != null && interceptors != null) {
                        interceptors.getInfo().setReplyServiceContexts(sinfo.getReplyServiceContextsArray());
                        try {
                            if (sinfo.reply_status() == 0) {
                                interceptors.handle_receive_reply(null);
                            } else if (sinfo.reply_status() == 1) {
                                interceptors.handle_receive_exception(SystemExceptionHelper.read(sinfo.sending_exception().create_input_stream()));
                            } else if (sinfo.reply_status() == 3) {
                                try {
                                    interceptors.handle_location_forward(null, sinfo.forward_reference());
                                }
                                catch (BAD_INV_ORDER bio) {
                                    interceptors.handle_receive_other(sinfo.reply_status());
                                }
                            } else if (sinfo.reply_status() == 2) {
                                interceptors.handle_receive_other(sinfo.reply_status());
                            }
                        }
                        catch (ForwardRequest fwd) {
                            throw new RuntimeException(fwd);
                        }
                        catch (RemarshalException re) {
                            // empty catch block
                        }
                    }
                }
                if (this.poa != null && this.poa.isUseServantManager() && !this.poa.isRetain() && this.cookie != null && this.invokedOperation != null) {
                    try {
                        byte[] oid = POAUtil.extractOID(this.getParsedIOR().get_object_key());
                        ServantLocator sl = (ServantLocator)this.poa.get_servant_manager();
                        sl.postinvoke(oid, this.poa, this.invokedOperation, this.cookie.value, (Servant)servant.servant);
                        this.cookie = null;
                        this.invokedOperation = null;
                    }
                    catch (Throwable e2) {
                        if (!this.logger.isWarnEnabled()) break block23;
                        this.logger.warn(e2.getMessage());
                    }
                }
            }
            java.lang.Object var7_9 = null;
            if (this.poa != null) {
                this.poa.removeLocalRequest();
            }
            this.orb.getPOACurrent()._removeContext(Thread.currentThread());
            if (this.orb.getInterceptorManager() != null) {
                this.orb.getInterceptorManager().removeLocalPICurrent();
            }
        }
        catch (Throwable throwable) {
            java.lang.Object var7_10 = null;
            if (this.poa != null) {
                this.poa.removeLocalRequest();
            }
            this.orb.getPOACurrent()._removeContext(Thread.currentThread());
            if (this.orb.getInterceptorManager() != null) {
                this.orb.getInterceptorManager().removeLocalPICurrent();
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public ServantObject servant_preinvoke(Object self, String operation, Class expectedType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (this.getPiorOriginal() != null) {
                return this.getPiorOriginal().getIORString();
            }
            return this.getParsedIOR().getIORString();
        }
    }

    public String toString(Object self) {
        return this.toString();
    }

    public String typeId() {
        return this.getParsedIOR().getIOR().type_id;
    }

    private void showPolicies(String name, Policy[] policies) {
        if (policies == null) {
            System.out.println(name + "policies array null");
        } else {
            System.out.println(name + "policies array count = " + policies.length);
            for (int i2 = 0; i2 < policies.length; ++i2) {
                System.out.println(name + "policy " + (i2 + 1) + " of " + policies.length);
                this.showPolicy(name, policies[i2]);
            }
        }
    }

    private void showPolicies(String name, Map policies) {
        if (policies == null) {
            System.out.println(name + "policies map null");
        } else if (policies.size() == 0) {
            System.out.println(name + "policies map empty");
        } else {
            System.out.println(name + "policies map size = " + policies.size());
            Set keys = policies.keySet();
            Iterator keysIter = keys.iterator();
            while (keysIter.hasNext()) {
                java.lang.Object key = keysIter.next();
                Policy policy = (Policy)policies.get(key);
                this.showPolicy(name + "key = " + key, policy);
            }
        }
    }

    private void showPolicy(String name, Policy policy) {
        if (policy == null) {
            System.out.println(name + ": policy is null");
        } else {
            ClientProtocolPolicy pol = (ClientProtocolPolicy)policy;
            Protocol[] protocols = pol.protocols();
            System.out.println("  Policy type = " + pol.policy_type() + (protocols == null ? ", null protocols" : ", protocol count = " + protocols.length));
            if (protocols != null) {
                for (int j2 = 0; j2 < protocols.length; ++j2) {
                    System.out.println("    " + protocols[j2].protocol_type);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set_policy_override(Object self, Policy[] policies, SetOverrideType set_add) {
        boolean showPolicies;
        if (this.disableClientOrbPolicies) {
            throw new BAD_PARAM("policy override is disabled per configuration");
        }
        Object result = this.duplicate(self);
        Delegate delResult = (Delegate)((ObjectImpl)result)._get_delegate();
        String hcPrefix = "[this:" + this.hashCode() + "/result:" + result.hashCode() + "/delResult: " + delResult.hashCode() + "] set_policy_override: ";
        String spVal = System.getProperty("ShowPolicies");
        boolean bl = showPolicies = spVal != null && spVal.equals("1");
        if (showPolicies) {
            this.showPolicies(hcPrefix + "delResult initial policy override: ", delResult.policy_overrides);
        }
        Map map = this.policy_overrides;
        synchronized (map) {
            if (set_add == SetOverrideType.ADD_OVERRIDE) {
                delResult.policy_overrides.putAll(this.policy_overrides);
                if (showPolicies) {
                    System.out.println(hcPrefix + "added current policy overrides to delResult due to ADD_OVERRIDE");
                    this.showPolicies(hcPrefix + "delResult policy overrides now: ", delResult.policy_overrides);
                }
            }
        }
        if (showPolicies) {
            this.showPolicies(hcPrefix + "adding following policies to delResult: ", policies);
        }
        for (int i2 = 0; i2 < policies.length; ++i2) {
            delResult.policy_overrides.put(ObjectUtil.newInteger(policies[i2].policy_type()), policies[i2]);
        }
        if (showPolicies) {
            this.showPolicies(hcPrefix + "delResult policy overrides now: ", delResult.policy_overrides);
        }
        return result;
    }

    public String get_codebase(Object self) {
        return this.getParsedIOR().getCodebaseComponent();
    }

    public Set get_pending_replies() {
        return this.pending_replies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyDone(ReplyPlaceholder placeholder) {
        Set set = this.pending_replies;
        synchronized (set) {
            this.pending_replies.remove(placeholder);
        }
    }

    public void lockBarrier() {
        this.pending_replies_sync.lockBarrier();
    }

    public void waitOnBarrier() {
        this.pending_replies_sync.waitOnBarrier();
    }

    public void openBarrier() {
        this.pending_replies_sync.openBarrier();
    }

    private void checkORB() {
        this.orb.work_pending();
    }

    public boolean isCtxNegotiated() {
        return this.ctxNegotiated;
    }

    public void setCtxNegotiated(boolean status) {
        this.ctxNegotiated = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSvcObjectID(byte[] id) {
        block15: {
            if (id == null) {
                this.svcObjectID = id;
            } else {
                CDRInputStream is = new CDRInputStream(this.orb, id);
                try {
                    if (is.available() < 8) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Internal error - received JAC context key with " + is.available());
                        }
                        throw new INTERNAL("Internal error - JAC service context key has " + is.available());
                    }
                    if (is.available() < 12) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Warning  - received JAC context key with " + is.available() + " - using incompatible version of JacORB key system. Disabling key system.");
                        }
                        this.svcObjectID = null;
                        break block15;
                    }
                    this.svcObjectID = new byte[11];
                    is.openEncapsulatedArray();
                    is.read_octet_array(this.svcObjectID, 0, this.svcObjectID.length);
                    java.lang.Object object = this.bind_sync;
                    synchronized (object) {
                        block16: {
                            if (this.bound) break block16;
                            if (this.logger.isWarnEnabled()) {
                                this.logger.warn("Connection has been released ; not updating socket hashCode");
                            }
                            return;
                        }
                        this.socketHash = this.connections[this.currentConnection].getGIOPConnection().getTransport().hashCode();
                    }
                }
                finally {
                    is.close();
                }
            }
        }
    }

    private ParsedIOR getPiorOriginal() {
        return (ParsedIOR)(this.rebindRetryStrategy == null ? null : this.rebindRetryStrategy.getOriginalIOR());
    }

    public boolean isIOGR() {
        return this.getParsedIOR().isIOGR();
    }

    public boolean isHeartbeatEnabled() {
        return this.getParsedIOR().isHeartbeatEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object get_component(Object self) {
        if (this.is_really_local(self)) {
            ServantObject so = this.servant_preinvoke(self, "_get_component", java.lang.Object.class);
            try {
                Servant servant = (Servant)so.servant;
                this.orb.set_delegate(servant);
                Object object = servant._get_component();
                return object;
            }
            finally {
                this.servant_postinvoke(self, so);
            }
        }
        while (true) {
            try {
                OutputStream os = this.request(self, "_get_component", true);
                InputStream is = this.invoke(self, os);
                return is.read_Object();
            }
            catch (RemarshalException re) {
                continue;
            }
            break;
        }
        catch (ApplicationException e2) {
            throw new INTERNAL("Unexpected exception " + e2.getId());
        }
    }

    private static class Barrier {
        private boolean is_open = true;

        private Barrier() {
        }

        public synchronized void waitOnBarrier() {
            while (!this.is_open) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void lockBarrier() {
            this.is_open = false;
        }

        public synchronized void openBarrier() {
            this.is_open = true;
            this.notifyAll();
        }
    }
}

