/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.NoBiDirClientRequestListener;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.portableInterceptor.DefaultClientInterceptor;
import org.omg.CORBA.Any;
import org.omg.ETF.Profile;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ForwardRequest;

public class BiDirConnectionClientInterceptor
extends DefaultClientInterceptor {
    private static final String name = "BiDirConnectionClientInterceptor";
    private final transient ORB orb;
    private ServiceContext bidir_ctx = null;

    public BiDirConnectionClientInterceptor(ORB orb) {
        this.orb = orb;
    }

    public String name() {
        return name;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        if (this.orb.useBiDirGIOP() && ((ClientRequestInfoImpl)ri).connection.isClientInitiated()) {
            if (this.bidir_ctx == null) {
                BasicAdapter ba = this.orb.getBasicAdapter();
                List endpoints = ba.getEndpointProfiles();
                Iterator i2 = endpoints.iterator();
                ArrayList listenPoints = new ArrayList();
                while (i2.hasNext()) {
                    Profile profile = (Profile)i2.next();
                    if (profile instanceof ProfileBase) {
                        listenPoints.addAll(((ProfileBase)profile).asListenPoints());
                        continue;
                    }
                    listenPoints.addAll(this.getListenPoints(profile));
                }
                ListenPoint[] listenPointsArray = listenPoints.toArray(new ListenPoint[listenPoints.size()]);
                BiDirIIOPServiceContext context = new BiDirIIOPServiceContext(listenPointsArray);
                Any any = this.orb.create_any();
                BiDirIIOPServiceContextHelper.insert(any, context);
                CDROutputStream cdr_out = new CDROutputStream(this.orb);
                try {
                    cdr_out.beginEncapsulatedArray();
                    BiDirIIOPServiceContextHelper.write(cdr_out, context);
                    this.bidir_ctx = new ServiceContext(5, cdr_out.getBufferCopy());
                }
                finally {
                    cdr_out.close();
                }
            }
            ri.add_request_service_context(this.bidir_ctx, true);
            GIOPConnection conn = ((ClientRequestInfoImpl)ri).connection.getGIOPConnection();
            if (conn.getRequestListener() instanceof NoBiDirClientRequestListener) {
                conn.setRequestListener(this.orb.getBasicAdapter().getRequestListener());
            }
        }
    }

    protected Collection getListenPoints(Profile profile) {
        return Collections.EMPTY_LIST;
    }
}

