/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.miop;

import java.io.ByteArrayOutputStream;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.omg.MIOP.PacketHeader_1_0;

public class FragmentedMessage
implements Configurable {
    public static final int NUMBER_OF_FRAGMENTS = 4;
    public static final int FRAGMENT_INCREMENT = 2;
    private final long creationTime = System.currentTimeMillis();
    private int numberOfFragments = 4;
    private byte[][] fragments;
    private int lastPacketArrived = -1;
    private int maxPacketArrived = -1;
    private int packetsReceived = 0;
    private boolean end_flag_dependent = false;
    private boolean end_flag_received = false;
    private int completionTimeout;
    private int packetDataMaxSize;

    protected boolean canBeDiscarded() {
        return this.end_flag_received && !this.isComplete() || System.currentTimeMillis() - this.creationTime > (long)(this.numberOfFragments * this.completionTimeout);
    }

    byte[] buildMessage() {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.numberOfFragments * this.packetDataMaxSize);
        for (int i2 = 0; i2 <= this.maxPacketArrived; ++i2) {
            out.write(this.fragments[i2], 0, this.fragments[i2].length);
        }
        return out.toByteArray();
    }

    protected boolean isComplete() {
        if (this.end_flag_dependent) {
            if (this.end_flag_received) {
                for (int i2 = 0; i2 < this.maxPacketArrived; ++i2) {
                    if (this.fragments[i2] != null) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return this.packetsReceived == this.numberOfFragments;
    }

    protected synchronized void addFragment(PacketHeader_1_0 header, byte[] fragment) {
        if (this.fragments == null) {
            if (header.number_of_packets > 0) {
                this.numberOfFragments = header.number_of_packets;
            } else {
                this.end_flag_dependent = true;
            }
            this.fragments = new byte[this.numberOfFragments][];
        }
        this.lastPacketArrived = header.packet_number;
        if (this.lastPacketArrived > this.maxPacketArrived) {
            this.maxPacketArrived = this.lastPacketArrived;
            if (this.maxPacketArrived >= this.fragments.length) {
                byte[][] oldFragments = this.fragments;
                this.numberOfFragments += 2;
                this.fragments = new byte[this.numberOfFragments][];
                System.arraycopy(oldFragments, 0, this.fragments, 0, oldFragments.length);
            }
        }
        if (this.fragments[this.lastPacketArrived] == null) {
            this.fragments[this.lastPacketArrived] = fragment;
            ++this.packetsReceived;
        }
        if (this.end_flag_dependent) {
            this.end_flag_received = (header.flags & 2) == 2;
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.completionTimeout = config.getAttributeAsInteger("jacorb.miop.message_completion_timeout", 500);
        int packetMax = config.getAttributeAsInteger("jacorb.miop.packet_max_size", 1500);
        this.packetDataMaxSize = packetMax - 60;
    }
}

