/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moproperties.view.gui;

import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.moproperties.controller.AttributeModelFetcherListener;
import se.ericsson.cello.emt.moproperties.controller.MoPropertiesController;
import se.ericsson.cello.emt.motools.common.gui.components.ArrayGUI;
import se.ericsson.cello.emt.motools.common.gui.components.AttributeJLabel;
import se.ericsson.cello.emt.motools.common.gui.components.ComponentFactory;
import se.ericsson.cello.emt.motools.common.gui.components.DataTypeGUI;
import se.ericsson.cello.emt.motools.common.gui.components.EnumGUI;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.gui.components.InformationButtonGui;
import se.ericsson.cello.emt.motools.common.gui.components.LabelledComponentTable;
import se.ericsson.cello.emt.motools.common.gui.components.ObjectRefGUI;
import se.ericsson.cello.emt.motools.common.gui.components.StructGUI;
import se.ericsson.cello.emt.motools.common.momodel.AttributeModel;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypeGUICreator
extends LabelledComponentTable
implements GUI_Container,
AttributeModelFetcherListener {
    private static final long serialVersionUID = 8090950011234745151L;
    private AttributeModel myAttrModel = null;
    private DataTypeGUI theOnlyMemberGUI = null;
    private String myAttributeName = null;
    private JPanel myOwner = null;
    private String attrGroupName = null;
    private MoPropertiesController myMoPropController = null;

    public DataTypeGUICreator(MoPropertiesController controller, boolean visible, GUI_Container container, JPanel owner, String groupName, boolean showButton, ToolServices myToolServices, String anAttributeName) {
        super("", "", 2, 2, visible, container, myToolServices);
        this.fullName = groupName;
        this.attrGroupName = groupName;
        this.myOwner = owner;
        this.myMoPropController = controller;
        this.myAttributeName = anAttributeName;
    }

    private DataTypeGUI createNewDataTypeGuiForTheAttribute(final AttributeModel m) {
        MoPropLog.logger().fine("thread name : " + Thread.currentThread().getName());
        DataTypeGUI theDataTypeGUI = null;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DataTypeGUICreator.this.createNewDataTypeGuiForTheAttribute(m);
                }
            });
        } else if (null != m) {
            this.myAttrModel = m;
            MoPropLog.logger().fine("before buildAttributeArea()");
            this.buildAttributeArea(m);
        } else {
            MoPropLog.logger().info("No attribute model were included in the constructor.");
        }
        MoPropLog.logger().info("Done createNewDataTypeGuiForTheAttribute for: " + this.myAttrModel.getName());
        return theDataTypeGUI;
    }

    private DataTypeGUI buildAttributeArea(AttributeModel m) {
        MoPropLog.logger().fine("start building DataTypeGUI for " + this.myAttrModel.getName());
        AttributeModel attrModel = m;
        JPanel labelPanel = new JPanel();
        JPanel infoBtnPanel = new JPanel();
        labelPanel.setLayout(new FlowLayout(0, 0, 0));
        InformationButtonGui infoButtonGui = new InformationButtonGui(this, this.myToolServices);
        infoButtonGui.setName(attrModel.getName());
        infoButtonGui.setDescription(attrModel.getMomAttribute().getExtendedDescription());
        infoBtnPanel.add(infoButtonGui);
        labelPanel.add(infoBtnPanel);
        labelPanel.add(new AttributeJLabel(attrModel));
        labelPanel.setName(attrModel.getName() + "_Name");
        this.addI(labelPanel);
        DataTypeGUI valueGUI = null;
        boolean ro = true;
        this.theOnlyMemberGUI = valueGUI = ComponentFactory.create(attrModel.getTypeValue(), ro, this, attrModel.getName(), false, this.myToolServices);
        this.addI(valueGUI);
        valueGUI.setLayout(new FlowLayout(0, 0, 12));
        return this;
    }

    @Override
    public void notifyAttributeModelsDone(List<AttributeModel> aAttributeModelList) {
        if (null != aAttributeModelList && aAttributeModelList.size() > 0) {
            this.myAttrModel = aAttributeModelList.get(0);
        }
        this.createNewDataTypeGuiForTheAttribute(this.myAttrModel);
    }

    @Override
    public void updateNeeded() {
        if (null != this.myOwner) {
            this.myOwner.validate();
        }
    }

    @Override
    public void valueChanged() {
    }

    public void readAttribute() {
        if (null != this.myAttributeName) {
            ArrayList<String> listOfAttrNames = new ArrayList<String>();
            listOfAttrNames.add(this.myAttributeName);
            MoPropLog.logger().fine("before myMoPropController.getAttributeModelsAsync for attr group: " + this.attrGroupName);
            this.myMoPropController.getAttributeModelsAsynchronousForSelectedAttributes(this.attrGroupName, this, listOfAttrNames);
        } else {
            MoPropLog.logger().fine("no need to read get attribute models, since the GUI is already initialized, attr group: " + this.attrGroupName);
        }
    }

    public DataTypeGUI getDataTypeGUI() {
        return this.theOnlyMemberGUI;
    }

    public AttributeModel getAttributeModel() {
        return this.myAttrModel;
    }

    public boolean isAttributeOfPrimitiveType() {
        boolean result = true;
        if (null == this.theOnlyMemberGUI) {
            result = true;
        } else if (this.theOnlyMemberGUI instanceof ArrayGUI || this.theOnlyMemberGUI instanceof StructGUI || this.theOnlyMemberGUI instanceof EnumGUI || this.theOnlyMemberGUI instanceof ObjectRefGUI) {
            result = false;
        }
        return result;
    }

    public void updateGuiValueForPrimitives(String v) {
        IllegalStateException e = null;
        if (null == this.myAttrModel) {
            String reason = "Can not update. Update requested before attribute model is made for: " + this.myAttributeName;
            MoPropLog.logger().info(reason);
            e = new IllegalStateException(reason);
            throw e;
        }
        if (null == this.theOnlyMemberGUI) {
            String reason = "Can not update. Update requested before createNewDataTypeGuiForTheAttribute for: " + this.myAttrModel.getName();
            MoPropLog.logger().info(reason);
            e = new IllegalStateException(reason);
            throw e;
        }
        this.theOnlyMemberGUI.setValue(v);
    }
}

