/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moproperties.view.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.moproperties.controller.MoPropertiesController;
import se.ericsson.cello.emt.moproperties.controller.PushAttributeValueListener;
import se.ericsson.cello.emt.moproperties.model.MoPropertiesModel;
import se.ericsson.cello.emt.moproperties.view.MoPropertiesView;
import se.ericsson.cello.emt.moproperties.view.gui.ActionDetailsGUI;
import se.ericsson.cello.emt.moproperties.view.gui.AttributeGroupGUI;
import se.ericsson.cello.emt.motools.common.gui.components.CompactGridLayout;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.gui.components.InformationButtonGui;
import se.ericsson.cello.emt.motools.common.gui.components.LdnProvider;
import se.ericsson.cello.emt.motools.common.gui.components.PopupGotoGui;
import se.ericsson.cello.emt.motools.common.gui.components.SmartProperties;
import se.ericsson.cello.emt.motools.common.mimparser.MimCompatibility;
import se.ericsson.cello.emt.motools.common.momodel.ActionModel;
import se.ericsson.cello.emt.motools.common.momodel.MoModel;
import se.ericsson.cello.emt.motools.common.toolservices.StartFailureException;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.emt.userpreferences.UserPreferencesI;
import se.ericsson.cello.emt.utils.guihelper.MessageDialog;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.cello.mimparser.MomEntity;

public class MoPropertiesGui
implements MoPropertiesView,
GUI_Container,
LdnProvider {
    private static final String SET_TOOLTIP = "Set attribute values and close the window";
    private static final String CANCEL_TOOLTIP = "Close the window";
    private static final String APPLY_TOOLTIP = "Set attribute values";
    private static final String MOHELP_BEGINNING_TOOLTIP = "Display help on ";
    private static final String REFRESH_TOOLTIP = "Update MO Properties with fresh values from the node";
    private MoPropertiesController controller = null;
    private MoPropertiesModel model;
    private ToolServices toolServices = null;
    private UserPreferencesI myUserPreference = null;
    private JTabbedPane tabpane = null;
    private static final int ATTRIBUTE_TAB = 0;
    private static final int ACTION_TAB = 1;
    private MoModel moModel = null;
    private List<String> attrGroupNameList = new ArrayList<String>(0);
    private List<ActionModel> actionList = new ArrayList<ActionModel>(0);
    private int nrOfOrdinaryAttrs = 0;
    private int totalNrOfGroupedAttrs = 0;
    private int totalNrOfAttrs = 0;
    private LinkedList<AttributeGroupGUI> myAttributeGroupGUIList = null;
    private final JPanel myPanel = new JPanel();
    private JFrame myFrame = null;
    private JPanel actionsPanel = null;
    private JPanel actionArea = null;
    private JPanel actionsButtonPanel = null;
    private JScrollPane attrscroller = null;
    private JButton setButton = null;
    private JButton applyButton = null;
    private JButton refreshButton = null;
    private JButton executeButton = null;
    private JButton cancelButton = null;
    private JButton moHelpButton = null;
    private JButton emHelpButton = null;
    private JButton actionsCancelButton = null;
    private JButton actionsHelpButton = null;
    private JButton actionsMOHelpButton = null;
    private JProgressBar statusProgressBar;
    private JComboBox action_combo = null;
    private Timer statusProgTimer;
    private InformationButtonGui myActionInfoButtonGui = null;
    private ActionDetailsGUI myActionDetailsGUI = null;
    private ActionListener mySetButtonActionListener = null;
    private ActionListener myRefreshButtonActionListener = null;
    private ActionListener myCancelButtonActionListener = null;
    private ActionListener myHelpButtonActionListener = null;
    private ActionListener myMOHelpButtonActionListener = null;
    private ActionListener statusActionListener;
    private ActionListener myEmHelpButtonActionListener = null;
    private ActionListener myApplyButtonActionListener = null;
    private boolean embedded;
    private final Comparator<ActionModel> actionModelComparator = new Comparator<ActionModel>(){

        @Override
        public int compare(ActionModel m1, ActionModel m2) {
            int result = 0;
            String n1 = m1.getName();
            String n2 = m2.getName();
            result = n1.compareTo(n2);
            return result;
        }
    };

    public MoPropertiesGui(MoPropertiesController controller, MoPropertiesModel model, boolean embedded) {
        this.controller = controller;
        this.model = model;
        this.embedded = embedded;
    }

    public void initialize() {
        if (!SwingUtilities.isEventDispatchThread()) {
            MoPropLog.logger().fine(" called from ordinary thread, do it in GUI thread");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MoPropertiesGui.this.initialize();
                }
            });
        } else {
            MoPropLog.logger().log(Level.INFO, "MoPropertiesView.initialize");
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                MoPropLog.logger().log(Level.INFO, "Was not able to set the correct look and feel of the system.\n");
            }
            this.fetchNonTimeConsumingModelData();
            if (!this.embedded) {
                this.initFrame();
            }
            this.buildGui();
        }
    }

    public void nodeConnectionLost() {
        MoPropLog.logger().log(Level.INFO, "nodeConnectionLost");
    }

    public void nodeConnectionRestored() {
        MoPropLog.logger().log(Level.INFO, "nodeConnectionRestored");
    }

    public void showUI(final boolean visible) {
        MoPropLog.logger().log(Level.INFO, "showUI.visible: " + visible);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (visible) {
                    MoPropertiesGui.this.bringToFront();
                } else {
                    MoPropertiesGui.this.myPanel.setVisible(false);
                    if (!MoPropertiesGui.this.embedded) {
                        MoPropertiesGui.this.myFrame.setVisible(false);
                    }
                }
            }
        });
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void setController(MoPropertiesController controller) {
        MoPropLog.logger().log(Level.INFO, "");
        this.controller = controller;
    }

    public void setModel(MoPropertiesModel model) {
        MoPropLog.logger().log(Level.INFO, "");
        this.model = model;
    }

    public void startAttributeStatusProgressMonitor(final String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MoPropertiesGui.this.startAttributeStatusProgressMonitor(message);
                }
            });
        } else {
            MoPropLog.logger().fine("starting statusProgressBar");
            if (message != null) {
                this.statusProgressBar.setString("  " + message + "  ");
                this.statusProgressBar.setStringPainted(true);
            } else {
                this.statusProgressBar.setString("");
                this.statusProgressBar.setStringPainted(false);
            }
            if (null == this.statusActionListener) {
                this.statusActionListener = new ActionListener(){
                    private int count = 1;

                    public void actionPerformed(ActionEvent evt) {
                        if (!MoPropertiesGui.this.statusProgressBar.isVisible()) {
                            MoPropertiesGui.this.statusProgressBar.setVisible(true);
                        }
                        this.count = ++this.count > 10 ? 1 : this.count;
                        MoPropertiesGui.this.statusProgressBar.setValue(this.count);
                    }
                };
            }
            if (null == this.statusProgTimer) {
                this.statusProgTimer = new Timer(100, this.statusActionListener);
                this.statusProgTimer.setInitialDelay(2000);
            }
            if (!this.statusProgTimer.isRunning()) {
                this.statusProgTimer.start();
            }
        }
    }

    public void stopAttributeStatusProgressMonitor() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MoPropertiesGui.this.stopAttributeStatusProgressMonitor();
                }
            });
        } else {
            MoPropLog.logger().fine("stop statusProgressBar");
            if (null != this.statusProgressBar) {
                this.statusProgressBar.setVisible(false);
            }
            if (null != this.statusProgTimer) {
                this.statusProgTimer.stop();
            }
        }
    }

    public void exit() {
        MoPropLog.logger().info("");
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MoPropertiesGui.this.exit();
                }
            });
        } else {
            this.controller.stopOngoingAsynchronousWork();
            this.model.exit();
            this.myPanel.setVisible(false);
            if (!this.embedded) {
                this.myFrame.setVisible(false);
            }
            this.destroy();
            if (!this.embedded) {
                this.myFrame.dispose();
            }
        }
    }

    public void updateNeeded() {
        this.myPanel.validate();
    }

    public void valueChanged() {
        boolean enableButtons = false;
        if (!this.myAttributeGroupGUIList.isEmpty()) {
            enableButtons = this.isAnyGuiAttributeChanged() && !this.isAnyGuiAttributeValueFaulty();
        }
        this.setButton.setEnabled(enableButtons);
        this.applyButton.setEnabled(enableButtons);
    }

    public void showErrorMessage(final String reason, final Exception e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MoPropertiesGui.this.showErrorMessage(reason, e);
                }
            });
        } else {
            MessageDialog msgDlg = MessageDialogFactory.createMessageDialog((String)reason, (Exception)e, (boolean)false, (JFrame)this.myFrame);
            msgDlg.setVisible(true);
        }
    }

    public String getLdn() {
        String ldn = "";
        if (this.model != null) {
            ldn = this.model.getLDN();
        }
        return ldn;
    }

    private void fetchNonTimeConsumingModelData() {
        this.toolServices = this.model.getToolServices();
        this.moModel = this.model.getMoModel();
        this.actionList = this.moModel.getActionModels();
        Collections.sort(this.actionList, this.actionModelComparator);
        this.attrGroupNameList = this.moModel.getAttributeGroupNames();
        this.nrOfOrdinaryAttrs = this.moModel.getNumberOfOrdinaryAttributes();
        this.totalNrOfGroupedAttrs = this.getTotalNumberOfGroupedAttributes();
        this.totalNrOfAttrs = this.nrOfOrdinaryAttrs + this.totalNrOfGroupedAttrs;
    }

    private int getTotalNumberOfGroupedAttributes() {
        int totalNrOfGroupedAttributes = 0;
        for (String currentGroupName : this.attrGroupNameList) {
            totalNrOfGroupedAttributes += this.moModel.getNumberOfAttributesForGroup(currentGroupName);
        }
        return totalNrOfGroupedAttributes;
    }

    private void bringToFront() {
        this.myPanel.setVisible(true);
        if (this.embedded) {
            return;
        }
        if (this.myFrame.getState() == 1) {
            this.myFrame.setState(0);
            this.autoCenter(this.myFrame);
        }
        this.myFrame.setVisible(true);
        this.myFrame.toFront();
        if (null != this.setButton) {
            this.setButton.requestFocusInWindow();
        }
    }

    private void autoCenter(JFrame aFrame) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        aFrame.setLocation((d.width - aFrame.getWidth()) / 2, (d.height - aFrame.getHeight()) / 2);
    }

    private Dimension getPercentDimension(int aP) {
        Dimension aDim = new Dimension(800, 600);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (aP >= 0 & aP <= 100) {
            aDim.height = d.height * aP / 100;
            aDim.width = d.width * aP / 100;
        }
        return aDim;
    }

    private void initFrame() {
        this.myFrame = new JFrame();
        this.myFrame.setContentPane(this.myPanel);
        this.myFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MoPropertiesGui.this.exit();
            }
        });
        this.myFrame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                int getWidth = (int)Math.floor(MoPropertiesGui.this.myFrame.getSize().getWidth());
                String width = Integer.toString(getWidth);
                int getHeight = (int)Math.floor(MoPropertiesGui.this.myFrame.getSize().getHeight());
                String height = Integer.toString(getHeight);
                if (null != MoPropertiesGui.this.myUserPreference) {
                    String keyEnding = MoPropertiesGui.this.createMoKeyForUserPrefs();
                    String widthKey = "cpp_moprop_width_" + keyEnding;
                    String heightKey = "cpp_moprop_height_" + keyEnding;
                    MoPropertiesGui.this.myUserPreference.setPreference(widthKey, width);
                    MoPropertiesGui.this.myUserPreference.setPreference(heightKey, height);
                }
            }
        });
        this.myFrame.setLayout(new BorderLayout(5, 5));
        Dimension d = this.getPercentDimension(40);
        try {
            this.myUserPreference = this.toolServices.getUserPreferenceServices();
            if (null != this.myUserPreference) {
                String keyEnding = this.createMoKeyForUserPrefs();
                String widthKey = "cpp_moprop_width_" + keyEnding;
                String heightKey = "cpp_moprop_height_" + keyEnding;
                String w = this.myUserPreference.getPreference(widthKey, Double.toString(d.getWidth()));
                String h = this.myUserPreference.getPreference(heightKey, Double.toString(d.getHeight()));
                int width = Integer.valueOf(w);
                int height = Integer.valueOf(h);
                d.setSize(width, height);
            }
        }
        catch (StartFailureException e1) {
            MoPropLog.logger().info("Failed getting Preferences Service.\n" + e1.getMessage());
        }
        catch (Exception e) {
            MoPropLog.logger().log(Level.FINE, "Something got wrong when setting window size");
            d = new Dimension(640, 480);
        }
        this.myFrame.setSize(d);
        String theLdn = this.model.getLDN();
        String theRDN = theLdn.substring(theLdn.lastIndexOf(",") + 1);
        String rdnPropertiesTitle = "Properties";
        String theTitle = this.model.getConfiguration().getTitle() + " - " + theRDN + " " + rdnPropertiesTitle;
        this.myFrame.setTitle(theTitle);
        this.installImageIcon();
        this.autoCenter(this.myFrame);
    }

    private void buildGui() {
        MoPropLog.logger().log(Level.INFO, "MoPropertiesGui.buildGui");
        this.myPanel.setLayout(new BorderLayout(5, 5));
        this.makeTheTitlePortion();
        this.initButtonListeners();
        this.makeTheContentPortion();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (MoPropertiesGui.this.nrOfOrdinaryAttrs < 1 || MoPropertiesGui.this.model.getConfiguration().getSelectedActionName() != null) {
                    MoPropertiesGui.this.toolServices.sendEmNotification(GuiTestEventTypes.MO_PROPERTIES_PANEL_UPDATED, this.getClass().getSimpleName() + " no attributes", null, GuiTestEventTypes.claimSeqNum(), System.currentTimeMillis(), this);
                }
            }
        });
    }

    private void makeTheTitlePortion() {
        if (this.embedded) {
            return;
        }
        JPanel classInstP = new JPanel(new FlowLayout(0, 0, 0));
        classInstP.setOpaque(false);
        JPanel infoLabelPanel = new JPanel();
        infoLabelPanel.setLayout(new FlowLayout(0, 3, 0));
        InformationButtonGui infoButtonGui = new InformationButtonGui(this, this.toolServices);
        infoButtonGui.setMargin(new Insets(0, 0, 0, 1));
        String theLdn = null;
        theLdn = this.model.getLDN();
        infoButtonGui.setName(theLdn);
        String theDescription = this.model.getMoModel().getMomClass().getExtendedDescription();
        infoButtonGui.setDescription(theDescription);
        infoLabelPanel.add(infoButtonGui);
        infoLabelPanel.add(new JLabel("LDN: "));
        classInstP.add(infoLabelPanel);
        JTextField ldnField = new JTextField();
        ldnField.setEditable(false);
        ldnField.setOpaque(false);
        ldnField.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 1));
        ldnField.setText(theLdn);
        ldnField.setToolTipText(theLdn);
        ldnField.setName("ldnTextBox");
        classInstP.add(ldnField);
        JPanel moNamePanel = new JPanel(new FlowLayout(0, 0, 0));
        Dimension cipDim = new Dimension(classInstP.getPreferredSize());
        classInstP.setMinimumSize(cipDim);
        classInstP.setMaximumSize(cipDim);
        moNamePanel.add(classInstP);
        moNamePanel.add(this.buildGotoPanelGui());
        Border border = BorderFactory.createEtchedBorder(0);
        JScrollPane nameScroller = new JScrollPane(moNamePanel, 21, 30);
        nameScroller.getHorizontalScrollBar().setUnitIncrement(100);
        nameScroller.setBorder(border);
        Dimension dim = new Dimension(moNamePanel.getPreferredSize().width, moNamePanel.getPreferredSize().height + nameScroller.getHorizontalScrollBar().getPreferredSize().height);
        moNamePanel.setPreferredSize(dim);
        moNamePanel.setMinimumSize(dim);
        moNamePanel.setMaximumSize(dim);
        moNamePanel.setMaximumSize(new Dimension(400, dim.height + 30));
        this.myPanel.add((Component)nameScroller, "North");
    }

    private JPanel buildGotoPanelGui() {
        JPanel containerPanel = new JPanel();
        PopupGotoGui myGtoGui = new PopupGotoGui(this, this.toolServices);
        containerPanel.add(myGtoGui.getGotoB());
        return containerPanel;
    }

    private void makeTheContentPortion() {
        int numberOfActions;
        MoPropLog.logger().info("");
        this.tabpane = new JTabbedPane(1);
        this.tabpane.setName("MoPropertiesTabPane");
        this.tabpane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                if (!MoPropertiesGui.this.embedded) {
                    if (MoPropertiesGui.this.tabpane.getSelectedIndex() == 0) {
                        MoPropertiesGui.this.myPanel.getRootPane().setDefaultButton(MoPropertiesGui.this.setButton);
                    } else if (MoPropertiesGui.this.tabpane.getSelectedIndex() == 1) {
                        MoPropertiesGui.this.myPanel.getRootPane().setDefaultButton(MoPropertiesGui.this.executeButton);
                    }
                }
            }
        });
        this.myPanel.add((Component)this.tabpane, "Center");
        if (this.totalNrOfAttrs > 0 && this.model.getConfiguration().getSelectedActionName() == null) {
            Container attributeContainer = this.buildAttributesArea();
            this.tabpane.add("Attributes(" + this.totalNrOfAttrs + ")", attributeContainer);
        }
        if ((numberOfActions = this.actionList.size()) > 0) {
            this.tabpane.add("Actions(" + numberOfActions + ")", this.buildActionsArea());
        }
    }

    private Container buildAttributesArea() {
        MoPropLog.logger().info("");
        JPanel attrPanel = new JPanel();
        attrPanel.setLayout(new BoxLayout(attrPanel, 1));
        if (this.myAttributeGroupGUIList != null) {
            this.myAttributeGroupGUIList.clear();
            this.myAttributeGroupGUIList = null;
        }
        this.myAttributeGroupGUIList = new LinkedList();
        this.attrscroller = new JScrollPane(attrPanel, 20, 30);
        this.attrscroller.getHorizontalScrollBar().setUnitIncrement(50);
        this.attrscroller.getVerticalScrollBar().setUnitIncrement(30);
        if (this.nrOfOrdinaryAttrs > 0) {
            AttributeGroupGUI ordinaryAttrGroupGui = new AttributeGroupGUI(this.controller, true, this, this.myPanel, null, false, this.toolServices, this.attrscroller);
            ordinaryAttrGroupGui.initBuildOfAttributesArea();
            attrPanel.add(ordinaryAttrGroupGui.getPanel());
            this.myAttributeGroupGUIList.add(ordinaryAttrGroupGui);
        }
        for (String attrGroupName : this.attrGroupNameList) {
            int nrOfAtttsForThisGroup = this.moModel.getNumberOfAttributesForGroup(attrGroupName);
            AttributeGroupGUI groupedAttrGroupGui = new AttributeGroupGUI(this.controller, false, this, this.myPanel, attrGroupName, nrOfAtttsForThisGroup, this.toolServices);
            attrPanel.add(groupedAttrGroupGui.getPanel());
            this.myAttributeGroupGUIList.add(groupedAttrGroupGui);
        }
        JPanel attrTabPanel = new JPanel(new BorderLayout(0, 0));
        attrTabPanel.add((Component)this.attrscroller, "Center");
        JPanel buttonPanel = this.makeButtonPanelForAttributes();
        attrTabPanel.add((Component)buttonPanel, "South");
        attrTabPanel.setName("MoAttributesTab");
        return attrTabPanel;
    }

    private JPanel makeButtonPanelForAttributes() {
        MoPropLog.logger().info("");
        JPanel attrStatusPanel = new JPanel(new FlowLayout(0));
        this.statusProgressBar = new JProgressBar();
        this.statusProgressBar.setName("treeProgressBar");
        this.statusProgressBar.setValue(0);
        this.statusProgressBar.setMaximum(10);
        this.statusProgressBar.setVisible(false);
        attrStatusPanel.add(this.statusProgressBar);
        JPanel attrButtonPanel = new JPanel(new FlowLayout(2));
        this.setButton = new JButton("Set");
        this.setButton.setToolTipText(SET_TOOLTIP);
        this.setButton.setMnemonic('S');
        attrButtonPanel.add(this.setButton);
        this.setButton.setEnabled(false);
        this.setButton.addActionListener(this.mySetButtonActionListener);
        this.cancelButton = new JButton("Close");
        this.cancelButton.setToolTipText(CANCEL_TOOLTIP);
        attrButtonPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(this.myCancelButtonActionListener);
        this.cancelButton.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "");
        this.cancelButton.getActionMap().put("", new AbstractAction(){
            private static final long serialVersionUID = 1449250124626654037L;

            public void actionPerformed(ActionEvent event) {
                MoPropertiesGui.this.exit();
            }
        });
        if (this.embedded) {
            this.setButton.setVisible(false);
            this.cancelButton.setVisible(false);
        }
        this.applyButton = new JButton("Apply");
        this.applyButton.setToolTipText(APPLY_TOOLTIP);
        this.applyButton.setMnemonic('A');
        attrButtonPanel.add(this.applyButton);
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(this.myApplyButtonActionListener);
        attrButtonPanel.add(this.applyButton);
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.setToolTipText(REFRESH_TOOLTIP);
        this.refreshButton.setMnemonic('f');
        attrButtonPanel.add(this.refreshButton);
        this.refreshButton.setEnabled(true);
        this.refreshButton.addActionListener(this.myRefreshButtonActionListener);
        this.refreshButton.getInputMap(2).put(KeyStroke.getKeyStroke(116, 0), "");
        this.refreshButton.getActionMap().put("", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                MoPropertiesGui.this.refresh();
            }
        });
        this.moHelpButton = new JButton("MO Help");
        this.moHelpButton.setToolTipText(MOHELP_BEGINNING_TOOLTIP + this.model.getMoModel().getMomClass().getName());
        this.moHelpButton.setMnemonic('M');
        attrButtonPanel.add(this.moHelpButton);
        this.moHelpButton.addActionListener(this.myMOHelpButtonActionListener);
        this.emHelpButton = new JButton("Help");
        this.emHelpButton.setToolTipText("How to use MO Properties Attributes area");
        attrButtonPanel.add(this.emHelpButton);
        this.emHelpButton.addActionListener(this.myEmHelpButtonActionListener);
        if (this.embedded) {
            this.emHelpButton.setMnemonic('p');
        } else {
            this.emHelpButton.getInputMap(2).put(KeyStroke.getKeyStroke(112, 0), "");
            this.emHelpButton.getActionMap().put("", new AbstractAction(){
                private static final long serialVersionUID = 5223846387182719197L;

                public void actionPerformed(ActionEvent ae) {
                    MoPropertiesGui.this.myEmHelpButtonActionListener.actionPerformed(ae);
                }
            });
        }
        JPanel combinedPanel = new JPanel(new BorderLayout());
        combinedPanel.add((Component)attrStatusPanel, "West");
        combinedPanel.add((Component)attrButtonPanel, "East");
        return combinedPanel;
    }

    private void initButtonListeners() {
        this.initSetButtonListener();
        this.initApplyButtonListener();
        this.initCancelButtonListener();
        this.initMOHelpButtonListener();
        this.initHelpButtonListener();
        this.initEmHelpButtonListener();
        this.initRefreshButtonListener();
    }

    private void initRefreshButtonListener() {
        this.myRefreshButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MoPropertiesGui.this.refresh();
            }
        };
    }

    private void initMOHelpButtonListener() {
        this.myMOHelpButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String ldn = MoPropertiesGui.this.model.getLDN();
                int start = ldn.lastIndexOf(44) + 1;
                int end = ldn.lastIndexOf(61);
                String moType = ldn.substring(start, end);
                MoPropertiesGui.this.toolServices.runHelp("class " + moType, "");
            }
        };
    }

    private void initHelpButtonListener() {
        this.myHelpButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MoPropertiesGui.this.toolServices.runHelp("Element Manager", "PerfOpOnMO");
            }
        };
    }

    private void initEmHelpButtonListener() {
        this.myEmHelpButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String cpiTitle = "Element Manager";
                String chapterTag = "moPropertiesHelp";
                MoPropertiesGui.this.toolServices.runHelp(cpiTitle, chapterTag);
            }
        };
    }

    private void initCancelButtonListener() {
        this.myCancelButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MoPropertiesGui.this.exit();
            }
        };
    }

    private void initApplyButtonListener() {
        this.myApplyButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MoPropLog.logger().fine("Apply button was pressed.");
                MoPropertiesGui.this.setButton.setEnabled(false);
                MoPropertiesGui.this.applyButton.setEnabled(false);
                MoPropertiesGui.this.refreshButton.setEnabled(false);
                MoPropertiesGui.this.myPanel.setCursor(new Cursor(3));
                boolean goOn = true;
                boolean anyGuiChange = true;
                try {
                    anyGuiChange = MoPropertiesGui.this.pushUpdatedGuiValuesToAttributeModels();
                }
                catch (Exception e) {
                    goOn = false;
                    MoPropertiesGui.this.setButton.setEnabled(false);
                    MoPropertiesGui.this.applyButton.setEnabled(false);
                    MoPropertiesGui.this.refreshButton.setEnabled(true);
                    MoPropertiesGui.this.myPanel.setCursor(new Cursor(0));
                    MoPropLog.logger().info("Failed to push gui values to the AttributeModel: " + e.getMessage());
                    String errorString = "Error setting attributes: ";
                    MoPropertiesGui.this.showErrorMessage(errorString, e);
                }
                if (!anyGuiChange) {
                    MoPropertiesGui.this.myPanel.setCursor(new Cursor(0));
                    MoPropertiesGui.this.refresh();
                } else if (goOn) {
                    MoPropLog.logger().fine("before myController.pushUpdatedAttributeModelValuesToNodeAsynchronous.");
                    MoPropertiesGui.this.controller.pushUpdatedAttributeModelValuesToNodeAsynchronous(new PushAttributeValueListener(){

                        public void notifyPushAttributeValuesToNodeIsDone(boolean success) {
                            if (success) {
                                MoPropLog.logger().fine("Gui values was successfully updated to the node.");
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        MoPropertiesGui.this.myPanel.setCursor(new Cursor(0));
                                        MoPropertiesGui.this.refresh();
                                    }
                                });
                            } else {
                                MoPropLog.logger().fine("Gui values was not successfully updated to the node.");
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        MoPropertiesGui.this.setButton.setEnabled(false);
                                        MoPropertiesGui.this.applyButton.setEnabled(false);
                                        MoPropertiesGui.this.refreshButton.setEnabled(true);
                                        MoPropertiesGui.this.myPanel.setCursor(new Cursor(0));
                                    }
                                });
                            }
                        }
                    });
                }
            }
        };
    }

    private void initSetButtonListener() {
        this.mySetButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MoPropLog.logger().fine("Set button was pressed.");
                MoPropertiesGui.this.setButton.setEnabled(false);
                MoPropertiesGui.this.applyButton.setEnabled(false);
                MoPropertiesGui.this.refreshButton.setEnabled(false);
                MoPropertiesGui.this.myPanel.setCursor(new Cursor(3));
                boolean goOn = true;
                boolean anyGuiChange = true;
                try {
                    anyGuiChange = MoPropertiesGui.this.pushUpdatedGuiValuesToAttributeModels();
                }
                catch (Exception e) {
                    goOn = false;
                    MoPropertiesGui.this.setButton.setEnabled(false);
                    MoPropertiesGui.this.applyButton.setEnabled(false);
                    MoPropertiesGui.this.refreshButton.setEnabled(true);
                    MoPropertiesGui.this.myPanel.setCursor(new Cursor(0));
                    MoPropLog.logger().info("Failed to push gui values to the AttributeModel: " + e.getMessage());
                    String errorString = "Error setting attributes: ";
                    MoPropertiesGui.this.showErrorMessage(errorString, e);
                }
                if (!anyGuiChange) {
                    MoPropertiesGui.this.myPanel.setCursor(new Cursor(0));
                    MoPropertiesGui.this.exit();
                } else if (goOn) {
                    MoPropLog.logger().fine("before myController.pushUpdatedAttributeModelValuesToNodeAsynchronous.");
                    MoPropertiesGui.this.controller.pushUpdatedAttributeModelValuesToNodeAsynchronous(new PushAttributeValueListener(){

                        public void notifyPushAttributeValuesToNodeIsDone(boolean success) {
                            if (success) {
                                MoPropLog.logger().fine("Gui values was successfully updated to the node.");
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        MoPropertiesGui.this.myPanel.setCursor(new Cursor(0));
                                        MoPropertiesGui.this.exit();
                                    }
                                });
                            } else {
                                MoPropLog.logger().fine("Gui values was not successfully updated to the node.");
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        MoPropertiesGui.this.setButton.setEnabled(false);
                                        MoPropertiesGui.this.applyButton.setEnabled(false);
                                        MoPropertiesGui.this.refreshButton.setEnabled(true);
                                        MoPropertiesGui.this.myPanel.setCursor(new Cursor(0));
                                    }
                                });
                            }
                        }
                    });
                }
            }
        };
    }

    private void destroy() {
        MoPropLog.logger().info("");
        if (null != this.myAttributeGroupGUIList) {
            this.myAttributeGroupGUIList.clear();
        }
        this.myAttributeGroupGUIList = null;
        if (this.setButton != null) {
            this.setButton.removeActionListener(this.mySetButtonActionListener);
            this.setButton = null;
            this.mySetButtonActionListener = null;
        }
        if (this.applyButton != null) {
            this.applyButton.removeActionListener(this.myApplyButtonActionListener);
            this.applyButton = null;
            this.myApplyButtonActionListener = null;
        }
        if (this.refreshButton != null) {
            this.refreshButton.removeActionListener(this.myRefreshButtonActionListener);
            this.myRefreshButtonActionListener = null;
            this.refreshButton = null;
        }
        if (this.actionsCancelButton != null) {
            this.actionsCancelButton.removeActionListener(this.myCancelButtonActionListener);
            this.actionsCancelButton.getInputMap().clear();
            this.actionsCancelButton.getActionMap().clear();
            this.actionsCancelButton = null;
        }
        if (this.cancelButton != null) {
            this.cancelButton.removeActionListener(this.myCancelButtonActionListener);
            this.cancelButton.getInputMap().clear();
            this.cancelButton.getActionMap().clear();
            this.myCancelButtonActionListener = null;
            this.cancelButton = null;
        }
        if (this.actionsHelpButton != null) {
            this.actionsHelpButton.removeActionListener(this.myHelpButtonActionListener);
            this.actionsHelpButton.getInputMap().clear();
            this.actionsHelpButton.getActionMap().clear();
            this.actionsHelpButton = null;
        }
        if (this.moHelpButton != null) {
            this.moHelpButton.removeActionListener(this.myHelpButtonActionListener);
            this.moHelpButton.getInputMap().clear();
            this.moHelpButton.getActionMap().clear();
            this.myHelpButtonActionListener = null;
            this.moHelpButton = null;
        }
        if (this.emHelpButton != null) {
            this.emHelpButton.removeActionListener(this.myEmHelpButtonActionListener);
            if (!this.embedded) {
                this.emHelpButton.getInputMap().clear();
                this.emHelpButton.getActionMap().clear();
            }
            this.myEmHelpButtonActionListener = null;
            this.emHelpButton = null;
        }
        if (this.attrscroller != null) {
            this.attrscroller.removeAll();
            this.attrscroller = null;
        }
        this.executeButton = null;
        if (null != this.myPanel) {
            this.myPanel.removeAll();
        }
    }

    private boolean pushUpdatedGuiValuesToAttributeModels() {
        boolean anyChangeInAnyGroup = false;
        Iterator iter = this.myAttributeGroupGUIList.iterator();
        AttributeGroupGUI currentAttributeGroupGUI = null;
        while (iter.hasNext()) {
            currentAttributeGroupGUI = (AttributeGroupGUI)iter.next();
            boolean groupChanged = currentAttributeGroupGUI.pushUpdatedAttrGuiToAttributeModels();
            if (!groupChanged) continue;
            anyChangeInAnyGroup = true;
        }
        return anyChangeInAnyGroup;
    }

    private void refresh() {
        try {
            this.controller.stopOngoingAsynchronousWork();
            this.model.getMoModel().clearModels();
            this.fetchNonTimeConsumingModelData();
            this.reBuildGui();
        }
        catch (Exception x) {
            String errorString = "Refresh failed.";
            this.showErrorMessage(errorString, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reBuildGui() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runthis = new Runnable(){

                public void run() {
                    MoPropertiesGui.this.reBuildGui();
                }
            };
            SwingUtilities.invokeLater(runthis);
            return;
        }
        MoPropLog.logger().info("Re-building the GUI");
        try {
            try {
                this.myPanel.setVisible(false);
                this.destroy();
                this.buildGui();
                this.showUI(true);
            }
            catch (Exception x) {
                String errorString = "Failed to refresh the MO Properties. ";
                this.showErrorMessage(errorString, x);
                Object var4_2 = null;
                this.myPanel.setCursor(new Cursor(0));
                return;
            }
            Object var4_1 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.myPanel.setCursor(new Cursor(0));
            throw throwable;
        }
        this.myPanel.setCursor(new Cursor(0));
    }

    private boolean isAnyGuiAttributeChanged() {
        boolean result = false;
        Iterator iter = this.myAttributeGroupGUIList.iterator();
        AttributeGroupGUI myGroupGui = null;
        while (iter.hasNext()) {
            myGroupGui = (AttributeGroupGUI)iter.next();
            if (!myGroupGui.isModified()) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isAnyGuiAttributeValueFaulty() {
        boolean result = false;
        Iterator iter = this.myAttributeGroupGUIList.iterator();
        AttributeGroupGUI myGroupGui = null;
        while (iter.hasNext()) {
            myGroupGui = (AttributeGroupGUI)iter.next();
            if (!myGroupGui.faultyValueEntered()) continue;
            result = true;
            break;
        }
        return result;
    }

    private Container buildActionsArea() {
        MoPropLog.logger().info("");
        this.actionsButtonPanel = new JPanel(new FlowLayout(2));
        int nrOfActions = this.actionList.size();
        String[] actionNames = new String[nrOfActions];
        ActionModel anAction = null;
        for (int i = 0; i < nrOfActions; ++i) {
            try {
                anAction = this.actionList.get(i);
                if (MimCompatibility.getDeprecated((MomEntity)anAction.getMomAction()) != null) {
                    actionNames[i] = "<html><strike>" + anAction.getName() + "</strike></html>";
                    continue;
                }
                actionNames[i] = anAction.getName();
                continue;
            }
            catch (Exception x) {
                String reason = "Failed to read action names.";
                this.showErrorMessage(reason, x);
            }
        }
        this.action_combo = new JComboBox<String>(actionNames);
        JPanel actionPanel = new JPanel();
        actionPanel.add(this.action_combo);
        actionPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.action_combo.setName("actionNamesComboBoxInMoProps");
        JPanel comboBoxAndInfoPanel = new JPanel();
        comboBoxAndInfoPanel.setOpaque(false);
        comboBoxAndInfoPanel.setLayout(new CompactGridLayout(3, 2, 2));
        JLabel actionLabel = new JLabel("Actions: ");
        this.myActionInfoButtonGui = new InformationButtonGui(this, this.toolServices);
        comboBoxAndInfoPanel.add(this.myActionInfoButtonGui.getPanel());
        comboBoxAndInfoPanel.add(actionLabel);
        comboBoxAndInfoPanel.add(actionPanel);
        this.actionsPanel = new JPanel(new BorderLayout(5, 5));
        this.actionsPanel.add((Component)comboBoxAndInfoPanel, "North");
        this.actionArea = new JPanel(new BorderLayout());
        this.actionArea.setName("actionArea");
        this.actionsPanel.add((Component)this.actionArea, "Center");
        this.actionsCancelButton = new JButton("Close");
        this.actionsCancelButton.setMnemonic('C');
        this.actionsCancelButton.setToolTipText(CANCEL_TOOLTIP);
        this.actionsCancelButton.addActionListener(this.myCancelButtonActionListener);
        this.actionsCancelButton.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "");
        this.actionsCancelButton.getActionMap().put("", new AbstractAction(){
            private static final long serialVersionUID = 3547533038091988318L;

            public void actionPerformed(ActionEvent event) {
                MoPropertiesGui.this.exit();
            }
        });
        this.actionsMOHelpButton = new JButton("MO Help");
        this.actionsMOHelpButton.setToolTipText(MOHELP_BEGINNING_TOOLTIP + this.model.getMoModel().getMomClass().getName());
        this.actionsMOHelpButton.setMnemonic('M');
        this.actionsMOHelpButton.addActionListener(this.myMOHelpButtonActionListener);
        this.actionsPanel.add((Component)this.actionsButtonPanel, "South");
        this.actionsHelpButton = new JButton("Help");
        this.actionsHelpButton.setToolTipText("How to use MO Properties Actions area");
        this.actionsHelpButton.setMnemonic('H');
        this.actionsHelpButton.addActionListener(this.myHelpButtonActionListener);
        this.actionsHelpButton.getInputMap(2).put(KeyStroke.getKeyStroke(112, 0), "");
        this.actionsHelpButton.getActionMap().put("", new AbstractAction(){
            private static final long serialVersionUID = -7684365432051743211L;

            public void actionPerformed(ActionEvent ae) {
                MoPropertiesGui.this.toolServices.runHelp("Element Manager", "PerfOpOnMO");
            }
        });
        this.createActionDetailsGUI();
        this.action_combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MoPropertiesGui.this.createActionDetailsGUI();
            }
        });
        this.actionsPanel.setName("MoActionsTab");
        return this.actionsPanel;
    }

    private void createActionDetailsGUI() {
        MoPropLog.logger().info("");
        try {
            this.actionArea.removeAll();
            int actionComboSelectIndex = this.action_combo.getSelectedIndex();
            ActionModel theAction = this.actionList.get(actionComboSelectIndex);
            String description = theAction.getMomAction().getExtendedDescription();
            this.myActionInfoButtonGui.setName(theAction.getName());
            this.myActionInfoButtonGui.setDescription(description);
            SmartProperties prop = new SmartProperties();
            this.myActionDetailsGUI = new ActionDetailsGUI(this.myPanel, prop, theAction, theAction.getName(), this.toolServices, this.controller);
            this.actionArea.add(this.myActionDetailsGUI.getParameterResultExceptionArea());
            this.actionsPanel.invalidate();
            this.actionsPanel.validate();
        }
        catch (Exception x) {
            String reason = "Failed to create action details.";
            this.showErrorMessage(reason, x);
        }
        this.actionsButtonPanel.removeAll();
        this.executeButton = this.myActionDetailsGUI.getExecuteBtn();
        this.executeButton.setName("actionExecuteButton");
        this.actionsButtonPanel.add(this.executeButton);
        this.actionsButtonPanel.add(this.actionsCancelButton);
        if (this.embedded) {
            this.actionsCancelButton.setVisible(false);
        }
        this.actionsButtonPanel.add(this.actionsMOHelpButton);
        this.actionsButtonPanel.add(this.actionsHelpButton);
    }

    private void installImageIcon() {
        if (this.embedded) {
            return;
        }
        Image anIcon = this.model.getConfiguration().getIconImage();
        if (anIcon != null) {
            this.myFrame.setIconImage(anIcon);
        }
    }

    private String createMoKeyForUserPrefs() {
        StringBuilder strbuf = new StringBuilder();
        strbuf.append(this.model.getMoModel().getMomClass().getName());
        String selectedAction = this.model.getConfiguration().getSelectedActionName();
        List<String> selectedAttributes = this.model.getConfiguration().getSelectedAttrNames();
        if (selectedAttributes.size() > 0) {
            for (String attr : selectedAttributes) {
                strbuf.append("_");
                strbuf.append(attr);
            }
        } else if (selectedAction != null && selectedAction.length() > 0) {
            strbuf.append("_");
            strbuf.append(selectedAction);
        }
        return strbuf.toString();
    }

    public MoPropertiesController getController() {
        return this.controller;
    }
}

