/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.mosearch;

import java.awt.Image;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import javax.swing.JFrame;
import se.ericsson.cello.emt.mosearch.MoSearch;
import se.ericsson.cello.emt.mosearch.MoSearchConfigImplFactory;
import se.ericsson.cello.emt.mosearch.MoSearchFactory;
import se.ericsson.cello.emt.mosearch.MoSearchLog;
import se.ericsson.cello.emt.mosearch.MoSearchTool;
import se.ericsson.cello.emt.mosearch.model.MoSearchModel;
import se.ericsson.cello.emt.mosearch.model.MoSearchModelFactory;
import se.ericsson.cello.emt.mosearch.view.gui.MoSearchGUI;
import se.ericsson.cello.emt.moti.LdnSelectionListener;
import se.ericsson.cello.emt.motools.common.config.ifc.Configuration;
import se.ericsson.cello.emt.motools.common.momodel.StartMo;
import se.ericsson.cello.emt.motools.common.momodel.StartMoFactory;
import se.ericsson.cello.emt.motools.common.toolservices.StartFailureException;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServicesFactory;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.utils.guihelper.IconHelper;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.ProgressListenerInterface;
import se.ericsson.security.launcher.ProgressUpdaterInterface;

public class MoSearchToolImpl
implements MoSearchTool,
ProgressUpdaterInterface {
    private LauncherInterface myLauncher;
    private MoSearch myMoSearch = null;
    private NodeServices myNodeServices;
    private Configuration myConfiguration;
    private Properties myParameters;
    private MoSearchModel mySearchModel;
    private MoSearchGUI myView;
    private CountDownLatch isInitialized;
    private ProgressListenerInterface listener = null;
    private boolean isToolStarted = false;

    public MoSearchToolImpl() {
        MoSearchLog.logger().info("MoSearchToolImpl constructor");
        this.isInitialized = new CountDownLatch(1);
    }

    public void reuse(String hostName, Properties parameters, LauncherInterface launcher, Launchable parent) {
        try {
            this.isInitialized.await();
        }
        catch (InterruptedException e) {
            MoSearchLog.logger().severe("await statement was interrupted");
            throw new RuntimeException(e.getMessage());
        }
        MoSearchLog.logger().info("MO Search reuse called with LDNs: " + parameters.getProperty("LDNs"));
        this.myParameters.remove("MOCLASS");
        Properties props = this.myParameters;
        props.putAll((Map<?, ?>)parameters);
        this.myConfiguration = MoSearchConfigImplFactory.createConfigurationHandler(props);
        ToolServices toolServices = ToolServicesFactory.createToolServices((Launchable)this, launcher, this.myConfiguration, this.myNodeServices, null);
        this.modelChanged(toolServices, this.myConfiguration);
    }

    public String toString() {
        String name = "";
        name = this.isToolStarted && this.myConfiguration != null ? this.myConfiguration.getManagerTitle() + " - " + this.myConfiguration.getCustomApplName() : "Element Manager - Search MO";
        return name;
    }

    public void exit() {
        this.isInitialized.countDown();
        if (null != this.mySearchModel) {
            this.mySearchModel.exit();
        }
        if (null != this.myView) {
            this.myView.exit();
        }
        this.myLauncher.onExit((Launchable)this);
    }

    public boolean reconnect(String arg0, Properties arg1) {
        return true;
    }

    public void run(String hostname, Properties arguments, LauncherInterface launcher, Launchable parent) {
        MoSearchLog.logger().info("MoSearch called with properties: " + arguments == null ? "null" : arguments.toString());
        this.myLauncher = launcher;
        this.myParameters = arguments;
        this.myConfiguration = MoSearchConfigImplFactory.createConfigurationHandler(arguments);
        this.init();
        this.listener.close();
    }

    public void setLdnSelectionListener(LdnSelectionListener listener) {
        try {
            this.isInitialized.await();
        }
        catch (InterruptedException e) {
            MoSearchLog.logger().severe("await statement was interrupted");
            throw new RuntimeException(e.getMessage());
        }
        this.myMoSearch.setLdnSelectionListener(listener);
    }

    public void modelChanged(ToolServices toolServices, Configuration configuration) {
        this.myMoSearch.modelChanged(toolServices, configuration);
        this.myView.updateUI(true);
    }

    private void init() {
        ToolServices toolServices = ToolServicesFactory.createToolServices((Launchable)this, this.myLauncher, this.myConfiguration);
        try {
            this.myNodeServices = toolServices.getNodeServices();
            StartMo startMo = StartMoFactory.createStartMo(this.myNodeServices, this.myConfiguration.getLdn());
            this.mySearchModel = MoSearchModelFactory.createMoSearchModel(toolServices, this.myConfiguration, startMo);
            this.myMoSearch = MoSearchFactory.createMoSearch(this.mySearchModel);
            this.myView = new MoSearchGUI(this.mySearchModel);
            this.mySearchModel.addView(this.myView);
            this.mySearchModel.showUI();
            this.isToolStarted = true;
        }
        catch (StartFailureException e) {
            MoSearchLog.logger().warning("An error occured while Search tried to initiate contact with the node. Exiting.");
            this.displayErrorMsg("Search MO could not start", "An error occured while trying to initiate contact with the node.", e);
            this.exit();
        }
        catch (Exception e) {
            MoSearchLog.logger().warning("An error occured while Search tried to initiate contact with the node. Exiting.");
            this.displayErrorMsg("Search MO could not start", "An error occured while trying to initiate contact with the node.", e);
            this.exit();
        }
        this.isInitialized.countDown();
    }

    private void displayErrorMsg(String heading, String msg, Exception e) {
        if (this.myView != null && this.myView.isVisible()) {
            MessageDialogFactory.createMessageDialog((String)heading, (String)msg, (Exception)e, (boolean)true, (JFrame)this.myView).setVisible(true);
        } else {
            JFrame invisibleFrame = null;
            String iconPath = this.myParameters.getProperty("TOOL_ICON");
            if (null != iconPath && iconPath.length() > 0) {
                Image im = new IconHelper().getIconImage(iconPath);
                invisibleFrame = new JFrame();
                invisibleFrame.setIconImage(im);
            }
            MessageDialogFactory.createMessageDialog((String)heading, (String)msg, (Exception)e, (boolean)true, invisibleFrame).setVisible(true);
        }
    }

    public void setProgressListener(ProgressListenerInterface listener) {
        this.listener = listener;
    }
}

