/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.gui.components;

import javax.swing.JLabel;
import se.ericsson.cello.emt.motools.common.mimparser.MimCompatibility;
import se.ericsson.cello.emt.motools.common.momodel.AttributeModel;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;
import se.ericsson.cello.mimparser.MomEntity;

public class AttributeJLabel
extends JLabel {
    private static final String RIGHT_PAREN = ")";
    private static final String LEFT_PAREN = "(";
    private static final String SPACE = " ";
    private AttributeModel attrModel;

    public AttributeJLabel(AttributeModel attrModel) {
        this.attrModel = attrModel;
        this.init();
    }

    private void init() {
        MomEntity momEntity = this.attrModel.getMomAttribute().getType();
        String attrModelName = this.attrModel.getName();
        String labelText = null;
        String unit = null;
        String multiplicationFactor = null;
        if (momEntity instanceof MomCorbaTypeAttribute) {
            unit = ((MomCorbaTypeAttribute)momEntity).getUnit();
            multiplicationFactor = ((MomCorbaTypeAttribute)momEntity).getMultiplicationFactor();
        }
        labelText = unit != null && multiplicationFactor != null && !multiplicationFactor.equals("1") ? attrModelName + SPACE + LEFT_PAREN + multiplicationFactor + " * " + unit + RIGHT_PAREN + ":" : (unit != null ? attrModelName + SPACE + LEFT_PAREN + unit + RIGHT_PAREN + ":" : attrModelName + ":");
        if (MimCompatibility.getDeprecated((MomEntity)this.attrModel.getMomAttribute()) != null) {
            super.setText("<html><strike>" + labelText + "</strike></html>");
        } else {
            super.setText(labelText);
        }
        super.setName(attrModelName);
    }
}

