/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.gui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.motools.common.gui.components.DataTypeGUI;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.gui.components.OE_Attr_TextField;
import se.ericsson.cello.emt.motools.common.gui.components.StringGUIDocumentListener;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.IntegerTypeValue;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;

public class IntegerGUI
extends DataTypeGUI {
    private static final long serialVersionUID = -142750682599911946L;
    private long initialValue;
    private long previousValue;
    private long maxValue;
    private long minValue;
    private String NOT_SET = "";
    private boolean readOnly = true;
    private IntegerTextField valueT = null;
    private JPanel panel = null;
    private boolean isValidInput = true;
    private IntegerTypeValue myIntegerTypeValue = null;
    private JTextField hiddenTextField = new JTextField();
    private JLabel faultyValue = null;

    public IntegerGUI(IntegerTypeValue aIntegerTypeValue, boolean isReadOnly, GUI_Container container, boolean supportNullValue, ToolServices aToolServices) {
        super(aIntegerTypeValue, container, aToolServices);
        this.panel = this.getPanel();
        this.myIntegerTypeValue = aIntegerTypeValue;
        String theMinValueAsString = this.myIntegerTypeValue.getMinAsStringValue();
        String theMaxValueAsString = this.myIntegerTypeValue.getMaxAsStringValue();
        try {
            this.minValue = Long.parseLong(theMinValueAsString);
        }
        catch (NumberFormatException e) {
            this.minValue = Integer.MIN_VALUE;
        }
        try {
            this.maxValue = Long.parseLong(theMaxValueAsString);
        }
        catch (NumberFormatException e) {
            this.maxValue = Integer.MAX_VALUE;
        }
        this.readOnly = isReadOnly;
        Long longValueObj = null;
        String stringValue = this.myIntegerTypeValue.getValueAsString();
        if (aIntegerTypeValue.isValueDefined()) {
            try {
                longValueObj = new Long(stringValue);
            }
            catch (NumberFormatException e) {
                longValueObj = new Long(0L);
                MoPropLog.logger().log(Level.INFO, "IntegerGUI: Illegal integer value: " + stringValue);
                this.faultyValue = new JLabel("  Invalid value");
            }
        } else {
            stringValue = "";
            longValueObj = new Long(0L);
        }
        this.valueT = new IntegerTextField(stringValue, longValueObj, this.readOnly);
        this.valueT.getDocument().addDocumentListener(new StringGUIDocumentListener(this));
        this.valueT.setAlignmentY(0.0f);
        this.valueT.setAlignmentX(0.0f);
        this.valueT.setName("valueField");
        if (this.faultyValue != null) {
            JPanel valueStatus = new JPanel(new BorderLayout());
            valueStatus.add((Component)this.valueT, "West");
            valueStatus.add((Component)this.faultyValue, "East");
            this.panel.add(valueStatus);
        } else {
            this.panel.add(this.valueT);
        }
        if (!supportNullValue && !aIntegerTypeValue.isValueDefined()) {
            JLabel statusL = new JLabel("Value is not defined");
            this.panel.add(statusL);
        }
    }

    public void newValue(String value) {
        this.valueT.setText(value);
    }

    public String getValue() {
        return this.valueT.getText();
    }

    public void setValue(String value) {
        MoPropLog.logger().log(Level.FINEST, "IntegerGUI.setValue(" + value + ")");
        this.valueT.putValue(value);
        this.setModified(false);
    }

    public void setGUIEditable(boolean editable) {
        this.valueT.setEditable(editable);
        if (editable) {
            this.valueT.setOpaque(true);
        } else {
            this.valueT.setOpaque(false);
        }
    }

    public boolean faultyValueEntered() {
        return !this.isValidInput;
    }

    class IntegerTextField
    extends OE_Attr_TextField {
        private static final long serialVersionUID = 771466731363423533L;
        Color errorColor;
        Color errorForegroundColor;

        IntegerTextField(String stringValue, long value, boolean readOnly) {
            super(stringValue);
            this.errorColor = new Color(255, 200, 200);
            this.errorForegroundColor = new Color(204, 0, 0);
            IntegerGUI.this.initialValue = value;
            IntegerGUI.this.previousValue = IntegerGUI.this.initialValue;
            this.setEditable(!readOnly);
            if (readOnly) {
                this.setOpaque(false);
                this.setBorder(null);
            } else {
                this.setOpaque(true);
                this.addKeyListener(new KeyAdapter(){

                    public void keyPressed(KeyEvent event) {
                        switch (event.getKeyCode()) {
                            case 40: {
                                IntegerGUI.this.newValue(Long.toString(IntegerGUI.this.previousValue - 1L));
                                break;
                            }
                            case 38: {
                                IntegerGUI.this.newValue(Long.toString(IntegerGUI.this.previousValue + 1L));
                            }
                            case 8: {
                                if (IntegerGUI.this.getValue().equals(IntegerGUI.this.NOT_SET)) {
                                    IntegerGUI.this.newValue("");
                                }
                            }
                            case 127: {
                                if (!IntegerGUI.this.getValue().equals(IntegerGUI.this.NOT_SET)) break;
                                IntegerGUI.this.newValue("");
                            }
                        }
                    }
                });
            }
            if (stringValue.equals(IntegerGUI.this.NOT_SET) && !readOnly) {
                this.verifyInput(stringValue);
            }
            String toolTipType = IntegerGUI.this.getTypeCode();
            String resolution = IntegerGUI.this.getResolution();
            String min = IntegerGUI.this.minValue + ",...";
            String max = "," + IntegerGUI.this.maxValue;
            boolean noLimitsAtAll = false;
            if (IntegerGUI.this.minValue == Integer.MIN_VALUE || IntegerGUI.this.minValue == Long.MIN_VALUE) {
                min = "...";
                noLimitsAtAll = true;
            }
            if (IntegerGUI.this.maxValue == Integer.MAX_VALUE || IntegerGUI.this.minValue == Long.MAX_VALUE) {
                max = "";
            } else {
                noLimitsAtAll = false;
            }
            if (noLimitsAtAll) {
                if (resolution != null) {
                    this.setToolTipText(toolTipType + ";" + " resolution:" + resolution);
                } else {
                    this.setToolTipText(toolTipType);
                }
            } else if (resolution != null) {
                this.setToolTipText(toolTipType + ": [" + min + max + "] ;" + " resolution:" + resolution);
            } else {
                this.setToolTipText(toolTipType + ": [" + min + max + "]");
            }
        }

        public void putValue(String value) {
            MoPropLog.logger().log(Level.FINEST, "IntegerTextField.putValue(" + value + ")");
            this.setText(value);
            try {
                IntegerGUI.this.initialValue = Long.valueOf(value);
                IntegerGUI.this.previousValue = IntegerGUI.this.initialValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
            IntegerGUI.this.setModified(false);
        }

        public boolean verifyInput(String attemptedText) {
            boolean changeValue = true;
            long attemptedValue = 0L;
            boolean accept = true;
            try {
                if (attemptedText.equals("") || attemptedText.equals("-") || attemptedText.equals(IntegerGUI.this.NOT_SET)) {
                    accept = false;
                } else {
                    boolean isAccepted;
                    attemptedValue = Long.valueOf(attemptedText);
                    boolean bl = isAccepted = attemptedValue >= IntegerGUI.this.minValue && attemptedValue <= IntegerGUI.this.maxValue;
                    if (attemptedValue != IntegerGUI.this.initialValue || !isAccepted) {
                        IntegerGUI.this.setModified(true);
                        accept = isAccepted;
                    }
                }
            }
            catch (NumberFormatException e) {
                accept = false;
                changeValue = false;
            }
            if (accept) {
                IntegerGUI.this.previousValue = attemptedValue;
                this.setOpaque(true);
                this.setForeground(IntegerGUI.this.hiddenTextField.getForeground());
            } else if (changeValue) {
                this.setOpaque(true);
                this.setForeground(this.errorForegroundColor);
            }
            this.invalidate();
            IntegerGUI.this.isValidInput = accept;
            this.requestFocus();
            return changeValue;
        }

        public Dimension getPreferredSize() {
            FontMetrics fm = this.getFontMetrics(IntegerGUI.this.getGUIFont());
            int width = fm.stringWidth("9223372036854775807") + 5;
            return new Dimension(width, super.getPreferredSize().height);
        }
    }
}

