/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.momodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import se.ericsson.cello.emt.moadd.MoAddLog;
import se.ericsson.cello.emt.motools.common.momodel.AttributeModel;
import se.ericsson.cello.emt.motools.common.momodel.AttributeModelImpl;
import se.ericsson.cello.emt.motools.common.momodel.MoTemplate;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValueFactory;
import se.ericsson.cello.mimparser.DerivedDataType;
import se.ericsson.cello.mimparser.MoRef;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.mimparser.MomSequence;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.mimparser.MomStructMember;
import se.ericsson.cello.mimparser.MomStructRef;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NameValueFactory;
import se.ericsson.cello.neal.cm.Struct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoTemplateImpl
implements MoTemplate {
    private MomClass momClass;
    private CmService cmService = null;
    private ArrayList<AttributeModel> attributeModels = null;
    private ArrayList<AttributeModel> attributeModelsWithSrcLdnValue = null;

    public MoTemplateImpl(MomClass momClass, CmService cmService) {
        this.momClass = momClass;
        this.cmService = cmService;
    }

    @Override
    public List<AttributeModel> getDefaultAttributeModels() {
        if (this.attributeModels != null) {
            return this.attributeModels;
        }
        if (this.momClass == null) {
            MoAddLog.logger().warning("momClass is null");
        }
        this.attributeModels = new ArrayList();
        TreeMap<String, AttributeModel> sortedAttrMap = new TreeMap<String, AttributeModel>();
        Iterator iter = this.momClass.getAttributes();
        while (iter.hasNext()) {
            String aName;
            MomAttribute attribute = (MomAttribute)iter.next();
            if (attribute == null) {
                MoAddLog.logger().warning("The MOM attribute is null");
            }
            if ((aName = attribute.getName()) == null) {
                MoAddLog.logger().warning("The name of the MOM attribute is null");
            } else {
                MoAddLog.logger().finer("The handled attribute is " + aName);
            }
            MomEntity aMomEntity = attribute.getType();
            if (aMomEntity == null) {
                MoAddLog.logger().warning("The MOM attribute type is null");
            }
            NameValue defaultValueAsNameValue = this.getDefaultValueAsNameValue(aName, aMomEntity);
            this.putAttrModelInMap(sortedAttrMap, attribute, defaultValueAsNameValue);
        }
        String moIdAttribute = this.momClass.getName() + "Id";
        sortedAttrMap.remove(moIdAttribute);
        this.attributeModels.addAll(sortedAttrMap.values());
        return this.attributeModels;
    }

    @Override
    public List<AttributeModel> getAttributeModelsWithSrcLdnValue(Mo sourceMo) {
        if (this.attributeModelsWithSrcLdnValue != null) {
            return this.attributeModelsWithSrcLdnValue;
        }
        this.attributeModelsWithSrcLdnValue = new ArrayList();
        TreeMap<String, AttributeModel> sortedAttrMap = new TreeMap<String, AttributeModel>();
        Iterator momAttrIter = this.momClass.getAttributes();
        ArrayList<String> attributesToFetch = new ArrayList<String>();
        while (momAttrIter.hasNext()) {
            MomAttribute attrInMom = (MomAttribute)momAttrIter.next();
            if (attrInMom.isReadOnly()) continue;
            attributesToFetch.add(attrInMom.getName());
        }
        String[] attributeNames = new String[attributesToFetch.size()];
        attributeNames = attributesToFetch.toArray(attributeNames);
        NameValue[] nameValues = null;
        boolean failedGettingAll = false;
        try {
            nameValues = sourceMo.getAttributes(attributeNames, null);
            if (null == nameValues) {
                failedGettingAll = true;
            }
        }
        catch (Exception exep) {
            failedGettingAll = true;
            MoAddLog.logger().info("Failed getting attribute values in one call. Will fetch them one by one");
        }
        if (failedGettingAll) {
            MoAddLog.logger().info("Will fetch attribute values one by one");
            for (int i = 0; i < attributeNames.length; ++i) {
                try {
                    NameValue srcLdnValueAsNameValue = sourceMo.getAttribute(attributeNames[i], null);
                    MomAttribute attrInMom = this.momClass.getAttribute(attributeNames[i]);
                    this.putAttrModelInMap(sortedAttrMap, attrInMom, srcLdnValueAsNameValue);
                    continue;
                }
                catch (Exception e) {
                    MoAddLog.logger().info("Failed getting an attribute value for " + attributeNames[i]);
                }
            }
        } else if (null != nameValues) {
            MoAddLog.logger().fine("Got all writable attribute values in one call to the node");
            for (int i = 0; i < nameValues.length; ++i) {
                MomAttribute attrInMom = this.momClass.getAttribute(nameValues[i].getName());
                this.putAttrModelInMap(sortedAttrMap, attrInMom, nameValues[i]);
            }
        }
        String moIdAttribute = this.momClass.getName() + "Id";
        sortedAttrMap.remove(moIdAttribute);
        this.attributeModelsWithSrcLdnValue.addAll(sortedAttrMap.values());
        return this.attributeModelsWithSrcLdnValue;
    }

    @Override
    public List<AttributeModel> getAttributeModels() {
        if (this.attributeModels != null) {
            return this.attributeModels;
        }
        this.attributeModels = new ArrayList();
        TreeMap<String, AttributeModelImpl> sortedAttrMap = new TreeMap<String, AttributeModelImpl>();
        Iterator iter = this.momClass.getAttributes();
        while (iter.hasNext()) {
            MomAttribute attribute = (MomAttribute)iter.next();
            TypeValue typeValue = TypeValueFactory.createTypeValue((MomEntity)attribute, null, this.cmService);
            AttributeModelImpl attributeModel = new AttributeModelImpl(attribute, typeValue);
            sortedAttrMap.put(attributeModel.getName(), attributeModel);
        }
        this.attributeModels.addAll(sortedAttrMap.values());
        return this.attributeModels;
    }

    private NameValue getDefaultValueAsNameValue(String aName, MomEntity aMomEntity) {
        NameValue nameValue = null;
        try {
            if (aMomEntity instanceof MomCorbaTypeAttribute) {
                MoAddLog.logger().finest("aMomEntity is instanceof MomCorbaTypeAttribute");
                nameValue = this.getDefaultValueForCorbaType(aName, (MomCorbaTypeAttribute)aMomEntity);
            } else if (aMomEntity instanceof MomSequence) {
                MoAddLog.logger().finest("aMomEntity is instanceof MomSequence");
                nameValue = this.getDefaultValueForMomSequence(aName, (MomSequence)aMomEntity);
            } else if (aMomEntity instanceof MomEnumRef) {
                MoAddLog.logger().finest("aMomEntity is instanceof MomEnumRef");
                nameValue = this.getDefaultValueForMomEnumRef(aName, (MomEnumRef)aMomEntity);
            } else if (aMomEntity instanceof MomClass) {
                MoAddLog.logger().finest("No default value for MomClass");
            } else if (aMomEntity instanceof MomStructRef) {
                MoAddLog.logger().finest("aMomEntity is instanceof MomStructRef");
                nameValue = this.getDefaultValueForMomStructRef(aName, (MomStructRef)aMomEntity);
            } else if (aMomEntity instanceof MoRef) {
                MoAddLog.logger().finest("No default value for MoRef");
            } else {
                MoAddLog.logger().warning("The MOM entity is of an unknown type");
            }
        }
        catch (NoClassDefFoundError noClassErr) {
            MoAddLog.logger().info("This seems to be a Mimparser that does not support MOM DTD Rev. D. The MomEntity: " + aMomEntity);
        }
        catch (Exception e1) {
            MoAddLog.logger().warning("Exception in getDefaultValueAsNameValue(). " + e1);
        }
        return nameValue;
    }

    private NameValue getDefaultValueForCorbaType(String name, MomCorbaTypeAttribute corbaType) {
        String javaType = corbaType.getType();
        Object defaultValue = corbaType.getDefault();
        if (defaultValue != null) {
            NameValueFactory nvf = this.cmService.getNameValueFactory();
            if (javaType.equals("Boolean")) {
                Boolean defValueBoolean = (Boolean)defaultValue;
                return nvf.create(name, defValueBoolean.booleanValue());
            }
            if (javaType.equals("Byte")) {
                Integer defValueInteger = (Integer)defaultValue;
                return nvf.create(name, defValueInteger.intValue());
            }
            if (javaType.equals("Character")) {
                Integer defValueInteger = (Integer)defaultValue;
                return nvf.create(name, defValueInteger.intValue());
            }
            if (javaType.equals("Double")) {
                Float defValueFloat = (Float)defaultValue;
                return nvf.create(name, defValueFloat.floatValue());
            }
            if (javaType.equals("Float")) {
                Float defValueFloat = (Float)defaultValue;
                return nvf.create(name, defValueFloat.floatValue());
            }
            if (javaType.equals("Integer")) {
                Integer defValueInteger = (Integer)defaultValue;
                return nvf.create(name, defValueInteger.intValue());
            }
            if (javaType.equals("Long")) {
                Long defValueLong = (Long)defaultValue;
                return nvf.create(name, defValueLong.longValue());
            }
            if (javaType.equals("Short")) {
                Integer defValueInteger = (Integer)defaultValue;
                return nvf.create(name, defValueInteger.intValue());
            }
            if (javaType.equals("String")) {
                String defValueString = "";
                if (!defaultValue.equals("\"\"")) {
                    defValueString = (String)defaultValue;
                }
                return nvf.create(name, defValueString);
            }
        }
        return null;
    }

    private NameValue getDefaultValueForMomEnumRef(String name, MomEnumRef momEnumRef) {
        NameValue nameValue = null;
        Integer enumDefaultValue = momEnumRef.getDefault();
        if (enumDefaultValue != null) {
            nameValue = this.cmService.getNameValueFactory().create(name, enumDefaultValue.intValue());
        }
        return nameValue;
    }

    private NameValue getDefaultValueForMomStructRef(String aStructName, MomStructRef momStructRef) {
        NameValue structDefaultNameValue = null;
        MomStruct momStruct = momStructRef.getStruct();
        structDefaultNameValue = this.getDefaultValueForMomStruct(aStructName, momStruct);
        return structDefaultNameValue;
    }

    private NameValue getDefaultValueForMomStruct(String aStructName, MomStruct momStruct) {
        NameValue structDefaultNameValue = null;
        Iterator iter = momStruct.getMembers();
        MomStructMember momStructMember = null;
        MomEntity momStructMemberValue = null;
        String momStructMemberName = null;
        ArrayList<NameValue> memberList = new ArrayList<NameValue>();
        while (iter.hasNext()) {
            NameValue nameValue;
            momStructMember = (MomStructMember)iter.next();
            momStructMemberName = momStructMember.getName();
            momStructMemberValue = momStructMember.getValue();
            if (momStructMemberValue instanceof MomCorbaTypeAttribute) {
                nameValue = this.getDefaultValueForCorbaType(momStructMemberName, (MomCorbaTypeAttribute)momStructMemberValue);
                if (nameValue == null) continue;
                memberList.add(nameValue);
                continue;
            }
            if (momStructMemberValue instanceof MomEnumRef) {
                nameValue = this.getDefaultValueForMomEnumRef(momStructMemberName, (MomEnumRef)momStructMemberValue);
                if (nameValue == null) continue;
                memberList.add(nameValue);
                continue;
            }
            if (!(momStructMemberValue instanceof MomSequence) || (nameValue = this.getDefaultValueForMomSequence(momStructMemberName, (MomSequence)momStructMemberValue)) == null) continue;
            memberList.add(nameValue);
        }
        NameValue[] nameValues = memberList.toArray(new NameValue[0]);
        Struct aStruct = new Struct(nameValues);
        structDefaultNameValue = this.cmService.getNameValueFactory().create(aStructName, aStruct);
        return structDefaultNameValue;
    }

    private NameValue getDefaultValueForMomSequence(String name, MomSequence momSequence) {
        NameValue nameValue = null;
        MomEntity aType = momSequence.getType();
        Iterator iter = momSequence.getDefaultValues();
        ArrayList<String> defaultValuesList = new ArrayList<String>();
        while (iter.hasNext()) {
            defaultValuesList.add((String)iter.next());
        }
        try {
            if (aType instanceof MomCorbaTypeAttribute) {
                nameValue = this.getDefaultValueArrayForCorbaType(name, (MomCorbaTypeAttribute)aType, defaultValuesList);
            } else if (aType instanceof MomEnumRef) {
                nameValue = this.getDefaultValueArrayForMomEnumRef(name, (MomEnumRef)aType, defaultValuesList);
            } else if (aType instanceof MomStruct) {
                nameValue = this.getDefaultValueArrayForMomStruct(name, (MomStruct)aType, defaultValuesList);
            } else if (!(aType instanceof MomClass)) {
                if (aType instanceof MomStructRef) {
                    nameValue = this.getDefaultValueArrayForMomStructRef(name, (MomStructRef)aType, defaultValuesList);
                } else if (!(aType instanceof MoRef) && aType instanceof DerivedDataType) {
                    nameValue = this.getDefaultValueArrayForDerivedDataType(name, aType, defaultValuesList);
                }
            }
        }
        catch (NoClassDefFoundError noClassErr) {
            MoAddLog.logger().info("This seems to be a Mimparser that does not support MOM DTD Rev. D. The MomEntity: " + aType);
        }
        return nameValue;
    }

    private NameValue getDefaultValueArrayForDerivedDataType(String name, MomEntity aMomEntity, List<String> defaultValueList) {
        if (aMomEntity instanceof DerivedDataType) {
            DerivedDataType theDerivedDataType = (DerivedDataType)aMomEntity;
            int n = defaultValueList.size();
            if (n <= 0) {
                return null;
            }
            NameValue defaultValueArrayAsNameValue = null;
            MomEntity aType = theDerivedDataType.getBaseType();
            if (aType instanceof MomCorbaTypeAttribute) {
                MomCorbaTypeAttribute aMomCorbaTypeAttribute = (MomCorbaTypeAttribute)aType;
                defaultValueArrayAsNameValue = this.getDefaultValueArrayForCorbaType(name, aMomCorbaTypeAttribute, defaultValueList);
            } else if (aType instanceof MomEnumRef) {
                MomEnumRef aMomEnumRef = (MomEnumRef)aType;
                defaultValueArrayAsNameValue = this.getDefaultValueArrayForMomEnumRef(name, aMomEnumRef, defaultValueList);
            } else if (aType instanceof MomStruct) {
                MomStruct aMomStruct = (MomStruct)aType;
                defaultValueArrayAsNameValue = this.getDefaultValueArrayForMomStruct(name, aMomStruct, defaultValueList);
            } else if (aType instanceof MomClass) {
                defaultValueArrayAsNameValue = null;
            } else if (aType instanceof MomStructRef) {
                MomStructRef aMomStructRef = (MomStructRef)aType;
                defaultValueArrayAsNameValue = this.getDefaultValueArrayForMomStructRef(name, aMomStructRef, defaultValueList);
            } else if (aType instanceof MoRef) {
                defaultValueArrayAsNameValue = null;
            } else if (aType instanceof MomSequence) {
                MomSequence aMomSequence = (MomSequence)aType;
                defaultValueArrayAsNameValue = this.getDefaultValueForMomSequence(name, aMomSequence);
            } else if (aType instanceof DerivedDataType) {
                defaultValueArrayAsNameValue = this.getDefaultValueArrayForDerivedDataType(name, aType, defaultValueList);
            }
            return defaultValueArrayAsNameValue;
        }
        return null;
    }

    private NameValue getDefaultValueArrayForCorbaType(String name, MomCorbaTypeAttribute corbaType, List<String> textList) {
        String javaType = corbaType.getType();
        NameValueFactory nvf = this.cmService.getNameValueFactory();
        int n = textList.size();
        if (n <= 0) {
            return null;
        }
        if (javaType.equals("Boolean")) {
            boolean[] bArr = new boolean[n];
            int i = 0;
            for (String defaultValueAsText : textList) {
                bArr[i++] = Boolean.parseBoolean(defaultValueAsText);
            }
            return nvf.create(name, bArr);
        }
        if (javaType.equals("Byte")) {
            int[] bArr = new int[n];
            int i = 0;
            for (String defaultValueAsText : textList) {
                bArr[i++] = Integer.parseInt(defaultValueAsText);
            }
            return nvf.create(name, bArr);
        }
        if (javaType.equals("Character")) {
            int[] bArr = new int[n];
            int i = 0;
            for (String defaultValueAsText : textList) {
                bArr[i++] = Character.getNumericValue(defaultValueAsText.charAt(0));
            }
            return nvf.create(name, bArr);
        }
        if (javaType.equals("Double")) {
            float[] bArr = new float[n];
            int i = 0;
            for (String defaultValueAsText : textList) {
                bArr[i++] = Float.parseFloat(defaultValueAsText);
            }
            return nvf.create(name, bArr);
        }
        if (javaType.equals("Float")) {
            float[] bArr = new float[n];
            int i = 0;
            for (String defaultValueAsText : textList) {
                bArr[i++] = Float.parseFloat(defaultValueAsText);
            }
            return nvf.create(name, bArr);
        }
        if (javaType.equals("Integer")) {
            int[] bArr = new int[n];
            int i = 0;
            for (String defaultValueAsText : textList) {
                bArr[i++] = Integer.parseInt(defaultValueAsText);
            }
            return nvf.create(name, bArr);
        }
        if (javaType.equals("Long")) {
            long[] bArr = new long[n];
            int i = 0;
            for (String defaultValueAsText : textList) {
                bArr[i++] = Long.parseLong(defaultValueAsText);
            }
            return nvf.create(name, bArr);
        }
        if (javaType.equals("Short")) {
            int[] bArr = new int[n];
            int i = 0;
            for (String defaultValueAsText : textList) {
                bArr[i++] = Integer.parseInt(defaultValueAsText);
            }
            return nvf.create(name, bArr);
        }
        if (javaType.equals("String")) {
            String[] bArr = new String[n];
            int i = 0;
            for (String defaultValueAsText : textList) {
                bArr[i++] = defaultValueAsText;
            }
            return nvf.create(name, bArr);
        }
        return null;
    }

    private NameValue getDefaultValueArrayForMomEnumRef(String name, MomEnumRef momEnumRef, List<String> textList) {
        NameValueFactory nvf = this.cmService.getNameValueFactory();
        int n = textList.size();
        if (n <= 0) {
            return null;
        }
        Iterator<String> iter = textList.iterator();
        NameValue defaultValueArrayAsNameValue = null;
        int[] bArr = new int[n];
        int i = 0;
        while (iter.hasNext()) {
            int tmpInt;
            String aDefaultValueAsText = iter.next();
            NameValue tmpNameValue = this.getDefaultValueForMomEnumRef(name, momEnumRef);
            if (tmpNameValue == null) {
                tmpInt = 0;
                MoAddLog.logger().info("Default value " + (i + 1) + " (of " + n + ") is null");
            } else {
                tmpInt = tmpNameValue.getIntValue();
            }
            bArr[i++] = tmpInt;
        }
        defaultValueArrayAsNameValue = nvf.create(name, bArr);
        return defaultValueArrayAsNameValue;
    }

    private NameValue getDefaultValueArrayForMomStruct(String name, MomStruct momStruct, List<String> textList) {
        NameValueFactory nvf = this.cmService.getNameValueFactory();
        int n = textList.size();
        if (n <= 0) {
            return null;
        }
        Iterator<String> iter = textList.iterator();
        NameValue defaultValueArrayAsNameValue = null;
        Struct[] bArr = new Struct[n];
        int i = 0;
        while (iter.hasNext()) {
            bArr[i++] = this.getDefaultValueForMomStruct(name, momStruct).getStructValue();
        }
        defaultValueArrayAsNameValue = nvf.create(name, bArr);
        return defaultValueArrayAsNameValue;
    }

    private NameValue getDefaultValueArrayForMomStructRef(String name, MomStructRef momStructRef, List<String> textList) {
        NameValueFactory nvf = this.cmService.getNameValueFactory();
        int n = textList.size();
        if (n <= 0) {
            return null;
        }
        Iterator<String> iter = textList.iterator();
        NameValue defaultValueArrayAsNameValue = null;
        Struct[] bArr = new Struct[n];
        int i = 0;
        while (iter.hasNext()) {
            bArr[i++] = this.getDefaultValueForMomStructRef(name, momStructRef).getStructValue();
        }
        defaultValueArrayAsNameValue = nvf.create(name, bArr);
        return defaultValueArrayAsNameValue;
    }

    @Override
    public MomClass getMomClass() {
        return this.momClass;
    }

    @Override
    public String getName() {
        return this.momClass.getName();
    }

    private void putAttrModelInMap(TreeMap<String, AttributeModel> sortedAttrMap, MomAttribute attrInMom, NameValue srcLdnValueAsNameValue) {
        TypeValue typeValue = TypeValueFactory.createTypeValue((MomEntity)attrInMom, srcLdnValueAsNameValue, this.cmService);
        AttributeModelImpl attributeModel = new AttributeModelImpl(attrInMom, typeValue);
        sortedAttrMap.put(attributeModel.getName(), attributeModel);
    }
}

