/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.common.proxy;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import enea.ose.system.SignalRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import se.ericsson.cello.neal.NealRuntimeException;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.NodeFactory;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.proxy.AbstractSignalConverter;
import se.ericsson.crbs.omf.common.proxy.AbstractSignalConverterHelper;
import se.ericsson.crbs.omf.common.proxy.IllegalSignalException;
import se.ericsson.crbs.omf.common.proxy.OseSenderReceiver;
import se.ericsson.crbs.omf.common.proxy.OseSenderReceiverFactoryImpl;
import se.ericsson.crbs.omf.common.proxy.SignalConverter;
import se.ericsson.crbs.omf.common.proxy.SignalException;
import se.ericsson.crbs.omf.common.proxy.SignalHandler;
import se.ericsson.crbs.omf.common.proxy.SignalObject;

public class AbstractSignalConverterHelperImpl
implements SignalConverter,
Runnable,
AbstractSignalConverterHelper {
    private static final Class THIS_CLASS = AbstractSignalConverterHelperImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    protected final List signalHandlers = new ArrayList();
    private final String serviceName;
    private final AbstractSignalConverter abstractSignalConverter;
    private final OseSenderReceiver oseSenderReceiver;
    private boolean serviceRunning = false;
    protected OseProcess inputThreadProcess = null;
    private QueueThread queueThread = null;
    private final SignalRegistry sigReg;
    private Thread inputThread = null;
    protected final List signalsToBeSent = new ArrayList();
    private ListIterator iterator = null;
    private final int EMPTY_LIST = -1;
    private int pos = -1;
    private final int max_queued_signals;

    public AbstractSignalConverterHelperImpl(String inputServiceName, Class[] inputSignals, AbstractSignalConverter inputAbstractSignalConverter) {
        this.serviceName = inputServiceName;
        this.abstractSignalConverter = inputAbstractSignalConverter;
        this.max_queued_signals = 0;
        this.oseSenderReceiver = OseSenderReceiverFactoryImpl.getInstance().getOseSenderReceiver();
        this.sigReg = new SignalRegistry();
        for (int i = 0; i < inputSignals.length; ++i) {
            this.sigReg.add(inputSignals[i]);
        }
    }

    public AbstractSignalConverterHelperImpl(String inputServiceName, Class[] inputSignals, AbstractSignalConverter inputAbstractSignalConverter, Integer maxQueuedSignals) {
        this.serviceName = inputServiceName;
        this.abstractSignalConverter = inputAbstractSignalConverter;
        this.max_queued_signals = maxQueuedSignals;
        this.oseSenderReceiver = OseSenderReceiverFactoryImpl.getInstance().getOseSenderReceiver();
        this.sigReg = new SignalRegistry();
        for (int i = 0; i < inputSignals.length; ++i) {
            this.sigReg.add(inputSignals[i]);
        }
    }

    private void inputSignalReceived(InSignal inSignal) throws IllegalSignalException {
        this.abstractSignalConverter.inputSignalReceived(inSignal);
    }

    public void sendSignal(OseProcess sender, OseProcess receiver, Signal signal) throws SignalException {
        this.oseSenderReceiver.sendSignal(sender, receiver, signal);
    }

    public void run() {
        logger.traceEnter(THIS_CLASS, "run()");
        this.waitForServiceToComeUp();
        this.inputThreadProcess = this.oseSenderReceiver.getThisProcess();
        this.oseSenderReceiver.addServiceToOseNameServer(this.serviceName);
        while (this.serviceRunning) {
            try {
                InSignal inSignal = this.oseSenderReceiver.receiveSignal(this.sigReg, 5000);
                if (inSignal == null) continue;
                logger.traceDebug(THIS_CLASS, "run() got signal");
                this.queueThread.addInputSignal(inSignal);
            }
            catch (Exception e) {
                logger.traceError(THIS_CLASS, "Received exception when reading OSE signal: " + e.getMessage());
            }
        }
        this.oseSenderReceiver.removeServiceFromOseNameServer(this.serviceName);
        logger.traceReturn(THIS_CLASS, "run()");
    }

    private void waitForServiceToComeUp() {
        while (this.serviceRunning) {
            try {
                Node localNode = NodeFactory.getNode();
                localNode.getCmService();
                break;
            }
            catch (NealRuntimeException nre) {
                logger.traceDebug(THIS_CLASS, "MO service not up, waiting..");
            }
            catch (Exception e) {
                logger.traceAbnormal(THIS_CLASS, "Proxy start caught Exception: " + e.getClass() + " " + e.getMessage());
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSignalHandler(SignalObject signalObject, SignalHandler signalHandler) {
        List list = this.signalHandlers;
        synchronized (list) {
            SignalHandlerHolder signalHandlerHolder = new SignalHandlerHolder(signalObject, signalHandler);
            if (!this.signalHandlers.contains(signalHandlerHolder)) {
                this.signalHandlers.add(signalHandlerHolder);
                logger.traceGeneral(THIS_CLASS, "Added: " + signalHandlerHolder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSignalHandler(SignalObject signalObject, SignalHandler signalHandler) {
        List list = this.signalHandlers;
        synchronized (list) {
            SignalHandlerHolder signalHandlerHolder = new SignalHandlerHolder(signalObject, signalHandler);
            if (this.signalHandlers.remove(signalHandlerHolder)) {
                logger.traceGeneral(THIS_CLASS, "Removed: " + signalHandlerHolder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignalHandler[] getSignalHandlers(SignalObject signalObject) {
        List list = this.signalHandlers;
        synchronized (list) {
            ArrayList<SignalHandler> handlersForSignal = new ArrayList<SignalHandler>();
            if (signalObject != null) {
                for (int i = 0; i < this.signalHandlers.size(); ++i) {
                    SignalHandlerHolder signalHandlerHolder = (SignalHandlerHolder)this.signalHandlers.get(i);
                    if (!((Object)signalHandlerHolder.signalObject).equals(signalObject)) continue;
                    handlersForSignal.add(signalHandlerHolder.signalHandler);
                }
            }
            SignalHandler[] signalHandlerArray = new SignalHandler[handlersForSignal.size()];
            handlersForSignal.toArray(signalHandlerArray);
            return signalHandlerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignalHandler[] getAllSignalHandlers() {
        List list = this.signalHandlers;
        synchronized (list) {
            List list2 = this.signalHandlers;
            synchronized (list2) {
                ArrayList<SignalHandler> signalHandlersList = new ArrayList<SignalHandler>();
                for (int i = 0; i < this.signalHandlers.size(); ++i) {
                    SignalHandlerHolder signalHandlerHolder = (SignalHandlerHolder)this.signalHandlers.get(i);
                    signalHandlersList.add(signalHandlerHolder.signalHandler);
                }
                SignalHandler[] signalHandlerArray = new SignalHandler[signalHandlersList.size()];
                signalHandlersList.toArray(signalHandlerArray);
                return signalHandlerArray;
            }
        }
    }

    public void startService() {
        logger.traceEnter(THIS_CLASS, "startService()");
        this.inputThread = new Thread((Runnable)this, "Input_Thread_for_Proxy:_\"" + this.serviceName + "\"");
        this.queueThread = new QueueThread(this.serviceName);
        this.serviceRunning = true;
        this.queueThread.startQueue();
        this.inputThread.start();
        logger.traceReturn(THIS_CLASS, "startService()");
    }

    public void stopService() {
        logger.traceEnter(THIS_CLASS, "stopService()");
        this.stopService(0);
        logger.traceReturn(THIS_CLASS, "stopService()");
    }

    public void stopService(int waitMilliSeconds) {
        logger.traceEnter(THIS_CLASS, "stopService(" + waitMilliSeconds + ")");
        this.serviceRunning = false;
        this.queueThread.stopQueue();
        if (waitMilliSeconds > 0) {
            long stopTime = System.currentTimeMillis() + (long)waitMilliSeconds;
            while (System.currentTimeMillis() < stopTime && this.queueThread.isAlive()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ignore) {}
            }
        }
        logger.traceReturn(THIS_CLASS, "stopService(" + waitMilliSeconds + ")");
    }

    public boolean isServiceRunning() {
        return this.serviceRunning && this.inputThread.isAlive() && this.queueThread != null && this.queueThread.isAlive();
    }

    public OseProcess getSender(InSignal inSignal) {
        return this.oseSenderReceiver.getSender(inSignal);
    }

    public InSignal peekSignalQueue() {
        InSignal inSignal = null;
        if (this.pos < this.signalsToBeSent.size() - 1) {
            inSignal = (InSignal)this.signalsToBeSent.get(this.pos + 1);
        }
        return inSignal;
    }

    private class QueueThread
    extends Thread {
        private boolean queueRunning;
        private final List waitingSignals;

        public QueueThread(String inputServiceName) {
            super("Queueing_Thread_for_Proxy:_\"" + inputServiceName + "\"");
            this.queueRunning = false;
            this.waitingSignals = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.queueRunning) {
                try {
                    List inSignal;
                    List list = this.waitingSignals;
                    synchronized (list) {
                        if (AbstractSignalConverterHelperImpl.this.signalsToBeSent.isEmpty() && !this.waitingSignals.isEmpty()) {
                            AbstractSignalConverterHelperImpl.this.signalsToBeSent.addAll(this.waitingSignals);
                            logger.traceDebug(THIS_CLASS, "Added all " + this.waitingSignals.size() + " signals to queue");
                            this.waitingSignals.clear();
                        } else if (this.waitingSignals.isEmpty()) {
                            this.waitingSignals.wait(5000L);
                        }
                    }
                    AbstractSignalConverterHelperImpl.this.iterator = AbstractSignalConverterHelperImpl.this.signalsToBeSent.listIterator();
                    while (AbstractSignalConverterHelperImpl.this.iterator.hasNext()) {
                        inSignal = (InSignal)AbstractSignalConverterHelperImpl.this.iterator.next();
                        AbstractSignalConverterHelperImpl.this.pos++;
                        String signalName = inSignal.getClass().getName();
                        logger.traceGeneral(THIS_CLASS, "Executing queued signal: [" + signalName + "]");
                        AbstractSignalConverterHelperImpl.this.inputSignalReceived((InSignal)inSignal);
                    }
                    inSignal = AbstractSignalConverterHelperImpl.this.signalsToBeSent;
                    synchronized (inSignal) {
                        AbstractSignalConverterHelperImpl.this.pos = -1;
                        AbstractSignalConverterHelperImpl.this.signalsToBeSent.clear();
                    }
                }
                catch (IllegalSignalException is) {
                    logger.traceError(THIS_CLASS, "Received IllegalSignal while execution queue of request: " + is.getMessage());
                }
                catch (InterruptedException ie) {
                    logger.traceError(THIS_CLASS, "Received InterruptedException while execution of queue request: " + ie.getMessage());
                }
                catch (Exception e) {
                    logger.traceError(THIS_CLASS, "Received exception while execution of queue request:" + e.getClass());
                    StackTraceElement[] stetab = e.getStackTrace();
                    String exStr = e.toString() + "\n";
                    for (int i = 0; i < stetab.length; ++i) {
                        exStr = exStr + "\t" + stetab[i].toString();
                        exStr = exStr + "\n";
                    }
                    logger.traceError(THIS_CLASS, "run(), StackTrace: " + exStr);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addInputSignal(InSignal inSignal) {
            List list = this.waitingSignals;
            synchronized (list) {
                String signalName = inSignal.getClass().getName();
                logger.traceGeneral(THIS_CLASS, "addInputSignal received signal: [" + signalName + "]" + " queue size:" + this.waitingSignals.size());
                if (AbstractSignalConverterHelperImpl.this.max_queued_signals > 0 && this.waitingSignals.size() >= AbstractSignalConverterHelperImpl.this.max_queued_signals) {
                    logger.traceAbnormal(THIS_CLASS, "addInputSignal QUEUE FULL! signal discharded:" + signalName + "]");
                } else {
                    this.waitingSignals.add(inSignal);
                    this.waitingSignals.notifyAll();
                }
            }
        }

        public void startQueue() {
            this.queueRunning = true;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopQueue() {
            this.queueRunning = false;
            List list = this.waitingSignals;
            synchronized (list) {
                this.waitingSignals.notifyAll();
            }
        }
    }

    private class SignalHandlerHolder {
        private final SignalObject signalObject;
        private final SignalHandler signalHandler;
        private final int hashValue;
        private final String stringValue;

        SignalHandlerHolder(SignalObject inputSignalObject, SignalHandler inputSignalHandler) {
            this.signalObject = inputSignalObject;
            this.signalHandler = inputSignalHandler;
            this.hashValue = (((Object)this.signalHandler).toString() + ((Object)this.signalObject).toString()).hashCode();
            this.stringValue = "Signal handler \"" + this.signalHandler + "\" for signal object, \"" + this.signalObject + "\"";
        }

        protected SignalObject getSignalObject() {
            return this.signalObject;
        }

        protected SignalHandler getSignalHandler() {
            return this.signalHandler;
        }

        public final int hashCode() {
            return this.hashValue;
        }

        public final boolean equals(Object otherObj) {
            boolean result = false;
            if (otherObj != null && otherObj instanceof SignalHandlerHolder) {
                SignalHandlerHolder otherSignalHandlerHolder = (SignalHandlerHolder)otherObj;
                result = this.signalObject.getSignalNumber() == otherSignalHandlerHolder.getSignalObject().getSignalNumber() && this.signalHandler.equals(otherSignalHandlerHolder.getSignalHandler());
            }
            return result;
        }

        public final String toString() {
            return this.stringValue;
        }
    }
}

