/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.omf.mao.genericmo.NullManagedObject;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class AttrListImpl
implements AttrList {
    private final List attrNames;
    protected final List attrValues;
    private final MoRepositoryWrapper moRepositoryWrapper;

    public AttrListImpl(List attrNames, List attrValues, MoRepositoryWrapper moRepositoryWrapper) {
        this.attrNames = attrNames;
        this.attrValues = attrValues;
        this.moRepositoryWrapper = moRepositoryWrapper;
    }

    public AttrListImpl(MoRepositoryWrapper moRepositoryWrapper) {
        this.attrNames = new ArrayList();
        this.attrValues = new ArrayList();
        this.moRepositoryWrapper = moRepositoryWrapper;
    }

    public AttrListImpl(String[] pattrNames, Object[] pattrValues, MoRepositoryWrapper moRepositoryWrapper) {
        this.attrNames = new ArrayList();
        this.attrValues = new ArrayList();
        for (int idx = 0; idx < pattrNames.length; ++idx) {
            this.attrNames.add(pattrNames[idx]);
            this.attrValues.add(pattrValues[idx]);
        }
        this.moRepositoryWrapper = moRepositoryWrapper;
    }

    public void addAttribute(String attrName, Object attrValue) {
        int index = this.indexOf(attrName);
        if (index != -1) {
            this.removeElementAt(index);
        }
        this.attrNames.add(attrName);
        this.attrValues.add(attrValue);
    }

    public void addElement(String attributeName, Object attributeValue) {
        this.attrNames.add(attributeName);
        this.attrValues.add(attributeValue);
    }

    private boolean checkIfSupportedPrimitiveType(Object value) {
        boolean isStruct;
        boolean res = false;
        boolean isInteger = value instanceof Integer || value instanceof Integer[] || value instanceof int[];
        boolean isLong = value instanceof Long || value instanceof Long[] || value instanceof long[];
        boolean isFloat = value instanceof Float || value instanceof Float[];
        boolean isBoolean = value instanceof Boolean || value instanceof Boolean[] || value instanceof boolean[];
        boolean isString = value instanceof String || value instanceof String[];
        boolean bl = isStruct = value instanceof Struct || value instanceof Struct[];
        if (isInteger || isLong || isFloat || isBoolean || isString || isStruct) {
            res = true;
        }
        return res;
    }

    public boolean contains(String[] searchList) {
        boolean result = true;
        for (int idx = 0; idx < searchList.length; ++idx) {
            if (this.indexOf(searchList[idx]) != -1) continue;
            result = false;
            break;
        }
        return result;
    }

    public String getName(int index) {
        return (String)this.attrNames.get(index);
    }

    public Object getValue(int index) throws NotHandledAttributeTypeException, MoNotFoundException {
        Object value = this.attrValues.get(index);
        Object result = null;
        if (value != null) {
            if (value instanceof ManagedObject) {
                result = this.getValueManagedObject(index);
            } else if (value instanceof ManagedObject[]) {
                result = this.getValueManagedObjectArray(index, value);
            } else if (this.checkIfSupportedPrimitiveType(value)) {
                result = value;
            } else {
                throw new NotHandledAttributeTypeException();
            }
        }
        return result;
    }

    private Object getValueManagedObject(int index) throws MoNotFoundException {
        ManagedObject managedObject = (ManagedObject)this.attrValues.get(index);
        String distName = managedObject.getLocalDistinguishedName();
        if (this.moRepositoryWrapper.lookup(distName) == null) {
            throw new MoNotFoundException(distName);
        }
        ManagedObject result = managedObject;
        return result;
    }

    private Object getValueManagedObjectArray(int index, Object value) throws MoNotFoundException {
        for (int idx = 0; idx < ((ManagedObject[])value).length; ++idx) {
            ManagedObject managedObject = ((ManagedObject[])this.attrValues.get(index))[idx];
            String distName = managedObject.getLocalDistinguishedName();
            if (this.moRepositoryWrapper.lookup(distName) != null || managedObject instanceof NullManagedObject) continue;
            throw new MoNotFoundException(distName);
        }
        Object result = value;
        return result;
    }

    public int indexOf(String name) {
        int result = -1;
        for (int idx = 0; idx < this.attrNames.size(); ++idx) {
            if (!this.getName(idx).equalsIgnoreCase(name)) continue;
            result = idx;
            break;
        }
        return result;
    }

    public void removeElementAt(int index) {
        this.attrNames.remove(index);
        this.attrValues.remove(index);
    }

    public int size() {
        return this.attrNames.size();
    }

    public String toString() {
        return StringHelper.toString(this);
    }

    public List getAttrNames() {
        return this.attrNames;
    }

    public List getAttrValues() {
        return this.attrValues;
    }
}

