/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.metadata;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AttributeDataType;

public class StructMetaData {
    private final String name;
    private final Map members;
    private Map deprecated = new TreeMap();

    public StructMetaData(String name, Map members) {
        this.name = name;
        this.members = members;
    }

    public AttributeDataType getMemberData(String memberName) {
        AttributeDataType reqMember = null;
        Iterator structMemberIter = this.members.values().iterator();
        while (structMemberIter.hasNext()) {
            AttributeDataType currentMemberData = (AttributeDataType)structMemberIter.next();
            if (!currentMemberData.getAttributeName().equals(memberName)) continue;
            reqMember = currentMemberData;
            break;
        }
        return reqMember;
    }

    public String[] getMemberNames() {
        String[] memberNames = new String[this.members.size()];
        Iterator structMemberIter = this.members.values().iterator();
        int index = 0;
        while (structMemberIter.hasNext()) {
            AttributeDataType currentMemberData = (AttributeDataType)structMemberIter.next();
            memberNames[index] = currentMemberData.getAttributeName();
            ++index;
        }
        return memberNames;
    }

    public Map getMembers() {
        return this.members;
    }

    public String[] getDeprecatedMemberNames() {
        String[] deprecatedMemberNames = new String[this.deprecated.size()];
        Iterator structMemberIter = this.deprecated.values().iterator();
        int index = 0;
        while (structMemberIter.hasNext()) {
            AttributeDataType currentMemberData = (AttributeDataType)structMemberIter.next();
            deprecatedMemberNames[index] = currentMemberData.getAttributeName();
            ++index;
        }
        return deprecatedMemberNames;
    }

    public void setDeprecated(Map deprecated) {
        this.deprecated = deprecated;
    }

    public Map getDeprecated() {
        return this.deprecated;
    }

    public String getName() {
        return this.name;
    }
}

