/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.mib;

import se.ericsson.cello.moframework.Mib;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.mib.MibHandler;
import se.ericsson.crbs.omf.mao.commonmo.mib.MibMgrWrapper;
import se.ericsson.crbs.omf.mao.commonmo.mib.MimVersionReader;

public class MibHandlerImpl
implements MibHandler {
    private static AbstractLogger logger = LoggingService.getLogger();
    private static final Class THIS_CLASS = MibHandlerImpl.class;
    private final transient MibMgrWrapper mibMgrWrapper;
    private final transient MimVersionReader mimVersionReader;
    private final transient TransactionFactory transactionFactory;

    public MibHandlerImpl(MimVersionReader aReader, TransactionFactory aTransFactory, MibMgrWrapper aMibMgrWrapper) {
        this.mimVersionReader = aReader;
        this.transactionFactory = aTransFactory;
        this.mibMgrWrapper = aMibMgrWrapper;
    }

    public void setMimVersion() {
        logger.traceEnter(THIS_CLASS, "setMimVersion");
        this.setMimVersion(this.mimVersionReader);
        logger.traceReturn(THIS_CLASS, "setMimVersion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMimVersion(MimVersionReader inputMimVersionReader) {
        String currentMimVersion = inputMimVersionReader.getMimVersion();
        String currentMimType = inputMimVersionReader.getMimType();
        String currentMimRelease = inputMimVersionReader.getMimRelease();
        logger.traceEnter(THIS_CLASS, "setMimVersion(version[" + currentMimVersion + "], type[" + currentMimType + "], release[" + currentMimRelease + "])");
        Mib mib = this.mibMgrWrapper.getMib();
        try {
            Control transaction = this.transactionFactory.create(59);
            Coordinator coordinator = transaction.getCoordinator();
            mib.setModelVersion(currentMimVersion, coordinator);
            logger.info(this.getClass(), "MIM version is set to " + currentMimVersion);
            mib.setModelType(currentMimType, coordinator);
            logger.info(this.getClass(), "MIM type is set to " + currentMimType);
            mib.setModelRelease(currentMimRelease, coordinator);
            logger.info(this.getClass(), "MIM release is set to " + currentMimRelease);
            transaction.getTerminator().commit();
        }
        catch (TransactionRolledBackException e) {
            logger.traceError(this.getClass(), "Failed to create or commit the transaction: " + (Object)((Object)e));
        }
        catch (MoAccessException e) {
            logger.traceError(this.getClass(), "Failed to set version or type of the MIM: " + (Object)((Object)e));
        }
        catch (InactiveTransactionException e) {
            logger.traceError(this.getClass(), "Transaction not active: " + (Object)((Object)e));
        }
        finally {
            logger.traceReturn(THIS_CLASS, "setMimVersion()");
        }
    }
}

