/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.mo;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonif.LdnFinder;
import se.ericsson.crbs.omf.mao.commonmo.mo.LdnProvider;

public class LdnFinderImpl
implements LdnFinder,
LdnProvider {
    private static final Class THIS_CLASS = LdnFinderImpl.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final Map moMap = new HashMap();

    public LdnFinderImpl() {
        logger.traceEnter(THIS_CLASS, "LdnFinderImpl");
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        serviceRepository.addService((Object)this, LdnFinder.class, null);
        serviceRepository.addService((Object)this, LdnProvider.class, null);
        logger.traceReturn(THIS_CLASS, "LdnFinderImpl");
    }

    private String generateKey(long froType, long froId) {
        return Long.toString(froType) + Long.toString(froId);
    }

    public String getManagedObjectLdn(long froType, long froId) throws MoNotFoundException {
        logger.traceEnter(THIS_CLASS, "getManagedObjectLdn(" + froType + ", " + froId + ")");
        String ldn = (String)this.moMap.get(this.generateKey(froType, froId));
        logger.traceReturn(THIS_CLASS, "getManagedObjectLdn");
        return ldn;
    }

    public void deregisterLdn(long froType, long froId) {
        logger.traceEnter(THIS_CLASS, "deregisterLdn(" + froType + ", " + froId + ")");
        this.moMap.remove(this.generateKey(froType, froId));
        logger.traceReturn(THIS_CLASS, "deregisterLdn");
    }

    public void registerLdn(long froType, long froId, String ldn) {
        logger.traceEnter(THIS_CLASS, "registerLdn(" + froType + ", " + froId + ", " + ldn + ")");
        this.moMap.put(this.generateKey(froType, froId), ldn);
        logger.traceReturn(THIS_CLASS, "registerLdn");
    }
}

