/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo;

import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.DeprecatedGenericMaoHelper;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class DeprecatedGenericMao
extends GenericMao {
    private static final Class THIS_CLASS = DeprecatedGenericMao.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());

    public DeprecatedGenericMao(ManagedObject parent, String identity, String moType, GenericMaoContext genericMaoContext, Coordinator coordinator, InitialMaoContext initialmaocontext) throws MoAccessException {
        super(parent, identity, moType, genericMaoContext, coordinator, initialmaocontext);
        if (this.replacesAnotherMO()) {
            String replacedMoName = DeprecatedGenericMaoHelper.getReplacedMoName(this.getMoType(), genericMaoContext);
            new DeprecatedGenericMao(parent, identity, replacedMoName, genericMaoContext, coordinator, initialmaocontext);
        }
    }

    protected DeprecatedGenericMao(MoDataWrapper recoveredData, String moType, GenericMaoContext genericMaoContext, InitialMaoContext initialmaocontext) throws MoNameAlreadyTakenException, MoAccessException {
        super(recoveredData, moType, genericMaoContext, initialmaocontext);
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "delete() - " + this.getLocalDistinguishedName());
        GenericMao replacingMo = DeprecatedGenericMaoHelper.lookupReplacingMo(this.getMoType(), this.getNamingAttributeValue(), this.getParent().getLocalDistinguishedName(), this.genericMaoContext);
        replacingMo.delete(coordinator);
        logger.traceReturn(THIS_CLASS, "delete() - " + this.getLocalDistinguishedName());
    }

    public void deprecatedDelete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "deprecatedDelete() - " + this.getLocalDistinguishedName());
        this.preDelete(coordinator);
        this.deleteMo(coordinator);
        if (this.replacesAnotherMO()) {
            DeprecatedGenericMao deprMo = (DeprecatedGenericMao)DeprecatedGenericMaoHelper.lookupReplacedMo(this.getMoType(), this.getNamingAttributeValue(), this.getLocalDistinguishedName(), this.getParent().getLocalDistinguishedName(), this.genericMaoContext);
            deprMo.deprecatedDelete(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "deprecatedDelete() - " + this.getLocalDistinguishedName());
    }

    public void deleteInternal(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "deleteInternal() - " + this.getLocalDistinguishedName());
        GenericMao replacingMo = DeprecatedGenericMaoHelper.lookupReplacingMo(this.getMoType(), this.getNamingAttributeValue(), this.getParent().getLocalDistinguishedName(), this.genericMaoContext);
        replacingMo.deleteInternal(coordinator);
        logger.traceReturn(THIS_CLASS, "deleteInternal() - " + this.getMoType());
    }

    public void reserve(ManagedObject moToReference, Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "reserve(" + moToReference.getLocalDistinguishedName() + ") - " + this.getMoType());
        GenericMao replacingMo = DeprecatedGenericMaoHelper.lookupReplacingMo(this.getMoType(), this.getNamingAttributeValue(), this.getParent().getLocalDistinguishedName(), this.genericMaoContext);
        replacingMo.reserve(moToReference, coordinator);
        logger.traceReturn(THIS_CLASS, "reserve(" + moToReference.getLocalDistinguishedName() + ") - " + this.getMoType());
    }

    public void release(ManagedObject moToRemove, Coordinator coordinator) throws TransactionRequiredException, MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "release(" + moToRemove.getLocalDistinguishedName() + ") - " + this.getMoType());
        GenericMao replacingMo = DeprecatedGenericMaoHelper.lookupReplacingMo(this.getMoType(), this.getNamingAttributeValue(), this.getParent().getLocalDistinguishedName(), this.genericMaoContext);
        replacingMo.release(moToRemove, coordinator);
        logger.traceReturn(THIS_CLASS, "release(" + moToRemove.getLocalDistinguishedName() + ") - " + this.getMoType());
    }

    public void postRecover() throws TransactionRequiredException, MoAccessException {
    }
}

