/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.StringHolder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.supplier.DataSupplier;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoValidator;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoValidatorFactory;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoUpgradeSubscriber;
import se.ericsson.crbs.omf.mao.genericmo.MaoFactory;
import se.ericsson.crbs.omf.mao.genericmo.SpecialisedMaoImplClassHelper;
import se.ericsson.crbs.omf.mao.indications.ServiceHandler;
import se.ericsson.crbs.omf.mao.indications.ServiceHandlerFactory;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapperFactory;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class GenericMaoFactory
implements MaoFactory {
    private static final AbstractLogger logger = LoggingService.getLogger(GenericMaoFactory.class.getName());
    private static final Class THIS_CLASS = GenericMaoFactory.class;
    protected final ServiceHandlerFactory serviceHandlerFactory;
    protected final MoValidatorFactory moValidatorFactory;
    private final MoDataWrapperFactory moDataWrapperFactory;
    protected final GenericMaoContext genericMaoContext;
    protected String myMoType = null;
    protected boolean mStarted = false;
    protected InitialMaoContext initMaocontext;
    public static final String BLOCK_CREATE = "Operation createMO is disabled during upgrade";

    protected GenericMaoFactory(String moType, GenericMaoContext aGenericMaoContext) {
        logger.traceEnter(THIS_CLASS, "GenericMaoFactory() - " + moType);
        this.myMoType = moType;
        this.genericMaoContext = aGenericMaoContext;
        this.serviceHandlerFactory = this.genericMaoContext.getServiceHandlerFactory();
        this.moValidatorFactory = this.genericMaoContext.getMoValidatorFactory();
        this.moDataWrapperFactory = this.genericMaoContext.getMoDataWrapperFactory();
        logger.traceReturn(THIS_CLASS, "GenericMaoFactory() - " + moType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createMo() - " + this.myMoType);
        if (GenericMaoUpgradeSubscriber.getInstance().getIsConversionOngoing()) {
            logger.traceDebug(THIS_CLASS, BLOCK_CREATE);
            MoAccessException exception = new MoAccessException(BLOCK_CREATE){};
            throw exception;
        }
        MoValidator validator = this.genericMaoContext.getMoValidator();
        validator.verifyAtCreate(parent, attributes, false, coordinator);
        StringHolder namingId = new StringHolder(identity);
        DataSupplier dataSupplier = this.genericMaoContext.getDataSupplier();
        MoRepositoryWrapper moRepositoryWrapper = this.genericMaoContext.getMoRepositoryWrapper();
        AttrList attributeList = dataSupplier.supplyDataAtCreate(source, attributes, parent, namingId, coordinator, moRepositoryWrapper);
        Object requiredObject = null;
        int softwareRevision = -1;
        ManagedObject managedObject = parent;
        synchronized (managedObject) {
            Class specialClass = SpecialisedMaoImplClassHelper.getSpecialisedMaoClass(this.myMoType, this.genericMaoContext);
            softwareRevision = this.genericMaoContext.getMoMetaDataFinder().getMoData(this.myMoType).getSwRevision();
            requiredObject = specialClass == null ? new GenericMao(parent, attributeList, namingId.getString(), this.myMoType, this.getGenericMaoContext(), new Integer(softwareRevision), coordinator, this.initMaocontext) : SpecialisedMaoImplClassHelper.createSpecialisedMaoImplClass(this.myMoType, specialClass, parent, attributeList, namingId.getString(), coordinator, this.getGenericMaoContext(), this.initMaocontext);
        }
        logger.traceReturn(THIS_CLASS, "createMo() - " + this.myMoType);
        return (ManagedObject)requiredObject;
    }

    public GenericMaoContext getGenericMaoContext() {
        return this.genericMaoContext;
    }

    public final InitialMaoContext getMaoContext() {
        return this.initMaocontext;
    }

    private final String getServiceName() {
        logger.traceEnter(THIS_CLASS, "getServiceName() - " + this.myMoType);
        String serviceName = "NO_SERVICE";
        MoMetaData moData = this.genericMaoContext.getMoMetaDataFinder().getMoData(this.myMoType);
        serviceName = moData.getServiceName();
        logger.traceReturn(THIS_CLASS, "getServiceName() - " + this.myMoType);
        return serviceName;
    }

    public void init() {
        logger.traceEnter(THIS_CLASS, "init() - " + this.myMoType);
        this.genericMaoContext.getMoFactoryMgrWrapper().register(this.myMoType, (MoFactory)this);
        logger.traceReturn(THIS_CLASS, "init() - " + this.myMoType);
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        logger.traceEnter(THIS_CLASS, "recoverMo() - " + this.myMoType);
        MoDataWrapper wrapper = this.moDataWrapperFactory.createMoDataWrapper(recoveredData);
        ManagedObject res = this.recoverMo(wrapper);
        logger.traceEnter(THIS_CLASS, "recoverMo() - " + this.myMoType);
        return res;
    }

    public ManagedObject recoverMo(MoDataWrapper recoveredData) throws MoNameAlreadyTakenException {
        logger.traceEnter(THIS_CLASS, "recoverMo() - " + this.myMoType);
        GenericMao requiredObject = null;
        Class specialClass = SpecialisedMaoImplClassHelper.getSpecialisedMaoClass(this.myMoType, this.genericMaoContext);
        if (specialClass == null) {
            try {
                requiredObject = new GenericMao(recoveredData, this.myMoType, this.getGenericMaoContext(), this.initMaocontext);
            }
            catch (MoAccessException e) {
                logger.traceError(this.getClass(), "Could not recover MO instance! For MO Type " + this.myMoType + " and LDN " + recoveredData.getLocalDistinguishedName(), e);
                throw new MoNameAlreadyTakenException(e.getReasonTag());
            }
        }
        try {
            Constructor recoveryConstructor = specialClass.getConstructor(MoDataWrapper.class, String.class, GenericMaoContext.class, InitialMaoContext.class);
            requiredObject = (GenericMao)recoveryConstructor.newInstance(recoveredData, this.myMoType, this.getGenericMaoContext(), this.initMaocontext);
        }
        catch (NoSuchMethodException e) {
            logger.traceError(this.getClass(), "Could not recover MO instance! For MO Type " + this.myMoType + " and LDN " + recoveredData.getLocalDistinguishedName(), e);
            throw new MoNameAlreadyTakenException("Method does not exist when recovering MO. Original Exception message: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new MoNameAlreadyTakenException("Illegal Access when recovering MO. Original Exception message: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new MoNameAlreadyTakenException("Instantiation Exception when recovering MO. Original Exception message: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            logger.traceError(THIS_CLASS, "", e.getTargetException());
            throw new MoNameAlreadyTakenException(e.getTargetException().toString());
        }
        logger.traceReturn(THIS_CLASS, "recoverMo() - " + this.myMoType);
        return requiredObject;
    }

    public void setMaoContext(InitialMaoContext initialmaocontext) {
        this.initMaocontext = initialmaocontext;
    }

    public void start() {
        logger.traceEnter(THIS_CLASS, "start() - " + this.myMoType);
        if (!this.mStarted) {
            this.subscribeFroService();
            this.mStarted = true;
        }
        logger.traceReturn(THIS_CLASS, "start() - " + this.myMoType);
    }

    private void subscribeFroService() {
        logger.traceEnter(THIS_CLASS, "subscribeFroService() - " + this.myMoType);
        String serviceName = this.getServiceName();
        ServiceHandler serviceHandler = this.serviceHandlerFactory.getServiceHandler(serviceName);
        serviceHandler.subscribeService(this.myMoType);
        logger.traceReturn(THIS_CLASS, "subscribeFroService() - " + this.myMoType);
    }
}

