/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.attributes.manager;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.ParameterVisitor;
import se.ericsson.cello.maofro.framework.SignedIntArrayParameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonif.LdnFinder;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.StructMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AttributeDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.SeqDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.StructRefType;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.NullManagedObject;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.CrbsParameterVisitor;
import se.ericsson.crbs.omf.mao.genericmo.xml.LongParameter;
import se.ericsson.crbs.omf.mao.genericmo.xml.MoRefParameter;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.omf.mao.wrappers.ServiceLocatorWrapper;

public class ParameterConverter {
    private static final Class THIS_CLASS = ParameterConverter.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private Object result = null;
    private final ParameterVisitor froConverter = new ConverterVisitor();
    private static final String TYPE_BOOLEAN = "Boolean";
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convertFroParameterToJavaType(String moType, Integer moId, Parameter froValue, MoRepositoryWrapper moRepositoryWrapper, GenericMaoContext aGenericMaoContext, String attributeName, String attributeType) throws MoAccessException {
        ParameterConverter parameterConverter = this;
        synchronized (parameterConverter) {
            String entMsg = "convertFroParameterToJavaType()";
            logger.traceEnter(THIS_CLASS, "convertFroParameterToJavaType()");
            String val = froValue == null ? "null" : froValue.getValueAsString();
            String debMsg = "Mo type = " + moType + ", Mo id = " + moId + ", Fro parameter, " + froValue.getName() + " = " + val + ", Attribute type = " + attributeType;
            logger.traceDebug(THIS_CLASS, debMsg);
            try {
                if (froValue instanceof MoRefParameter) {
                    String ldn;
                    this.result = null;
                    MoRefParameter moRefParameter = (MoRefParameter)froValue;
                    String string = ldn = moRefParameter.getLdn() != null && moRefParameter.getLdn().trim().equals("") ? null : moRefParameter.getLdn();
                    if (ldn == null && moRefParameter.getFroType() != -1 && moRefParameter.getFroId() != -1) {
                        ServiceRepository serviceRepository = ServiceLocatorWrapper.getServiceRepository();
                        LdnFinder ldnFinder = (LdnFinder)serviceRepository.getService(LdnFinder.class);
                        ldn = ldnFinder.getManagedObjectLdn(moRefParameter.getFroType(), moRefParameter.getFroId());
                    }
                    if (ldn != null) {
                        this.result = moRepositoryWrapper.lookup(ldn);
                    }
                    if (this.result == null) {
                        String errMsg = "Either LDN or froType+froId required for references!";
                        logger.traceAbnormal(THIS_CLASS, "Either LDN or froType+froId required for references!");
                        this.result = new NullManagedObject();
                    }
                } else if (froValue instanceof ArrayParameter) {
                    ArrayParameter arrayParameter = (ArrayParameter)froValue;
                    if (arrayParameter.size() == 0) {
                        this.result = this.getArrayParameterType(attributeType);
                    } else if (arrayParameter.get(0) instanceof MoRefParameter) {
                        ManagedObject[] resultArray = new ManagedObject[arrayParameter.size()];
                        for (int i = 0; i < arrayParameter.size(); ++i) {
                            MoRefParameter currentRef = (MoRefParameter)arrayParameter.get(i);
                            resultArray[i] = currentRef.getLdn() == null ? new NullManagedObject() : moRepositoryWrapper.lookup(currentRef.getLdn());
                        }
                        this.result = resultArray;
                    } else if (arrayParameter.get(0) instanceof StructParameter) {
                        StructImpl[] sia = new StructImpl[arrayParameter.size()];
                        for (int i = 0; i < arrayParameter.size(); ++i) {
                            Parameter ap = arrayParameter.get(i);
                            sia[i] = (StructImpl)this.convertStructParameter(aGenericMaoContext, ap, moType, attributeName);
                        }
                        this.result = sia;
                    } else {
                        froValue.accept(this.froConverter);
                    }
                    if (attributeType != null && attributeType.equals("Boolean[]")) {
                        this.result = this.convertIntegerToBooleanArray((Object[])this.result);
                    }
                } else if (TYPE_BOOLEAN.equalsIgnoreCase(attributeType)) {
                    SignedIntParameter signedIntParameter = (SignedIntParameter)froValue;
                    this.result = signedIntParameter.getBoolean();
                } else if (froValue instanceof LongParameter) {
                    LongParameter longParameter = (LongParameter)froValue;
                    this.result = new Long(longParameter.getValue());
                } else if (froValue instanceof StructParameter) {
                    this.result = this.convertStructParameter(aGenericMaoContext, froValue, moType, attributeName);
                } else {
                    froValue.accept(this.froConverter);
                }
            }
            catch (ProcessingFailureException pfe) {
                throw pfe;
            }
            catch (Exception e) {
                logger.traceDebug(THIS_CLASS, e.getMessage());
                logger.traceDebugStackTrace(THIS_CLASS, e);
                throw new ProcessingFailureException(e.getClass() + " " + e.getMessage());
            }
            String retMsg = "convertFroParameterToJavaType() = " + this.result;
            logger.traceReturn(THIS_CLASS, retMsg);
            return this.result;
        }
    }

    private Object getArrayParameterType(String attributeType) {
        Object[] retType = new ManagedObject[]{};
        if (null != attributeType) {
            if ("String[]".equals(attributeType)) {
                retType = new String[]{};
            } else if ("Long[]".equals(attributeType)) {
                retType = new Long[]{};
            } else if ("Integer[]".equals(attributeType)) {
                retType = new Integer[]{};
            } else if ("struct[]".equals(attributeType)) {
                retType = (Object[])Array.newInstance(StructImpl.class, 0);
            } else if ("Boolean[]".equals(attributeType)) {
                retType = new Boolean[]{};
            } else if ("boolean[]".equals(attributeType)) {
                retType = new boolean[0];
            } else if ("int[]".equals(attributeType)) {
                retType = new int[0];
            }
        }
        return retType;
    }

    private Boolean[] convertIntegerToBooleanArray(Object[] integerArray) {
        Boolean[] result = new Boolean[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            Integer value = (Integer)integerArray[i];
            result[i] = value == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return result;
    }

    private Object convertStructParameter(GenericMaoContext aGenericMaoContext, Parameter froValue, String moType, String attributeName) throws Exception {
        logger.traceEnter(THIS_CLASS, "convertStructParameter() froValue = " + froValue.getValueAsString() + " moType = " + moType + " attributeName = " + attributeName);
        AttributeMetaData attrMetaData = aGenericMaoContext.getMoMetaDataFinder().getMoAttributes(moType, attributeName);
        AttributeDataType attrDataType = attrMetaData.getData();
        if (attrDataType instanceof SeqDataType) {
            attrDataType = ((SeqDataType)attrDataType).getSeqType();
        }
        String referencedStruct = ((StructRefType)attrDataType).getReferencedStruct();
        logger.traceDebug(THIS_CLASS, "referencedStruct = " + referencedStruct);
        StructMetaData structMetaData = (StructMetaData)aGenericMaoContext.getMoMetaDataFinder().getStructmap().get(referencedStruct);
        String[] members = structMetaData.getMemberNames();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < members.length; ++i) {
            Object obj;
            Iterator iter;
            ArrayList<Object> arrayList;
            AttributeDataType attributeDataType = structMetaData.getMemberData(members[i]);
            String returnType = attributeDataType.getJavaReturnType();
            Parameter value = ((StructParameter)froValue).get(members[i]);
            logger.traceDebug(THIS_CLASS, "returnType = " + returnType + " type = " + value.getClass() + " value = " + value.getValueAsString());
            names.add(members[i]);
            if ("Boolean[]".equalsIgnoreCase(returnType)) {
                arrayList = new ArrayList<Object>();
                iter = ((ArrayParameter)value).iterator();
                while (iter.hasNext()) {
                    obj = ((SignedIntParameter)iter.next()).getBoolean();
                    arrayList.add(obj);
                }
                values.add(arrayList.toArray(new Boolean[arrayList.size()]));
                continue;
            }
            if ("Integer[]".equalsIgnoreCase(returnType)) {
                arrayList = new ArrayList();
                iter = ((ArrayParameter)value).iterator();
                while (iter.hasNext()) {
                    obj = new Integer(((SignedIntParameter)iter.next()).getValue());
                    arrayList.add(obj);
                }
                values.add(arrayList.toArray(new Integer[arrayList.size()]));
                continue;
            }
            if ("String[]".equalsIgnoreCase(returnType)) {
                arrayList = new ArrayList();
                iter = ((ArrayParameter)value).iterator();
                while (iter.hasNext()) {
                    obj = ((StringParameter)iter.next()).getValue();
                    arrayList.add(obj);
                }
                values.add(arrayList.toArray(new String[arrayList.size()]));
                continue;
            }
            if ("Long[]".equalsIgnoreCase(returnType)) {
                arrayList = new ArrayList();
                iter = ((ArrayParameter)value).iterator();
                while (iter.hasNext()) {
                    obj = new Long(((LongParameter)((Object)iter.next())).getValue());
                    arrayList.add(obj);
                }
                values.add(arrayList.toArray(new Long[arrayList.size()]));
                continue;
            }
            if (TYPE_BOOLEAN.equalsIgnoreCase(returnType)) {
                Boolean obj2 = ((SignedIntParameter)value).getBoolean();
                values.add(obj2);
                continue;
            }
            value.accept(this.froConverter);
            values.add(this.result);
        }
        this.result = new StructImpl(names.toArray(new String[names.size()]), values.toArray(new Object[values.size()]));
        logger.traceReturn(THIS_CLASS, "convertStructParameter()");
        return this.result;
    }

    class ConverterVisitor
    implements CrbsParameterVisitor {
        private String eltjavaType = "Object";

        ConverterVisitor() {
        }

        public void visitArrayParameter(ArrayParameter arrayparameter) throws Exception {
            int noElt = arrayparameter.size();
            ArrayList<Object> eltList = new ArrayList<Object>(noElt);
            Iterator iterator = arrayparameter.iterator();
            while (iterator.hasNext()) {
                Parameter elt = (Parameter)iterator.next();
                elt.accept((ParameterVisitor)this);
                eltList.add(ParameterConverter.this.result);
            }
            Object[] obj = new Object[]{};
            if ("Integer".equals(this.eltjavaType) || this.eltjavaType.indexOf("Enum") != -1) {
                obj = (Object[])Array.newInstance(class$java$lang$Integer == null ? (class$java$lang$Integer = ParameterConverter.class$("java.lang.Integer")) : class$java$lang$Integer, 0);
            } else if ("Long".equals(this.eltjavaType)) {
                obj = (Object[])Array.newInstance(class$java$lang$Long == null ? (class$java$lang$Long = ParameterConverter.class$("java.lang.Long")) : class$java$lang$Long, 0);
            } else if ("String".equals(this.eltjavaType)) {
                obj = (Object[])Array.newInstance(class$java$lang$String == null ? (class$java$lang$String = ParameterConverter.class$("java.lang.String")) : class$java$lang$String, 0);
            } else if (this.eltjavaType.indexOf("Struct") != -1) {
                obj = (Object[])Array.newInstance(class$se$ericsson$cello$moframework$StructImpl == null ? (class$se$ericsson$cello$moframework$StructImpl = ParameterConverter.class$("se.ericsson.cello.moframework.StructImpl")) : class$se$ericsson$cello$moframework$StructImpl, 0);
            }
            this.eltjavaType = "Array";
            ParameterConverter.this.result = eltList.toArray(obj);
        }

        public void visitSignedIntArrayParameter(SignedIntArrayParameter signedintarrayparameter) throws Exception {
            ParameterConverter.this.result = signedintarrayparameter.getValue();
            this.eltjavaType = "S32Array";
        }

        public void visitSignedIntParameter(SignedIntParameter signedintparameter) throws Exception {
            ParameterConverter.this.result = new Integer(signedintparameter.getValue());
            this.eltjavaType = "Integer";
        }

        public void visitStringParameter(StringParameter stringparameter) throws Exception {
            ParameterConverter.this.result = stringparameter.getValue();
            this.eltjavaType = "String";
        }

        public void visitStructParameter(StructParameter structparameter) throws Exception {
            int noElts = structparameter.size();
            String[] names = new String[noElts];
            Object[] values = new Object[noElts];
            Iterator iterator = structparameter.iterator();
            int counter = 0;
            while (iterator.hasNext()) {
                Parameter param = (Parameter)iterator.next();
                param.accept((ParameterVisitor)this);
                names[counter] = param.getName();
                values[counter] = ParameterConverter.this.result;
                ++counter;
            }
            ParameterConverter.this.result = new StructImpl(names, values);
            this.eltjavaType = "Struct";
        }

        public void visitUnsignedIntParameter(UnsignedIntParameter unsignedintparameter) throws Exception {
            ParameterConverter.this.result = new Long(unsignedintparameter.getValue());
            this.eltjavaType = "Long";
        }

        public void visitLongParameter(LongParameter longParameter) throws Exception {
            ParameterConverter.this.result = new Long(longParameter.getValue());
            this.eltjavaType = "Long";
        }
    }
}

