/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.attributes.type;

import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.swmanagement.LoadModuleMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.LocalAttribute;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.MaoSequenceAttribute;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class MaoReferenceAttribute
implements LocalAttribute {
    private ReferenceAttribute attributeValue = null;
    private final String attributeName;
    private final boolean isAvcNotifier;
    private static final Class THIS_CLASS = MaoSequenceAttribute.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());

    public MaoReferenceAttribute(String attributeName, boolean isAvcNotifier) {
        this.attributeName = attributeName;
        this.isAvcNotifier = isAvcNotifier;
    }

    public void delete(ManagedObject myMo, Coordinator coord) throws MoAccessException {
        ManagedObject referencedMO = this.attributeValue.getValue(coord);
        if (!(referencedMO instanceof LoadModuleMo) && referencedMO != null) {
            ((Reservable)referencedMO).release(myMo, coord);
        }
    }

    public Object getValue(Coordinator coord) throws MoAccessException {
        return this.attributeValue.getValue(coord);
    }

    public void init(AttrList attributes, MoDataWrapper mMoData, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.attributeValue = new ReferenceAttribute(this.attributeName, this.isAvcNotifier);
        if (attributes.contains(new String[]{this.attributeName})) {
            ManagedObject referencedMO = (ManagedObject)attributes.getValue(attributes.indexOf(this.attributeName));
            this.attributeValue.setValue(referencedMO);
            if (!(referencedMO instanceof LoadModuleMo) && referencedMO != null) {
                ((Reservable)referencedMO).reserve(managedObject, coordinator);
            }
        }
        mMoData.registerPersistentAttr((Attribute)this.attributeValue);
    }

    public void recover(Attribute newValue) {
        this.attributeValue = (ReferenceAttribute)newValue;
    }

    public void setValue(Object newValue, Coordinator coord, ManagedObject myMo) throws MoAccessException {
        try {
            ManagedObject referencedMO = this.attributeValue.getValue(coord);
            if (referencedMO != null && !(referencedMO instanceof LoadModuleMo)) {
                ((Reservable)referencedMO).release(myMo, coord);
            }
        }
        catch (MoRemovedException mre) {
            logger.traceDebug(MaoReferenceAttribute.class, "Reference MO has been removed");
        }
        if (newValue != null && !(newValue instanceof LoadModuleMo)) {
            ((Reservable)newValue).reserve(myMo, coord);
        }
        this.attributeValue.setValue((ManagedObject)newValue);
    }

    public String toString() {
        return "Name: " + this.attributeName + " Value: " + this.attributeValue + " AVCNotifier " + this.isAvcNotifier;
    }
}

