/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.xml.sax.helpers.AttributesImpl;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.data.MOName;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

class XMLElementImpl
implements XMLElement {
    private static final int EMPTY_LIST = 0;
    private String text;
    private final String type;
    protected List children = new ArrayList();
    private AttributesImpl attributes = new AttributesImpl();

    private static String[] getStructNames(String value) {
        ArrayList<Object> structNames = new ArrayList<Object>();
        StringTokenizer structFinder = new StringTokenizer(value, ":");
        while (structFinder.hasMoreTokens()) {
            String structNameValue = (String)structFinder.nextElement();
            StringTokenizer valueFinder = new StringTokenizer(structNameValue, ";");
            if (!valueFinder.hasMoreTokens()) continue;
            structNames.add(valueFinder.nextElement());
        }
        return structNames.toArray(new String[structNames.size()]);
    }

    private static String[] getStructValues(String value) {
        ArrayList<String> structValues = new ArrayList<String>();
        StringTokenizer structFinder = new StringTokenizer(value, ":");
        while (structFinder.hasMoreTokens()) {
            String structNameValue = (String)structFinder.nextElement();
            StringTokenizer valueFinder = new StringTokenizer(structNameValue, ";");
            int index = 0;
            while (valueFinder.hasMoreTokens()) {
                String currentValue = (String)valueFinder.nextElement();
                if (index == 1) {
                    structValues.add(currentValue);
                }
                ++index;
            }
        }
        return structValues.toArray(new String[structValues.size()]);
    }

    public XMLElementImpl(String type) {
        this(type, "", new ArrayList());
    }

    public XMLElementImpl(String type, AttributesImpl attributes) {
        this.type = type;
        this.attributes = attributes;
    }

    public XMLElementImpl(String type, String text) {
        this(type, text, new ArrayList());
    }

    public XMLElementImpl(String type, String text, List children) {
        this.type = type;
        this.text = text;
        this.children = children;
    }

    public void addAttribute(String name, String value) {
        this.attributes.addAttribute("", "", name, "", value);
    }

    public void addChild(XMLElement child) {
        this.children.add(child);
    }

    public Object convertToDataType(String momType, String value) {
        Object attributeValue = null;
        if (momType.equals("string")) {
            attributeValue = value;
        }
        if (momType.equals("stringSeq")) {
            attributeValue = this.getSequenceStrings((String)value);
        } else if (momType.equals("moRef")) {
            attributeValue = MOName.create((String)value);
        } else if (momType.equals("moRefSeq")) {
            attributeValue = this.getSequenceLdns((String)value);
        } else if (momType.equals("boolean")) {
            attributeValue = Boolean.valueOf((String)value);
        } else if (momType.equals("enumRef")) {
            attributeValue = new Integer((String)value);
        } else if (momType.equals("long")) {
            attributeValue = new Integer((String)value);
        } else if (momType.equals("struct")) {
            attributeValue = new StructImpl(XMLElementImpl.getStructNames((String)value), XMLElementImpl.getStructValues((String)value));
        }
        return attributeValue;
    }

    public AttributesImpl getAttributes() {
        return this.attributes;
    }

    public List getChildren() {
        return this.children;
    }

    private MOName[] getSequenceLdns(String value) {
        ArrayList<MOName> ldnList = new ArrayList<MOName>();
        StringTokenizer moFinder = new StringTokenizer(value, ":");
        while (moFinder.hasMoreElements()) {
            ldnList.add(MOName.create((String)moFinder.nextElement()));
        }
        return ldnList.toArray(new MOName[ldnList.size()]);
    }

    private String[] getSequenceStrings(String value) {
        ArrayList<Object> ldnList = new ArrayList<Object>();
        StringTokenizer moFinder = new StringTokenizer(value, ":");
        while (moFinder.hasMoreElements()) {
            ldnList.add(moFinder.nextElement());
        }
        return ldnList.toArray(new String[ldnList.size()]);
    }

    public String getText() {
        return this.text;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasAttributes() {
        return this.attributes.getLength() > 0;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }
}

