/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.from;

import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.collector.DataWriter;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.cmaaue.from.Constants;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.transaction.Coordinator;

public class CollectAtmCounterModeValuesAction
implements DataCollectorAction,
Constants {
    private static final String COUNTER_MODE = "counterMode";

    public void perform(CollectorContext collectorContext, Coordinator coordinator, String string) throws AueException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute("atmMos", false);
        this.collectData("Aal0TpVccTp", sequenceAttribute, collectorContext, coordinator);
        this.collectData("Aal1TpVccTp", sequenceAttribute, collectorContext, coordinator);
        this.collectData("Aal5TpVccTp", sequenceAttribute, collectorContext, coordinator);
        this.collectData("Aal2PathVccTp", sequenceAttribute, collectorContext, coordinator);
        DataWriter dataWriter = collectorContext.getDataWriter();
        dataWriter.writeData((Attribute)sequenceAttribute, collectorContext, coordinator);
    }

    private void collectData(String string, SequenceAttribute sequenceAttribute, CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType(string);
        ManagedObject managedObject = null;
        int n = 0;
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            try {
                n = (Integer)managedObject.getAttribute(COUNTER_MODE, null);
                this.addElement(managedObject, sequenceAttribute, n);
            }
            catch (MoAccessException moAccessException) {
                throw new AueException("Attribute counterMode not found", (Throwable)moAccessException);
            }
        }
    }

    private void addElement(ManagedObject managedObject, SequenceAttribute sequenceAttribute, int n) {
        StructAttribute structAttribute = new StructAttribute("", false);
        structAttribute.addElement((Attribute)new ReferenceAttribute(managedObject.getType(), managedObject.getLocalDistinguishedName(), false));
        structAttribute.addElement((Attribute)new IntegerAttribute(COUNTER_MODE, false, n));
        sequenceAttribute.addElement((Attribute)structAttribute);
    }
}

