/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sync;

import se.ericsson.cello.equipment.CbuMo;
import se.ericsson.cello.equipment.PiuDeviceMo;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.iptransport.ExchangeTerminalIpMo;
import se.ericsson.cello.iptransport.GigaBitEthernetMo;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.sync.PacketTimeSyncRefMo;
import se.ericsson.cello.sync.PacketTimeSyncRefMoGen;
import se.ericsson.cello.sync.SyncReservable;
import se.ericsson.cello.sync.TimingUnitMo;
import se.ericsson.cello.transaction.Coordinator;

public class PacketTimeSyncRefMoImpl
extends PacketTimeSyncRefMoGen
implements SyncReservable {
    public PacketTimeSyncRefMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public PacketTimeSyncRefMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    public ManagedObject fetchTransportLayerRef(SignedIntParameter signedIntParameter, Coordinator coordinator) throws MoAccessException {
        return MaoFroTypeConverter.froId2MaoInstance((String)"GigaBitEthernet", (int)signedIntParameter.getValue(), (Coordinator)coordinator);
    }

    protected void validatePtpDomain(int n, SetRequestContext setRequestContext) throws MoAccessException {
        super.validatePtpDomain(n, setRequestContext);
        Coordinator coordinator = setRequestContext.getCoordinator();
        MoIterator moIterator = MoRepository.instance().lookupType("PacketTimeSyncRef");
        while (moIterator != null && moIterator.hasMoreElements()) {
            PacketTimeSyncRefMo packetTimeSyncRefMo = (PacketTimeSyncRefMo)moIterator.nextElement();
            if (packetTimeSyncRefMo == this || n != packetTimeSyncRefMo.getPtpDomain(coordinator)) continue;
            throw new ConfigurationMismatchException("PtpDomain has to be a unique number among the configured packetTimeSyncRef ");
        }
    }

    protected int findTuFroID(ManagedObject managedObject) throws MoAccessException {
        ExchangeTerminalIpMo exchangeTerminalIpMo = (ExchangeTerminalIpMo)managedObject.getParent();
        PlugInUnitMo plugInUnitMo = null;
        plugInUnitMo = exchangeTerminalIpMo.getParent() instanceof PiuDeviceMo ? (PlugInUnitMo)exchangeTerminalIpMo.getParent().getParent() : (PlugInUnitMo)exchangeTerminalIpMo.getParent();
        MoIterator moIterator = plugInUnitMo.getChildren();
        ManagedObject managedObject2 = null;
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                managedObject2 = moIterator.nextMo();
                if (managedObject2 instanceof TimingUnitMo) {
                    return ((FroInfo)managedObject2).getFroId(null);
                }
                if (!(managedObject2 instanceof CbuMo)) continue;
                MoIterator moIterator2 = managedObject2.getChildren();
                while (moIterator2.hasMoreElements()) {
                    ManagedObject managedObject3 = moIterator2.nextMo();
                    if (!(managedObject3 instanceof TimingUnitMo)) continue;
                    return ((FroInfo)managedObject3).getFroId(null);
                }
            }
        }
        return 0;
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        ManagedObject managedObject = (ManagedObject)setRequestContext.getAttributeFromRequest("transportLayerRef");
        int n = this.findTuFroID(managedObject);
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("timTuFroId", n));
    }

    public void syncReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reserve(managedObject, coordinator);
    }

    public void syncRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.release(managedObject, coordinator);
    }

    protected void validateTransportLayerRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        if (managedObject == null || !(managedObject instanceof GigaBitEthernetMo)) {
            throw new ValueOutOfRangeException("transportLayerRef", "PacketTimeSyncRef");
        }
    }

    protected Object handleGetPtpQualityLevel(GetRequestContext getRequestContext) throws MoAccessException {
        StructParameter structParameter = (StructParameter)getRequestContext.getParameter("parentDs");
        if (structParameter == null) {
            throw new FroRequestFailedException("PacketTimeSyncRef", "Missing parameter from FRO: parentDs", "getAttributes", -1);
        }
        return new Integer(((SignedIntParameter)structParameter.get("parentDs_grandmasterClockClass")).getValue());
    }

    protected void handleSetPtpQualityLevel(int n, SetRequestContext setRequestContext) throws MoAccessException {
    }
}

