/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.HashMap;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.MoRepositoryWrapper;
import se.ericsson.crbs.omf.aue.step1.MoRepositoryWrapperFactory;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.AddAttributeAction;
import se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CreateFroEcBusAction
extends AbstractCreateInstanceAction {
    private static final Class THIS_CLASS = CreateFroEcBusAction.class;
    private static TableHandler tableHandler;
    private static final AbstractLogger logger;
    private static final String ECBUS_ATT_CONNECTION_TYPE = "connectionType";
    private static final String ECBUS_ATT_CONNECTOR_REF = "ecBusConnectorRef";
    private static final String ECBUS_MO_TYPE = "EcBus";
    private static final String DEFAULT_ECBUS_LDN = "ManagedElement=1,Equipment=1,EcBus=1";
    private static final String DEFAULT_ECBUS_RDN_VALUE = "1";
    private static final String MASTER_PLUG_IN_UNIT_LDN = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1";
    private static final int ECBUS_FRO_TYPE_ID = 117702672;
    private static final int ECBUS_FRO_ID = 1;
    private static final String PLUG_IN_UNIT_FRO_TYPE;
    private static final String PLUG_IN_UNIT_MO_TYPE = "PlugInUnit";
    private static final String PLUG_IN_UNIT_FRO_ID_ATTR_NAME = "resourceId";
    private static final String ECPORT_MO_TYPE = "EcPort";
    private static final String ECPORT_ATT_ECBUS_REF = "ecBusRef";
    private static final String ECBUS_DATA = "ecBusData";
    private static final String BOOL_CREATE_ECBUS_DATA = "boolCreateEcBusData";
    private static final String CONNECTION_TYPE_VALUE_EC = "EC";
    private static final String STRING_TRUE = "true";
    private static final String STRING_FALSE = "false";
    private String createEcBusStep2 = "false";

    public void createInstance(AueContext aueContext) throws CrbsAueException {
        Object object;
        logger.traceEnter(THIS_CLASS, "createInstance()");
        tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            object = tableHandler.getTableData(ECPORT_MO_TYPE);
            if (object != null && object.getNumberOfRecords() != 0) {
                this.createEcBusStep2 = STRING_TRUE;
                this.createDefaultEcBus(aueContext);
                this.updateEcPorts(tableHandler);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read EcPort tabledata.", (Throwable)tableDataException);
        }
        try {
            object = "";
            object = this.createEcBusStep2;
            tableHandler.storeInAuePersistency("", BOOL_CREATE_ECBUS_DATA, (String)object);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "createInstance()");
    }

    private void createDefaultEcBus(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createDefaultEcBus()");
        String string = "";
        string = Integer.toString(1);
        try {
            tableHandler.storeInAuePersistency("", ECBUS_DATA, string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", ECBUS_MO_TYPE);
        hashMap.put("frotype", Integer.toString(117702672));
        hashMap.put("rdnValue", DEFAULT_ECBUS_RDN_VALUE);
        hashMap.put("parentldn", "ManagedElement=1,Equipment=1");
        hashMap.put("froid", Integer.toString(1));
        hashMap.put("parentRefExists", Boolean.FALSE.toString());
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        createOneInstanceAction.setMoActionArgs(hashMap);
        createOneInstanceAction.convert(aueContext);
        String string2 = this.getPiuFroId(MASTER_PLUG_IN_UNIT_LDN);
        String string3 = this.getMoRef(ECBUS_ATT_CONNECTOR_REF, MASTER_PLUG_IN_UNIT_LDN, PLUG_IN_UNIT_FRO_TYPE, string2);
        this.addMoTypeSpecificAttribute(ECBUS_ATT_CONNECTION_TYPE, "String", CONNECTION_TYPE_VALUE_EC, aueContext);
        this.addMoTypeSpecificAttribute(ECBUS_ATT_CONNECTOR_REF, "moRef", string3, aueContext);
    }

    private void addMoTypeSpecificAttribute(String string, String string2, String string3, AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addMoTypeSpecificAttribute()");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Mo", ECBUS_MO_TYPE);
        hashMap.put("name", string);
        hashMap.put("type", string2);
        hashMap.put("defaultValue", string3);
        AddAttributeAction addAttributeAction = new AddAttributeAction();
        addAttributeAction.setMoActionArgs(hashMap);
        addAttributeAction.convert(aueContext);
        hashMap.clear();
        logger.traceReturn(THIS_CLASS, "addMoTypeSpecificAttribute()");
    }

    private void updateEcPorts(TableHandler tableHandler) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "updateEcPorts()");
        try {
            TableData tableData = tableHandler.getTableData(ECPORT_MO_TYPE);
            for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
                String string = this.getFroId(Integer.toString(117702672), DEFAULT_ECBUS_LDN, tableHandler);
                String string2 = this.getMoRef(ECPORT_ATT_ECBUS_REF, DEFAULT_ECBUS_LDN, Integer.toString(117702672), string);
                tableData.setAttributeValue(i, ECPORT_ATT_ECBUS_REF, (Object)string2);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read EcPort tabledata.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "updateEcPorts()");
    }

    private String getFroId(String string, String string2, TableHandler tableHandler) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getFroId()");
        String string3 = null;
        try {
            TableData tableData = tableHandler.getTableData(string);
            if (tableData.getNumberOfRecords() == 0) {
                string3 = "0";
            } else {
                Object[] objectArray = tableData.getAttributeValues("ldn");
                Object[] objectArray2 = tableData.getAttributeValues("froid");
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!objectArray[i].toString().equals(string2)) continue;
                    string3 = objectArray2[i].toString();
                }
            }
            if (string3 == null) {
                throw new CrbsAueException("The froId for MO " + string + " could not be found in the database");
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to read " + string + " tabledata.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "getFroId()");
        return string3;
    }

    private String getMoRef(String string, String string2, String string3, String string4) {
        String string5 = "<moref name=\"" + string + "\">" + "<attr name=\"ldn\" type=\"STRING\" value=\"" + string2 + "\"/>" + "<attr name=\"froType\" type=\"S32\" value=\"" + string3 + "\"/>" + "<attr name=\"froId\" type=\"S32\" value=\"" + string4 + "\"/>" + "</moref>";
        return string5;
    }

    private String getPiuFroId(String string) {
        logger.traceEnter(THIS_CLASS, "getPiuFroId ");
        MoRepositoryWrapper moRepositoryWrapper = MoRepositoryWrapperFactory.getMoRepositoryWrapper();
        MoIterator moIterator = moRepositoryWrapper.lookupType(PLUG_IN_UNIT_MO_TYPE);
        String string2 = null;
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!managedObject.getLocalDistinguishedName().equals(string)) continue;
            try {
                Integer n = (Integer)managedObject.getAttribute(PLUG_IN_UNIT_FRO_ID_ATTR_NAME, null);
                string2 = String.valueOf(n);
                break;
            }
            catch (MoAccessException moAccessException) {
                logger.traceError(THIS_CLASS, "Could not fetch froId of PIU", (Throwable)moAccessException);
            }
        }
        return string2;
    }

    static {
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
        PLUG_IN_UNIT_FRO_TYPE = Integer.toString(0);
    }
}

