/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.ChangeAttributeValueAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroStruct;
import se.ericsson.crbs.omf.aue.step1.actions.util.NameTypeValue;
import se.ericsson.crbs.omf.aue.step1.actions.util.ParseException;
import se.ericsson.crbs.omf.aue.step1.actions.util.XmlTag;
import se.ericsson.crbs.supsys.omf.aue.step1.util.CabinetParametersHelper;

public class UpdateClimateRegulationSystemAction
extends AbstractCreateInstanceAction {
    private static final Class THIS_CLASS = UpdateClimateRegulationSystemAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String AUE_PERSISTENCY_KEY = "UpdateClimateRegulationSystemAttrData";
    private static final String CABINET = "Cabinet";
    private static final String PRODUCT_DATA = "productData";
    private static final String PRODUCT_NAME = "productName";
    private static final String CLIMATE_REGULATION_NAME = "climateRegulationSystem";
    private static final String CABINET6120_PRODUCT_NAME = "RBS6120";
    private static final String CABINET6120_REGULATION = "1";
    private static final String LDN = "ldn";

    public void createInstance(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        TableData tableData = this.getTableData(this.tableHandler, CABINET);
        List list = this.findCabinets(tableData, CABINET6120_PRODUCT_NAME);
        if (list.isEmpty() && 1 == tableData.getNumberOfRecords()) {
            logger.info(THIS_CLASS, "Looking at ManagedElement to find cabinet productName");
            CabinetParametersHelper cabinetParametersHelper = new CabinetParametersHelper();
            String string = cabinetParametersHelper.getProductNameFromManagedElementMO(aueContext);
            logger.info(THIS_CLASS, "ManagedElement productName: " + string);
            string = cabinetParametersHelper.filterCabinetType(string).toLowerCase();
            if (string.equals(CABINET6120_PRODUCT_NAME.toLowerCase())) {
                try {
                    list.add((String)tableData.getRecordMap(0).get(LDN));
                }
                catch (TableDataException tableDataException) {
                    throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
                }
            }
        }
        this.changeRegulationOnCabinets(aueContext, list, CABINET6120_REGULATION);
        this.informStep2(list, CABINET6120_REGULATION);
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private List findCabinets(TableData tableData, String string) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "findCabinets()");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
            Object object;
            Object object2;
            Map map;
            try {
                map = tableData.getRecordMap(i);
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
            }
            String string2 = "";
            String string3 = "";
            String string4 = (String)map.get(PRODUCT_DATA);
            try {
                object2 = new FroStruct(this.tableHandler);
                object2.parse(string4);
                object = object2.getXmlTags();
                for (int j = 0; j < ((XmlTag[])object).length; ++j) {
                    if (!((NameTypeValue)object[j]).getName().toLowerCase().equals(PRODUCT_NAME.toLowerCase())) continue;
                    string2 = ((NameTypeValue)object[j]).getValue();
                }
                if (map.containsKey(CLIMATE_REGULATION_NAME)) {
                    string3 = map.get(CLIMATE_REGULATION_NAME).toString();
                }
            }
            catch (ParseException parseException) {
                throw new CrbsAueException(parseException.getMessage(), (Throwable)parseException);
            }
            logger.info(THIS_CLASS, "findCabinets(): Found Cabinet - productName: " + string2 + ", climateRegulationSystem: " + string3);
            object2 = new CabinetParametersHelper();
            object = ((CabinetParametersHelper)object2).filterCabinetType(string2).toLowerCase();
            String string5 = ((CabinetParametersHelper)object2).filterCabinetType(string).toLowerCase();
            if (((String)object).equals(string5)) {
                logger.info(THIS_CLASS, "findCabinets(): productName matches with " + string);
                String string6 = (String)map.get(LDN);
                arrayList.add(string6);
                continue;
            }
            logger.info(THIS_CLASS, "findCabinets(): productName do not match with " + string);
        }
        logger.info(THIS_CLASS, "findCabinets(): cabinetArrayList.size: " + arrayList.size());
        logger.traceReturn(THIS_CLASS, "findCabinets()");
        return arrayList;
    }

    private void changeRegulationOnCabinets(AueContext aueContext, List list, String string) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "changeRegulationOnCabinets()");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            ChangeAttributeValueAction changeAttributeValueAction = this.getChangeAttributeValueAction(CABINET, CLIMATE_REGULATION_NAME, string, null, LdnUtil.getRdnValue((String)string2));
            try {
                logger.info(THIS_CLASS, "Changing climateRegulationSystem on cabinetLdn: " + string2 + " to " + string);
                changeAttributeValueAction.convert(aueContext);
            }
            catch (TableAlreadyExistsException tableAlreadyExistsException) {
                throw new CrbsAueException(tableAlreadyExistsException.getMessage(), (Throwable)tableAlreadyExistsException);
            }
            catch (NoSuchTableException noSuchTableException) {
                throw new CrbsAueException(noSuchTableException.getMessage(), (Throwable)noSuchTableException);
            }
            catch (CrbsAueException crbsAueException) {
                throw new CrbsAueException(crbsAueException.getMessage(), (Throwable)crbsAueException);
            }
        }
        logger.traceReturn(THIS_CLASS, "changeRegulationOnCabinets()");
    }

    private ChangeAttributeValueAction getChangeAttributeValueAction(String string, String string2, String string3, String string4, String string5) {
        logger.traceEnter(THIS_CLASS, "getChangeAttributeValueAction()");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Mo", string);
        hashMap.put("attribute", string2);
        hashMap.put("newAttributeValue", string3);
        if (string4 != null) {
            hashMap.put("oldAttributeValue", string4);
        }
        if (string5 != null) {
            hashMap.put("rdnValue", string5);
        }
        ChangeAttributeValueAction changeAttributeValueAction = new ChangeAttributeValueAction();
        changeAttributeValueAction.setMoActionArgs(hashMap);
        logger.traceReturn(THIS_CLASS, "getChangeAttributeValueAction()");
        return changeAttributeValueAction;
    }

    private void informStep2(List list, String string) throws CrbsAueException {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next() + ";" + string;
            stringBuffer.append((stringBuffer.length() > 0 ? ":" : "") + string2);
        }
        try {
            logger.info(THIS_CLASS, "informStep2, storeing in Auepersistency: " + stringBuffer.toString());
            this.tableHandler.storeInAuePersistency("", AUE_PERSISTENCY_KEY, stringBuffer.toString());
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
    }

    private TableData getTableData(TableHandler tableHandler, String string) throws CrbsAueException {
        TableData tableData;
        try {
            tableData = tableHandler.getTableData(string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("It is not possible to get the table data: " + string, (Throwable)tableDataException);
        }
        return tableData;
    }
}

