/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.debug.trace;

import java.util.Dictionary;
import java.util.Enumeration;
import se.ericsson.cello.support.debug.trace.FastHashtableEntry;
import se.ericsson.cello.support.debug.trace.FastHashtableEnumerator;

public class FastHashtable
extends Dictionary
implements Cloneable {
    private transient FastHashtableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public FastHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new FastHashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public FastHashtable(int n) {
        this(n, 0.75f);
    }

    public FastHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new FastHashtableEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new FastHashtableEnumerator(this.table, false);
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n = fastHashtableEntryArray.length;
        while (n-- > 0) {
            FastHashtableEntry fastHashtableEntry = fastHashtableEntryArray[n];
            while (fastHashtableEntry != null) {
                if (fastHashtableEntry.value.equals(object)) {
                    return true;
                }
                fastHashtableEntry = fastHashtableEntry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % fastHashtableEntryArray.length;
        FastHashtableEntry fastHashtableEntry = fastHashtableEntryArray[n2];
        while (fastHashtableEntry != null) {
            if (fastHashtableEntry.hash == n && fastHashtableEntry.key.equals(object)) {
                return true;
            }
            fastHashtableEntry = fastHashtableEntry.next;
        }
        return false;
    }

    public final Object get(Object object) {
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % fastHashtableEntryArray.length;
        FastHashtableEntry fastHashtableEntry = fastHashtableEntryArray[n2];
        while (fastHashtableEntry != null) {
            if (fastHashtableEntry.key == object) {
                return fastHashtableEntry.value;
            }
            fastHashtableEntry = fastHashtableEntry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        FastHashtableEntry[] fastHashtableEntryArray2 = new FastHashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = fastHashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            FastHashtableEntry fastHashtableEntry = fastHashtableEntryArray[n3];
            while (fastHashtableEntry != null) {
                FastHashtableEntry fastHashtableEntry2 = fastHashtableEntry;
                fastHashtableEntry = fastHashtableEntry.next;
                int n4 = (fastHashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                fastHashtableEntry2.next = fastHashtableEntryArray2[n4];
                fastHashtableEntryArray2[n4] = fastHashtableEntry2;
            }
        }
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % fastHashtableEntryArray.length;
        FastHashtableEntry fastHashtableEntry = fastHashtableEntryArray[n2];
        while (fastHashtableEntry != null) {
            if (fastHashtableEntry.key == object) {
                Object object3 = fastHashtableEntry.value;
                fastHashtableEntry.value = object2;
                return object3;
            }
            fastHashtableEntry = fastHashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, object2);
        }
        fastHashtableEntry = new FastHashtableEntry();
        fastHashtableEntry.hash = n;
        fastHashtableEntry.key = object;
        fastHashtableEntry.value = object2;
        fastHashtableEntry.next = fastHashtableEntryArray[n2];
        fastHashtableEntryArray[n2] = fastHashtableEntry;
        ++this.count;
        return null;
    }

    public Object remove(Object object) {
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % fastHashtableEntryArray.length;
        FastHashtableEntry fastHashtableEntry = fastHashtableEntryArray[n2];
        FastHashtableEntry fastHashtableEntry2 = null;
        while (fastHashtableEntry != null) {
            if (fastHashtableEntry.key == object) {
                if (fastHashtableEntry2 != null) {
                    fastHashtableEntry2.next = fastHashtableEntry.next;
                } else {
                    fastHashtableEntryArray[n2] = fastHashtableEntry.next;
                }
                --this.count;
                return fastHashtableEntry.value;
            }
            fastHashtableEntry2 = fastHashtableEntry;
            fastHashtableEntry = fastHashtableEntry.next;
        }
        return null;
    }

    public void clear() {
        FastHashtableEntry[] fastHashtableEntryArray = this.table;
        int n = fastHashtableEntryArray.length;
        while (--n >= 0) {
            fastHashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            FastHashtable fastHashtable = (FastHashtable)super.clone();
            fastHashtable.table = new FastHashtableEntry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                fastHashtable.table[n] = this.table[n] != null ? (FastHashtableEntry)this.table[n].clone() : null;
            }
            return fastHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

