/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.debug.trace;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.OutSignal;
import enea.ose.system.Signal;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import se.ericsson.cello.support.debug.ThreadsContainer;
import se.ericsson.cello.support.debug.signals_lnx.OsaJavaTraceStatusCfm;
import se.ericsson.cello.support.debug.signals_lnx.OsaJavaTraceStatusInd;
import se.ericsson.cello.support.debug.trace.ExternalCommunicatorForLinux;
import se.ericsson.cello.support.debug.trace.FastHashtable;
import se.ericsson.cello.support.debug.trace.ThreadContainer;
import se.ericsson.cello.support.debug.trace.TraceItem;
import se.ericsson.cello.support.debug.trace.VariableFilter;

public final class ThreadsContainerForLinux
extends FastHashtable
implements ThreadsContainer {
    VariableFilter alwaysFilter = new VariableFilter();
    ExternalCommunicatorForLinux extCom = new ExternalCommunicatorForLinux(this);
    HashMap configuredItems = new HashMap();
    static final int INITIAL_NR_OF_THREAD_CONTAINERS = 200;
    static final float DEFAULT_THREAD_CONTAINER_LOAD_FACTOR = 0.2f;
    private static StringWriter stringWriter = new StringWriter();
    private static PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);

    private final void logThreadChange(String string) {
    }

    private final void logFilterChange(String string) {
    }

    public ThreadsContainerForLinux() {
        super(200, 0.2f);
    }

    public final ThreadContainer getTC(Thread thread) {
        return (ThreadContainer)this.get(thread);
    }

    private final ThreadContainer setTC(Thread thread, Object object) {
        return (ThreadContainer)this.put(thread, object);
    }

    private void checkForDeadThreads() {
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Thread thread = (Thread)enumeration.nextElement();
            if (thread.isAlive()) continue;
            this.remove(thread);
        }
    }

    private final ThreadContainer getThreadContainer() {
        Thread thread = Thread.currentThread();
        ThreadContainer threadContainer = this.getTC(thread);
        if (threadContainer == null) {
            this.logThreadChange("registering thread " + thread.getName());
            threadContainer = new ThreadContainer(thread);
            this.setTC(thread, threadContainer);
            Iterator iterator = this.configuredItems.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TraceItem traceItem = new TraceItem((String)entry.getKey());
                if (!this.isThreadNameMatching(threadContainer.getThreadName(), traceItem.getThreadName())) continue;
                this.logFilterChange("  Applying filter " + (Long)entry.getValue());
                threadContainer.pf.modifyFilter(traceItem.toString(), (Long)entry.getValue(), -1);
                threadContainer.alwaysFilter = threadContainer.pf.getAlwaysFilter();
            }
            this.updateAlwaysFilter(threadContainer);
            this.checkForDeadThreads();
        }
        return threadContainer;
    }

    public final void traceGroup(int n, Class clazz, String string) {
        if (this.isTraceGroupEnabled(n, clazz)) {
            this.doTrace(5 + (n - 1), clazz, string, Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isTraceGroupEnabled(int n, Class clazz) {
        if (this.alwaysFilter.group[n] && this.getTC(Thread.currentThread()) != null) {
            return false;
        }
        ThreadsContainerForLinux threadsContainerForLinux = this;
        synchronized (threadsContainerForLinux) {
            ThreadContainer threadContainer = this.getThreadContainer();
            if (threadContainer.alwaysFilter.group[n]) {
                return false;
            }
            return !threadContainer.pf.filterGroup(n, clazz.getName());
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void traceError(Class clazz, String string, Throwable throwable) {
        ThreadContainer threadContainer;
        if (this.alwaysFilter.error && this.getTC(Thread.currentThread()) != null) {
            return;
        }
        ThreadsContainerForLinux threadsContainerForLinux = this;
        synchronized (threadsContainerForLinux) {
            threadContainer = this.getThreadContainer();
        }
        threadsContainerForLinux = this;
        synchronized (threadsContainerForLinux) {
            if (threadContainer.alwaysFilter.error) {
                return;
            }
            if (!threadContainer.pf.filterError(clazz.getName())) {
                String string2 = "";
                if (throwable != null) {
                    string2 = "\n" + ThreadsContainerForLinux.getStackTrace(throwable);
                }
                this.doTrace(1, clazz, string + string2, Thread.currentThread().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void traceInfo(Class clazz, String string) {
        if (this.alwaysFilter.info && this.getTC(Thread.currentThread()) != null) {
            return;
        }
        ThreadsContainerForLinux threadsContainerForLinux = this;
        synchronized (threadsContainerForLinux) {
            ThreadContainer threadContainer = this.getThreadContainer();
            if (threadContainer.alwaysFilter.info) {
                return;
            }
            if (!threadContainer.pf.filterInfo(clazz.getName())) {
                this.doTrace(4, clazz, string, Thread.currentThread().getName());
            }
        }
    }

    public final void traceEnter(Class clazz, String string) {
        if (this.isEnterEnabled(clazz)) {
            this.doTrace(2, clazz, string, Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEnterEnabled(Class clazz) {
        if (this.alwaysFilter.enter && this.getTC(Thread.currentThread()) != null) {
            return false;
        }
        ThreadsContainerForLinux threadsContainerForLinux = this;
        synchronized (threadsContainerForLinux) {
            ThreadContainer threadContainer = this.getThreadContainer();
            if (threadContainer.alwaysFilter.enter) {
                return false;
            }
            if (!threadContainer.pf.filterEnter(clazz.getName())) {
                return true;
            }
        }
        return false;
    }

    public final void traceReturn(Class clazz, String string) {
        if (this.isReturnEnabled(clazz)) {
            this.doTrace(3, clazz, string, Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isReturnEnabled(Class clazz) {
        if (this.alwaysFilter.ret && this.getTC(Thread.currentThread()) != null) {
            return false;
        }
        ThreadsContainerForLinux threadsContainerForLinux = this;
        synchronized (threadsContainerForLinux) {
            ThreadContainer threadContainer = this.getThreadContainer();
            if (threadContainer.alwaysFilter.ret) {
                return false;
            }
            return !threadContainer.pf.filterReturn(clazz.getName());
            {
            }
        }
    }

    public final void traceState(Class clazz, String string) {
        if (this.isStateEnabled(clazz)) {
            this.doTrace(14, clazz, string, Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isStateEnabled(Class clazz) {
        if (this.alwaysFilter.state && this.getTC(Thread.currentThread()) != null) {
            return false;
        }
        ThreadsContainerForLinux threadsContainerForLinux = this;
        synchronized (threadsContainerForLinux) {
            ThreadContainer threadContainer = this.getThreadContainer();
            if (threadContainer.alwaysFilter.state) {
                return false;
            }
            return !threadContainer.pf.filterState(clazz.getName());
            {
            }
        }
    }

    public final void traceParam(Class clazz, String string) {
        if (this.isParamEnabled(clazz)) {
            this.doTrace(19, clazz, string, Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isParamEnabled(Class clazz) {
        if (this.alwaysFilter.param && this.getTC(Thread.currentThread()) != null) {
            return false;
        }
        ThreadsContainerForLinux threadsContainerForLinux = this;
        synchronized (threadsContainerForLinux) {
            ThreadContainer threadContainer = this.getThreadContainer();
            if (threadContainer.alwaysFilter.param) {
                return false;
            }
            return !threadContainer.pf.filterParam(clazz.getName());
            {
            }
        }
    }

    public final void traceSendSig(Class clazz, String string, OutSignal outSignal, OseProcess oseProcess) {
        if (this.isSendSigEnabled(clazz)) {
            Signal signal = (Signal)outSignal;
            String string2 = "signo:" + signal.getSigNo() + " " + "receiver:" + Integer.toHexString(oseProcess.getPID()) + " " + string;
            this.doTrace(18, clazz, string2, Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSendSigEnabled(Class clazz) {
        if (this.alwaysFilter.send_sig && this.getTC(Thread.currentThread()) != null) {
            return false;
        }
        ThreadsContainerForLinux threadsContainerForLinux = this;
        synchronized (threadsContainerForLinux) {
            ThreadContainer threadContainer = this.getThreadContainer();
            if (threadContainer.alwaysFilter.send_sig) {
                return false;
            }
            return !threadContainer.pf.filterSendSig(clazz.getName());
            {
            }
        }
    }

    public final void traceRecSig(Class clazz, String string, InSignal inSignal) {
        if (this.isRecSigEnabled(clazz)) {
            String string2 = "signo:" + inSignal.getSigNo() + " " + "sender:" + Integer.toHexString(inSignal.getSender().getPID()) + " " + string;
            this.doTrace(17, clazz, string2, Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRecSigEnabled(Class clazz) {
        if (this.alwaysFilter.rec_sig && this.getTC(Thread.currentThread()) != null) {
            return false;
        }
        ThreadsContainerForLinux threadsContainerForLinux = this;
        synchronized (threadsContainerForLinux) {
            ThreadContainer threadContainer = this.getThreadContainer();
            if (threadContainer.alwaysFilter.rec_sig) {
                return false;
            }
            return !threadContainer.pf.filterRecSig(clazz.getName());
            {
            }
        }
    }

    public final boolean isTraceEnabled(Class clazz) {
        if (this.isEnterEnabled(clazz) || this.isReturnEnabled(clazz) || this.isStateEnabled(clazz) || this.isParamEnabled(clazz) || this.isSendSigEnabled(clazz) || this.isRecSigEnabled(clazz)) {
            return true;
        }
        for (int i = 1; i < 10; ++i) {
            if (!this.isTraceGroupEnabled(i, clazz)) continue;
            return true;
        }
        return false;
    }

    private final boolean isThreadNameMatching(String string, String string2) {
        int n = string2.indexOf(42);
        boolean bl = n != -1 ? string.regionMatches(0, string2, 0, string2.length() - 1) : string.equals(string2);
        return bl;
    }

    private Collection getMatchingThreads(String string) {
        Enumeration enumeration = this.keys();
        Vector<Thread> vector = new Vector<Thread>();
        while (enumeration.hasMoreElements()) {
            Thread thread = (Thread)enumeration.nextElement();
            ThreadContainer threadContainer = this.getTC(thread);
            if (!this.isThreadNameMatching(threadContainer.getThreadName(), string)) continue;
            vector.addElement(thread);
        }
        return vector;
    }

    private void updateAlwaysFilter(ThreadContainer threadContainer) {
        this.alwaysFilter = this.alwaysFilter.and(threadContainer.alwaysFilter);
    }

    private void updateAlwaysFilter() {
        Enumeration enumeration = this.elements();
        VariableFilter variableFilter = null;
        while (enumeration.hasMoreElements()) {
            ThreadContainer threadContainer = (ThreadContainer)enumeration.nextElement();
            if (variableFilter == null) {
                variableFilter = (VariableFilter)threadContainer.alwaysFilter.clone();
                continue;
            }
            variableFilter = variableFilter.and(threadContainer.alwaysFilter);
        }
        if (variableFilter != null) {
            this.alwaysFilter = variableFilter;
        } else {
            System.out.println("NO THREADS!!!");
        }
    }

    public synchronized void modifyFilter(String string, long l, int n) {
        TraceItem traceItem;
        try {
            traceItem = new TraceItem(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException);
            return;
        }
        Iterator iterator = this.getMatchingThreads(traceItem.getThreadName()).iterator();
        while (iterator.hasNext()) {
            ThreadContainer threadContainer = this.getTC((Thread)iterator.next());
            this.logFilterChange("modifying for " + threadContainer.getThreadName() + ", before:\n" + threadContainer.pf.toString());
            threadContainer.pf.modifyFilter(traceItem.toString(), l, n);
            threadContainer.alwaysFilter = threadContainer.pf.getAlwaysFilter();
            this.logFilterChange("After:\n" + threadContainer.pf.toString());
        }
        this.updateAlwaysFilter();
    }

    synchronized void updateConfiguration(String string, long l) {
        if (l == 18L) {
            this.logFilterChange("Removing mask for " + string);
            this.configuredItems.remove(string);
        } else {
            this.logFilterChange("Putting mask " + l + " for " + string);
            this.configuredItems.put(string, new Long(l));
        }
    }

    synchronized void sendStatusInd(OseProcess oseProcess, String string) {
        TraceItem traceItem;
        try {
            traceItem = new TraceItem(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException);
            oseProcess.post(new OsaJavaTraceStatusCfm());
            return;
        }
        String string2 = traceItem.getPackageName();
        Collection collection = this.getMatchingThreads(traceItem.getThreadName());
        int n = collection.size();
        int n2 = 100;
        Iterator iterator = collection.iterator();
        for (n = collection.size(); n > 0; n -= n2) {
            int n3 = n > n2 ? n2 : n;
            int[] nArray = new int[n3];
            String[] stringArray = new String[n3];
            long[] lArray = new long[n3];
            for (int i = 0; i < n3; ++i) {
                Thread thread = (Thread)iterator.next();
                ThreadContainer threadContainer = this.getTC(thread);
                long l = threadContainer.pf.getFilterMask(string2);
                nArray[i] = threadContainer.getOseProcess().getPID();
                stringArray[i] = TraceItem.getTraceItemString(string2, thread.getName());
                lArray[i] = l;
                this.logFilterChange("  mask for " + thread.getName() + ":\n" + threadContainer.pf.toString() + " (" + l + ")");
            }
            OsaJavaTraceStatusInd osaJavaTraceStatusInd = new OsaJavaTraceStatusInd(n3, nArray, stringArray, lArray);
            oseProcess.post(osaJavaTraceStatusInd);
        }
        oseProcess.post(new OsaJavaTraceStatusCfm());
    }

    static String getStackTrace(Throwable throwable) {
        stringWriter.getBuffer().setLength(0);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private void doTrace(int n, Class clazz, String string, String string2) {
        this.doTrace_(n, clazz.getName(), string, string2);
    }

    private native void doTrace_(int var1, String var2, String var3, String var4);
}

