/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.debug.trace;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.OutSignal;
import enea.ose.system.Signal;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import se.ericsson.cello.support.debug.ThreadsContainer;
import se.ericsson.cello.support.debug.trace.ExternalCommunicatorForOse;
import se.ericsson.cello.support.debug.trace.FastHashtable;
import se.ericsson.cello.support.debug.trace.OmcsfFilterMaskResult;
import se.ericsson.cello.support.debug.trace.ThreadContainer;
import se.ericsson.cello.support.debug.trace.TraceItem;
import se.ericsson.cello.support.debug.trace.VariableFilter;

public final class ThreadsContainerForOse
extends FastHashtable
implements ThreadsContainer {
    VariableFilter alwaysFilter = new VariableFilter();
    ExternalCommunicatorForOse extCom = new ExternalCommunicatorForOse(this);
    static final int INITIAL_NR_OF_THREAD_CONTAINERS = 200;
    static final float DEFAULT_THREAD_CONTAINER_LOAD_FACTOR = 0.2f;
    private static StringWriter stringWriter = new StringWriter();
    private static PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);

    public ThreadsContainerForOse() {
        super(200, 0.2f);
    }

    public final ThreadContainer getTC(Thread thread) {
        return (ThreadContainer)this.get(thread);
    }

    public final ThreadContainer setTC(Thread thread, Object object) {
        return (ThreadContainer)this.put(thread, object);
    }

    public final synchronized ThreadContainer removeThread(Thread thread) {
        return (ThreadContainer)this.remove(thread);
    }

    public final ThreadContainer getThreadContainer() {
        Thread thread = Thread.currentThread();
        ThreadContainer threadContainer = this.getTC(thread);
        if (threadContainer == null) {
            threadContainer = new ThreadContainer(thread);
            this.setTC(thread, threadContainer);
            this.updateAlwaysFilter(threadContainer);
            this.extCom.register(thread);
        }
        return threadContainer;
    }

    public final void traceGroup(int n, Class clazz, String string) {
        if (this.isTraceGroupEnabled(n, clazz)) {
            this.extCom.sendTraceMessage(4 + n, 0, clazz.getName(), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isTraceGroupEnabled(int n, Class clazz) {
        ThreadContainer threadContainer;
        if (this.alwaysFilter.group[n] && this.getTC(Thread.currentThread()) != null) {
            return false;
        }
        ThreadsContainerForOse threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            threadContainer = this.getThreadContainer();
        }
        Thread.currentThread();
        Thread.yield();
        threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            if (threadContainer.alwaysFilter.group[n]) {
                return false;
            }
            return !threadContainer.pf.filterGroup(n, clazz.getName());
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void traceError(Class clazz, String string, Throwable throwable) {
        ThreadContainer threadContainer;
        if (this.alwaysFilter.error && this.getTC(Thread.currentThread()) != null) {
            return;
        }
        ThreadsContainerForOse threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            threadContainer = this.getThreadContainer();
        }
        Thread.currentThread();
        Thread.yield();
        threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            if (threadContainer.alwaysFilter.error) {
                return;
            }
            if (!threadContainer.pf.filterError(clazz.getName())) {
                String string2 = "";
                if (throwable != null) {
                    string2 = "\n" + ThreadsContainerForOse.getStackTrace(throwable);
                }
                this.extCom.sendTraceMessage(1, 0, clazz.getName(), string + string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void traceInfo(Class clazz, String string) {
        ThreadContainer threadContainer;
        if (this.alwaysFilter.info && this.getTC(Thread.currentThread()) != null) {
            return;
        }
        ThreadsContainerForOse threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            threadContainer = this.getThreadContainer();
        }
        Thread.currentThread();
        Thread.yield();
        threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            if (threadContainer.alwaysFilter.info) {
                return;
            }
            if (!threadContainer.pf.filterInfo(clazz.getName())) {
                this.extCom.sendTraceMessage(4, 0, clazz.getName(), string);
            }
        }
    }

    public final void traceEnter(Class clazz, String string) {
        if (this.isEnterEnabled(clazz)) {
            this.extCom.sendTraceMessage(2, 0, clazz.getName(), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEnterEnabled(Class clazz) {
        ThreadContainer threadContainer;
        if (this.alwaysFilter.enter && this.getTC(Thread.currentThread()) != null) {
            return false;
        }
        ThreadsContainerForOse threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            threadContainer = this.getThreadContainer();
        }
        Thread.currentThread();
        Thread.yield();
        threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            if (threadContainer.alwaysFilter.enter) {
                return false;
            }
            if (!threadContainer.pf.filterEnter(clazz.getName())) {
                return true;
            }
        }
        return false;
    }

    public final void traceReturn(Class clazz, String string) {
        if (this.isReturnEnabled(clazz)) {
            this.extCom.sendTraceMessage(3, 0, clazz.getName(), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isReturnEnabled(Class clazz) {
        ThreadContainer threadContainer;
        if (this.alwaysFilter.ret && this.getTC(Thread.currentThread()) != null) {
            return false;
        }
        ThreadsContainerForOse threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            threadContainer = this.getThreadContainer();
        }
        Thread.currentThread();
        Thread.yield();
        threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            if (threadContainer.alwaysFilter.ret) {
                return false;
            }
            return !threadContainer.pf.filterReturn(clazz.getName());
            {
            }
        }
    }

    public final void traceState(Class clazz, String string) {
        if (this.isStateEnabled(clazz)) {
            this.extCom.sendTraceMessage(14, 0, clazz.getName(), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isStateEnabled(Class clazz) {
        ThreadContainer threadContainer;
        if (this.alwaysFilter.state && this.getTC(Thread.currentThread()) != null) {
            return false;
        }
        ThreadsContainerForOse threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            threadContainer = this.getThreadContainer();
        }
        Thread.currentThread();
        Thread.yield();
        threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            if (threadContainer.alwaysFilter.state) {
                return false;
            }
            return !threadContainer.pf.filterState(clazz.getName());
            {
            }
        }
    }

    public final void traceParam(Class clazz, String string) {
        if (this.isParamEnabled(clazz)) {
            this.extCom.sendTraceMessage(19, 0, clazz.getName(), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isParamEnabled(Class clazz) {
        ThreadContainer threadContainer;
        if (this.alwaysFilter.param && this.getTC(Thread.currentThread()) != null) {
            return false;
        }
        ThreadsContainerForOse threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            threadContainer = this.getThreadContainer();
        }
        Thread.currentThread();
        Thread.yield();
        threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            if (threadContainer.alwaysFilter.param) {
                return false;
            }
            return !threadContainer.pf.filterParam(clazz.getName());
            {
            }
        }
    }

    public final void traceSendSig(Class clazz, String string, OutSignal outSignal, OseProcess oseProcess) {
        if (this.isSendSigEnabled(clazz)) {
            Signal signal = (Signal)outSignal;
            String string2 = "signo:" + signal.getSigNo() + " " + "receiver:" + Integer.toHexString(oseProcess.getPID()) + " " + string;
            this.extCom.sendTraceMessage(18, 0, clazz.getName(), string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSendSigEnabled(Class clazz) {
        ThreadContainer threadContainer;
        if (this.alwaysFilter.send_sig && this.getTC(Thread.currentThread()) != null) {
            return false;
        }
        ThreadsContainerForOse threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            threadContainer = this.getThreadContainer();
        }
        Thread.currentThread();
        Thread.yield();
        threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            if (threadContainer.alwaysFilter.send_sig) {
                return false;
            }
            return !threadContainer.pf.filterSendSig(clazz.getName());
            {
            }
        }
    }

    public final void traceRecSig(Class clazz, String string, InSignal inSignal) {
        if (this.isRecSigEnabled(clazz)) {
            String string2 = "signo:" + inSignal.getSigNo() + " " + "sender:" + Integer.toHexString(inSignal.getSender().getPID()) + " " + string;
            this.extCom.sendTraceMessage(17, 0, clazz.getName(), string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRecSigEnabled(Class clazz) {
        ThreadContainer threadContainer;
        if (this.alwaysFilter.rec_sig && this.getTC(Thread.currentThread()) != null) {
            return false;
        }
        ThreadsContainerForOse threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            threadContainer = this.getThreadContainer();
        }
        Thread.currentThread();
        Thread.yield();
        threadsContainerForOse = this;
        synchronized (threadsContainerForOse) {
            if (threadContainer.alwaysFilter.rec_sig) {
                return false;
            }
            return !threadContainer.pf.filterRecSig(clazz.getName());
            {
            }
        }
    }

    public final boolean isTraceEnabled(Class clazz) {
        if (this.isEnterEnabled(clazz) || this.isReturnEnabled(clazz) || this.isStateEnabled(clazz) || this.isParamEnabled(clazz) || this.isSendSigEnabled(clazz) || this.isRecSigEnabled(clazz)) {
            return true;
        }
        for (int i = 1; i < 10; ++i) {
            if (!this.isTraceGroupEnabled(i, clazz)) continue;
            return true;
        }
        return false;
    }

    private String[] getWildcardString(String string) {
        int n = 1;
        int n2 = -1;
        while ((n2 = string.indexOf(42, n2 + 1)) >= 0) {
            ++n;
        }
        String[] stringArray = new String[n];
        n2 = -1;
        int n3 = 0;
        n = 0;
        while ((n2 = string.indexOf(42, n3)) >= 0) {
            stringArray[n++] = string.substring(n3, n2);
            n3 = n2 + 1;
        }
        if (string.length() > n3) {
            stringArray[n] = string.substring(n3);
        }
        return stringArray;
    }

    private boolean wildcardMatch(String string, String[] stringArray) {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                return true;
            }
            if ((n = string.indexOf(stringArray[i], n + 1)) >= 0) continue;
            return false;
        }
        return true;
    }

    private Thread[] getThread(String string) {
        Thread[] threadArray;
        String[] stringArray = this.getWildcardString(string);
        Enumeration enumeration = this.keys();
        Vector<Thread[]> vector = new Vector<Thread[]>();
        while (enumeration.hasMoreElements()) {
            threadArray = (Thread[])enumeration.nextElement();
            ThreadContainer threadContainer = this.getTC((Thread)threadArray);
            if (!this.wildcardMatch(threadContainer.getThreadName(), stringArray)) continue;
            vector.addElement(threadArray);
        }
        threadArray = new Thread[vector.size()];
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = (Thread)vector.elementAt(i);
        }
        return threadArray;
    }

    private void updateAlwaysFilter(ThreadContainer threadContainer) {
        this.alwaysFilter = this.alwaysFilter.and(threadContainer.alwaysFilter);
    }

    private void updateAlwaysFilter() {
        Enumeration enumeration = this.elements();
        VariableFilter variableFilter = null;
        while (enumeration.hasMoreElements()) {
            ThreadContainer threadContainer = (ThreadContainer)enumeration.nextElement();
            if (variableFilter == null) {
                variableFilter = (VariableFilter)threadContainer.alwaysFilter.clone();
                continue;
            }
            variableFilter = variableFilter.and(threadContainer.alwaysFilter);
        }
        if (variableFilter != null) {
            this.alwaysFilter = variableFilter;
        }
    }

    public synchronized void modifyFilter(String string, long l, int n) {
        TraceItem traceItem;
        try {
            traceItem = new TraceItem(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException);
            return;
        }
        String string2 = traceItem.getPackageName();
        Thread[] threadArray = this.getThread(traceItem.getThreadName());
        for (int i = 0; i < threadArray.length; ++i) {
            ThreadContainer threadContainer = this.getTC(threadArray[i]);
            threadContainer.pf.modifyFilter(string2, l, n);
            threadContainer.alwaysFilter = threadContainer.pf.getAlwaysFilter();
        }
        this.updateAlwaysFilter();
    }

    public synchronized OmcsfFilterMaskResult getFilterMask(String string) {
        TraceItem traceItem;
        try {
            traceItem = new TraceItem(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new OmcsfFilterMaskResult(2, string);
        }
        String string2 = traceItem.getPackageName();
        Thread[] threadArray = this.getThread(traceItem.getThreadName());
        OmcsfFilterMaskResult omcsfFilterMaskResult = null;
        for (int i = 0; i < threadArray.length; ++i) {
            ThreadContainer threadContainer = this.getTC(threadArray[i]);
            omcsfFilterMaskResult = new OmcsfFilterMaskResult(0, string2, threadContainer.pf.getFilterMask(string2), threadArray[i], omcsfFilterMaskResult);
        }
        return omcsfFilterMaskResult;
    }

    public synchronized void setDefaultFilter(String string) {
        TraceItem traceItem;
        try {
            traceItem = new TraceItem(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        String string2 = traceItem.getPackageName();
        Thread[] threadArray = this.getThread(traceItem.getThreadName());
        for (int i = 0; i < threadArray.length; ++i) {
            ThreadContainer threadContainer = this.getTC(threadArray[i]);
            threadContainer.pf.setDefaultFilter(string2);
            threadContainer.alwaysFilter = threadContainer.pf.getAlwaysFilter();
        }
        this.updateAlwaysFilter();
    }

    static String getStackTrace(Throwable throwable) {
        stringWriter.getBuffer().setLength(0);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

