/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.internal;

import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.PortableServer.POA;
import se.ericsson.cello.neal.NealRuntimeException;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.internal.NealPoa;
import se.ericsson.cello.neal.internal.csu_version.CsuVersionInfo;
import se.ericsson.cello.neal.internal.csu_version.CurrentAdapter;
import se.ericsson.cello.neal.internal.orb_version.DummyOrbOperations;
import se.ericsson.cello.neal.internal.orb_version.JacOrbOperations;
import se.ericsson.cello.neal.internal.orb_version.JacOrbVersionInfo;
import se.ericsson.cello.neal.internal.orb_version.NealOrbDefaultFactory;
import se.ericsson.cello.neal.internal.orb_version.OrbOperations;
import se.ericsson.cello.neal.internal.orb_version.VisiBrokerOperations;
import se.ericsson.cello.neal.internal.orb_version.VisiBrokerVersionInfo;
import se.ericsson.security.corba.Current;

public class NealOrb
extends NealPoa {
    private static NealOrb defaultInstance;
    private static boolean externalOrbUsed;
    private final ORB orb;
    private final OrbOperations orbOperations;
    protected CurrentAdapter csuCurrent = this.getCurrentCsuAdapter();

    protected NealOrb(NealOrb nealOrb) {
        super(nealOrb);
        this.orb = nealOrb.orb;
        this.orbOperations = nealOrb.orbOperations;
    }

    public NealOrb(ORB oRB, POA pOA, POA pOA2) {
        super(pOA, pOA2);
        this.orb = oRB;
        this.orbOperations = JacOrbVersionInfo.instance().classORB == oRB.getClass() ? new JacOrbOperations(oRB) : (VisiBrokerVersionInfo.instance().classORB == oRB.getClass() ? new VisiBrokerOperations(oRB) : new DummyOrbOperations(oRB));
    }

    public NealOrb getCopy() {
        return new NealOrb(this);
    }

    public static synchronized NealOrb createDefaultNealOrb() {
        if (!externalOrbUsed) {
            defaultInstance = null;
        }
        return NealOrb.getDefaultNealOrb();
    }

    private static synchronized NealOrb getDefaultNealOrb() {
        if (defaultInstance == null) {
            defaultInstance = NealOrbDefaultFactory.instance().getNealOrbFactoryDefault();
        }
        return defaultInstance;
    }

    public static synchronized NealOrb getDefaultNealOrbCopy() {
        return NealOrb.getDefaultNealOrb().getCopy();
    }

    public static synchronized void setDefaultOrbAndPoa(ORB oRB, POA pOA, POA pOA2) {
        if (oRB != null) {
            defaultInstance = new NealOrb(oRB, pOA, pOA2);
            defaultInstance.startPoa();
            externalOrbUsed = true;
        } else {
            defaultInstance = NealOrbDefaultFactory.instance().getNealOrbFactoryDefault();
            externalOrbUsed = false;
        }
    }

    public Object string_to_object(String string) {
        return this.orb.string_to_object(string);
    }

    public String object_to_string(Object object) {
        return this.orb.object_to_string(object);
    }

    public static Any create_any() {
        Any any = ORB.init().create_any();
        return any;
    }

    public static DynAnyFactory getDefaultDynAnyFactory() {
        return NealOrb.getDefaultNealOrb().getDynAnyFactory();
    }

    public DynAnyFactory getDynAnyFactory() {
        try {
            DynAnyFactory dynAnyFactory = DynAnyFactoryHelper.narrow((Object)this.orb.resolve_initial_references("DynAnyFactory"));
            return dynAnyFactory;
        }
        catch (InvalidName invalidName) {
            throw new NealRuntimeException("NEAL Internal Error! Failed to resolve_initial_references(\"DynAnyFactory\") !", invalidName);
        }
    }

    public synchronized ORB getORB() {
        return this.orb;
    }

    public Boolean isSecure(Object object) {
        if (this.orbOperations == null) {
            return null;
        }
        try {
            return this.orbOperations.isSecure(object);
        }
        catch (Exception exception) {
            NealLog.warning("Failed determining security status from IOR", exception);
            return null;
        }
    }

    public String getHostname(String string) {
        if (this.orbOperations == null) {
            return null;
        }
        try {
            return this.orbOperations.getHostname(string);
        }
        catch (Exception exception) {
            NealLog.warning("Failed determining hostname from IOR", exception);
            return null;
        }
    }

    protected String getId() {
        return this.toString();
    }

    protected CurrentAdapter getCurrentCsuAdapter() {
        CurrentAdapter currentAdapter = CsuVersionInfo.instance().isJarOnClasspath() ? CurrentAdapter.instance() : null;
        return currentAdapter;
    }

    public void setAuditIdenity(String string) {
        try {
            Current current = (Current)this.orb.resolve_initial_references("OMSecSecurityCurrent");
            this.csuCurrent.setAuditIdentityCurrentAdapter(current, string);
        }
        catch (InvalidName invalidName) {
            NealLog.finest("InavlidName: ", invalidName);
        }
    }

    static {
        externalOrbUsed = false;
    }
}

