/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CacheManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.Observer;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;

public class CachedMoImpl
implements CachedMo,
Observer {
    protected final Mo mo;
    protected final CmService cmService;
    protected final String type;
    final String name;
    final String ldn;
    final CachedMo parent;
    final Node node;
    private boolean isInitialCachingDone = false;
    final CachedMoChildren children;
    protected final Map attributes;
    protected final CacheManager manager;
    private static final String NOT_READABLE_MESSAGE = "[Not readable]";

    public CachedMoImpl(CacheManager cacheManager, CachedMo cachedMo, Mo mo) throws Exception {
        this.manager = cacheManager;
        this.parent = cachedMo;
        this.mo = mo;
        this.node = cacheManager.getNode();
        this.cmService = cacheManager.getNode().getCmService();
        this.type = mo.getType();
        this.name = mo.getName();
        this.ldn = mo.getLdn();
        this.children = new CachedMoChildren();
        this.attributes = Collections.synchronizedMap(new TreeMap());
    }

    @Override
    public String getMoType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLdn() {
        return this.ldn;
    }

    @Override
    public CachedMo getParent() {
        return this.parent;
    }

    @Override
    public List getChildren(String string) {
        return this.children.getList(string);
    }

    @Override
    public List getChildren() {
        return this.children.getList();
    }

    @Override
    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    @Override
    public CachedMo[] getReferenced(String string) {
        Mo mo;
        Object object = this.attributes.get(string);
        if (object == null) {
            try {
                mo = this.mo.getAttribute(string, null);
                object = mo.getValue();
                this.attributes.put(string, object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object instanceof NameValue) {
            object = ((NameValue)object).getValue();
        }
        if (object instanceof Mo[]) {
            mo = (Mo)object;
            CachedMo[] cachedMoArray = new CachedMoImpl[((Mo[])mo).length];
            try {
                for (int i = 0; i < ((Mo)mo).length; ++i) {
                    String string2 = mo[i].getLdn();
                    cachedMoArray[i] = this.manager.getCachedMo(string2);
                }
                return cachedMoArray;
            }
            catch (Exception exception) {
                Trace.error(this, "Exception at getReferenced() " + exception);
                return null;
            }
        }
        if (object instanceof Mo) {
            try {
                mo = (Mo)object;
                CachedMo[] cachedMoArray = new CachedMoImpl[1];
                String string3 = mo.getLdn();
                if (string3 == null) {
                    return new CachedMo[0];
                }
                cachedMoArray[0] = this.manager.getCachedMo(string3);
                return cachedMoArray;
            }
            catch (Exception exception) {
                Trace.error(this, "Exception at getReferenced() " + exception);
                return null;
            }
        }
        return null;
    }

    @Override
    public void cacheChildren(int n, Observer observer) throws Exception {
        try {
            String[] stringArray = new String[]{};
            Mo[] moArray = this.mo.getChildren("", "", this.convertScope(n), null);
            for (int i = 0; i < moArray.length; ++i) {
                String string = this.getParentLdn(moArray[i]);
                CachedMoImpl cachedMoImpl = (CachedMoImpl)this.manager.getCachedMo(string);
                CachedMoImpl cachedMoImpl2 = new CachedMoImpl(this.manager, cachedMoImpl, moArray[i]);
                if (cachedMoImpl == null) {
                    Trace.error(this, "cacheChildren(int,Obeserver) found and ignored children whose parents were not cached");
                } else {
                    cachedMoImpl.addChild(cachedMoImpl2);
                }
                this.manager.addCachedMo(cachedMoImpl2);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            observer.done();
        }
    }

    protected Scope convertScope(int n) {
        Scope scope = null;
        switch (n) {
            case 0: {
                scope = Scope.BASE_ONLY;
                break;
            }
            case 1: {
                scope = Scope.ONE_LEVEL;
                break;
            }
            case 2: {
                scope = Scope.TWO_LEVELS;
                break;
            }
            case 3: {
                scope = Scope.THREE_LEVELS;
                break;
            }
            case 4: {
                scope = Scope.FIVE_LEVELS;
                break;
            }
            case 5: {
                scope = Scope.FIVE_LEVELS;
                break;
            }
            default: {
                scope = Scope.ALL_LEVELS;
            }
        }
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheAttributes(String[] stringArray, Observer observer) throws Exception {
        try {
            NameValue[] nameValueArray = this.mo.getAttributes(stringArray, null);
            for (int i = 0; i < nameValueArray.length; ++i) {
                this.attributes.put(nameValueArray[i].getName(), nameValueArray[i].getValue());
            }
        }
        catch (Exception exception) {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    NameValue nameValue = this.mo.getAttribute(stringArray[i], null);
                    this.attributes.put(nameValue.getName(), nameValue.getValue());
                    continue;
                }
                catch (Exception exception2) {
                    this.attributes.put(stringArray[i], NOT_READABLE_MESSAGE);
                    Trace.warning(this, "Unable to read attribute: " + stringArray[i] + "  " + this.ldn + "    Details: " + exception2.toString());
                }
            }
        }
        finally {
            if (observer != null) {
                observer.done();
            }
        }
    }

    @Override
    public void cacheAttribute(String string, Observer observer) throws Exception {
        String[] stringArray = new String[]{string};
        this.cacheAttributes(stringArray, observer);
    }

    @Override
    public void cacheAllAttributesAtInitialStart(Observer observer) throws Exception {
        if (this.isInitialCachingDone) {
            return;
        }
        String[] stringArray = this.manager.getAttributeNamesAsArray(this.type);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.cacheAttributesAtInitialStart(stringArray, observer);
        this.isInitialCachingDone = true;
    }

    @Override
    public void cacheAttributesAtInitialStart(String[] stringArray, Observer observer) throws Exception {
        if (this.isInitialCachingDone) {
            return;
        }
        if (this.attributes.isEmpty()) {
            this.cacheAttributes(stringArray, observer);
        } else {
            String[] stringArray2 = this.getRemainingAttributes(stringArray);
            this.cacheAttributes(stringArray2, observer);
        }
    }

    private String[] getRemainingAttributes(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (this.attributes.containsKey(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public boolean isInitialCachingDone() {
        return this.isInitialCachingDone;
    }

    @Override
    public void cacheReferencedMo(String string, Observer observer) throws Exception {
        try {
            Object object;
            Transaction transaction = this.cmService.createNullTransaction();
            String string2 = (String)this.mo.getAttribute(string, null).getValue();
            Mo mo = this.cmService.getMo(string2);
            Mo mo2 = mo.getParent(transaction);
            CachedMo cachedMo = null;
            if (mo2 != null) {
                object = mo2.getLdn();
                CachedMo cachedMo2 = this.manager.getCachedMo((String)object);
                if (cachedMo2 == null) {
                    this.manager.cacheMo((String)object, this);
                }
                cachedMo = this.manager.getCachedMo((String)object);
            }
            object = new CachedMoImpl(this.manager, cachedMo, mo);
            this.manager.addCachedMo((CachedMo)object);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            observer.done();
        }
    }

    @Override
    public String toString() {
        return this.mo.toString();
    }

    @Override
    public void done() {
    }

    @Override
    public void addChild(CachedMo cachedMo) {
        this.children.put(cachedMo);
    }

    protected String getParentLdn(Mo mo) throws Exception {
        int n;
        String string = mo.getLdn();
        int n2 = string.lastIndexOf(n = 44);
        if (n2 == -1) {
            return null;
        }
        String string2 = string.substring(0, n2);
        return string2;
    }

    @Override
    public Map getAttributesMap() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getAttributesReport() {
        String string = "";
        String string2 = "  ";
        Set set = this.attributes.keySet();
        if (set.isEmpty()) {
            return "\n[No attributes found]";
        }
        Map map = this.attributes;
        synchronized (map) {
            Iterator iterator = set.iterator();
            try {
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    Object v = this.attributes.get(k);
                    String string3 = this.getValueReport(v, string2 + "   ");
                    string = string + "\n" + string2 + k + " = " + string3;
                }
            }
            catch (Exception exception) {
                Trace.error(this, "Error while reading attribute values!\n LDN: " + this.ldn + "\n No of Attributes: " + set.size() + "\n Attribute and values: " + string, exception);
            }
        }
        return string;
    }

    private String getValueReport(Object object, String string) {
        if (object == null) {
            return NOT_READABLE_MESSAGE;
        }
        if (object.getClass().isArray()) {
            if (object instanceof Mo[]) {
                Mo[] moArray = (Mo[])object;
                String string2 = "";
                for (int i = 0; i < moArray.length; ++i) {
                    string2 = string2 + "\n" + string + moArray[i].getLdn();
                }
                return string2;
            }
            if (object instanceof Struct[]) {
                Struct[] structArray = (Struct[])object;
                String string3 = "";
                for (int i = 0; i < structArray.length; ++i) {
                    string3 = string3 + this.getValueReport(structArray[i], string) + "\n";
                }
                return string3;
            }
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                String string4 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    String string5 = stringArray[i];
                    if ("".equals(string5)) {
                        string5 = "\"\"";
                    }
                    string4 = string4 + "\n" + string + string5;
                }
                return string4;
            }
            if (object instanceof int[]) {
                int[] nArray = (int[])object;
                String string6 = "";
                for (int i = 0; i < nArray.length; ++i) {
                    string6 = string6 + "\n" + string + nArray[i];
                }
                return string6;
            }
            if (object instanceof long[]) {
                long[] lArray = (long[])object;
                String string7 = "";
                for (int i = 0; i < lArray.length; ++i) {
                    string7 = string7 + "\n" + string + lArray[i];
                }
                return string7;
            }
            if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                String string8 = "";
                for (int i = 0; i < blArray.length; ++i) {
                    string8 = string8 + "\n" + string + blArray[i];
                }
                return string8;
            }
            if (object instanceof float[]) {
                float[] fArray = (float[])object;
                String string9 = "";
                for (int i = 0; i < fArray.length; ++i) {
                    string9 = string9 + "\n" + string + fArray[i];
                }
                return string9;
            }
            if (object instanceof NameValue[]) {
                NameValue[] nameValueArray = (NameValue[])object;
                String string10 = "{\n";
                for (int i = 0; i < nameValueArray.length; ++i) {
                    string10 = string10 + string + this.getValueReport(nameValueArray[i], string + "   ") + "\n";
                }
                string10 = string10 + string + "}";
                return string10;
            }
            Trace.error(this, "getValueReport() encountered an unrecognised array type:" + object + " : " + object.getClass().getName());
            return object.toString();
        }
        if (object instanceof Mo) {
            Mo mo = (Mo)object;
            return mo.getLdn();
        }
        if (object instanceof NameValue) {
            NameValue nameValue = (NameValue)object;
            Object object2 = nameValue.getValue();
            String string11 = string + this.getValueReport(object2, string + "   ");
            return string11;
        }
        if (object instanceof Struct) {
            Struct struct = (Struct)object;
            String[] stringArray = struct.getMemberNames();
            String string12 = "\n" + string + "{ \n";
            for (int i = 0; i < stringArray.length; ++i) {
                NameValue nameValue = struct.getMember(stringArray[i]);
                String string13 = nameValue.getName();
                Object object3 = nameValue.getValue();
                string12 = string12 + string + string + string13 + " = " + this.getValueReport(object3, string + "   ") + "\n";
            }
            string12 = string12 + string + "}";
            return string12;
        }
        if (object instanceof String) {
            if ("".equals(object)) {
                return "\"\"";
            }
            return object.toString();
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return "" + n;
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return "" + l;
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            return "" + f.floatValue();
        }
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            return "" + bl;
        }
        Trace.error(this, "getValueReport() encountered an unrecognised type:" + object);
        return object.toString();
    }

    @Override
    public void printAll() {
        this.printAll("");
    }

    @Override
    public CacheManager getCacheManager() {
        return this.manager;
    }

    private void printAll(String string) {
        String string2 = string;
        System.out.println(string2 + this);
        List list = this.children.getList();
        Iterator iterator = list.iterator();
        string2 = string2 + " ";
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CachedMoImpl) {
                CachedMoImpl cachedMoImpl = (CachedMoImpl)iterator.next();
                cachedMoImpl.printAll(string2);
                continue;
            }
            System.out.println(string2 + "??? child to " + this);
        }
    }

    private CmService getCmService() {
        return this.cmService;
    }

    private class CachedMoChildren {
        final Map<String, List<CachedMo>> map = new TreeMap<String, List<CachedMo>>();
        final List<CachedMo> allCachedChildren = new ArrayList<CachedMo>();

        public synchronized void put(CachedMo cachedMo) {
            String string = cachedMo.getMoType();
            if (string == null) {
                return;
            }
            List<CachedMo> list = this.map.get(string);
            if (list == null) {
                list = new ArrayList<CachedMo>();
                list.add(cachedMo);
                this.map.put(string, list);
                this.allCachedChildren.add(cachedMo);
            } else {
                list.add(cachedMo);
                this.allCachedChildren.add(cachedMo);
            }
        }

        public synchronized List getList(String string) {
            List<CachedMo> list = this.map.get(string);
            if (list == null) {
                return new ArrayList(0);
            }
            return list;
        }

        public synchronized List getList() {
            return this.allCachedChildren;
        }
    }
}

