/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coli.ColiCongestionException;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coli.ColiException;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coli.ColiSession;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coli.ColiSessionFactory;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.ColiListener;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.ColiThreadCounter;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.Command;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.LhshCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.ParGetCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.PsPortCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.parsers.ps.ProcessStatus;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.units.AuxiliaryUnitHandler;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.units.DeviceBoardHandler;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Utils;

public class CommandHandlingSession
implements Runnable {
    final Vector coliListeners = new Vector();
    private volatile boolean isBusy = false;
    private boolean isDeviceBoard = false;
    private List auxiliaryList;
    private ArrayList atfBoardList;
    private Command[] commands;
    private ColiSession aSession;
    final ColiSessionFactory myFactory;
    private ArrayList deviceBoardList;
    long[] startTime = new long[]{0L, 0L};
    int TIMER_JOB = 0;
    int TIMER_COMMAND = 1;
    int jobType = -1;
    ArrayList traceLog = new ArrayList(100);
    final Map exceptionMap = new HashMap();
    public boolean stopFlag = false;
    final ColiThreadCounter ctCounter;
    private static int coliJobCounter = 1;

    public CommandHandlingSession(ColiSessionFactory coliSessionFactory, ColiThreadCounter coliThreadCounter) {
        this.myFactory = coliSessionFactory;
        this.ctCounter = coliThreadCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            if (this.ctCounter != null) {
                this.ctCounter.coliThreadStarted();
            }
            try {
                this.runMainImplementation();
            }
            finally {
                if (this.ctCounter != null) {
                    this.ctCounter.coliThreadStopped();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMainImplementation() {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            block11: {
                Trace.observation(this, "Coli job start: " + this);
                this.startMeasurement(this.TIMER_JOB);
                try {
                    Thread.sleep(100L);
                    this.executeQueue();
                }
                catch (Exception exception) {
                    this.notifyListenersAboutException(exception);
                }
                catch (Throwable throwable) {
                    Trace.observation(this, "Exception at run() " + throwable);
                    Exception exception = new Exception("COLI job failed: " + throwable.getMessage());
                    this.notifyListenersAboutException(exception);
                }
                finally {
                    this.stopMeasurement(this.TIMER_JOB, "This Job is ended: " + this.toString());
                    Trace.observation(this, "Coli job done: " + this);
                    this.logoff();
                    this.isBusy = false;
                    if (this.exceptionMap.isEmpty()) break block11;
                    Iterator iterator = this.exceptionMap.values().iterator();
                    Exception exception = null;
                    while (iterator.hasNext()) {
                        exception = (Exception)iterator.next();
                        this.notifyListenersAboutException(exception);
                    }
                }
            }
        }
    }

    public String getFirstLdnInDeviceBoardList() {
        Object e;
        String string = "";
        if (this.deviceBoardList != null && (e = this.deviceBoardList.get(0)) instanceof DeviceBoardHandler) {
            DeviceBoardHandler deviceBoardHandler = (DeviceBoardHandler)e;
            string = deviceBoardHandler.getLdn();
        }
        return string;
    }

    public String getFirstLdnInAuxillaryUnitsList() {
        Object e;
        String string = "";
        if (this.auxiliaryList != null && (e = this.auxiliaryList.get(0)) instanceof AuxiliaryUnitHandler) {
            AuxiliaryUnitHandler auxiliaryUnitHandler = (AuxiliaryUnitHandler)e;
            string = auxiliaryUnitHandler.getLdn();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQueue() throws Exception {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            if ((this.deviceBoardList == null || this.deviceBoardList.isEmpty()) && (this.auxiliaryList == null || this.auxiliaryList.isEmpty())) {
                return;
            }
            try {
                if (!this.stopFlag) {
                    this.aSession = this.myFactory.newSession();
                    if (this.isDeviceBoard) {
                        this.executeDeviceBoardQueue();
                    } else {
                        this.executeAuxiliaryQueue();
                    }
                }
            }
            finally {
                this.logoff();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDeviceBoardQueue() throws ColiCongestionException {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            if (this.commands != null) {
                Trace.observation(this, "There are " + this.commands.length + " commands to execute in board queue in " + this.toString());
            }
            block7: for (DeviceBoardHandler deviceBoardHandler : this.deviceBoardList) {
                Command[] commandArray = null;
                commandArray = deviceBoardHandler.getAllCommands();
                boolean bl = true;
                for (int i = 0; i < commandArray.length; ++i) {
                    String string;
                    String string2;
                    String string3;
                    block21: {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (this.stopFlag) break block7;
                        string3 = commandArray[i].getCommand();
                        ArrayList arrayList = this.getCmdArguments(string3);
                        string2 = commandArray[i].getCommandType();
                        Trace.observation(this, "Executing number " + i + " " + string2 + " in board queue in " + this.toString());
                        string = null;
                        try {
                            string = this.sendCmd(string3, 0);
                        }
                        catch (ColiException coliException) {
                            this.trace(coliException.toString());
                            string = null;
                            this.exceptionMap.put(this.commands[i].getUnitLdn(), coliException);
                            if (string3.indexOf("lhsh") == -1) break block21;
                            bl = false;
                            continue block7;
                        }
                    }
                    if (string3.indexOf("lhsh") != -1 && string.indexOf("Welcome") == -1 && !(bl = false)) {
                        string = null;
                        continue block7;
                    }
                    commandArray[i].setCommandRespons(string);
                    boolean bl2 = this.isGpbCommandHandlingReady(commandArray[i]);
                    boolean bl3 = this.isGpbLogHandlingReady(commandArray, i);
                    if ("exit".equals(string2) || bl2 || bl3) {
                        if (this.jobType == 4) {
                            this.notifyListeners(commandArray[i].getUnitLdn(), 4);
                            for (ColiListener coliListener : this.coliListeners) {
                                coliListener.sessionDataCached(this);
                            }
                        } else if (this.jobType == 0) {
                            this.notifyListeners(commandArray[i].getUnitLdn(), 0);
                            for (ColiListener coliListener : this.coliListeners) {
                                coliListener.sessionDataCached(this);
                            }
                        } else {
                            this.notifyListeners(commandArray[i].getUnitLdn(), 0);
                        }
                    }
                    if (!string2.equals("pmdumps")) continue;
                    this.getAndStoreDumps(commandArray[i]);
                }
            }
            if (!this.stopFlag) {
                if (this.jobType == 2) {
                    this.notifyListeners("", 2);
                }
            } else {
                Trace.observation(this, "A DB Command handling session has stopped:" + this.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAuxiliaryQueue() throws ColiCongestionException {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            Map map = new HashMap();
            ArrayList arrayList = this.atfBoardList;
            Iterator iterator = arrayList.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.stopFlag) break;
                DeviceBoardHandler deviceBoardHandler = (DeviceBoardHandler)iterator.next();
                bl = this.connectToAtfBoard(deviceBoardHandler);
                if (!bl) continue;
                map = this.GetAUs(deviceBoardHandler);
                if (map != null) {
                    this.handleAtfProcesses(map, deviceBoardHandler);
                }
                try {
                    this.sendCmd("exit", 0);
                }
                catch (ColiException coliException) {
                    this.trace(coliException.toString());
                }
            }
            if (!this.stopFlag) {
                if (this.jobType == 3) {
                    this.notifyListeners("", 3);
                } else if (this.jobType == 1) {
                    this.notifyListeners("", 1);
                    for (ColiListener coliListener : this.coliListeners) {
                        coliListener.sessionDataCached(this);
                    }
                }
            } else {
                Trace.observation(this, "An AUX Command handling session has stopped:" + this.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getCmdArguments(String string) {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreElements()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueJob(ArrayList arrayList, int n) {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            this.jobType = n;
            this.isBusy = true;
            this.isDeviceBoard = true;
            this.deviceBoardList = arrayList;
            Command[] commandArray = null;
            ArrayList arrayList2 = arrayList;
            for (Object object : arrayList2) {
                commandArray = this.buildCommandArray(object.getAllCommands(), commandArray);
            }
            this.commands = commandArray;
            if (!this.stopFlag) {
                Object object;
                object = new Thread((Runnable)this, "COLI job #" + coliJobCounter++);
                ((Thread)object).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Command[] buildCommandArray(Command[] commandArray, Command[] commandArray2) {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            Command[] commandArray3 = null;
            commandArray3 = commandArray2 != null ? new Command[commandArray2.length + commandArray.length] : new Command[commandArray.length];
            if (commandArray2 != null) {
                int n;
                for (n = 0; n < commandArray2.length; ++n) {
                    commandArray3[n] = commandArray2[n];
                }
                for (n = commandArray2.length; n < commandArray2.length + commandArray.length; ++n) {
                    commandArray3[n] = commandArray[n - commandArray2.length];
                }
            } else {
                for (int i = 0; i < commandArray.length; ++i) {
                    commandArray3[i] = commandArray[i];
                }
            }
            return commandArray3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueJob(List list, ArrayList arrayList, int n) {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            if (list == null || list.isEmpty()) {
                return;
            }
            Trace.observation(this, "Thread: " + this + "   queueJob()");
            this.jobType = n;
            this.isBusy = true;
            this.isDeviceBoard = false;
            this.auxiliaryList = list;
            this.atfBoardList = arrayList;
            if (!this.stopFlag) {
                Thread thread = new Thread((Runnable)this, "COLI job");
                thread.start();
            }
        }
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public void stopNodeAccess() {
        this.stopFlag = true;
        Trace.observation(this, "Stopping command handling session...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendCmd(String string, int n) throws ColiException, ColiCongestionException {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            if (this.stopFlag) {
                this.logoff();
                return "";
            }
            return this.send(string, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String send(String string, int n) throws ColiException, ColiCongestionException {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            if (this.stopFlag) {
                this.logoff();
                return "";
            }
            String string2 = null;
            this.startMeasurement(this.TIMER_COMMAND);
            try {
                string2 = this.aSession.send(string, n);
            }
            finally {
                this.stopMeasurement(this.TIMER_COMMAND, string);
            }
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trace(String string) {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            this.traceLog.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMeasurement(int n) {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            this.startTime[n] = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMeasurement(int n, String string) {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            long l = System.currentTimeMillis() - this.startTime[n];
            this.trace("Measurement of: " + string + ",   Time taken [" + l + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logoff() {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            try {
                if (this.aSession != null) {
                    this.aSession.disconnect();
                    this.aSession = null;
                }
            }
            catch (ColiException coliException) {
                Trace.error(this, "exception at logoff " + coliException.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map GetAUs(DeviceBoardHandler deviceBoardHandler) throws ColiCongestionException {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            String string = null;
            String string2 = deviceBoardHandler.getBoardCode();
            PsPortCommand psPortCommand = new PsPortCommand(string2);
            String string3 = psPortCommand.getCommand();
            try {
                string = this.sendCmd(string3, 0);
            }
            catch (ColiException coliException) {
                this.trace(coliException.toString());
                this.exceptionMap.put(deviceBoardHandler.getLdn(), coliException);
                return null;
            }
            ProcessStatus processStatus = new ProcessStatus(string);
            Map map = null;
            map = processStatus.parse();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string4 : map.keySet()) {
                if (Utils.AU_SERVERS.contains(string4)) continue;
                arrayList.add(string4);
            }
            if (!arrayList.isEmpty()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string5 = (String)arrayList.get(i);
                    map.remove(string5);
                }
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAtfProcesses(Map map, DeviceBoardHandler deviceBoardHandler) throws ColiCongestionException {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            String string;
            String string2;
            Object object;
            Iterator iterator;
            List list = this.auxiliaryList;
            String string3 = null;
            Map map2 = this.calculateProcessesToServerMap(map);
            Map map3 = null;
            if (this.jobType == 3) {
                map3 = this.calculateSingletonUnitTypes();
            } else {
                iterator = (AuxiliaryUnitHandler)this.auxiliaryList.get(0);
                object = iterator.getAtfProcess();
                string2 = deviceBoardHandler.getBoardCode();
                if (object != null && string2.equals(iterator.getAtfBoard().getBoardCode())) {
                    map2 = this.refreshMap(map2, (String)object);
                }
            }
            iterator = map2.keySet().iterator();
            if (map3 != null) {
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    string2 = (String)map2.get(object);
                    string = (String)Utils.serverToUnitTypeMap.get(string2);
                    if (!this.isUnitSingletone(map3, string)) continue;
                    AuxiliaryUnitHandler auxiliaryUnitHandler = this.getSingletonAuxUnit(string);
                    string3 = this.connectToProcess((String)object);
                    if (string3 != null) {
                        auxiliaryUnitHandler.setAtfBoard(deviceBoardHandler);
                        this.handleData(auxiliaryUnitHandler, deviceBoardHandler);
                    }
                    map2.remove(object);
                    iterator = map2.keySet().iterator();
                    list.remove(auxiliaryUnitHandler);
                }
            }
            object = map2.keySet().iterator();
            while (object.hasNext() && !this.stopFlag) {
                string2 = (String)object.next();
                string3 = this.connectToProcess(string2);
                if (this.stopFlag) {
                    Trace.observation(this, "stopping progressing...");
                    return;
                }
                string = null;
                if (string3 == null) continue;
                string = this.getSerialNoFromColi(string2);
                if (this.stopFlag) {
                    Trace.observation(this, "stopping progressing...");
                    return;
                }
                boolean bl = false;
                for (AuxiliaryUnitHandler auxiliaryUnitHandler : list) {
                    if (!auxiliaryUnitHandler.getNodeStoredSerialNo().equals(string)) continue;
                    bl = true;
                    auxiliaryUnitHandler.setColiFetchedSerialNo(string);
                    auxiliaryUnitHandler.setAtfProcess(string2);
                    auxiliaryUnitHandler.setAtfBoard(deviceBoardHandler);
                    this.handleData(auxiliaryUnitHandler, deviceBoardHandler);
                }
                if (!bl) {
                    try {
                        string3 = this.sendCmd("exit", 0);
                    }
                    catch (ColiException coliException) {
                        this.trace(coliException.toString());
                        string3 = "Command failed";
                    }
                    continue;
                }
                if (this.jobType != 1 && this.jobType != 5) continue;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColiListener(ColiListener coliListener) {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            this.coliListeners.add(coliListener);
        }
    }

    public void removeColiListener(ColiListener coliListener) {
        this.coliListeners.remove(coliListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(String string, int n) {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            if (n == 0) {
                for (ColiListener coliListener : this.coliListeners) {
                    coliListener.deviceBoardDataCached(this, string);
                }
            }
            if (n == 1) {
                for (ColiListener coliListener : this.coliListeners) {
                    coliListener.auxiliaryUnitDataCached(this, string);
                }
            }
            if (n == 3 || n == 2) {
                for (ColiListener coliListener : this.coliListeners) {
                    coliListener.sessionDataCached(this);
                }
            }
            if (n == 4) {
                for (ColiListener coliListener : this.coliListeners) {
                    coliListener.deviceBoardLogDataCached(this, string);
                }
            }
            if (n == 5) {
                for (ColiListener coliListener : this.coliListeners) {
                    coliListener.auxiliaryUnitLogDataCached(this, string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersAboutException(Exception exception) {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            for (ColiListener coliListener : this.coliListeners) {
                coliListener.coliCommunicationExceptionOccured(this, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map calculateSingletonUnitTypes() {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (AuxiliaryUnitHandler auxiliaryUnitHandler : this.auxiliaryList) {
                String string = auxiliaryUnitHandler.getType();
                if (hashMap.containsKey(string)) {
                    hashMap.remove(string);
                    hashMap.put(string, Boolean.FALSE);
                    continue;
                }
                hashMap.put(string, Boolean.TRUE);
            }
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUnitSingletone(Map map, String string) {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            boolean bl = false;
            Boolean bl2 = null;
            if (map.containsKey(string) && (bl2 = (Boolean)map.get(string)).booleanValue()) {
                bl = true;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuxiliaryUnitHandler getSingletonAuxUnit(String string) {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            AuxiliaryUnitHandler auxiliaryUnitHandler = null;
            for (AuxiliaryUnitHandler auxiliaryUnitHandler2 : this.auxiliaryList) {
                if (!auxiliaryUnitHandler2.getType().equalsIgnoreCase(string)) continue;
                auxiliaryUnitHandler = auxiliaryUnitHandler2;
                break;
            }
            return auxiliaryUnitHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String connectToProcess(String string) throws ColiCongestionException {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            String string2 = null;
            LhshCommand lhshCommand = new LhshCommand(string, "");
            String string3 = lhshCommand.getCommand();
            try {
                string2 = this.sendCmd(string3, 0);
            }
            catch (ColiException coliException) {
                this.trace(coliException.toString());
                this.exceptionMap.put(string, coliException);
                string2 = null;
            }
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSerialNoFromColi(String string) throws ColiCongestionException {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            String string2 = null;
            String string3 = null;
            ParGetCommand parGetCommand = new ParGetCommand(string);
            String string4 = parGetCommand.getCommand();
            try {
                string2 = this.sendCmd(string4, 0);
            }
            catch (ColiException coliException) {
                this.trace(coliException.toString());
                this.exceptionMap.put(string, coliException);
                string2 = null;
            }
            if (string2 != null) {
                parGetCommand.setCommandRespons(string2);
                string3 = (String)parGetCommand.getParsedCmdRespons("SYS_HW_SERIAL");
            }
            return string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleData(AuxiliaryUnitHandler auxiliaryUnitHandler, DeviceBoardHandler deviceBoardHandler) throws ColiCongestionException {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            String string = null;
            Command[] commandArray = auxiliaryUnitHandler.getAllCommands();
            for (int i = 0; i < commandArray.length; ++i) {
                try {
                    string = this.sendCmd(commandArray[i].getCommand(), 0);
                }
                catch (ColiException coliException) {
                    this.trace(coliException.toString());
                    this.exceptionMap.put(auxiliaryUnitHandler.getLdn(), coliException);
                    string = null;
                }
                commandArray[i].setCommandRespons(string);
            }
            if (this.jobType == 5) {
                this.notifyListeners(auxiliaryUnitHandler.getLdn(), 5);
                for (ColiListener coliListener : this.coliListeners) {
                    coliListener.sessionDataCached(this);
                }
            } else if (this.jobType == 1) {
                this.notifyListeners(auxiliaryUnitHandler.getLdn(), 1);
                for (ColiListener coliListener : this.coliListeners) {
                    coliListener.sessionDataCached(this);
                }
            } else {
                this.notifyListeners(auxiliaryUnitHandler.getLdn(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map calculateProcessesToServerMap(Map map) {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : map.keySet()) {
                List list = (List)map.get(string);
                for (String string2 : list) {
                    hashMap.put(string2, string);
                }
            }
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGpbCommandHandlingReady(Command command) {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            boolean bl = false;
            String string = "GeneralProcessorUnit=1";
            String string2 = command.getUnitLdn();
            if (!string2.endsWith(string)) {
                return bl;
            }
            if (command.getCommandType().equals("capi tot")) {
                bl = true;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGpbLogHandlingReady(Command[] commandArray, int n) {
        CommandHandlingSession commandHandlingSession = this;
        synchronized (commandHandlingSession) {
            boolean bl = false;
            Command[] commandArray2 = commandArray;
            String string = "GeneralProcessorUnit=1";
            String string2 = commandArray2[n].getUnitLdn();
            if (!string2.endsWith(string)) {
                return bl;
            }
            if (n > 0) {
                String string3 = commandArray2[n - 1].getCommandType();
                if (string3.equals(Utils.LOG_COMMANDS[0]) || string3.equals(Utils.LOG_COMMANDS[1])) {
                    bl = true;
                }
            } else if (commandArray2.length == 1 && (commandArray2[0].getCommandType().equals(Utils.LOG_COMMANDS[0]) || commandArray2[0].getCommandType().equals(Utils.LOG_COMMANDS[1]))) {
                bl = true;
            }
            return bl;
        }
    }

    private void getAndStoreDumps(Command command) throws ColiCongestionException {
        Object[] objectArray = command.getParsedCmdRespons();
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            String string2 = "/c/public_html/" + string + ".txt";
            String string3 = "pmdsave " + string + " " + string2;
            try {
                this.sendCmd(string3, 0);
                continue;
            }
            catch (ColiException coliException) {
                this.trace(coliException.toString());
            }
        }
    }

    private Map refreshMap(Map map, String string) {
        Map<String, String> map2 = new HashMap();
        boolean bl = false;
        for (String string2 : map.keySet()) {
            if (!string2.equals(string)) continue;
            String string3 = (String)map.get(string2);
            map2.put(string, string3);
            bl = true;
            break;
        }
        if (!bl) {
            map2 = map;
        }
        return map2;
    }

    private boolean connectToAtfBoard(DeviceBoardHandler deviceBoardHandler) throws ColiCongestionException {
        boolean bl = false;
        String string = deviceBoardHandler.getBoardCode();
        LhshCommand lhshCommand = new LhshCommand(string, deviceBoardHandler.getLdn());
        String string2 = lhshCommand.getCommand();
        try {
            this.sendCmd(string2, 0);
            bl = true;
        }
        catch (ColiException coliException) {
            this.trace(coliException.toString());
            this.exceptionMap.put(deviceBoardHandler.getLdn(), coliException);
            bl = false;
        }
        return bl;
    }
}

