/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.units;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.CapiTotCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.Command;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.CommandData;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.ExitCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.LhshCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.LlogCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.PmDumpsCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.TeLogReadCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.ViiCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.units.DeviceBoardHandler;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Utils;

public class DeviceBoard
implements DeviceBoardHandler {
    private static final String slotRDN = "Slot=";
    private static final String subrackRDN = "Subrack=";
    private static final String GPB_RDN = "GeneralProcessorUnit=1";
    private static final String CBU_RDN = "Cbu=1";
    private String ldn;
    private String slotId;
    private String subrackId;
    private String subrackLDN;
    private String boardCode;
    private String boardType;
    private boolean isActiveUnit = false;
    private boolean isAtfBoard = false;
    private List logCommandNameList = new ArrayList();
    private String[] commands;
    final Map commandMap = new HashMap();
    private Command[] allCommands;

    public DeviceBoard(String string) {
        this(string, new ArrayList());
    }

    public DeviceBoard(String string, String string2) {
        this.boardType = string2;
        this.logCommandNameList = new ArrayList();
        this.ldn = string;
        this.slotId = this.calculateSlotId();
        this.subrackId = this.calculateSubrackId();
        this.subrackLDN = this.calculateSubrackLDN();
        this.boardCode = this.calculateBoardCode();
        if (Utils.ATF_BOARDS.contains(string2)) {
            this.isAtfBoard = true;
        }
        this.prepareAllColiCommands();
    }

    public DeviceBoard(String string, List list) {
        this.logCommandNameList = list;
        this.ldn = string;
        this.boardType = this.calculateBoardType();
        this.slotId = this.calculateSlotId();
        this.subrackId = this.calculateSubrackId();
        this.subrackLDN = this.calculateSubrackLDN();
        this.boardCode = this.calculateBoardCode();
        if (Utils.ATF_BOARDS.contains(this.boardType)) {
            this.isAtfBoard = true;
        }
        this.prepareAllColiCommands();
    }

    @Override
    public String[] getCommands() {
        if (this.commands == null || this.commands.length == 0) {
            return null;
        }
        return this.commands;
    }

    @Override
    public Command[] getAllCommands() {
        return this.allCommands;
    }

    @Override
    public Map getCommandTable() {
        return this.commandMap;
    }

    @Override
    public String getLdn() {
        return this.ldn;
    }

    @Override
    public String getBoardType() {
        return this.boardType;
    }

    @Override
    public String getSlotId() {
        return this.slotId;
    }

    @Override
    public String getSubrackId() {
        return this.subrackId;
    }

    @Override
    public String getSubrackLDN() {
        return this.subrackLDN;
    }

    @Override
    public boolean isUsedAsAtfBoard() {
        return this.isAtfBoard;
    }

    @Override
    public String getBoardCode() {
        return this.boardCode;
    }

    @Override
    public boolean isGpbUnit() {
        boolean bl = false;
        if (this.ldn.endsWith(GPB_RDN) || this.ldn.endsWith(CBU_RDN)) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isActiveUnit() {
        return this.isActiveUnit;
    }

    @Override
    public void setActiveUnit(boolean bl) {
        this.isActiveUnit = bl;
    }

    private String calculateSlotId() {
        int n = this.ldn.indexOf(slotRDN);
        String string = this.ldn.substring(n);
        int n2 = string.indexOf(",");
        int n3 = string.indexOf("=");
        String string2 = string.substring(n3 + 1, n2);
        return string2;
    }

    private String calculateSubrackId() {
        int n = this.ldn.indexOf(subrackRDN);
        String string = this.ldn.substring(n);
        int n2 = string.indexOf(",");
        int n3 = string.indexOf("=");
        String string2 = string.substring(n3 + 1, n2);
        return string2;
    }

    private String calculateSubrackLDN() {
        int n = this.ldn.indexOf(subrackRDN);
        String string = this.ldn.substring(n);
        int n2 = string.indexOf(",");
        String string2 = this.ldn.substring(0, n + n2) + ";";
        return string2;
    }

    private String calculateBoardCode() {
        Integer n;
        int n2;
        Object e;
        String string;
        Integer n3;
        String string2 = null;
        String string3 = this.slotId;
        String string4 = null;
        int n4 = Integer.parseInt(this.subrackId);
        if ((string2 = (n3 = new Integer(--n4)).toString()).length() == 1) {
            string2 = "0" + string2;
        }
        if (this.slotId.length() == 1) {
            string3 = "0" + this.slotId;
        }
        if ((string = (String)(e = Utils.ATF_BOARDS.get(1))).equalsIgnoreCase(this.boardType) && (n2 = (n = Integer.valueOf(this.slotId)).intValue()) > 1) {
            string3 = "00";
        }
        string4 = string2 + string3 + "00";
        return string4;
    }

    private String calculateBoardType() {
        String string = this.ldn;
        int n = string.lastIndexOf("=");
        String string2 = string.substring(0, n);
        int n2 = string2.lastIndexOf(",");
        String string3 = string2.substring(n2 + 1);
        return string3;
    }

    private void prepareAllColiCommands() {
        List list = this.buildCommandList();
        this.buildCommandMap(list);
        this.buildCommandArray(list);
        this.buildCommandNameArray(list);
    }

    private List buildCommandList() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!this.isGpbUnit() || !this.isActiveUnit()) {
            object = new LhshCommand(this.boardCode, this.ldn);
            arrayList.add(object);
        }
        if (this.logCommandNameList.isEmpty()) {
            object = new ViiCommand(Utils.UNIT_TYPE[0], this.ldn);
            CapiTotCommand capiTotCommand = new CapiTotCommand(this.ldn);
            arrayList.add(object);
            arrayList.add(capiTotCommand);
        } else {
            for (String string : this.logCommandNameList) {
                CommandData commandData;
                if (string.equals(Utils.LOG_COMMANDS[0])) {
                    commandData = new LlogCommand(this.ldn);
                    arrayList.add(commandData);
                }
                if (string.equals(Utils.LOG_COMMANDS[1])) {
                    commandData = new TeLogReadCommand(this.ldn);
                    arrayList.add(commandData);
                }
                if (!string.equals(Utils.LOG_COMMANDS[2])) continue;
                commandData = new PmDumpsCommand(this.ldn);
                arrayList.add(commandData);
            }
        }
        if (!this.isGpbUnit() || !this.isActiveUnit()) {
            object = new ExitCommand(this.ldn);
            arrayList.add(object);
        }
        return arrayList;
    }

    private void buildCommandMap(List list) {
        for (Command command : list) {
            this.commandMap.put(command.getCommandType(), command);
        }
    }

    private void buildCommandArray(List list) {
        Object[] objectArray = list.toArray();
        this.allCommands = new Command[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.allCommands[i] = (Command)objectArray[i];
        }
    }

    private void buildCommandNameArray(List list) {
        this.commands = new String[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Command command = (Command)iterator.next();
            this.commands[n] = command.getCommandType();
            ++n;
        }
    }
}

