/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.common;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class Trace {
    public static final int LEVEL_SHOW_ALL = 5;
    public static final String ERROR = "ERROR";
    public static final String WARNING = "WARNING";
    public static final String OBSERVATION = "OBSERVATION";
    public static final String OBSERVATION_OF_TIME = "OBSERVATION OF TIME";
    public static final String NEW_LINE = System.getProperty("line.separator", "\n\r");
    public static final String LOGGER_NAME_EMSERV = "se.ericsson.crbs.cabv.support";
    private static final Logger logger = Logger.getLogger("se.ericsson.crbs.cabv.support");
    private static String output;
    private static double totalBeginTime;
    private static final String TEXT_DELIM = "; ";
    private static int logCount;
    private static ByteArrayOutputStream exceptionStream;
    private static PrintWriter exceptionWriter;
    private static Handler consoleHandler;

    private Trace() {
    }

    public static void error(Object object, String string) {
        Trace.error(object, string, null);
    }

    public static void error(Object object, String string, Throwable throwable) {
        if (!logger.isLoggable(Level.SEVERE)) {
            return;
        }
        String string2 = Trace.prepareMessage(object, "ERROR; " + string + TEXT_DELIM + TEXT_DELIM + TEXT_DELIM + TEXT_DELIM);
        Trace.log(Level.SEVERE, null, string2, throwable);
    }

    public static void warning(Object object, String string) {
        Trace.warning(object, string, null);
    }

    public static void warning(Object object, String string, Exception exception) {
        if (!logger.isLoggable(Level.WARNING)) {
            return;
        }
        String string2 = Trace.prepareMessage(object, "WARNING; " + string + TEXT_DELIM + TEXT_DELIM + TEXT_DELIM + TEXT_DELIM);
        Trace.log(Level.WARNING, null, string2, exception);
    }

    public static void observation(Object object, String string) {
        Trace.observation(object, string, null);
    }

    public static void observation(String string) {
        logger.log(Level.FINER, string);
    }

    public static void observation(Object object, String string, Exception exception) {
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        String string2 = Trace.prepareMessage(object, "OBSERVATION; " + string + TEXT_DELIM + TEXT_DELIM + TEXT_DELIM + TEXT_DELIM);
        Trace.log(Level.FINE, null, string2, exception);
    }

    public static void startTimeObservation(Object object, String string) {
        double d = System.currentTimeMillis();
        Trace.startTimeObservation(object, string, d);
    }

    public static void startTimeObservation(Object object, String string, double d) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        totalBeginTime = d;
        String string2 = Trace.prepareMessage(object, "OBSERVATION OF TIME; " + string + TEXT_DELIM + "0" + TEXT_DELIM + "Total time elapsed (ms)" + TEXT_DELIM + "0" + TEXT_DELIM);
        Trace.log(Level.FINER, null, string2, null);
    }

    public static void timeObservation(Object object, String string, double d) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        double d2 = (double)System.currentTimeMillis() - totalBeginTime;
        String string2 = Trace.prepareMessage(object, "OBSERVATION OF TIME; " + string + new Double(d).intValue() + TEXT_DELIM + "Total time elapsed (ms)" + TEXT_DELIM + new Double(d2).intValue() + TEXT_DELIM);
        Trace.log(Level.FINER, null, string2, null);
    }

    private static String prepareMessage(Object object, String string) {
        output = object != null ? string + "  [" + object.getClass().getName() + "]" + "  " + Thread.currentThread().getName() : string + "  [" + object + "]" + "  " + Thread.currentThread().getName();
        return output;
    }

    public static void setLevel(Level level) {
        logger.setLevel(level);
    }

    public static void createTestConsole(Level level) {
        if (consoleHandler != null) {
            logger.removeHandler(consoleHandler);
        }
        consoleHandler = new ConsoleHandler();
        logger.addHandler(consoleHandler);
        consoleHandler.setLevel(level);
        logger.setUseParentHandlers(false);
    }

    public static void readConfiguration() {
        String string;
        boolean bl;
        if (consoleHandler == null && (bl = new File(string = System.getProperty("user.home") + System.getProperty("file.separator") + ".cabinetviewer.properties").exists())) {
            LogManager logManager = LogManager.getLogManager();
            try {
                logManager.readConfiguration(new FileInputStream(string));
            }
            catch (Exception exception) {
                System.out.println("Problem opening file for configuration of logging" + string);
            }
        }
    }

    static void log(Level level, String string, String string2, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(logCount++).append(" ");
        if (string != null) {
            stringBuffer.append(string).append(" ");
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(NEW_LINE);
        if (throwable != null) {
            stringBuffer.append("Exception: " + throwable);
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(Trace.getStackTrace(throwable));
            stringBuffer.append(NEW_LINE);
            if (throwable instanceof InvocationTargetException) {
                Throwable throwable2 = ((InvocationTargetException)throwable).getTargetException();
                stringBuffer.append("Target Exception: " + throwable2);
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(Trace.getStackTrace(throwable2));
                stringBuffer.append(NEW_LINE);
            }
        }
        logger.log(level, stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = exceptionStream;
        synchronized (byteArrayOutputStream) {
            exceptionStream.reset();
            throwable.printStackTrace(exceptionWriter);
            return exceptionStream.toString();
        }
    }

    static {
        logCount = 0;
        exceptionStream = new ByteArrayOutputStream(1200);
        exceptionWriter = new PrintWriter(exceptionStream, true);
        consoleHandler = null;
    }
}

